/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.events;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import com.ironsource.eventsmodule.DataBaseEventsStorage;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.eventsmodule.EventsSender;
import com.ironsource.eventsmodule.IEventsManager;
import com.ironsource.eventsmodule.IEventsSenderResultListener;
import com.ironsource.mediationsdk.IronSourceSegment;
import com.ironsource.mediationsdk.events.AbstractEventsFormatter;
import com.ironsource.mediationsdk.events.EventsFormatterFactory;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ServerSegmetData;
import com.ironsource.mediationsdk.sdk.GeneralProperties;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseEventsManager
implements IEventsManager {
    final int DEFAULT_BACKUP_THRESHOLD = 1;
    final int DEFAULT_MAX_NUMBER_OF_EVENTS = 100;
    final int DEFAULT_MAX_EVENTS_PER_BATCH = 5000;
    final int NO_CONNECTIVITY_EVENT_ID_ADDITION = 90000;
    final int ERROR_REASON_MAX_LENGTH = 50;
    final int DATABASE_VERSION = 5;
    final String DATABASE_NAME = "supersonic_sdk.db";
    final String KEY_PROVIDER = "provider";
    final String KEY_PLACEMENT = "placement";
    private final String MEDIATION_ABT = "abt";
    private boolean mHasServerResponse;
    private boolean mHadTriggerEvent = false;
    private DataBaseEventsStorage mDbStorage;
    private AbstractEventsFormatter mFormatter;
    private ArrayList<EventData> mLocalEvents;
    private boolean mIsEventsEnabled = true;
    private int mTotalEvents;
    private String mSessionId;
    private Context mContext;
    private int mMaxNumberOfEvents = 100;
    private int mMaxEventsPerBatch = 5000;
    private int mBackupThreshold = 1;
    private int[] mOptOutEvents;
    private int[] mOptInEvents;
    private int[] mTriggerEvents;
    private int[] mNonConnectivityEvents;
    private Map<String, String> mBatchParams = new HashMap<String, String>();
    private Map<String, String> mGenericEventParams = new HashMap<String, String>();
    private String mAbt = "";
    int mAdUnitType;
    String mFormatterType;
    String mEventType;
    Set<Integer> mConnectivitySensitiveEventsSet;
    private EventThread mEventThread;
    private IronSourceSegment mSegment;
    private ServerSegmetData mServerSegmentData;
    private IronSourceLoggerManager mLoggerManager;
    private final Object mDBSyncLock = new Object();

    void initState() {
        this.mLocalEvents = new ArrayList();
        this.mTotalEvents = 0;
        this.mFormatter = EventsFormatterFactory.getFormatter(this.mFormatterType, this.mAdUnitType);
        this.mEventThread = new EventThread(this.mEventType + "EventThread");
        this.mEventThread.start();
        this.mEventThread.prepareHandler();
        this.mLoggerManager = IronSourceLoggerManager.getLogger();
        this.mSessionId = IronSourceUtils.getSessionId();
        this.mConnectivitySensitiveEventsSet = new HashSet<Integer>();
        this.initConnectivitySensitiveEventsSet();
    }

    protected void initConnectivitySensitiveEventsSet() {
    }

    public synchronized void start(Context context, IronSourceSegment segment) {
        this.mFormatterType = IronSourceUtils.getDefaultEventsFormatterType(context, this.mEventType, this.mFormatterType);
        this.verifyCurrentFormatter(this.mFormatterType);
        this.mFormatter.setEventsServerUrl(IronSourceUtils.getDefaultEventsURL(context, this.mEventType, null));
        this.mDbStorage = DataBaseEventsStorage.getInstance(context, "supersonic_sdk.db", 5);
        this.backupEventsToDb();
        this.mOptOutEvents = IronSourceUtils.getDefaultOptOutEvents(context, this.mEventType);
        this.mOptInEvents = IronSourceUtils.getDefaultOptInEvents(context, this.mEventType);
        this.mTriggerEvents = IronSourceUtils.getDefaultTriggerEvents(context, this.mEventType);
        this.mNonConnectivityEvents = IronSourceUtils.getDefaultNonConnectivityEvents(context, this.mEventType);
        this.mSegment = segment;
        this.mContext = context;
    }

    public synchronized void setServerSegmentData(ServerSegmetData serverSegment) {
        this.mServerSegmentData = serverSegment;
    }

    private synchronized boolean isNoConnectivityEvent(String connectionType, EventData event) {
        if (!connectionType.equalsIgnoreCase("none")) {
            return false;
        }
        boolean isNonConnectivityEvent = this.isEventsArrayNotEmpty(this.mNonConnectivityEvents) ? this.isEventInArray(event.getEventId(), this.mNonConnectivityEvents) : this.mConnectivitySensitiveEventsSet.contains(event.getEventId());
        return isNonConnectivityEvent;
    }

    private synchronized int convertEventToNotConnected(EventData event) {
        return event.getEventId() + 90000;
    }

    @Override
    public synchronized void log(final EventData event) {
        this.mEventThread.postTask(new Runnable(){

            @Override
            public void run() {
                JSONObject additionalData;
                if (event == null || !BaseEventsManager.this.mIsEventsEnabled) {
                    return;
                }
                event.addToAdditionalData("eventSessionId", BaseEventsManager.this.mSessionId);
                String connectionType = IronSourceUtils.getConnectionType(BaseEventsManager.this.mContext);
                if (BaseEventsManager.this.shouldAddConnectionType(event)) {
                    event.addToAdditionalData("connectionType", connectionType);
                }
                if (BaseEventsManager.this.isNoConnectivityEvent(connectionType, event)) {
                    event.setEventId(BaseEventsManager.this.convertEventToNotConnected(event));
                }
                if ((additionalData = event.getAdditionalDataJSON()) != null && additionalData.has("reason")) {
                    try {
                        String errorReason = additionalData.getString("reason");
                        errorReason = errorReason.substring(0, Math.min(errorReason.length(), 50));
                        event.addToAdditionalData("reason", errorReason);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (!BaseEventsManager.this.getGenericEventParams().isEmpty()) {
                    for (Map.Entry<String, String> entry : BaseEventsManager.this.getGenericEventParams().entrySet()) {
                        if (event.getAdditionalDataJSON().has(entry.getKey()) || entry.getKey() == "eventId" || entry.getKey() == "timestamp") continue;
                        event.addToAdditionalData(entry.getKey(), entry.getValue());
                    }
                }
                try {
                    String ret = "{\"eventId\":" + event.getEventId() + ",\"timestamp\":" + event.getTimeStamp() + "," + event.getAdditionalData().substring(1);
                    BaseEventsManager.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.EVENT, ret.replace(",", "\n"), 0);
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                if (BaseEventsManager.this.shouldEventBeLogged(event)) {
                    if (BaseEventsManager.this.shouldAddSessionDepth(event) && !BaseEventsManager.this.sessionDepthIsSet(event)) {
                        int sessionDepth = BaseEventsManager.this.getSessionDepth(event);
                        event.addToAdditionalData("sessionDepth", sessionDepth);
                    }
                    if (BaseEventsManager.this.shouldExtractCurrentPlacement(event)) {
                        BaseEventsManager.this.setCurrentPlacement(event);
                    } else if (!TextUtils.isEmpty((CharSequence)BaseEventsManager.this.getCurrentPlacement(event.getEventId())) && BaseEventsManager.this.shouldIncludeCurrentPlacement(event)) {
                        event.addToAdditionalData("placement", BaseEventsManager.this.getCurrentPlacement(event.getEventId()));
                    }
                    BaseEventsManager.this.mLocalEvents.add(event);
                    BaseEventsManager.this.mTotalEvents++;
                }
                boolean isTrigger = BaseEventsManager.this.isEventsArrayNotEmpty(BaseEventsManager.this.mTriggerEvents) ? BaseEventsManager.this.isEventInArray(event.getEventId(), BaseEventsManager.this.mTriggerEvents) : BaseEventsManager.this.isTriggerEvent(event);
                if (!BaseEventsManager.this.mHadTriggerEvent && isTrigger) {
                    BaseEventsManager.this.mHadTriggerEvent = true;
                }
                if (BaseEventsManager.this.mDbStorage != null) {
                    if (BaseEventsManager.this.shouldSendEvents()) {
                        BaseEventsManager.this.sendEvents();
                    } else if (BaseEventsManager.this.shouldBackupEventsToDb(BaseEventsManager.this.mLocalEvents) || isTrigger) {
                        BaseEventsManager.this.backupEventsToDb();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents() {
        ArrayList<EventData> combinedEventList;
        this.mHadTriggerEvent = false;
        Object object = this.mDBSyncLock;
        synchronized (object) {
            ArrayList<EventData> storedEvents = this.mDbStorage.loadEvents(this.mEventType);
            combinedEventList = this.initCombinedEventList(this.mLocalEvents, storedEvents, this.mMaxEventsPerBatch);
            this.mLocalEvents.clear();
            this.mDbStorage.clearEvents(this.mEventType);
        }
        this.mTotalEvents = 0;
        if (combinedEventList.size() > 0) {
            JSONObject generalProperties = GeneralProperties.getProperties().toJSON();
            try {
                Map<String, String> batchParams;
                this.updateSegmentsData(generalProperties);
                String abt = this.getAbt();
                if (!TextUtils.isEmpty((CharSequence)abt)) {
                    generalProperties.put("abt", (Object)abt);
                }
                if (!(batchParams = this.getBatchParams()).isEmpty()) {
                    for (Map.Entry<String, String> entry : batchParams.entrySet()) {
                        if (generalProperties.has(entry.getKey())) continue;
                        generalProperties.put(entry.getKey(), (Object)entry.getValue());
                    }
                }
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
            String dataToSend = this.mFormatter.format(combinedEventList, generalProperties);
            new EventsSender(new IEventsSenderResultListener(){

                @Override
                public synchronized void onEventsSenderResult(final ArrayList<EventData> extraData, final boolean success) {
                    BaseEventsManager.this.mEventThread.postTask(new Runnable(){

                        @Override
                        public void run() {
                            if (success) {
                                ArrayList<EventData> events = BaseEventsManager.this.mDbStorage.loadEvents(BaseEventsManager.this.mEventType);
                                BaseEventsManager.this.mTotalEvents = events.size() + BaseEventsManager.this.mLocalEvents.size();
                            } else if (extraData != null) {
                                BaseEventsManager.this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Failed to send events", 0);
                                BaseEventsManager.this.mDbStorage.saveEvents(extraData, BaseEventsManager.this.mEventType);
                                ArrayList<EventData> storedEvents = BaseEventsManager.this.mDbStorage.loadEvents(BaseEventsManager.this.mEventType);
                                BaseEventsManager.this.mTotalEvents = storedEvents.size() + BaseEventsManager.this.mLocalEvents.size();
                            }
                        }
                    });
                }
            }).execute(new Object[]{dataToSend, this.mFormatter.getEventsServerUrl(), combinedEventList});
        }
    }

    private ArrayList<EventData> initCombinedEventList(ArrayList<EventData> localEvents, ArrayList<EventData> storedEvents, int maxSize) {
        ArrayList<EventData> result;
        ArrayList<EventData> allEvents = new ArrayList<EventData>();
        allEvents.addAll(localEvents);
        allEvents.addAll(storedEvents);
        Collections.sort(allEvents, new Comparator<EventData>(){

            @Override
            public int compare(EventData event1, EventData event2) {
                if (event1.getTimeStamp() >= event2.getTimeStamp()) {
                    return 1;
                }
                return -1;
            }
        });
        if (allEvents.size() <= maxSize) {
            result = new ArrayList<EventData>(allEvents);
        } else {
            result = new ArrayList(allEvents.subList(0, maxSize));
            List<EventData> eventsToSave = allEvents.subList(maxSize, allEvents.size());
            this.mDbStorage.saveEvents(eventsToSave, this.mEventType);
        }
        return result;
    }

    private void verifyCurrentFormatter(String formatterType) {
        if (this.mFormatter == null || !this.mFormatter.getFormatterType().equals(formatterType)) {
            this.mFormatter = EventsFormatterFactory.getFormatter(formatterType, this.mAdUnitType);
        }
    }

    @Override
    public void setBackupThreshold(int backupThreshold) {
        if (backupThreshold > 0) {
            this.mBackupThreshold = backupThreshold;
        }
    }

    @Override
    public void setMaxNumberOfEvents(int maxNumberOfEvents) {
        if (maxNumberOfEvents > 0) {
            this.mMaxNumberOfEvents = maxNumberOfEvents;
        }
    }

    @Override
    public void setMaxEventsPerBatch(int maxEventsPerBatch) {
        if (maxEventsPerBatch > 0) {
            this.mMaxEventsPerBatch = maxEventsPerBatch;
        }
    }

    @Override
    public void setOptOutEvents(int[] optOutEvents, Context context) {
        this.mOptOutEvents = optOutEvents;
        IronSourceUtils.saveDefaultOptOutEvents(context, this.mEventType, optOutEvents);
    }

    @Override
    public void setOptInEvents(int[] optInEvents, Context context) {
        this.mOptInEvents = optInEvents;
        IronSourceUtils.saveDefaultOptInEvents(context, this.mEventType, optInEvents);
    }

    @Override
    public void setTriggerEvents(int[] triggerEvents, Context context) {
        this.mTriggerEvents = triggerEvents;
        IronSourceUtils.saveDefaultTriggerEvents(context, this.mEventType, triggerEvents);
    }

    @Override
    public void setNonConnectivityEvents(int[] nonConnectivityEvents, Context context) {
        this.mNonConnectivityEvents = nonConnectivityEvents;
        IronSourceUtils.saveDefaultNonConnectivityEvents(context, this.mEventType, nonConnectivityEvents);
    }

    @Override
    public void setEventsUrl(String eventsUrl, Context context) {
        if (!TextUtils.isEmpty((CharSequence)eventsUrl)) {
            if (this.mFormatter != null) {
                this.mFormatter.setEventsServerUrl(eventsUrl);
            }
            IronSourceUtils.saveDefaultEventsURL(context, this.mEventType, eventsUrl);
        }
    }

    @Override
    public void setFormatterType(String formatterType, Context context) {
        if (!TextUtils.isEmpty((CharSequence)formatterType)) {
            this.mFormatterType = formatterType;
            IronSourceUtils.saveDefaultEventsFormatterType(context, this.mEventType, formatterType);
            this.verifyCurrentFormatter(formatterType);
        }
    }

    @Override
    public void setIsEventsEnabled(boolean isEnabled) {
        this.mIsEventsEnabled = isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupEventsToDb() {
        Object object = this.mDBSyncLock;
        synchronized (object) {
            this.mDbStorage.saveEvents(this.mLocalEvents, this.mEventType);
            this.mLocalEvents.clear();
        }
    }

    private boolean shouldSendEvents() {
        boolean shouldSendEvents = (this.mTotalEvents >= this.mMaxNumberOfEvents || this.mHadTriggerEvent) && this.mHasServerResponse;
        return shouldSendEvents;
    }

    private boolean shouldBackupEventsToDb(ArrayList<EventData> events) {
        boolean shouldBackup = false;
        if (events != null) {
            shouldBackup = events.size() >= this.mBackupThreshold;
        }
        return shouldBackup;
    }

    private boolean isEventsArrayNotEmpty(int[] array) {
        return array != null && array.length > 0;
    }

    private boolean isEventInArray(int eventId, int[] array) {
        boolean eventInArray = false;
        if (this.isEventsArrayNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (eventId != array[i]) continue;
                eventInArray = true;
                break;
            }
        }
        return eventInArray;
    }

    private boolean shouldEventBeLogged(EventData event) {
        boolean logEvent = false;
        if (event != null) {
            logEvent = this.isEventsArrayNotEmpty(this.mOptOutEvents) ? !this.isEventInArray(event.getEventId(), this.mOptOutEvents) : (this.isEventsArrayNotEmpty(this.mOptInEvents) ? this.isEventInArray(event.getEventId(), this.mOptInEvents) : true);
        }
        return logEvent;
    }

    public void setHasServerResponse(boolean hasResponse) {
        this.mHasServerResponse = hasResponse;
    }

    String getProviderNameForEvent(EventData event) {
        String provider;
        try {
            JSONObject eventData = new JSONObject(event.getAdditionalData());
            provider = eventData.optString("provider", "");
        }
        catch (JSONException e2) {
            return "";
        }
        return provider;
    }

    public void triggerEventsSend() {
        this.sendEvents();
    }

    public void sendEventToUrl(EventData eventData, String url) {
        try {
            ArrayList<EventData> singleEventArray = new ArrayList<EventData>();
            singleEventArray.add(eventData);
            String dataToSend = this.mFormatter.format(singleEventArray, GeneralProperties.getProperties().toJSON());
            new EventsSender().execute(new Object[]{dataToSend, url, null});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateSegmentsData(JSONObject object) {
        try {
            if (this.mSegment != null) {
                if (this.mSegment.getAge() > 0) {
                    object.put("age", this.mSegment.getAge());
                }
                if (!TextUtils.isEmpty((CharSequence)this.mSegment.getGender())) {
                    object.put("gen", (Object)this.mSegment.getGender());
                }
                if (this.mSegment.getLevel() > 0) {
                    object.put("lvl", this.mSegment.getLevel());
                }
                if (this.mSegment.getIsPaying() != null) {
                    object.put("pay", this.mSegment.getIsPaying().get());
                }
                if (this.mSegment.getIapt() > 0.0) {
                    object.put("iapt", this.mSegment.getIapt());
                }
                if (this.mSegment.getUcd() > 0L) {
                    object.put("ucd", this.mSegment.getUcd());
                }
            }
            if (this.mServerSegmentData != null) {
                String id = this.mServerSegmentData.getSegmentId();
                if (!TextUtils.isEmpty((CharSequence)id)) {
                    object.put("segmentId", (Object)id);
                }
                JSONObject customs = this.mServerSegmentData.getCustomSegments();
                Iterator iterator = customs.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    object.put(key, customs.get(key));
                }
            }
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
    }

    public void setABT(String abt) {
        this.mAbt = abt;
    }

    public String getAbt() {
        return this.mAbt;
    }

    public void setBatchParams(Map<String, String> batchParams) {
        this.mBatchParams.putAll(batchParams);
    }

    public Map<String, String> getBatchParams() {
        return this.mBatchParams;
    }

    public void setEventGenericParams(Map<String, String> genericParams) {
        this.mGenericEventParams.putAll(genericParams);
    }

    public Map<String, String> getGenericEventParams() {
        return this.mGenericEventParams;
    }

    protected abstract boolean shouldExtractCurrentPlacement(EventData var1);

    protected abstract boolean shouldIncludeCurrentPlacement(EventData var1);

    protected abstract boolean isTriggerEvent(EventData var1);

    protected abstract int getSessionDepth(EventData var1);

    protected abstract void setCurrentPlacement(EventData var1);

    protected abstract String getCurrentPlacement(int var1);

    private boolean shouldAddSessionDepth(EventData event) {
        return event.getEventId() != 14 && event.getEventId() != 514 && event.getEventId() != 140 && event.getEventId() != 40 && event.getEventId() != 41 && event.getEventId() != 50 && event.getEventId() != 51;
    }

    private boolean shouldAddConnectionType(EventData event) {
        return event.getEventId() != 40 && event.getEventId() != 41 && event.getEventId() != 50 && event.getEventId() != 51;
    }

    private boolean sessionDepthIsSet(EventData event) {
        JSONObject data = event.getAdditionalDataJSON();
        if (data == null) {
            return false;
        }
        return data.has("sessionDepth");
    }

    public void setEventAuctionParams(Map<String, Object> data, int auctionTrial, String auctionFallback) {
        data.put("auctionTrials", auctionTrial);
        if (!TextUtils.isEmpty((CharSequence)auctionFallback)) {
            data.put("auctionFallback", auctionFallback);
        }
    }

    private class EventThread
    extends HandlerThread {
        private Handler mHandler;

        EventThread(String name) {
            super(name);
        }

        void postTask(Runnable task) {
            this.mHandler.post(task);
        }

        void prepareHandler() {
            this.mHandler = new Handler(this.getLooper());
        }
    }
}

