/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class ProgSmash {
    protected AbstractAdapter mAdapter;
    protected AdapterConfig mAdapterConfig;
    private boolean mIsLoadCandidate;
    protected JSONObject mAdUnitSettings;
    protected String mDynamicDemandSourceId;

    ProgSmash(AdapterConfig adapterConfig, AbstractAdapter adapter) {
        this.mAdapterConfig = adapterConfig;
        this.mAdapter = adapter;
        this.mAdUnitSettings = adapterConfig.getAdUnitSetings();
    }

    public boolean isBidder() {
        return this.mAdapterConfig.isBidder();
    }

    public int getMaxAdsPerSession() {
        return this.mAdapterConfig.getMaxAdsPerSession();
    }

    public String getInstanceName() {
        return this.mAdapterConfig.getProviderName();
    }

    public String getNameForReflection() {
        return this.mAdapterConfig.getProviderNameForReflection();
    }

    public void setIsLoadCandidate(boolean isLoadCandidate) {
        this.mIsLoadCandidate = isLoadCandidate;
    }

    public boolean getIsLoadCandidate() {
        return this.mIsLoadCandidate;
    }

    public int getProgrammaticValue() {
        return 1;
    }

    public Map<String, Object> getProviderEventData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            data.put("providerAdapterVersion", this.mAdapter != null ? this.mAdapter.getVersion() : "");
            data.put("providerSDKVersion", this.mAdapter != null ? this.mAdapter.getCoreSDKVersion() : "");
            data.put("spId", this.mAdapterConfig.getSubProviderId());
            data.put("provider", this.mAdapterConfig.getAdSourceNameForEvents());
            data.put("instanceType", this.isBidder() ? 2 : 1);
            data.put("programmatic", this.getProgrammaticValue());
            if (!TextUtils.isEmpty((CharSequence)this.mDynamicDemandSourceId)) {
                data.put("dynamicDemandSource", this.mDynamicDemandSourceId);
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "getProviderEventData " + this.getInstanceName() + ")", e2);
        }
        return data;
    }

    public void setDynamicDemandSourceIdByServerData(String serverData) {
        this.mDynamicDemandSourceId = AuctionDataUtils.getInstance().getDynamicDemandSourceIdFromServerData(serverData);
    }
}

