/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.DemandOnlyIsSmash;
import com.ironsource.mediationsdk.ISDemandOnlyListenerWrapper;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.InterstitialConfigurations;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.DemandOnlyIsManagerListener;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

class DemandOnlyIsManager
implements DemandOnlyIsManagerListener {
    private ConcurrentHashMap<String, DemandOnlyIsSmash> mSmashes = new ConcurrentHashMap();
    private AuctionSettings mAuctionSettings;

    DemandOnlyIsManager(List<ProviderSettings> providersList, InterstitialConfigurations configs, String appKey, String userId) {
        this.mAuctionSettings = configs.getInterstitialAuctionSettings();
        for (ProviderSettings provider : providersList) {
            if (provider.getProviderTypeForReflection().equalsIgnoreCase("SupersonicAds") || provider.getProviderTypeForReflection().equalsIgnoreCase("IronSource")) {
                AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(provider, provider.getRewardedVideoSettings(), true);
                if (adapter == null) continue;
                DemandOnlyIsSmash smash = new DemandOnlyIsSmash(appKey, userId, provider, this, configs.getInterstitialAdaptersSmartLoadTimeout(), adapter);
                this.mSmashes.put(provider.getSubProviderId(), smash);
                continue;
            }
            this.logInternal("cannot load " + provider.getProviderTypeForReflection());
        }
    }

    public void loadInterstitialWithAdm(String instanceId, String adm, boolean isBidderFlow) {
        try {
            if (!this.mSmashes.containsKey(instanceId)) {
                this.sendMediationEvent(2500, instanceId);
                IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Interstitial");
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, error);
                return;
            }
            DemandOnlyIsSmash smash = this.mSmashes.get(instanceId);
            if (isBidderFlow) {
                if (!smash.isBidder()) {
                    IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitialWithAdm in IAB flow must be called by bidder instances");
                    this.logInternal(error.getErrorMessage());
                    ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, error);
                    this.sendProviderEvent(2200, smash);
                } else {
                    JSONObject jsonObj = AuctionDataUtils.getInstance().decodeAdmResponse(adm);
                    AuctionDataUtils.AuctionData auctionDataObj = AuctionDataUtils.getInstance().getAuctionDataFromResponse(jsonObj);
                    AuctionResponseItem responseItem = AuctionDataUtils.getInstance().getAuctionResponseItem(smash.getInstanceName(), auctionDataObj.getWaterfall());
                    if (responseItem != null) {
                        smash.setDynamicDemandSourceIdByServerData(responseItem.getServerData());
                        smash.loadInterstitial(responseItem.getServerData(), auctionDataObj.getAuctionId(), responseItem.getBurls());
                        this.sendProviderEvent(2002, smash);
                    } else {
                        IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitialWithAdm invalid enriched adm");
                        this.logInternal(error.getErrorMessage());
                        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, error);
                        this.sendProviderEvent(2200, smash);
                    }
                }
            } else if (!smash.isBidder()) {
                this.sendProviderEvent(2002, smash);
                smash.loadInterstitial("", "", null);
            } else {
                IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitialWithAdm in non IAB flow must be called by non bidder instances");
                this.logInternal(error.getErrorMessage());
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, error);
                this.sendProviderEvent(2200, smash);
            }
        }
        catch (Exception e2) {
            IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitialWithAdm exception");
            this.logInternal(error.getErrorMessage());
            ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, error);
        }
    }

    public String getBiddingData() {
        this.sendMediationEvent(83005, null);
        if (this.mSmashes != null) {
            DemandOnlyIsSmash smash = this.mSmashes.entrySet().iterator().next().getValue();
            String token = AdapterRepository.getInstance().getBiddingData(IronSource.AD_UNIT.INTERSTITIAL, smash.getAdapterConfig().getProviderSettings());
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
            String sessionId = IronSourceUtils.getSessionId();
            if (token != null) {
                HashMap<String, String> ironSourceBidderMap = new HashMap<String, String>();
                ironSourceBidderMap.put("token", token);
                HashMap<String, Object> bidder = new HashMap<String, Object>();
                bidder.put("IronSource", ironSourceBidderMap);
                try {
                    JSONObject ret = new JSONObject();
                    ret = AuctionDataUtils.getInstance().enrichToken(ContextProvider.getInstance().getApplicationContext(), bidder, null, null, sessionDepth, sessionId, this.mAuctionSettings);
                    return AuctionDataUtils.getInstance().encryptToken(ret);
                }
                catch (JSONException e2) {
                    this.logInternal("getBiddingData() got error during enrich token");
                    this.sendMediationEvent(83007, null);
                    return null;
                }
            }
        }
        this.logInternal("called getBiddingData() with no smashes");
        this.sendMediationEvent(83006, null);
        return null;
    }

    public void showInterstitial(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(2500, instanceId);
            IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Interstitial");
            ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdShowFailed(instanceId, error);
            return;
        }
        DemandOnlyIsSmash smash = this.mSmashes.get(instanceId);
        this.sendProviderEvent(2201, smash);
        smash.showInterstitial();
    }

    public boolean isInterstitialReady(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(2500, instanceId);
            return false;
        }
        DemandOnlyIsSmash smash = this.mSmashes.get(instanceId);
        if (smash.isInterstitialReady()) {
            this.sendProviderEvent(2211, smash);
            return true;
        }
        this.sendProviderEvent(2212, smash);
        return false;
    }

    @Override
    public void onInterstitialAdReady(DemandOnlyIsSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onInterstitialAdReady");
        this.sendProviderEvent(2003, smash, new Object[][]{{"duration", elapsedTime}});
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdReady(smash.getSubProviderId());
    }

    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error, DemandOnlyIsSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onInterstitialAdLoadFailed error=" + error.toString());
        this.sendProviderEvent(2200, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", elapsedTime}});
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onInterstitialAdOpened(DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdOpened");
        this.sendProviderEvent(2005, smash);
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdOpened(smash.getSubProviderId());
        if (smash.isBidder()) {
            for (String url : smash.mBUrl) {
                if (url == null) continue;
                AuctionDataUtils.getInstance().sendResponse(url);
            }
        }
    }

    @Override
    public void onInterstitialAdClosed(DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdClosed");
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
        this.sendProviderEvent(2204, smash, new Object[][]{{"sessionDepth", sessionDepth}});
        SessionDepthManager.getInstance().increaseSessionDepth(2);
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdClosed(smash.getSubProviderId());
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error, DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdShowFailed error=" + error.toString());
        this.sendProviderEvent(2203, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdShowFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onInterstitialAdClicked(DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdClicked");
        this.sendProviderEvent(2006, smash);
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdClicked(smash.getSubProviderId());
    }

    @Override
    public void onInterstitialAdVisible(DemandOnlyIsSmash smash) {
        this.sendProviderEvent(2210, smash);
        this.logSmashCallback(smash, "onInterstitialAdVisible");
    }

    private void sendProviderEvent(int eventId, DemandOnlyIsSmash smash) {
        this.sendProviderEvent(eventId, smash, null);
    }

    private void sendProviderEvent(int eventId, DemandOnlyIsSmash smash, Object[][] keyVals) {
        Map<String, Object> data = smash.getProviderEventData();
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    private void sendMediationEvent(int eventId, String instanceId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("isDemandOnly", 1);
        data.put("spId", instanceId != null ? instanceId : "");
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "DemandOnlyIsManager " + text, 0);
    }

    private void logSmashCallback(DemandOnlyIsSmash smash, String line) {
        String text = "DemandOnlyIsManager " + smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

