/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.LoadWhileShowSupportState;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.logger.LogListener;
import com.ironsource.mediationsdk.logger.LoggingApi;
import com.ironsource.mediationsdk.sdk.BannerAdapterApi;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.BaseApi;
import com.ironsource.mediationsdk.sdk.InterstitialAdapterApi;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoAdapterApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ContextProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public abstract class AbstractAdapter
implements BaseApi,
InterstitialAdapterApi,
RewardedVideoAdapterApi,
BannerAdapterApi,
LoggingApi {
    private IronSourceLoggerManager mLoggerManager;
    protected RewardedVideoSmashListener mActiveRewardedVideoSmash;
    protected CopyOnWriteArrayList<RewardedVideoSmashListener> mAllRewardedVideoSmashes;
    protected ConcurrentHashMap<String, RewardedVideoSmashListener> mRewardedVideoPlacementToListenerMap;
    protected InterstitialSmashListener mActiveInterstitialSmash;
    protected CopyOnWriteArrayList<InterstitialSmashListener> mAllInterstitialSmashes;
    protected ConcurrentHashMap<String, InterstitialSmashListener> mInterstitialPlacementToListenerMap;
    protected BannerSmashListener mActiveBannerSmash;
    protected CopyOnWriteArrayList<BannerSmashListener> mAllBannerSmashes;
    protected ConcurrentHashMap<String, BannerSmashListener> mBannerPlacementToListenerMap;
    private String mPluginType;
    private String mPluginFrameworkVersion;
    private String mProviderName;
    private static Boolean mAdapterDebug;
    protected LoadWhileShowSupportState mLWSSupportState = LoadWhileShowSupportState.NONE;

    public void earlyInit(String appKey, String userId, JSONObject config) {
    }

    public void initInterstitialForBidding(String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
    }

    public void initRewardedVideoForBidding(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
    }

    public void loadRewardedVideoForBidding(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
    }

    public void loadInterstitialForBidding(JSONObject config, InterstitialSmashListener listener, String serverData) {
    }

    public Map<String, Object> getInterstitialBiddingData(JSONObject config) {
        return null;
    }

    public Map<String, Object> getRewardedVideoBiddingData(JSONObject config) {
        return null;
    }

    public void initRewardedVideoForDemandOnly(String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
    }

    public void loadRewardedVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener) {
    }

    public void loadRewardedVideoForDemandOnlyForBidding(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
    }

    public AbstractAdapter(String providerName) {
        this.mLoggerManager = IronSourceLoggerManager.getLogger();
        this.mAllRewardedVideoSmashes = new CopyOnWriteArrayList();
        this.mAllInterstitialSmashes = new CopyOnWriteArrayList();
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mRewardedVideoPlacementToListenerMap = new ConcurrentHashMap();
        this.mInterstitialPlacementToListenerMap = new ConcurrentHashMap();
        this.mBannerPlacementToListenerMap = new ConcurrentHashMap();
        this.mProviderName = providerName;
    }

    public String getProviderName() {
        return this.mProviderName;
    }

    protected String getDynamicUserId() {
        return IronSourceObject.getInstance().getDynamicUserId();
    }

    void setPluginData(String pluginType, String pluginFrameworkVersion) {
        this.mPluginType = pluginType;
        this.mPluginFrameworkVersion = pluginFrameworkVersion;
    }

    public String getPluginType() {
        return this.mPluginType;
    }

    public String getPluginFrameworkVersion() {
        return this.mPluginFrameworkVersion;
    }

    public abstract String getVersion();

    public abstract String getCoreSDKVersion();

    @Override
    public void setLogListener(LogListener logListener) {
    }

    protected boolean isAdaptersDebugEnabled() {
        return mAdapterDebug != null && mAdapterDebug != false;
    }

    @Override
    public void initBanners(String appKey, String userId, JSONObject config, BannerSmashListener listener) {
    }

    @Override
    public void loadBanner(IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
    }

    @Override
    public void destroyBanner(JSONObject config) {
    }

    @Override
    public void reloadBanner(IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
    }

    @Override
    public boolean shouldBindBannerViewOnReload() {
        return false;
    }

    protected void addBannerListener(BannerSmashListener listener) {
    }

    protected void removeBannerListener(BannerSmashListener listener) {
    }

    @Override
    public void addRewardedVideoListener(RewardedVideoSmashListener listener) {
        this.mAllRewardedVideoSmashes.add(listener);
    }

    public void updateRewardedVideoListener(RewardedVideoSmashListener listener) {
        this.mAllRewardedVideoSmashes.clear();
        this.mAllRewardedVideoSmashes.add(listener);
    }

    @Override
    public void removeRewardedVideoListener(RewardedVideoSmashListener listener) {
        this.mAllRewardedVideoSmashes.remove(listener);
    }

    @Override
    public void addInterstitialListener(InterstitialSmashListener listener) {
        this.mAllInterstitialSmashes.add(listener);
    }

    @Override
    public void removeInterstitialListener(InterstitialSmashListener listener) {
        this.mAllInterstitialSmashes.remove(listener);
    }

    public void setAge(int age) {
    }

    public void setGender(String gender) {
    }

    @Override
    public void setMediationSegment(String segment) {
    }

    protected void setMediationState(AbstractSmash.MEDIATION_STATE state, String adUnit) {
    }

    protected void setConsent(boolean consent) {
    }

    protected void setAdapterDebug(Boolean adapterDebug) {
        mAdapterDebug = adapterDebug;
    }

    protected void setMetaData(String key, String value) {
    }

    public LoadWhileShowSupportState getLoadWhileShowSupportState() {
        return this.mLWSSupportState;
    }

    protected void postOnUIThread(Runnable runnable) {
        ContextProvider.getInstance().postOnUIThread(runnable);
    }

    protected void runOnUIThread(Runnable runnable) {
        ContextProvider.getInstance().runOnUIThread(runnable);
    }
}

