/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.service;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.ConnectivityService;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.sdk.service.Connectivity.ConnectivityUtils;
import com.ironsource.sdk.utils.DeviceProperties;
import com.ironsource.sdk.utils.IronSourceStorageUtils;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import org.json.JSONObject;

public class DeviceData {
    private static final String TAG = DeviceData.class.getSimpleName();

    public static JSONObject fetchAdvertiserIdData(Context context) {
        SDKUtils.loadGoogleAdvertiserInfo(context);
        String advertiserId = SDKUtils.getAdvertiserId();
        Boolean isLAT = SDKUtils.isLimitAdTrackingEnabled();
        JSONObject jsObj = new JSONObject();
        if (!TextUtils.isEmpty((CharSequence)advertiserId)) {
            try {
                Logger.i(TAG, "add AID and LAT");
                jsObj.put("isLimitAdTrackingEnabled", (Object)isLAT);
                StringBuilder aid = new StringBuilder().append("deviceIds").append("[").append("AID").append("]");
                jsObj.put(aid.toString(), (Object)SDKUtils.encodeString(advertiserId));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return jsObj;
    }

    public static JSONObject fetchMutableData(Context context) {
        JSONObject jsObj = new JSONObject();
        DeviceData.updateWithDisplaySize(jsObj);
        DeviceData.updateWithConnectionInfo(context, jsObj);
        DeviceData.updateWithFreeDiskSize(context, jsObj);
        DeviceData.updateWithBatteryLevel(context, jsObj);
        DeviceData.updateWithDeviceVolume(context, jsObj);
        DeviceData.updateWithSDCardAvailable(jsObj);
        DeviceData.updateWithIsCharging(context, jsObj);
        DeviceData.updateWithChargingType(context, jsObj);
        DeviceData.updateWithAirplaneMode(context, jsObj);
        DeviceData.updateWithStayOnWhenPluggedIn(context, jsObj);
        return jsObj;
    }

    private static void updateObjectWithKeyValue(JSONObject jsObj, String key, String value) {
        try {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                jsObj.put(key, (Object)SDKUtils.encodeString(value));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean getControllerConfigFlagValue(String flagName) {
        return SDKUtils.getControllerConfigAsJSONObject().optBoolean(flagName);
    }

    private static void updateWithDisplaySize(JSONObject jsObj) {
        try {
            String width = String.valueOf(DeviceStatus.getDisplayWidth());
            DeviceData.updateObjectWithKeyValue(jsObj, "displaySizeWidth", width);
            String height = String.valueOf(DeviceStatus.getDisplayHeight());
            DeviceData.updateObjectWithKeyValue(jsObj, "displaySizeHeight", height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithConnectionInfo(Context context, JSONObject jsObj) {
        try {
            String connectionType = ConnectivityUtils.getConnectionType(context);
            if (!TextUtils.isEmpty((CharSequence)connectionType) && !connectionType.equals("none")) {
                jsObj.put(SDKUtils.encodeString("connectionType"), (Object)SDKUtils.encodeString(connectionType));
            }
            if (Build.VERSION.SDK_INT >= 23) {
                jsObj.put(SDKUtils.encodeString("cellularNetworkType"), ConnectivityService.getCellularNetworkType(context));
                jsObj.put(SDKUtils.encodeString("hasVPN"), ConnectivityUtils.hasVPN(context));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithBatteryLevel(Context context, JSONObject jsObj) {
        try {
            jsObj.put(SDKUtils.encodeString("batteryLevel"), DeviceStatus.getBatteryLevel(context));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithDeviceVolume(Context context, JSONObject jsObj) {
        try {
            float deviceVolume = DeviceProperties.getInstance(context).getDeviceVolume(context);
            jsObj.put(SDKUtils.encodeString("deviceVolume"), (double)deviceVolume);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithFreeDiskSize(Context context, JSONObject jsObj) {
        try {
            long freeDiskSize = DeviceStatus.getAvailableMemorySizeInMegaBytes(IronSourceStorageUtils.getDiskCacheDirPath(context));
            jsObj.put(SDKUtils.encodeString("diskFreeSize"), (Object)SDKUtils.encodeString(String.valueOf(freeDiskSize)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithSDCardAvailable(JSONObject jsObj) {
        try {
            if (DeviceData.getControllerConfigFlagValue("sdCardAvailable")) {
                jsObj.put(SDKUtils.encodeString("sdCardAvailable"), DeviceStatus.isExternalMemoryAvailableWritable());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithIsCharging(Context context, JSONObject jsObj) {
        try {
            if (DeviceData.getControllerConfigFlagValue("isCharging")) {
                jsObj.put(SDKUtils.encodeString("isCharging"), DeviceStatus.isCharging(context));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithChargingType(Context context, JSONObject jsObj) {
        try {
            if (DeviceData.getControllerConfigFlagValue("chargingType")) {
                jsObj.put(SDKUtils.encodeString("chargingType"), DeviceStatus.chargingType(context));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithAirplaneMode(Context context, JSONObject jsObj) {
        try {
            if (DeviceData.getControllerConfigFlagValue("airplaneMode")) {
                jsObj.put(SDKUtils.encodeString("airplaneMode"), DeviceStatus.isAirplaneMode(context));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void updateWithStayOnWhenPluggedIn(Context context, JSONObject jsObj) {
        try {
            if (DeviceData.getControllerConfigFlagValue("stayOnWhenPluggedIn")) {
                jsObj.put(SDKUtils.encodeString("stayOnWhenPluggedIn"), DeviceStatus.isStayOnWhenPluggedIn(context));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static JSONObject fetchPermanentData(Context context) {
        DeviceProperties deviceProperties = DeviceProperties.getInstance(context);
        JSONObject jsObj = new JSONObject();
        try {
            boolean isRoot;
            String rootStr;
            float deviceScale;
            String scaleStr;
            String packageName;
            String deviceLanguage;
            String deviceOSVersionFull;
            String deviceOSVersion;
            String deviceOSType;
            String deviceModel;
            String deviceOem = deviceProperties.getDeviceOem();
            if (deviceOem != null) {
                jsObj.put(SDKUtils.encodeString("deviceOEM"), (Object)SDKUtils.encodeString(deviceOem));
            }
            if ((deviceModel = deviceProperties.getDeviceModel()) != null) {
                jsObj.put(SDKUtils.encodeString("deviceModel"), (Object)SDKUtils.encodeString(deviceModel));
            }
            if ((deviceOSType = deviceProperties.getDeviceOsType()) != null) {
                jsObj.put(SDKUtils.encodeString("deviceOs"), (Object)SDKUtils.encodeString(deviceOSType));
            }
            if ((deviceOSVersion = deviceProperties.getDeviceOsVersion()) != null) {
                deviceOSVersion = deviceOSVersion.replaceAll("[^0-9/.]", "");
                jsObj.put(SDKUtils.encodeString("deviceOSVersion"), (Object)deviceOSVersion);
            }
            if ((deviceOSVersionFull = deviceProperties.getDeviceOsVersion()) != null) {
                jsObj.put(SDKUtils.encodeString("deviceOSVersionFull"), (Object)SDKUtils.encodeString(deviceOSVersionFull));
            }
            String deviceApiLevel = String.valueOf(deviceProperties.getDeviceApiLevel());
            jsObj.put(SDKUtils.encodeString("deviceApiLevel"), (Object)deviceApiLevel);
            String ssaSDKVersion = DeviceProperties.getSupersonicSdkVersion();
            if (ssaSDKVersion != null) {
                jsObj.put(SDKUtils.encodeString("SDKVersion"), (Object)SDKUtils.encodeString(ssaSDKVersion));
            }
            if (deviceProperties.getDeviceCarrier() != null && deviceProperties.getDeviceCarrier().length() > 0) {
                jsObj.put(SDKUtils.encodeString("mobileCarrier"), (Object)SDKUtils.encodeString(deviceProperties.getDeviceCarrier()));
            }
            if (!TextUtils.isEmpty((CharSequence)(deviceLanguage = context.getResources().getConfiguration().locale.getLanguage()))) {
                jsObj.put(SDKUtils.encodeString("deviceLanguage"), (Object)SDKUtils.encodeString(deviceLanguage.toUpperCase()));
            }
            if (DeviceData.getControllerConfigFlagValue("totalDeviceRAM")) {
                long totalDeviceRAM = DeviceStatus.getTotalDeviceRAM(context);
                jsObj.put(SDKUtils.encodeString("totalDeviceRAM"), (Object)SDKUtils.encodeString(String.valueOf(totalDeviceRAM)));
            }
            if (!TextUtils.isEmpty((CharSequence)(packageName = ApplicationContext.getPackageName(context)))) {
                jsObj.put(SDKUtils.encodeString("bundleId"), (Object)SDKUtils.encodeString(packageName));
            }
            if (!TextUtils.isEmpty((CharSequence)(scaleStr = String.valueOf(deviceScale = DeviceStatus.getDeviceDensity())))) {
                jsObj.put(SDKUtils.encodeString("deviceScreenScale"), (Object)SDKUtils.encodeString(scaleStr));
            }
            if (!TextUtils.isEmpty((CharSequence)(rootStr = String.valueOf(isRoot = DeviceStatus.isRootedDevice())))) {
                jsObj.put(SDKUtils.encodeString("unLocked"), (Object)SDKUtils.encodeString(rootStr));
            }
            jsObj.put(SDKUtils.encodeString("mcc"), ConnectivityService.getNetworkMCC(context));
            jsObj.put(SDKUtils.encodeString("mnc"), ConnectivityService.getNetworkMNC(context));
            jsObj.put(SDKUtils.encodeString("phoneType"), ConnectivityService.getPhoneType(context));
            jsObj.put(SDKUtils.encodeString("simOperator"), (Object)SDKUtils.encodeString(ConnectivityService.getSimOperator(context)));
            jsObj.put(SDKUtils.encodeString("lastUpdateTime"), ApplicationContext.getLastUpdateTime(context));
            jsObj.put(SDKUtils.encodeString("firstInstallTime"), ApplicationContext.getFirstInstallTime(context));
            jsObj.put(SDKUtils.encodeString("appVersion"), (Object)SDKUtils.encodeString(ApplicationContext.getApplicationVersionName(context)));
            String installerPackageName = ApplicationContext.getInstallerPackageName(context);
            if (!TextUtils.isEmpty((CharSequence)installerPackageName)) {
                jsObj.put(SDKUtils.encodeString("installerPackageName"), (Object)SDKUtils.encodeString(installerPackageName));
            }
            jsObj.put("localTime", (Object)SDKUtils.encodeString(String.valueOf(DeviceStatus.getDeviceLocalTime())));
            jsObj.put("timezoneOffset", (Object)SDKUtils.encodeString(String.valueOf(DeviceStatus.getDeviceTimeZoneOffsetInMinutes())));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsObj;
    }
}

