/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.service.Connectivity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import android.util.Log;
import com.ironsource.sdk.service.Connectivity.ConnectivityUtils;
import com.ironsource.sdk.service.Connectivity.IConnectivity;
import com.ironsource.sdk.service.Connectivity.IConnectivityStatus;
import org.json.JSONObject;

public class NetworkCallbackStrategy
implements IConnectivity {
    private String TAG = NetworkCallbackStrategy.class.getSimpleName();
    private int kSupportingVersionForNetworkCallback = 23;
    private final IConnectivityStatus mNetworkState;
    private ConnectivityManager.NetworkCallback mNetworkCallback;

    public NetworkCallbackStrategy(IConnectivityStatus networkState) {
        this.mNetworkState = networkState;
    }

    @Override
    @SuppressLint(value={"NewApi", "MissingPermission"})
    public void startListenToNetworkChanges(final Context context) {
        if (Build.VERSION.SDK_INT >= this.kSupportingVersionForNetworkCallback) {
            this.stopListenToNetworkChanges(context);
            if (ConnectivityUtils.getConnectionType(context).equals("none")) {
                this.mNetworkState.onDisconnected();
            }
            if (this.mNetworkCallback == null) {
                this.mNetworkCallback = new ConnectivityManager.NetworkCallback(){

                    public void onAvailable(Network network) {
                        if (network != null) {
                            NetworkCallbackStrategy.this.mNetworkState.onConnected(ConnectivityUtils.getConnectionType(network, context), ConnectivityUtils.getNetworkData(context, network));
                        } else {
                            NetworkCallbackStrategy.this.mNetworkState.onConnected(ConnectivityUtils.getConnectionType(context), ConnectivityUtils.getNetworkData(context, ConnectivityUtils.getActiveNetwork(context)));
                        }
                    }

                    public void onLost(Network network) {
                        if (ConnectivityUtils.getConnectionType(context).equals("none")) {
                            NetworkCallbackStrategy.this.mNetworkState.onDisconnected();
                        }
                    }

                    public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                        if (network != null) {
                            NetworkCallbackStrategy.this.mNetworkState.onStatusChanged(ConnectivityUtils.getConnectionType(network, context), ConnectivityUtils.getNetworkData(context, network));
                        }
                    }

                    public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
                        if (network != null) {
                            NetworkCallbackStrategy.this.mNetworkState.onStatusChanged(ConnectivityUtils.getConnectionType(network, context), ConnectivityUtils.getNetworkData(context, network));
                        }
                    }
                };
            }
            NetworkRequest request = new NetworkRequest.Builder().addCapability(12).build();
            try {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager != null) {
                    connectivityManager.registerNetworkCallback(request, this.mNetworkCallback);
                }
            }
            catch (Exception e2) {
                Log.e((String)this.TAG, (String)"NetworkCallback was not able to register");
            }
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void stopListenToNetworkChanges(Context context) {
        if (Build.VERSION.SDK_INT >= this.kSupportingVersionForNetworkCallback && this.mNetworkCallback != null && context != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            try {
                if (connectivityManager != null) {
                    connectivityManager.unregisterNetworkCallback(this.mNetworkCallback);
                }
            }
            catch (Exception e2) {
                Log.e((String)this.TAG, (String)"NetworkCallback for was not registered or already unregistered");
            }
        }
    }

    @Override
    public JSONObject getConnectivityInfo(Context context) {
        return ConnectivityUtils.getNetworkData(context, ConnectivityUtils.getActiveNetwork(context));
    }

    @Override
    public void release() {
        this.mNetworkCallback = null;
    }
}

