/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceAES {
    private static boolean mDidSendEncryptionFailEventInSession = false;

    public static synchronized String encode(String keyString, String stringToEncode) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)stringToEncode)) {
            return "";
        }
        try {
            SecretKeySpec skeySpec = IronSourceAES.getKey(keyString);
            byte[] clearText = stringToEncode.getBytes("UTF8");
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(1, (Key)skeySpec, ivParameterSpec);
            String encrypedValue = Base64.encodeToString((byte[])cipher.doFinal(clearText), (int)0);
            encrypedValue = encrypedValue.replaceAll(System.getProperty("line.separator"), "");
            return encrypedValue;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public static synchronized String decode(String keyString, String stringToDecode) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)stringToDecode)) {
            return "";
        }
        try {
            SecretKeySpec key = IronSourceAES.getKey(keyString);
            byte[] iv = new byte[16];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            byte[] encrypedPwdBytes = Base64.decode((String)stringToDecode, (int)0);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)key, ivParameterSpec);
            byte[] decrypedValueBytes = cipher.doFinal(encrypedPwdBytes);
            String decrypedValue = new String(decrypedValueBytes);
            return decrypedValue;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (!mDidSendEncryptionFailEventInSession) {
                mDidSendEncryptionFailEventInSession = true;
                JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
                try {
                    data.put("status", (Object)"false");
                    data.put("errorCode", 1);
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
                EventData parseFailedEvent = new EventData(114, data);
                InterstitialEventsManager.getInstance().sendEventToUrl(parseFailedEvent, "https://outcome-ssp.supersonicads.com/mediation?adUnit=2");
            }
            return "";
        }
    }

    private static SecretKeySpec getKey(String key) throws UnsupportedEncodingException {
        int keyLength = 256;
        byte[] keyBytes = new byte[keyLength / 8];
        Arrays.fill(keyBytes, (byte)0);
        byte[] passwordBytes = key.getBytes("UTF-8");
        int length = passwordBytes.length < keyBytes.length ? passwordBytes.length : keyBytes.length;
        System.arraycopy(passwordBytes, 0, keyBytes, 0, length);
        return new SecretKeySpec(keyBytes, "AES");
    }
}

