/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.metadata;

import com.ironsource.mediationsdk.metadata.MetaData;

public class MetaDataUtils {
    public static MetaData.MetaDataValueTypes getValueTypeForKey(String key) {
        if (key.equalsIgnoreCase("do_not_sell")) {
            return MetaData.MetaDataValueTypes.META_DATA_VALUE_BOOLEAN;
        }
        return MetaData.MetaDataValueTypes.META_DATA_VALUE_STRING;
    }

    public static boolean isKnownKey(String key) {
        return key.equalsIgnoreCase("do_not_sell");
    }

    public static String formatValueForType(String value, MetaData.MetaDataValueTypes valueType) {
        String formattedValue = value;
        if (valueType == MetaData.MetaDataValueTypes.META_DATA_VALUE_BOOLEAN) {
            formattedValue = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") ? "true" : (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") ? "false" : "");
        }
        return formattedValue;
    }

    public static MetaData formatMetaData(String key, String value) {
        if (!MetaDataUtils.isKnownKey(key)) {
            MetaData metaData = new MetaData(key, value);
            return metaData;
        }
        String formattedKey = key.toLowerCase();
        MetaData.MetaDataValueTypes valueType = MetaDataUtils.getValueTypeForKey(formattedKey);
        String formattedValue = MetaDataUtils.formatValueForType(value, valueType);
        MetaData formattedMetaData = new MetaData(formattedKey, formattedValue, valueType);
        return formattedMetaData;
    }

    public static String checkMetaDataKeyValidity(String key) {
        if (key == null || key.length() > 64 || !key.matches("[A-Za-z0-9_\\-.]+")) {
            return "The MetaData key you entered is invalid. Please enter a key of maximum 64 characters that consists of only letters, digits and the following characters: . - _";
        }
        return "";
    }

    public static String checkMetaDataValueValidity(String value) {
        if (value == null || value.length() > 64 || !value.matches("[A-Za-z0-9_\\-.]+")) {
            return "The MetaData value you entered is invalid. Please enter a value of maximum 64 characters that consists of only letters, digits and the following characters: . - _";
        }
        return "";
    }

    public static boolean isValidCCPAMetaData(String key, String value) {
        return key.equals("do_not_sell") && value.length() > 0;
    }

    public static boolean getMetaDataBooleanValue(String value) {
        return !value.equals("false");
    }
}

