/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.environment.NetworkStateReceiver;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AdaptersCompatibilityHandler;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.AuctionEventListener;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionHistory;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.IProgRvManager;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgRvSmash;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.RVListenerWrapper;
import com.ironsource.mediationsdk.RvLoadTrigger;
import com.ironsource.mediationsdk.RvLoadTriggerCallback;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionCappingManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class ProgRvManager
implements ProgRvManagerListener,
RvLoadTriggerCallback,
AuctionEventListener,
IProgRvManager,
NetworkStateReceiver.NetworkStateReceiverListener {
    private final ConcurrentHashMap<String, ProgRvSmash> mSmashes;
    private CopyOnWriteArrayList<ProgRvSmash> mWaterfall;
    private List<AuctionResponseItem> mNextWaterfallToLoad;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private ConcurrentHashMap<String, AuctionHistory.ISAuctionPerformance> mWaterfallPerformance;
    private SessionCappingManager mSessionCappingManager;
    private RvLoadTrigger mRvLoadTrigger;
    private boolean mIsAuctionEnabled;
    private boolean mIsAuctionOnShowStart;
    private boolean mShouldLoadAfterClose;
    private AuctionHandler mAuctionHandler;
    private AuctionHistory mAuctionHistory;
    private String mCurrentPlacement;
    private String mCurrentAuctionId;
    private int mSessionDepth = 1;
    private long mAuctionStartTime;
    private long mTimeToWaitBeforeLoadMS;
    private long mLastChangedAvailabilityTime;
    private int mMaxSmashesToLoad;
    private boolean mAdvancedLoading;
    private boolean mIsShowingVideo;
    private Boolean mLastReportedAvailabilityState;
    private RV_MEDIATION_STATE mState;
    private int mAuctionTrial;
    private String mAuctionFallback = "";
    private boolean mShouldTrackNetworkState = false;
    private NetworkStateReceiver mNetworkStateReceiver;

    public ProgRvManager(List<ProviderSettings> providersList, RewardedVideoConfigurations configs, String appKey, String userId) {
        long initStartTime = new Date().getTime();
        this.sendMediationEventWithoutAuctionId(81312);
        this.setState(RV_MEDIATION_STATE.RV_STATE_INITIATING);
        this.mLastReportedAvailabilityState = null;
        this.mMaxSmashesToLoad = configs.getRewardedVideoAdaptersSmartLoadAmount();
        this.mAdvancedLoading = configs.getRewardedVideoAdvancedLoading();
        this.mCurrentPlacement = "";
        AuctionSettings auctionSettings = configs.getRewardedVideoAuctionSettings();
        this.mIsShowingVideo = false;
        this.mWaterfall = new CopyOnWriteArrayList();
        this.mNextWaterfallToLoad = new ArrayList<AuctionResponseItem>();
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mWaterfallPerformance = new ConcurrentHashMap();
        this.mLastChangedAvailabilityTime = new Date().getTime();
        this.mIsAuctionEnabled = auctionSettings.getNumOfMaxTrials() > 0;
        this.mIsAuctionOnShowStart = auctionSettings.getIsAuctionOnShowStart();
        this.mShouldLoadAfterClose = !auctionSettings.getIsLoadWhileShow();
        this.mTimeToWaitBeforeLoadMS = auctionSettings.getTimeToWaitBeforeLoadMs();
        if (this.mIsAuctionEnabled) {
            this.mAuctionHandler = new AuctionHandler("rewardedVideo", auctionSettings, this);
        }
        this.mRvLoadTrigger = new RvLoadTrigger(auctionSettings, this);
        this.mSmashes = new ConcurrentHashMap();
        ArrayList<String> instances = new ArrayList<String>();
        for (ProviderSettings provider : providersList) {
            AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(provider, provider.getRewardedVideoSettings());
            if (adapter == null || !AdaptersCompatibilityHandler.getInstance().isAdapterVersionRVCompatible(adapter)) continue;
            ProgRvSmash smash = new ProgRvSmash(appKey, userId, provider, this, configs.getRewardedVideoAdaptersSmartLoadTimeout(), adapter);
            String instanceName = smash.getInstanceName();
            this.mSmashes.put(instanceName, smash);
            instances.add(instanceName);
        }
        this.mAuctionHistory = new AuctionHistory(instances, auctionSettings.getAuctionSavedHistoryLimit());
        this.mSessionCappingManager = new SessionCappingManager(new ArrayList<ProgSmash>(this.mSmashes.values()));
        for (ProgRvSmash smash : this.mSmashes.values()) {
            if (!smash.isBidder()) continue;
            smash.initForBidding();
        }
        long elapsedTime = new Date().getTime() - initStartTime;
        this.sendMediationEventWithoutAuctionId(81313, new Object[][]{{"duration", elapsedTime}});
        this.loadRewardedVideo(auctionSettings.getTimeToWaitBeforeFirstAuctionMs());
    }

    private void loadRewardedVideo(long timeToWaitBeforeAuction) {
        if (this.mSessionCappingManager.areAllSmashesCapped()) {
            this.sendMediationEvent(81001, new Object[][]{{"errorCode", 80001}, {"reason", "all smashes are capped"}});
            this.handleLoadFailure();
            return;
        }
        if (this.mIsAuctionEnabled) {
            if (!this.mWaterfallPerformance.isEmpty()) {
                this.mAuctionHistory.storeWaterfallPerformance(this.mWaterfallPerformance);
                this.mWaterfallPerformance.clear();
            }
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ProgRvManager.this.makeAuction();
                }
            }, timeToWaitBeforeAuction);
        } else {
            this.updateWaterfallToNonBidding();
            if (this.mNextWaterfallToLoad.isEmpty()) {
                this.sendMediationEvent(81001, new Object[][]{{"errorCode", 80002}, {"reason", "waterfall is empty"}});
                this.handleLoadFailure();
                return;
            }
            this.sendMediationEventWithoutAuctionId(1000);
            if (!this.mShouldLoadAfterClose || !this.mIsShowingVideo) {
                this.loadSmashesForNextWaterfall();
            }
        }
    }

    @Override
    public synchronized void showRewardedVideo(Placement placement) {
        if (placement == null) {
            String message = "showRewardedVideo error: empty default placement";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(1021, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEvent(1113, new Object[][]{{"errorCode", 1021}, {"reason", message}}, false, true);
            return;
        }
        this.mCurrentPlacement = placement.getPlacementName();
        this.logApi("showRewardedVideo() placement=" + this.mCurrentPlacement);
        this.sendMediationEventWithPlacement(1100);
        if (this.mIsShowingVideo) {
            String message = "showRewardedVideo error: can't show ad while an ad is already showing";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(1022, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 1022}, {"reason", message}});
            return;
        }
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
            String message = "showRewardedVideo error: show called while no ads are available";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(1023, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 1023}, {"reason", message}});
            return;
        }
        if (CappingManager.isRvPlacementCapped(ContextProvider.getInstance().getApplicationContext(), this.mCurrentPlacement)) {
            String message = "showRewardedVideo error: placement " + this.mCurrentPlacement + " is capped";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(524, message);
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 524}, {"reason", message}});
            return;
        }
        for (ProgRvSmash smash : this.mWaterfall) {
            if (smash.isReadyToShow()) {
                this.mIsShowingVideo = true;
                smash.reportShowChance(true, this.mSessionDepth);
                this.showVideo(smash, placement);
                this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                return;
            }
            smash.reportShowChance(false, this.mSessionDepth);
        }
        String message = "showRewardedVideo(): No ads to show";
        this.logApi(message);
        RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
        this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", 509}, {"reason", message}});
        this.mRvLoadTrigger.showError();
    }

    private void showVideo(ProgRvSmash smash, Placement placement) {
        this.logInternal("showVideo()");
        this.mSessionCappingManager.increaseShowCounter(smash);
        if (this.mSessionCappingManager.isCapped(smash)) {
            smash.setCappedPerSession();
            IronSourceUtils.sendAutomationLog(smash.getInstanceName() + " rewarded video is now session capped");
        }
        CappingManager.incrementRvShowCounter(ContextProvider.getInstance().getApplicationContext(), placement.getPlacementName());
        if (CappingManager.isRvPlacementCapped(ContextProvider.getInstance().getApplicationContext(), placement.getPlacementName())) {
            this.sendMediationEventWithPlacement(1400);
        }
        smash.showVideo(placement, this.mSessionDepth);
    }

    @Override
    public synchronized boolean isRewardedVideoAvailable() {
        if (this.mShouldTrackNetworkState && !IronSourceUtils.isNetworkConnected(ContextProvider.getInstance().getApplicationContext())) {
            return false;
        }
        if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW || this.mIsShowingVideo) {
            return false;
        }
        for (ProgRvSmash smash : this.mWaterfall) {
            if (!smash.isReadyToShow()) continue;
            return true;
        }
        return false;
    }

    private void makeAuction() {
        this.setState(RV_MEDIATION_STATE.RV_STATE_AUCTION_IN_PROGRESS);
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgRvManager.this.logInternal("makeAuction()");
                ProgRvManager.this.mCurrentAuctionId = "";
                ProgRvManager.this.mAuctionStartTime = new Date().getTime();
                HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
                ArrayList<String> noBidderCandidates = new ArrayList<String>();
                StringBuilder waterfallStr = new StringBuilder();
                for (ProgRvSmash smash : ProgRvManager.this.mSmashes.values()) {
                    smash.unloadVideo();
                    if (ProgRvManager.this.mSessionCappingManager.isCapped(smash)) continue;
                    if (smash.isBidder()) {
                        Map<String, Object> biddingData = smash.getBiddingData();
                        if (biddingData == null) continue;
                        bidderCandidates.put(smash.getInstanceName(), biddingData);
                        waterfallStr.append("2" + smash.getInstanceName() + ",");
                        continue;
                    }
                    if (smash.isBidder()) continue;
                    noBidderCandidates.add(smash.getInstanceName());
                    waterfallStr.append("1" + smash.getInstanceName() + ",");
                }
                if (bidderCandidates.keySet().size() == 0 && noBidderCandidates.size() == 0) {
                    ProgRvManager.this.logInternal("makeAuction() failed - request waterfall is empty");
                    ProgRvManager.this.sendMediationEvent(81001, new Object[][]{{"errorCode", 80003}, {"reason", "waterfall request is empty"}});
                    ProgRvManager.this.handleLoadFailure();
                    return;
                }
                ProgRvManager.this.logInternal("makeAuction() - request waterfall is: " + waterfallStr);
                if (waterfallStr.length() > 256) {
                    waterfallStr.setLength(256);
                } else if (waterfallStr.length() > 0) {
                    waterfallStr.deleteCharAt(waterfallStr.length() - 1);
                }
                ProgRvManager.this.sendMediationEventWithoutAuctionId(1000);
                ProgRvManager.this.sendMediationEventWithoutAuctionId(1300);
                ProgRvManager.this.sendMediationEventWithoutAuctionId(1310, new Object[][]{{"ext1", waterfallStr.toString()}});
                ProgRvManager.this.mAuctionHandler.executeAuction(ContextProvider.getInstance().getApplicationContext(), bidderCandidates, noBidderCandidates, ProgRvManager.this.mAuctionHistory, ProgRvManager.this.mSessionDepth);
            }
        });
    }

    private void loadSmashesForNextWaterfall() {
        this.updateWaterfall(this.mNextWaterfallToLoad);
        this.loadSmashes();
    }

    private void updateWaterfallToNonBidding() {
        this.updateNextWaterfallToLoad(this.extractNonBidderProvidersFromWaterfall());
        this.mCurrentAuctionId = "fallback_" + System.currentTimeMillis();
    }

    private void updateNextWaterfallToLoad(List<AuctionResponseItem> waterfall) {
        this.mNextWaterfallToLoad = waterfall;
        StringBuilder waterfallStr = new StringBuilder();
        for (AuctionResponseItem item : waterfall) {
            waterfallStr.append(this.getAsString(item) + ",");
        }
        this.logInternal("updateNextWaterfallToLoad() - next waterfall is " + waterfallStr.toString());
        if (waterfallStr.length() > 256) {
            waterfallStr.setLength(256);
        } else if (waterfallStr.length() > 0) {
            waterfallStr.deleteCharAt(waterfallStr.length() - 1);
        } else {
            this.logInternal("Updated waterfall is empty");
        }
        this.sendMediationEvent(1311, new Object[][]{{"ext1", waterfallStr.toString()}});
    }

    private List<AuctionResponseItem> extractNonBidderProvidersFromWaterfall() {
        CopyOnWriteArrayList<AuctionResponseItem> nonBidders = new CopyOnWriteArrayList<AuctionResponseItem>();
        for (ProgRvSmash smash : this.mSmashes.values()) {
            if (smash.isBidder() || this.mSessionCappingManager.isCapped(smash)) continue;
            nonBidders.add(new AuctionResponseItem(smash.getInstanceName()));
        }
        return nonBidders;
    }

    private String getAsString(AuctionResponseItem item) {
        ProgRvSmash smash = this.mSmashes.get(item.getInstanceName());
        String isProgrammatic = smash != null ? (smash.isBidder() ? "2" : "1") : (TextUtils.isEmpty((CharSequence)item.getServerData()) ? "1" : "2");
        return isProgrammatic + item.getInstanceName();
    }

    private void updateWaterfall(List<AuctionResponseItem> waterfall) {
        this.mWaterfall.clear();
        this.mWaterfallServerData.clear();
        this.mWaterfallPerformance.clear();
        for (AuctionResponseItem item : waterfall) {
            ProgRvSmash smash = this.mSmashes.get(item.getInstanceName());
            if (smash != null) {
                smash.setIsLoadCandidate(true);
                this.mWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
                this.mWaterfallPerformance.put(item.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceDidntAttemptToLoad);
                continue;
            }
            this.logInternal("updateWaterfall() - could not find matching smash for auction response item " + item.getInstanceName());
        }
        this.mNextWaterfallToLoad.clear();
    }

    private void loadSmash(ProgRvSmash smash) {
        String serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
        String dynamicDemandSourceId = AuctionDataUtils.getInstance().getDynamicDemandSourceIdFromServerData(serverData);
        smash.loadVideo(serverData, this.mCurrentAuctionId, this.mAuctionTrial, this.mAuctionFallback, this.mSessionDepth, dynamicDemandSourceId);
    }

    private void loadSmashes() {
        if (this.mWaterfall.isEmpty()) {
            this.sendMediationEvent(81001, new Object[][]{{"errorCode", 80004}, {"reason", "waterfall is empty"}});
            this.handleLoadFailure();
            return;
        }
        this.setState(RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES);
        int loadedInstances = 0;
        for (int i = 0; i < this.mWaterfall.size() && loadedInstances < this.mMaxSmashesToLoad; ++i) {
            ProgRvSmash smash = this.mWaterfall.get(i);
            if (!smash.getIsLoadCandidate()) continue;
            if (this.mAdvancedLoading && smash.isBidder()) {
                if (loadedInstances == 0) {
                    this.loadSmash(smash);
                    break;
                }
                this.logInternal("Advanced Loading: Won't start loading bidder " + smash.getInstanceName() + " as a non bidder is being loaded");
                break;
            }
            this.loadSmash(smash);
            ++loadedInstances;
        }
    }

    private void handleLoadFailure() {
        this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
        this.reportAvailabilityIfNeeded(false);
        this.mRvLoadTrigger.loadError();
    }

    private void setState(RV_MEDIATION_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        this.mState = state;
    }

    @Override
    public synchronized void onLoadSuccess(ProgRvSmash smash, String auctionId) {
        this.logSmashCallback(smash, "onLoadSuccess ");
        if (this.mCurrentAuctionId != null && !auctionId.equalsIgnoreCase(this.mCurrentAuctionId)) {
            this.logInternal("onLoadSuccess was invoked with auctionId: " + auctionId + " and the current id is " + this.mCurrentAuctionId);
            smash.sendProviderEvent(81315, new Object[][]{{"errorCode", 2}, {"reason", "onLoadSuccess wrong auction ID " + (Object)((Object)this.mState)}});
            return;
        }
        RV_MEDIATION_STATE currentState = this.mState;
        this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceLoadedSuccessfully);
        this.reportAvailabilityIfNeeded(true);
        if (this.mState == RV_MEDIATION_STATE.RV_STATE_LOADING_SMASHES) {
            this.setState(RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW);
            long elapsedTime = new Date().getTime() - this.mAuctionStartTime;
            this.sendMediationEvent(1003, new Object[][]{{"duration", elapsedTime}});
            if (this.mIsAuctionEnabled) {
                AuctionResponseItem winnerInstance = this.mWaterfallServerData.get(smash.getInstanceName());
                if (winnerInstance != null) {
                    this.mAuctionHandler.reportLoadSuccess(winnerInstance);
                    this.mAuctionHandler.reportAuctionLose(this.mWaterfall, this.mWaterfallServerData, winnerInstance);
                } else {
                    String smashName = smash != null ? smash.getInstanceName() : "Smash is null";
                    this.logErrorInternal("onLoadSuccess winner instance " + smashName + " missing from waterfall. auctionId: " + auctionId + " and the current id is " + this.mCurrentAuctionId);
                    this.sendMediationEvent(81317, new Object[][]{{"errorCode", 1010}, {"reason", "Loaded missing " + (Object)((Object)currentState)}, {"ext1", smashName}});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoadError(ProgRvSmash smash, String auctionId) {
        CopyOnWriteArrayList<ProgRvSmash> smashesToLoad = new CopyOnWriteArrayList<ProgRvSmash>();
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onLoadError ");
            if (!auctionId.equalsIgnoreCase(this.mCurrentAuctionId)) {
                this.logInternal("onLoadError was invoked with auctionId:" + auctionId + " and the current id is " + this.mCurrentAuctionId);
                smash.sendProviderEvent(81315, new Object[][]{{"errorCode", 4}, {"reason", "loadError wrong auction ID " + (Object)((Object)this.mState)}});
                return;
            }
            this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceFailedToLoad);
            boolean hasLoadInProgress = false;
            boolean hasLoaded = false;
            for (ProgRvSmash waterfallSmash : this.mWaterfall) {
                if (waterfallSmash.getIsLoadCandidate()) {
                    if (this.mAdvancedLoading && waterfallSmash.isBidder() && (hasLoadInProgress || hasLoaded)) {
                        String reason = hasLoadInProgress ? "a non bidder is being loaded" : "a non bidder was already loaded successfully";
                        this.logInternal("Advanced Loading: Won't start loading bidder " + waterfallSmash.getInstanceName() + " as " + reason);
                        break;
                    }
                    if (this.mWaterfallServerData.get(waterfallSmash.getInstanceName()) == null) continue;
                    smashesToLoad.add(waterfallSmash);
                    if (!this.mAdvancedLoading || !smash.isBidder() || waterfallSmash.isBidder() || smashesToLoad.size() >= this.mMaxSmashesToLoad) break;
                    hasLoadInProgress = true;
                    continue;
                }
                if (waterfallSmash.isLoadingInProgress()) {
                    hasLoadInProgress = true;
                    continue;
                }
                if (!waterfallSmash.isReadyToShow()) continue;
                hasLoaded = true;
            }
            if (!(smashesToLoad != null && smashesToLoad.size() != 0 || hasLoaded || hasLoadInProgress)) {
                this.logInternal("onLoadError(): No other available smashes");
                this.reportAvailabilityIfNeeded(false);
                this.setState(RV_MEDIATION_STATE.RV_STATE_NOT_LOADED);
                this.mRvLoadTrigger.loadError();
            }
        }
        for (ProgRvSmash smashToLoad : smashesToLoad) {
            this.loadSmash(smashToLoad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdOpened(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            ++this.mSessionDepth;
            this.logSmashCallback(smash, "onRewardedVideoAdOpened");
            RVListenerWrapper.getInstance().onRewardedVideoAdOpened();
            if (this.mIsAuctionEnabled) {
                AuctionResponseItem showingInstance = this.mWaterfallServerData.get(smash.getInstanceName());
                if (showingInstance != null) {
                    this.mAuctionHandler.reportImpression(showingInstance, this.mCurrentPlacement);
                    this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceShowedSuccessfully);
                } else {
                    String smashName = smash != null ? smash.getInstanceName() : "Smash is null";
                    this.logErrorInternal("onRewardedVideoAdOpened showing instance " + smashName + " missing from waterfall");
                    this.sendMediationEvent(81317, new Object[][]{{"errorCode", 1011}, {"reason", "Showing missing " + (Object)((Object)this.mState)}, {"ext1", smashName}});
                }
            }
            this.mRvLoadTrigger.showStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            this.logSmashCallback(smash, "onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
            this.sendMediationEventWithPlacement(1113, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
            RVListenerWrapper.getInstance().onRewardedVideoAdShowFailed(error);
            this.mIsShowingVideo = false;
            this.mWaterfallPerformance.put(smash.getInstanceName(), AuctionHistory.ISAuctionPerformance.ISAuctionPerformanceFailedToShow);
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                this.reportAvailabilityIfNeeded(false);
            }
            this.mRvLoadTrigger.showError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed(ProgRvSmash smash) {
        ProgRvManager progRvManager = this;
        synchronized (progRvManager) {
            boolean hasOtherAvailableAds = false;
            try {
                for (ProgRvSmash aSmash : this.mSmashes.values()) {
                    if (!aSmash.isRewardedVideoAvailable()) continue;
                    this.logInternal(aSmash.getInstanceName() + " has available RV");
                    hasOtherAvailableAds = true;
                    break;
                }
            }
            catch (Throwable e2) {
                this.logInternal("Failed to check RV availability");
            }
            smash.sendProviderEventWithPlacement(1203, new Object[][]{{"ext1", "otherRVAvailable = " + (hasOtherAvailableAds ? "true" : "false")}});
            this.logSmashCallback(smash, "onRewardedVideoAdClosed, mediation state: " + this.mState.name());
            RVListenerWrapper.getInstance().onRewardedVideoAdClosed();
            this.mIsShowingVideo = false;
            if (this.mState != RV_MEDIATION_STATE.RV_STATE_READY_TO_SHOW) {
                this.reportAvailabilityIfNeeded(false);
            }
            if (this.mIsAuctionOnShowStart) {
                if (this.mNextWaterfallToLoad != null && this.mNextWaterfallToLoad.size() > 0) {
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            ProgRvManager.this.loadSmashesForNextWaterfall();
                        }
                    }, this.mTimeToWaitBeforeLoadMS);
                }
            } else {
                this.mRvLoadTrigger.showEnd();
            }
        }
    }

    @Override
    public void onRewardedVideoAdStarted(ProgRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdStarted");
        RVListenerWrapper.getInstance().onRewardedVideoAdStarted();
    }

    @Override
    public void onRewardedVideoAdEnded(ProgRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdEnded");
        RVListenerWrapper.getInstance().onRewardedVideoAdEnded();
    }

    @Override
    public void onRewardedVideoAdRewarded(ProgRvSmash smash, Placement placement) {
        this.logSmashCallback(smash, "onRewardedVideoAdRewarded");
        RVListenerWrapper.getInstance().onRewardedVideoAdRewarded(placement);
    }

    @Override
    public void onRewardedVideoAdClicked(ProgRvSmash smash, Placement placement) {
        this.logSmashCallback(smash, "onRewardedVideoAdClicked");
        RVListenerWrapper.getInstance().onRewardedVideoAdClicked(placement);
    }

    private void reportAvailabilityIfNeeded(boolean isAvailable) {
        if (this.mLastReportedAvailabilityState == null || this.mLastReportedAvailabilityState != isAvailable) {
            this.mLastReportedAvailabilityState = isAvailable;
            long timeSpentInLastAvailability = new Date().getTime() - this.mLastChangedAvailabilityTime;
            this.mLastChangedAvailabilityTime = new Date().getTime();
            if (isAvailable) {
                this.sendMediationEvent(1111, new Object[][]{{"duration", timeSpentInLastAvailability}});
            } else {
                this.sendMediationEvent(1112, new Object[][]{{"duration", timeSpentInLastAvailability}});
            }
            RVListenerWrapper.getInstance().onRewardedVideoAvailabilityChanged(isAvailable);
        }
    }

    private void logSmashCallback(ProgRvSmash smash, String line) {
        String text = smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "ProgRvManager: " + text, 0);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgRvManager: " + text, 0);
    }

    private void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgRvManager: " + text, 3);
    }

    private void logAPIError(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 3);
    }

    private void logApi(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 1);
    }

    private void sendMediationEventWithoutAuctionId(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false, false);
    }

    private void sendMediationEventWithoutAuctionId(int eventId) {
        this.sendMediationEvent(eventId, null, false, false);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false, true);
    }

    private void sendMediationEventWithPlacement(int eventId) {
        this.sendMediationEvent(eventId, null, true, true);
    }

    private void sendMediationEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, true, true);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals, boolean isAddPlacement, boolean isAddAuctionId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("programmatic", 1);
        if (isAddAuctionId && !TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        if (this.shouldAddAuctionParams(eventId)) {
            RewardedVideoEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFallback);
        }
        data.put("sessionDepth", this.mSessionDepth);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgRvManager: RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 1003 || eventId == 1302 || eventId == 1301;
    }

    @Override
    public synchronized void onLoadTriggered() {
        this.logInternal("onLoadTriggered: RV load was triggered in " + (Object)((Object)this.mState) + " state");
        this.loadRewardedVideo(0L);
    }

    @Override
    public void onAuctionSuccess(List<AuctionResponseItem> newWaterfall, String auctionId, int auctionTrial, long elapsedTime) {
        this.logInternal("makeAuction(): success");
        this.mCurrentAuctionId = auctionId;
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFallback = "";
        this.sendMediationEvent(1302, new Object[][]{{"duration", elapsedTime}});
        this.updateNextWaterfallToLoad(newWaterfall);
        if (!this.mShouldLoadAfterClose || !this.mIsShowingVideo) {
            this.loadSmashesForNextWaterfall();
        }
    }

    @Override
    public void onAuctionFailed(int errorCode, String errorMessage, int auctionTrial, String auctionFallback, long elapsedTime) {
        this.logInternal("Auction failed | moving to fallback waterfall");
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFallback = auctionFallback;
        if (TextUtils.isEmpty((CharSequence)errorMessage)) {
            this.sendMediationEventWithoutAuctionId(1301, new Object[][]{{"errorCode", errorCode}, {"duration", elapsedTime}});
        } else {
            this.sendMediationEventWithoutAuctionId(1301, new Object[][]{{"errorCode", errorCode}, {"reason", errorMessage}, {"duration", elapsedTime}});
        }
        this.updateWaterfallToNonBidding();
        if (!this.mShouldLoadAfterClose || !this.mIsShowingVideo) {
            this.loadSmashesForNextWaterfall();
        }
    }

    @Override
    public void onNetworkAvailabilityChanged(boolean connected) {
        if (!this.mShouldTrackNetworkState) {
            return;
        }
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Network Availability Changed To: " + connected, 1);
        if (this.shouldNotifyNetworkAvailabilityChanged(connected)) {
            this.reportAvailabilityIfNeeded(connected);
        }
    }

    @Override
    public void shouldTrackNetworkState(Context context, boolean track) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgRvManager Should Track Network State: " + track, 0);
        this.mShouldTrackNetworkState = track;
        if (this.mShouldTrackNetworkState) {
            if (this.mNetworkStateReceiver == null) {
                this.mNetworkStateReceiver = new NetworkStateReceiver(context, this);
            }
            context.getApplicationContext().registerReceiver((BroadcastReceiver)this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        } else if (this.mNetworkStateReceiver != null) {
            context.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mNetworkStateReceiver);
        }
    }

    private boolean shouldNotifyNetworkAvailabilityChanged(boolean connected) {
        boolean shouldNotify = false;
        if (this.mLastReportedAvailabilityState == null) {
            return false;
        }
        if (connected && !this.mLastReportedAvailabilityState.booleanValue() && this.isRewardedVideoAvailable()) {
            shouldNotify = true;
        } else if (!connected && this.mLastReportedAvailabilityState.booleanValue()) {
            shouldNotify = true;
        }
        return shouldNotify;
    }

    private static enum RV_MEDIATION_STATE {
        RV_STATE_INITIATING,
        RV_STATE_AUCTION_IN_PROGRESS,
        RV_STATE_NOT_LOADED,
        RV_STATE_LOADING_SMASHES,
        RV_STATE_READY_TO_SHOW;

    }
}

