/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.supersonicads;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.ironsource.adapters.supersonicads.SupersonicConfig;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.metadata.MetaDataUtils;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InternalOfferwallListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.OfferwallAdapterApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.SSAFactory;
import com.ironsource.sdk.SSAPublisher;
import com.ironsource.sdk.data.AdUnitsReady;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.listeners.OnBannerListener;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.OnRewardedVideoListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

class SupersonicAdsAdapter
extends AbstractAdapter
implements OfferwallAdapterApi,
OnOfferWallListener,
OnInterstitialListener,
OnRewardedVideoListener,
OnBannerListener,
ContextProvider.ContextLifeCycleListener {
    private static final String VERSION = "6.17.0";
    private final String TIMESTAMP = "timestamp";
    private final String ITEM_SIGNATURE = "itemSignature";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    private final String OW_PLACEMENT_ID = "placementId";
    private SSAPublisher mSSAPublisher;
    private InternalOfferwallListener mOfferwallListener;
    private boolean mIsRVAvailable = false;
    private static AtomicBoolean mDidSetInitParams = new AtomicBoolean(false);
    private String mUserAgeGroup;
    private String mUserGender;
    private String mMediationSegment;
    private boolean mConsent;
    private boolean mDidSetConsent;
    private static AtomicBoolean mDidInitSdk = new AtomicBoolean(false);
    private final String SUPERSONIC_ADS = "SupersonicAds";
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private final String APPLICATION_USER_GENDER = "applicationUserGender";
    private final String APPLICATION_USER_AGE_GROUP = "applicationUserAgeGroup";
    private final String LANGUAGE = "language";
    private final String MAX_VIDEO_LENGTH = "maxVideoLength";
    private final String CAMPAIGN_ID = "campaignId";
    private final String CUSTOM_PARAM_PREFIX = "custom_";
    private final String CUSTOM_SEGMENT = "custom_Segment";
    private final String ITEM_NAME = "itemName";
    private final String ITEM_COUNT = "itemCount";
    private final String APPLICATION_PRIVATE_KEY = "privateKey";
    private final String CLIENT_SIDE_CALLBACKS = "useClientSideCallbacks";
    private final String AD_VISIBLE_EVENT_NAME = "impressions";
    private ISNAdView mIsnAdView;
    private AtomicBoolean isRVInitiated;

    public static SupersonicAdsAdapter startAdapter(String providerName) {
        return new SupersonicAdsAdapter(providerName);
    }

    private SupersonicAdsAdapter(String providerName) {
        super(providerName);
        IronLog.INTERNAL.verbose("");
        this.isRVInitiated = new AtomicBoolean(false);
        ContextProvider.getInstance().registerLifeCycleListener(this);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData ret = new IntegrationData("SupersonicAds", VERSION);
        ret.activities = new String[]{"com.ironsource.sdk.controller.ControllerActivity", "com.ironsource.sdk.controller.InterstitialActivity", "com.ironsource.sdk.controller.OpenUrlActivity"};
        return ret;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    public static String getAdapterSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onPause(Activity activity) {
        if (this.mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mSSAPublisher.onPause");
            this.mSSAPublisher.onPause(activity);
        }
    }

    @Override
    public void onResume(Activity activity) {
        if (this.mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mSSAPublisher.onResume");
            this.mSSAPublisher.onResume(activity);
        }
    }

    @Override
    public void setAge(int age) {
        this.mUserAgeGroup = age >= 13 && age <= 17 ? "1" : (age >= 18 && age <= 20 ? "2" : (age >= 21 && age <= 24 ? "3" : (age >= 25 && age <= 34 ? "4" : (age >= 35 && age <= 44 ? "5" : (age >= 45 && age <= 54 ? "6" : (age >= 55 && age <= 64 ? "7" : (age > 65 && age <= 120 ? "8" : "0")))))));
    }

    @Override
    public void setGender(String gender) {
        this.mUserGender = gender;
    }

    @Override
    public void setMediationSegment(String segment) {
        this.mMediationSegment = segment;
    }

    @Override
    public void initRewardedVideo(final String appKey, final String userId, final JSONObject config, RewardedVideoSmashListener listener) {
        if (this.isRVInitiated.compareAndSet(false, true)) {
            this.setParamsBeforeInit(config);
            this.postOnUIThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());
                        HashMap rewardedVideoExtraParams = SupersonicAdsAdapter.this.getRewardedVideoExtraParams(config);
                        if (SupersonicAdsAdapter.this.mDidSetConsent) {
                            SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                        }
                        IronLog.ADAPTER_API.verbose(SupersonicAdsAdapter.this.getProviderName() + " mSSAPublisher.initRewardedVideo");
                        SupersonicAdsAdapter.this.mSSAPublisher.initRewardedVideo(appKey, userId, SupersonicAdsAdapter.this.getProviderName(), rewardedVideoExtraParams, SupersonicAdsAdapter.this);
                        mDidInitSdk.set(true);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        SupersonicAdsAdapter.this.onRVInitFail("initRewardedVideo");
                    }
                }
            });
        } else {
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " adapter already initiated");
            this.fetchRewardedVideoForAutomaticLoad(config, listener);
        }
    }

    @Override
    public void fetchRewardedVideoForAutomaticLoad(JSONObject config, RewardedVideoSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getProviderName());
        for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
            if (smash == null) continue;
            smash.onRewardedVideoAvailabilityChanged(this.mIsRVAvailable);
        }
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        this.mActiveRewardedVideoSmash = listener;
        if (this.mSSAPublisher != null) {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
            JSONObject showParams = new JSONObject();
            try {
                showParams.put("demandSourceName", (Object)this.getProviderName());
                showParams.put("sessionDepth", sessionDepth);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mSSAPublisher.showRewardedVideo");
            this.mSSAPublisher.showRewardedVideo(showParams);
        } else {
            this.mIsRVAvailable = false;
            if (this.mActiveRewardedVideoSmash != null) {
                this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
            }
            for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
                if (smash == null) continue;
                smash.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        return this.mIsRVAvailable;
    }

    @Override
    public void initInterstitial(final String appKey, final String userId, JSONObject config, InterstitialSmashListener listener) {
        this.setParamsBeforeInit(config);
        this.postOnUIThread(new Runnable(){

            @Override
            public void run() {
                try {
                    SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());
                    HashMap interstitialExtraParams = SupersonicAdsAdapter.this.getInterstitialExtraParams();
                    if (SupersonicAdsAdapter.this.mDidSetConsent) {
                        SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                    }
                    IronLog.ADAPTER_API.verbose(SupersonicAdsAdapter.this.getProviderName() + " mSSAPublisher.initInterstitial");
                    SupersonicAdsAdapter.this.mSSAPublisher.initInterstitial(appKey, userId, SupersonicAdsAdapter.this.getProviderName(), interstitialExtraParams, SupersonicAdsAdapter.this);
                    mDidInitSdk.set(true);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    SupersonicAdsAdapter.this.onInterstitialInitFailed(e2.getMessage());
                }
            }
        });
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        if (this.mSSAPublisher != null) {
            JSONObject loadParams = new JSONObject();
            try {
                loadParams.put("demandSourceName", (Object)this.getProviderName());
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mSSAPublisher.loadInterstitial");
            this.mSSAPublisher.loadInterstitial(loadParams);
        } else {
            IronLog.INTERNAL.error("Please call initInterstitial before calling loadInterstitial");
            for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
                if (smash == null) continue;
                smash.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("Load was called before Init"));
            }
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        this.mActiveInterstitialSmash = listener;
        if (this.mSSAPublisher != null) {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
            JSONObject showParams = new JSONObject();
            try {
                showParams.put("demandSourceName", (Object)this.getProviderName());
                showParams.put("sessionDepth", sessionDepth);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mSSAPublisher.showInterstitial");
            this.mSSAPublisher.showInterstitial(showParams);
        } else {
            IronLog.INTERNAL.error("Please call loadInterstitialForBidding before calling showInterstitial");
            if (this.mActiveInterstitialSmash != null) {
                this.mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Interstitial"));
            }
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        return this.mSSAPublisher != null && this.mSSAPublisher.isInterstitialAdAvailable(this.getProviderName());
    }

    @Override
    public void setInternalOfferwallListener(InternalOfferwallListener listener) {
        this.mOfferwallListener = listener;
    }

    @Override
    public void initOfferwall(final String appKey, final String userId, final JSONObject config) {
        IronLog.ADAPTER_API.verbose(this.getProviderName());
        this.setParamsBeforeInit(config);
        this.postOnUIThread(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap offerwallExtraParams = SupersonicAdsAdapter.this.getOfferwallExtraParams(config);
                    SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());
                    if (SupersonicAdsAdapter.this.mDidSetConsent) {
                        SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                    }
                    IronLog.ADAPTER_API.verbose(SupersonicAdsAdapter.this.getProviderName() + " mSSAPublisher.initOfferWall");
                    SupersonicAdsAdapter.this.mSSAPublisher.initOfferWall(appKey, userId, offerwallExtraParams, SupersonicAdsAdapter.this);
                    mDidInitSdk.set(true);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    IronLog.ADAPTER_API.error(SupersonicAdsAdapter.this.getProviderName() + ":initOfferwall(userId:" + userId + ")" + e2);
                    SupersonicAdsAdapter.this.mOfferwallListener.onOfferwallAvailable(false, ErrorBuilder.buildInitFailedError("Adapter initialization failure - " + SupersonicAdsAdapter.this.getProviderName() + " - " + e2.getMessage(), "Offerwall"));
                }
            }
        });
    }

    @Override
    public void getOfferwallCredits() {
        if (this.mSSAPublisher != null) {
            String appKey = IronSourceObject.getInstance().getIronSourceAppKey();
            String userId = IronSourceObject.getInstance().getIronSourceUserId();
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mSSAPublisher.getOfferWallCredits");
            this.mSSAPublisher.getOfferWallCredits(appKey, userId, this);
        } else {
            IronLog.INTERNAL.error("Please call init before calling getOfferwallCredits");
        }
    }

    @Override
    public void showOfferwall(String placementId, JSONObject config) {
        HashMap<String, String> offerwallExtraParams = this.getOfferwallExtraParams(config);
        if (offerwallExtraParams != null) {
            offerwallExtraParams.put("placementId", placementId);
        }
        if (this.mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mSSAPublisher.showOfferWall");
            this.mSSAPublisher.showOfferWall(offerwallExtraParams);
        } else {
            IronLog.INTERNAL.error("Please call init before calling showOfferwall");
        }
    }

    @Override
    public boolean isOfferwallAvailable() {
        return true;
    }

    @Override
    public void initBanners(final String appKey, final String userId, final JSONObject config, BannerSmashListener listener) {
        IronLog.ADAPTER_API.verbose(this.getProviderName());
        this.setParamsBeforeInit(config);
        this.postOnUIThread(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap bannerExtraParams = SupersonicAdsAdapter.this.getBannerExtraParams(config);
                    SupersonicAdsAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());
                    if (SupersonicAdsAdapter.this.mDidSetConsent) {
                        SupersonicAdsAdapter.this.applyConsent(SupersonicAdsAdapter.this.mConsent);
                    }
                    IronLog.ADAPTER_API.verbose(SupersonicAdsAdapter.this.getProviderName() + " mSSAPublisher.initBanner");
                    SupersonicAdsAdapter.this.mSSAPublisher.initBanner(appKey, userId, SupersonicAdsAdapter.this.getProviderName(), bannerExtraParams, SupersonicAdsAdapter.this);
                    mDidInitSdk.set(true);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    SupersonicAdsAdapter.this.onBannerInitFailed(e2.getMessage());
                }
            }
        });
    }

    @Override
    public void loadBanner(final IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
        try {
            if (this.mSSAPublisher == null) {
                IronLog.INTERNAL.error("Please call initBanner before calling loadBanner");
                for (BannerSmashListener smash : this.mAllBannerSmashes) {
                    if (smash == null) continue;
                    smash.onBannerAdLoadFailed(ErrorBuilder.buildLoadFailedError("Load was called before Init"));
                }
            }
            this.mActiveBannerSmash = listener;
            if (this.mIsnAdView != null) {
                this.mIsnAdView.performCleanup();
                this.mIsnAdView = null;
            }
            final JSONObject loadParams = new JSONObject();
            loadParams.put("demandSourceName", (Object)this.getProviderName());
            loadParams.put("productType", (Object)SSAEnums.ProductType.Banner);
            this.postOnUIThread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            SupersonicAdsAdapter.this.mIsnAdView = SupersonicAdsAdapter.this.createBanner(banner.getActivity(), banner.getSize(), SupersonicAdsAdapter.this.mActiveBannerSmash);
                            if (SupersonicAdsAdapter.this.mIsnAdView != null) {
                                IronLog.ADAPTER_API.verbose("mIsnAdView.loadAd");
                                SupersonicAdsAdapter.this.mIsnAdView.loadAd(loadParams);
                            }
                        }
                        catch (Exception e2) {
                            String errorString = "Banner Load Fail, " + SupersonicAdsAdapter.this.getProviderName() + " - " + e2.getMessage();
                            IronSourceError error = ErrorBuilder.buildLoadFailedError(errorString);
                            if (SupersonicAdsAdapter.this.mActiveBannerSmash == null) break block3;
                            SupersonicAdsAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(error);
                        }
                    }
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void reloadBanner(IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
        try {
            if (this.mIsnAdView != null) {
                IronLog.ADAPTER_API.verbose("mIsnAdView.loadAd");
                this.mIsnAdView.loadAd(config);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            IronLog.INTERNAL.error(this.getProviderName() + " reloadBanner Failed to reload banner ad");
        }
    }

    @Override
    public void destroyBanner(JSONObject config) {
        if (this.mIsnAdView != null) {
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " mIsnAdView.performCleanup");
            this.mIsnAdView.performCleanup();
            this.mIsnAdView = null;
        }
    }

    private void setParamsBeforeInit(JSONObject config) {
        if (mDidSetInitParams.compareAndSet(false, true)) {
            SDKUtils.setControllerUrl(config.optString("controllerUrl"));
            int debugMode = config.optInt("debugMode", 0);
            if (this.isAdaptersDebugEnabled()) {
                debugMode = 3;
            }
            SDKUtils.setDebugMode(debugMode);
            SDKUtils.setControllerConfig(config.optString("controllerConfig", ""));
            IronLog.ADAPTER_API.verbose(this.getProviderName() + "setting controller url to  " + config.optString("controllerUrl"));
            IronLog.ADAPTER_API.verbose(this.getProviderName() + "setting controller config to  " + config.optString("controllerConfig"));
            IronLog.ADAPTER_API.verbose(this.getProviderName() + "setting debug mode to " + debugMode);
        }
    }

    private HashMap<String, String> getGenenralExtraParams() {
        String pluginType;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.mUserAgeGroup)) {
            params.put("applicationUserAgeGroup", this.mUserAgeGroup);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserGender)) {
            params.put("applicationUserGender", this.mUserGender);
        }
        if (!TextUtils.isEmpty((CharSequence)(pluginType = this.getPluginType()))) {
            params.put("SDKPluginType", pluginType);
        }
        return params;
    }

    private HashMap<String, String> getRewardedVideoExtraParams(JSONObject config) {
        String campaignId;
        String maxVideoLength;
        HashMap<String, String> rvExtraParams = this.getGenenralExtraParams();
        String language = config.optString("language");
        if (!TextUtils.isEmpty((CharSequence)language)) {
            rvExtraParams.put("language", language);
        }
        if (!TextUtils.isEmpty((CharSequence)(maxVideoLength = config.optString("maxVideoLength")))) {
            rvExtraParams.put("maxVideoLength", maxVideoLength);
        }
        if (!TextUtils.isEmpty((CharSequence)(campaignId = config.optString("campaignId")))) {
            rvExtraParams.put("campaignId", campaignId);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediationSegment)) {
            rvExtraParams.put("custom_Segment", this.mMediationSegment);
        }
        this.addItemNameCountSignature(rvExtraParams, config);
        Map<String, String> customParams = SupersonicConfig.getConfigObj().getRewardedVideoCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            rvExtraParams.putAll(customParams);
        }
        return rvExtraParams;
    }

    private HashMap<String, String> getInterstitialExtraParams() {
        return this.getGenenralExtraParams();
    }

    private HashMap<String, String> getOfferwallExtraParams(JSONObject config) {
        HashMap<String, String> owExtraParams = this.getGenenralExtraParams();
        String language = config.optString("language");
        if (!TextUtils.isEmpty((CharSequence)language)) {
            owExtraParams.put("language", language);
        }
        boolean clientSideCallbacks = SupersonicConfig.getConfigObj().getClientSideCallbacks();
        owExtraParams.put("useClientSideCallbacks", String.valueOf(clientSideCallbacks));
        Map<String, String> customParams = SupersonicConfig.getConfigObj().getOfferwallCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            owExtraParams.putAll(customParams);
        }
        this.addItemNameCountSignature(owExtraParams, config);
        return owExtraParams;
    }

    private HashMap<String, String> getBannerExtraParams(JSONObject config) {
        return this.getGenenralExtraParams();
    }

    private void addItemNameCountSignature(HashMap<String, String> params, JSONObject config) {
        try {
            String itemName = config.optString("itemName");
            int itemCount = config.optInt("itemCount", -1);
            String privateKey = config.optString("privateKey");
            boolean shouldAddSignature = true;
            if (TextUtils.isEmpty((CharSequence)itemName)) {
                shouldAddSignature = false;
            } else {
                params.put("itemName", itemName);
            }
            if (TextUtils.isEmpty((CharSequence)privateKey)) {
                shouldAddSignature = false;
            }
            if (itemCount == -1) {
                shouldAddSignature = false;
            } else {
                params.put("itemCount", String.valueOf(itemCount));
            }
            if (shouldAddSignature) {
                int timestamp = IronSourceUtils.getCurrentTimestamp();
                params.put("timestamp", String.valueOf(timestamp));
                params.put("itemSignature", this.createItemSig(timestamp, itemName, itemCount, privateKey));
            }
        }
        catch (Exception e2) {
            IronLog.ADAPTER_API.error(" addItemNameCountSignature" + e2);
        }
    }

    private String createItemSig(int timestamp, String itemName, int itemCount, String privateKey) {
        return IronSourceUtils.getMD5(timestamp + itemName + itemCount + privateKey);
    }

    private String createMinimumOfferCommissionSig(double min, String privateKey) {
        return IronSourceUtils.getMD5(min + privateKey);
    }

    private String createUserCreationDateSig(String userid, String uCreationDate, String privateKey) {
        return IronSourceUtils.getMD5(userid + uCreationDate + privateKey);
    }

    private ISNAdView createBanner(Activity activity, ISBannerSize bannerSize, BannerSmashListener listener) {
        String BANNER = "BANNER";
        String LARGE = "LARGE";
        String RECTANGLE = "RECTANGLE";
        String SMART = "SMART";
        String CUSTOM = "CUSTOM";
        int STANDARD_SCREEN_BANNER_WIDTH = 320;
        int STANDARD_BANNER_SIZE_HEIGHT = 50;
        int LARGE_SCREEN_BANNER_WIDTH = 728;
        int LARGE_BANNER_SIZE_HEIGHT = 90;
        String sizeLabel = bannerSize.getDescription();
        int widthDp = 320;
        int heightDp = 50;
        switch (sizeLabel) {
            case "BANNER": {
                widthDp = 320;
                heightDp = 50;
                break;
            }
            case "LARGE": {
                widthDp = 320;
                heightDp = 90;
                break;
            }
            case "SMART": {
                boolean isLargeScreen = AdapterUtils.isLargeScreen(activity);
                widthDp = isLargeScreen ? 728 : 320;
                heightDp = isLargeScreen ? 90 : 50;
                break;
            }
            case "CUSTOM": {
                widthDp = 320;
                heightDp = bannerSize.getHeight();
                if (heightDp == 50 || heightDp == 90) break;
                if (listener != null) {
                    listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize("SupersonicAds"));
                }
                return null;
            }
            default: {
                if (listener != null) {
                    listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize("SupersonicAds"));
                }
                return null;
            }
        }
        int widthPixels = AdapterUtils.dpToPixels(activity, widthDp);
        int heightPixels = AdapterUtils.dpToPixels(activity, heightDp);
        ISAdSize bannerAdSize = new ISAdSize(widthPixels, heightPixels, sizeLabel);
        return this.mSSAPublisher.createBanner(activity, bannerAdSize);
    }

    @Override
    public void onRVNoMoreOffers() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        this.mIsRVAvailable = false;
        for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
            if (smash == null) continue;
            smash.onRewardedVideoAvailabilityChanged(false);
        }
    }

    @Override
    public void onRVInitSuccess(AdUnitsReady aur) {
        boolean availability;
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        int numOfAdUnits = 0;
        try {
            numOfAdUnits = Integer.parseInt(aur.getNumOfAdUnits());
        }
        catch (NumberFormatException e2) {
            IronLog.INTERNAL.error("parseInt()" + e2);
        }
        this.mIsRVAvailable = availability = numOfAdUnits > 0;
        for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
            if (smash == null) continue;
            smash.onRewardedVideoAvailabilityChanged(availability);
        }
    }

    @Override
    public void onRVInitFail(String error) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (RewardedVideoSmashListener smash : this.mAllRewardedVideoSmashes) {
            if (smash == null) continue;
            smash.onRewardedVideoAvailabilityChanged(false);
        }
    }

    @Override
    public void onRVAdClicked() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdClicked();
        }
    }

    @Override
    public void onRVEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName() + " " + eventName + " extData: " + extData.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)eventName) && "impressions".equals(eventName) && this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdVisible();
        }
    }

    @Override
    public void onRVShowFail(String error) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(new IronSourceError(509, error));
        }
    }

    @Override
    public void onRVAdCredited(int amount) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
        }
    }

    @Override
    public void onRVAdClosed() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
        }
    }

    @Override
    public void onRVAdOpened() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
        }
    }

    @Override
    public void onInterstitialInitSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialInitSuccess();
        }
    }

    @Override
    public void onInterstitialInitFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError(description, "Interstitial"));
        }
    }

    @Override
    public void onInterstitialLoadSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialAdReady();
        }
    }

    @Override
    public void onInterstitialLoadFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
            if (smash == null) continue;
            smash.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
        }
    }

    @Override
    public void onInterstitialOpen() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdOpened();
        }
    }

    @Override
    public void onInterstitialAdRewarded(String demandSourceId, int amount) {
    }

    @Override
    public void onInterstitialClose() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdClosed();
        }
    }

    @Override
    public void onInterstitialShowSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowSucceeded();
        }
    }

    @Override
    public void onInterstitialShowFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", description));
        }
    }

    @Override
    public void onInterstitialClick() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdClicked();
        }
    }

    @Override
    public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName() + " " + eventName + " extData: " + extData.toString());
            if (!TextUtils.isEmpty((CharSequence)eventName) && "impressions".equals(eventName) && this.mActiveInterstitialSmash != null) {
                this.mActiveInterstitialSmash.onInterstitialAdVisible();
            }
        }
    }

    @Override
    public void onOfferwallInitSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallAvailable(true);
        }
    }

    @Override
    public void onOfferwallInitFail(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(description);
            this.mOfferwallListener.onOfferwallAvailable(false, sse);
        }
    }

    @Override
    public void onOfferwallEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        }
    }

    @Override
    public void onOWShowSuccess(String placementId) {
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        } else {
            IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName() + ":onOWShowSuccess(placementId:" + placementId + ")");
        }
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallOpened();
        }
    }

    @Override
    public void onOWShowFail(String desc) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(desc);
            this.mOfferwallListener.onOfferwallShowFailed(sse);
        }
    }

    @Override
    public void onOWGeneric(String arg0, String arg1) {
    }

    @Override
    public boolean onOWAdCredited(int credits, int totalCredits, boolean totalCreditsFlag) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        return this.mOfferwallListener != null && this.mOfferwallListener.onOfferwallAdCredited(credits, totalCredits, totalCreditsFlag);
    }

    @Override
    public void onOWAdClosed() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            this.mOfferwallListener.onOfferwallClosed();
        }
    }

    @Override
    public void onGetOWCreditsFailed(String desc) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(desc);
            this.mOfferwallListener.onGetOfferwallCreditsFailed(sse);
        }
    }

    @Override
    public void onBannerInitSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null) continue;
            smash.onBannerInitSuccess();
        }
    }

    @Override
    public void onBannerInitFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null) continue;
            smash.onBannerInitFailed(ErrorBuilder.buildInitFailedError(description, "Banner"));
        }
    }

    @Override
    public void onBannerClick() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        if (this.mActiveBannerSmash != null) {
            this.mActiveBannerSmash.onBannerAdClicked();
        }
    }

    @Override
    public void onBannerLoadSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null || this.mIsnAdView == null || this.mIsnAdView.getAdViewSize() == null) continue;
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.mIsnAdView.getAdViewSize().getWidth(), this.mIsnAdView.getAdViewSize().getHeight());
            layoutParams.gravity = 17;
            smash.onBannerAdLoaded((View)this.mIsnAdView, layoutParams);
        }
    }

    @Override
    public void onBannerLoadFail(String description) {
        IronLog.ADAPTER_CALLBACK.verbose(this.getProviderName());
        for (BannerSmashListener smash : this.mAllBannerSmashes) {
            if (smash == null) continue;
            smash.onBannerAdLoadFailed(ErrorBuilder.buildInitFailedError(description, "Banner"));
        }
    }

    @Override
    protected void addBannerListener(BannerSmashListener listener) {
        this.mAllBannerSmashes.add(listener);
    }

    @Override
    protected void removeBannerListener(BannerSmashListener listener) {
        this.mAllBannerSmashes.remove(listener);
    }

    @Override
    protected void setMediationState(AbstractSmash.MEDIATION_STATE state, String adUnit) {
        if (this.mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose(this.getProviderName() + ": setMediationState(" + adUnit + " , " + this.getProviderName() + " , " + state.getValue() + ")");
            this.mSSAPublisher.setMediationState(adUnit, this.getProviderName(), state.getValue());
        }
    }

    @Override
    protected void setConsent(boolean consent) {
        IronLog.ADAPTER_API.verbose(this.getProviderName() + ": setConsent (" + (consent ? "true" : "false") + ")");
        this.mDidSetConsent = true;
        this.mConsent = consent;
        this.applyConsent(consent);
    }

    private void applyConsent(boolean consent) {
        if (this.mSSAPublisher == null) {
            return;
        }
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("gdprConsentStatus", (Object)String.valueOf(consent));
            consentParams.put("demandSourceName", (Object)this.getProviderName());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        this.mSSAPublisher.updateConsentInfo(consentParams);
    }

    @Override
    public void earlyInit(String appKey, String userId, JSONObject config) {
        IronSourceUtils.sendAutomationLog(this.getProviderName() + ": earlyInit");
        if (mDidInitSdk.compareAndSet(false, true)) {
            if (this.isAdaptersDebugEnabled()) {
                SDKUtils.setDebugMode(3);
            } else {
                SDKUtils.setDebugMode(config.optInt("debugMode", 0));
            }
            SDKUtils.setControllerUrl(config.optString("controllerUrl"));
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " IronSourceNetwork setting controller url to  " + config.optString("controllerUrl"));
            SDKUtils.setControllerConfig(config.optString("controllerConfig", ""));
            IronLog.ADAPTER_API.verbose(this.getProviderName() + " IronSourceNetwork setting controller config to  " + config.optString("controllerConfig"));
            HashMap<String, String> initParams = this.getInitParams();
            IronSourceNetwork.initSDK(ContextProvider.getInstance().getCurrentActiveActivity(), appKey, userId, initParams);
            IronLog.ADAPTER_API.verbose("initSDK with appKey=" + appKey + " userId=" + userId + " parameters " + initParams);
        }
    }

    private HashMap<String, String> getInitParams() {
        String pluginType;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.mUserAgeGroup)) {
            params.put("applicationUserAgeGroup", this.mUserAgeGroup);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserGender)) {
            params.put("applicationUserGender", this.mUserGender);
        }
        if (!TextUtils.isEmpty((CharSequence)(pluginType = this.getPluginType()))) {
            params.put("SDKPluginType", pluginType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediationSegment)) {
            params.put("custom_Segment", this.mMediationSegment);
        }
        return params;
    }

    private boolean isValidMetaData(String key, String value) {
        if (key.equals("do_not_sell")) {
            return MetaDataUtils.isValidCCPAMetaData(key, value);
        }
        return true;
    }

    @Override
    protected void setMetaData(String key, String value) {
        if (!mDidInitSdk.get()) {
            IronLog.ADAPTER_API.verbose("key=" + key + ", value=" + value);
            if (!this.isValidMetaData(key, value)) {
                IronLog.ADAPTER_API.verbose("not valid");
                return;
            }
            JSONObject metaDataJson = new JSONObject();
            try {
                metaDataJson.put(key, (Object)value);
                IronSourceNetwork.updateMetadata(metaDataJson);
            }
            catch (JSONException e2) {
                IronLog.ADAPTER_API.error("error - " + (Object)((Object)e2));
                e2.printStackTrace();
            }
        }
    }
}

