package com.ironsource.adapters.supersonicads;

import android.app.Activity;
import android.text.TextUtils;
import android.view.Gravity;
import android.widget.FrameLayout;

import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.BuildConfig;
import com.ironsource.mediationsdk.IntegrationData;

import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronLog;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.metadata.MetaDataConstants;
import com.ironsource.mediationsdk.metadata.MetaDataUtils;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InternalOfferwallListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.OfferwallAdapterApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ContextProvider;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceConstants;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.ISAdSize;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.SSAFactory;
import com.ironsource.sdk.SSAPublisher;
import com.ironsource.sdk.data.AdUnitsReady;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.listeners.OnBannerListener;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.OnRewardedVideoListener;
import com.ironsource.sdk.constants.Constants;
import com.ironsource.sdk.utils.SDKUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;


class SupersonicAdsAdapter extends AbstractAdapter implements OfferwallAdapterApi, OnOfferWallListener, OnInterstitialListener, OnRewardedVideoListener, OnBannerListener, ContextProvider.ContextLifeCycleListener {

    private final static String VERSION = BuildConfig.VERSION_NAME;
    private final String TIMESTAMP = "timestamp";
    private final String ITEM_SIGNATURE = "itemSignature";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    private final String OW_PLACEMENT_ID = "placementId";

    private SSAPublisher mSSAPublisher;

    private InternalOfferwallListener mOfferwallListener;

    private boolean mIsRVAvailable = false;
    private static AtomicBoolean mDidSetInitParams = new AtomicBoolean(false);

    private String mUserAgeGroup;
    private String mUserGender;
    private String mMediationSegment;
    private boolean mConsent;
    private boolean mDidSetConsent;
    private static AtomicBoolean mDidInitSdk = new AtomicBoolean(false);

    private final String SUPERSONIC_ADS = "SupersonicAds";

    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";

    private final String APPLICATION_USER_GENDER = "applicationUserGender";
    private final String APPLICATION_USER_AGE_GROUP = "applicationUserAgeGroup";

    private final String LANGUAGE = "language";
    private final String MAX_VIDEO_LENGTH = "maxVideoLength";
    private final String CAMPAIGN_ID = "campaignId";
    private final String CUSTOM_PARAM_PREFIX = "custom_";
    private final String CUSTOM_SEGMENT = CUSTOM_PARAM_PREFIX + "Segment";

    private final String ITEM_NAME = "itemName";
    private final String ITEM_COUNT = "itemCount";
    private final String APPLICATION_PRIVATE_KEY = "privateKey";

    private final String CLIENT_SIDE_CALLBACKS = "useClientSideCallbacks";
    private final String AD_VISIBLE_EVENT_NAME = "impressions";

    private ISNAdView mIsnAdView;

    private AtomicBoolean isRVInitiated;

    public static SupersonicAdsAdapter startAdapter(String providerName) {
        return new SupersonicAdsAdapter(providerName);
    }

    private SupersonicAdsAdapter(String providerName) {
        super(providerName);
        IronLog.INTERNAL.verbose("");
        isRVInitiated = new AtomicBoolean(false);
        ContextProvider.getInstance().registerLifeCycleListener(this);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData ret = new IntegrationData("SupersonicAds", VERSION);
        ret.activities = new String[]{"com.ironsource.sdk.controller.ControllerActivity",
                "com.ironsource.sdk.controller.InterstitialActivity", "com.ironsource.sdk.controller.OpenUrlActivity"};
        return ret;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    public static String getAdapterSDKVersion() { return SDKUtils.getSDKVersion(); }


    // ********** Base **********

    @Override
    public void onPause(Activity activity) {
        if (mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.onPause");
            mSSAPublisher.onPause(activity);
        }
    }

    @Override
    public void onResume(Activity activity) {
        if (mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.onResume");
            mSSAPublisher.onResume(activity);
        }

    }

    @Override
    public void setAge(int age) {
        if (age >= 13 && age <= 17) {
            mUserAgeGroup = "1";
        } else if (age >= 18 && age <= 20) {
            mUserAgeGroup = "2";
        } else if (age >= 21 && age <= 24) {
            mUserAgeGroup = "3";
        } else if (age >= 25 && age <= 34) {
            mUserAgeGroup = "4";
        } else if (age >= 35 && age <= 44) {
            mUserAgeGroup = "5";
        } else if (age >= 45 && age <= 54) {
            mUserAgeGroup = "6";
        } else if (age >= 55 && age <= 64) {
            mUserAgeGroup = "7";
        } else if (age > 65 && age <= 120) {
            mUserAgeGroup = "8";
        } else {
            mUserAgeGroup = "0";
        }
    }

    @Override
    public void setGender(String gender) {
        mUserGender = gender;
    }

    @Override
    public void setMediationSegment(String segment) {
        mMediationSegment = segment;
    }

    // ********** RewardedVideo **********

    @Override
    public void initRewardedVideo(final String appKey, final String userId, final JSONObject config, RewardedVideoSmashListener listener) {

        if (isRVInitiated.compareAndSet(false, true)) {
            setParamsBeforeInit(config);
            postOnUIThread(new Runnable() {

                @Override
                public void run() {
                    try {
                        mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());
                        HashMap<String, String> rewardedVideoExtraParams = getRewardedVideoExtraParams(config);

                        if (mDidSetConsent) {
                            applyConsent(mConsent);
                        }
                        IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.initRewardedVideo");
                        mSSAPublisher.initRewardedVideo(
                                appKey,
                                userId,
                                getProviderName(),
                                rewardedVideoExtraParams,
                                SupersonicAdsAdapter.this
                        );
                        mDidInitSdk.set(true);

                    } catch (Exception e) {
                        e.printStackTrace();
                        onRVInitFail("initRewardedVideo");
                    }
                }

            });
        }
        else {
            IronLog.ADAPTER_API.verbose( getProviderName() + " adapter already initiated");
            fetchRewardedVideoForAutomaticLoad(config, listener);
        }
    }

    @Override
    public void fetchRewardedVideoForAutomaticLoad(final JSONObject config, final RewardedVideoSmashListener listener) {
        IronLog.ADAPTER_API.verbose( getProviderName());

        for (RewardedVideoSmashListener smash : mAllRewardedVideoSmashes) {
            if (smash != null) {
                smash.onRewardedVideoAvailabilityChanged(mIsRVAvailable);
            }
        }
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        mActiveRewardedVideoSmash = listener;

        if (mSSAPublisher != null) {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(SessionDepthManager.REWARDEDVIDEO);

            JSONObject showParams = new JSONObject();
            try {
                showParams.put(Constants.RequestParameters.DEMAND_SOURCE_NAME, getProviderName());
                showParams.put(Constants.RequestParameters.SESSION_DEPTH, sessionDepth);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.showRewardedVideo");
            mSSAPublisher.showRewardedVideo(showParams);
        } else {
            mIsRVAvailable = false;

            if (mActiveRewardedVideoSmash != null)
                mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError(IronSourceConstants.REWARDED_VIDEO_AD_UNIT));

            for (RewardedVideoSmashListener smash : mAllRewardedVideoSmashes) {
                if (smash != null)
                    smash.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        return mIsRVAvailable;
    }


    // ********** Interstitial **********

    @Override
    public void initInterstitial(final String appKey, final String userId, final JSONObject config, InterstitialSmashListener listener) {

        setParamsBeforeInit(config);
        postOnUIThread(new Runnable() {
            @Override
            public void run() {
                try {
                    mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());

                    final HashMap<String, String> interstitialExtraParams = getInterstitialExtraParams();

                    if (mDidSetConsent) {
                        applyConsent(mConsent);
                    }
                    IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.initInterstitial");
                    mSSAPublisher.initInterstitial(appKey, userId, getProviderName(), interstitialExtraParams, SupersonicAdsAdapter.this);
                    mDidInitSdk.set(true);
                } catch (Exception e) {
                    e.printStackTrace();
                    onInterstitialInitFailed(e.getMessage());
                }
            }
        });
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        if (mSSAPublisher != null) {
            JSONObject loadParams = new JSONObject();
            try {
                loadParams.put(Constants.RequestParameters.DEMAND_SOURCE_NAME, getProviderName());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.loadInterstitial");
            mSSAPublisher.loadInterstitial(loadParams);
        } else {
            IronLog.INTERNAL.error("Please call initInterstitial before calling loadInterstitial");

            for (InterstitialSmashListener smash : mAllInterstitialSmashes) {
                if (smash != null)
                    smash.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("Load was called before Init"));
            }
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        mActiveInterstitialSmash = listener;

        if (mSSAPublisher != null) {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(SessionDepthManager.INTERSTITIAL);

            JSONObject showParams = new JSONObject();
            try {
                showParams.put(Constants.RequestParameters.DEMAND_SOURCE_NAME, getProviderName());
                showParams.put(Constants.RequestParameters.SESSION_DEPTH, sessionDepth);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.showInterstitial");
            mSSAPublisher.showInterstitial(showParams);
        } else {
            IronLog.INTERNAL.error( "Please call loadInterstitialForBidding before calling showInterstitial");

            if (mActiveInterstitialSmash != null)
                mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError(IronSourceConstants.INTERSTITIAL_AD_UNIT));
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        return mSSAPublisher != null && mSSAPublisher.isInterstitialAdAvailable(getProviderName());
    }

    // ********** Offerwall **********

    @Override
    public void setInternalOfferwallListener(InternalOfferwallListener listener) {
        mOfferwallListener = listener;
    }

    @Override
    public void initOfferwall(final String appKey, final String userId, final JSONObject config) {
        IronLog.ADAPTER_API.verbose(getProviderName());

        setParamsBeforeInit(config);
        postOnUIThread(new Runnable() {
            @Override
            public void run() {
                try {
                    Map<String, String> offerwallExtraParams = getOfferwallExtraParams(config);
                    mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());

                    if (mDidSetConsent) {
                        applyConsent(mConsent);
                    }
                    IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.initOfferWall");
                    mSSAPublisher.initOfferWall(appKey, userId, offerwallExtraParams, SupersonicAdsAdapter.this);
                    mDidInitSdk.set(true);
                } catch (Exception e) {
                    e.printStackTrace();
                    IronLog.ADAPTER_API.error(getProviderName() + ":initOfferwall(userId:" + userId + ")"+  e);
                    mOfferwallListener.onOfferwallAvailable(false,
                            ErrorBuilder.buildInitFailedError("Adapter initialization failure - " + getProviderName() + " - " + e.getMessage(), IronSourceConstants.OFFERWALL_AD_UNIT));
                }
            }
        });
    }

    @Override
    public void getOfferwallCredits() {

        if (mSSAPublisher != null) {
            String appKey = IronSourceObject.getInstance().getIronSourceAppKey();
            String userId = IronSourceObject.getInstance().getIronSourceUserId();
            IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.getOfferWallCredits");
            mSSAPublisher.getOfferWallCredits(appKey, userId, this);
        } else
            IronLog.INTERNAL.error( "Please call init before calling getOfferwallCredits");
    }

    @Override
    public void showOfferwall(String placementId, JSONObject config) {
        Map<String, String> offerwallExtraParams = getOfferwallExtraParams(config);
        if (offerwallExtraParams != null) {
            offerwallExtraParams.put(OW_PLACEMENT_ID, placementId);
        }

        if (mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.showOfferWall");
            mSSAPublisher.showOfferWall(offerwallExtraParams);
        } else {
            IronLog.INTERNAL.error( "Please call init before calling showOfferwall");
        }
    }

    @Override
    public boolean isOfferwallAvailable() {
        return true;
    }

    // ********** Banners **********

    @Override
    public void initBanners(final String appKey, final String userId, final JSONObject config, final BannerSmashListener listener) {
        IronLog.ADAPTER_API.verbose(getProviderName());

        setParamsBeforeInit(config);
        postOnUIThread(new Runnable() {
            @Override
            public void run() {
                try {
                    Map<String, String> bannerExtraParams = getBannerExtraParams(config);
                    mSSAPublisher = SSAFactory.getPublisherInstance(ContextProvider.getInstance().getCurrentActiveActivity());

                    if (mDidSetConsent) {
                        applyConsent(mConsent);
                    }
                    IronLog.ADAPTER_API.verbose(getProviderName() + " mSSAPublisher.initBanner");
                    mSSAPublisher.initBanner(appKey, userId, getProviderName(), bannerExtraParams, SupersonicAdsAdapter.this);
                    mDidInitSdk.set(true);

                } catch (Exception e) {
                    e.printStackTrace();
                    onBannerInitFailed(e.getMessage());
                }
            }
        });
    }

    @Override
    public void loadBanner(final IronSourceBannerLayout banner, final JSONObject config, final BannerSmashListener listener) {
        try {
            if (mSSAPublisher == null) {
                IronLog.INTERNAL.error( "Please call initBanner before calling loadBanner");
                for (BannerSmashListener smash : mAllBannerSmashes) {
                    if (smash != null) {
                        smash.onBannerAdLoadFailed(ErrorBuilder.buildLoadFailedError("Load was called before Init"));
                    }
                }
            }

            mActiveBannerSmash = listener;
            //Remove ISNAdView instance from memory in order to prevent multiple instances of it
            //in scenarios when there's a failure in SDK6 that we're not aware of
            if (mIsnAdView != null) {
                mIsnAdView.performCleanup();
                mIsnAdView = null;
            }
            final JSONObject loadParams = new JSONObject();
            loadParams.put(Constants.RequestParameters.DEMAND_SOURCE_NAME, getProviderName());
            loadParams.put(Constants.ParametersKeys.PRODUCT_TYPE, SSAEnums.ProductType.Banner);


            postOnUIThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        mIsnAdView = createBanner(banner.getActivity(), banner.getSize(), mActiveBannerSmash);
                        if (mIsnAdView != null) {
                            IronLog.ADAPTER_API.verbose("mIsnAdView.loadAd");
                            mIsnAdView.loadAd(loadParams);
                        }
                    } catch (Exception e) {
                        String errorString = IronSourceConstants.BANNER_AD_UNIT + " Load Fail, "
                                + getProviderName() + " - " + e.getMessage();

                        IronSourceError error = ErrorBuilder.buildLoadFailedError(errorString);

                        if (mActiveBannerSmash != null) {
                            mActiveBannerSmash.onBannerAdLoadFailed(error);
                        }
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reloadBanner(final IronSourceBannerLayout banner,final JSONObject config,final BannerSmashListener listener) {
        try {
            if (mIsnAdView != null) {
                IronLog.ADAPTER_API.verbose("mIsnAdView.loadAd");
                mIsnAdView.loadAd(config);
            }
        } catch (Exception e) {
            e.printStackTrace();
            IronLog.INTERNAL.error( getProviderName() + " reloadBanner Failed to reload banner ad");
        }
    }

    @Override
    public void destroyBanner(final JSONObject config) {
        if (mIsnAdView != null) {
            IronLog.ADAPTER_API.verbose(getProviderName() + " mIsnAdView.performCleanup");
            mIsnAdView.performCleanup();
            mIsnAdView = null;
        }
    }

    // ********** Helpers **********

    private void setParamsBeforeInit(JSONObject config) {
        if (mDidSetInitParams.compareAndSet(false,true )) {

            SDKUtils.setControllerUrl(config.optString(DYNAMIC_CONTROLLER_URL));

            int debugMode = config.optInt(DYNAMIC_CONTROLLER_DEBUG_MODE, 0);
            if (isAdaptersDebugEnabled()) {
                debugMode = IronSourceLogger.IronSourceLogLevel.ERROR;
            }
            SDKUtils.setDebugMode(debugMode);

            SDKUtils.setControllerConfig(config.optString(DYNAMIC_CONTROLLER_CONFIG, ""));

            IronLog.ADAPTER_API.verbose (getProviderName() + "setting controller url to  "+ config.optString(DYNAMIC_CONTROLLER_URL));
            IronLog.ADAPTER_API.verbose (getProviderName() + "setting controller config to  "+ config.optString(DYNAMIC_CONTROLLER_CONFIG));
            IronLog.ADAPTER_API.verbose (getProviderName() + "setting debug mode to " + debugMode);
        }
    }

    private HashMap<String, String> getGenenralExtraParams() {
        HashMap<String, String> params = new HashMap<>();

        //Check and add user age group configuration
        if (!TextUtils.isEmpty(mUserAgeGroup))
            params.put(APPLICATION_USER_AGE_GROUP, mUserAgeGroup);

        //Check and add user creation gender configuration
        if (!TextUtils.isEmpty(mUserGender))
            params.put(APPLICATION_USER_GENDER, mUserGender);

        String pluginType = getPluginType();
        if (!TextUtils.isEmpty(pluginType))
            params.put(SDK_PLUGIN_TYPE, pluginType);

        return params;
    }

    private HashMap<String, String> getRewardedVideoExtraParams(JSONObject config) {
        HashMap<String, String> rvExtraParams = getGenenralExtraParams();

        //Check and add language configuration
        String language = config.optString(LANGUAGE);
        if (!TextUtils.isEmpty(language)) {
            rvExtraParams.put(LANGUAGE, language);
        }

        //Check and add maxVideoLength configuration
        String maxVideoLength = config.optString(MAX_VIDEO_LENGTH);
        if (!TextUtils.isEmpty(maxVideoLength)) {
            rvExtraParams.put(MAX_VIDEO_LENGTH, maxVideoLength);
        }

        //Check and add campaignId configuration
        String campaignId = config.optString(CAMPAIGN_ID);
        if (!TextUtils.isEmpty(campaignId))
            rvExtraParams.put(CAMPAIGN_ID, campaignId);

        //Check and add segment configuration
        if (!TextUtils.isEmpty(mMediationSegment)) {
            rvExtraParams.put(CUSTOM_SEGMENT, mMediationSegment);
        }

        //Check and add itemName/itemCount/privateKey configurations
        addItemNameCountSignature(rvExtraParams, config);

        //Add RewardedVideo customParams if set
        Map<String, String> customParams = SupersonicConfig.getConfigObj().getRewardedVideoCustomParams();
        if (customParams != null && !customParams.isEmpty())
            rvExtraParams.putAll(customParams);

        return rvExtraParams;
    }

    private HashMap<String, String> getInterstitialExtraParams() {
        return getGenenralExtraParams();
    }

    private HashMap<String, String> getOfferwallExtraParams(JSONObject config) {
        HashMap<String, String> owExtraParams = getGenenralExtraParams();

        //Check language configuration
        String language = config.optString(LANGUAGE);
        if (!TextUtils.isEmpty(language)) {
            owExtraParams.put(LANGUAGE, language);
        }

        //Check client side callbacks configuration
        boolean clientSideCallbacks = SupersonicConfig.getConfigObj().getClientSideCallbacks();
        owExtraParams.put(CLIENT_SIDE_CALLBACKS, String.valueOf(clientSideCallbacks));

        //Add Offerwall customParams if set
        Map<String, String> customParams = SupersonicConfig.getConfigObj().getOfferwallCustomParams();
        if (customParams != null && !customParams.isEmpty())
            owExtraParams.putAll(customParams);

        addItemNameCountSignature(owExtraParams, config);

        return owExtraParams;
    }

    private HashMap<String, String> getBannerExtraParams(JSONObject config) {
        return getGenenralExtraParams();
    }


    private void addItemNameCountSignature(HashMap<String, String> params, JSONObject config) {
        try {
            String itemName = config.optString(ITEM_NAME);
            int itemCount = config.optInt(ITEM_COUNT, -1);
            String privateKey = config.optString(APPLICATION_PRIVATE_KEY);

            boolean shouldAddSignature = true;

            if (TextUtils.isEmpty(itemName))
                shouldAddSignature = false;
            else
                params.put(ITEM_NAME, itemName);

            if (TextUtils.isEmpty(privateKey))
                shouldAddSignature = false;

            if (itemCount == -1)
                shouldAddSignature = false;
            else
                params.put(ITEM_COUNT, String.valueOf(itemCount));


            if (shouldAddSignature) {
                int timestamp = IronSourceUtils.getCurrentTimestamp();
                params.put(TIMESTAMP, String.valueOf(timestamp));
                params.put(ITEM_SIGNATURE, createItemSig(timestamp, itemName, itemCount, privateKey));
            }

        } catch (Exception e) {
            IronLog.ADAPTER_API.error ( " addItemNameCountSignature"+ e);
        }
    }

    private String createItemSig(int timestamp, String itemName, int itemCount, String privateKey) {
        return IronSourceUtils.getMD5(timestamp + itemName + itemCount + privateKey);
    }

    private String createMinimumOfferCommissionSig(double min, String privateKey) {
        return IronSourceUtils.getMD5(min + privateKey);
    }

    private String createUserCreationDateSig(String userid, String uCreationDate, String privateKey) {
        return IronSourceUtils.getMD5(userid + uCreationDate + privateKey);
    }

    private ISNAdView createBanner(final Activity activity, final ISBannerSize bannerSize, BannerSmashListener listener) {
        final String BANNER = "BANNER",
                LARGE = "LARGE",
                RECTANGLE = "RECTANGLE",
                SMART = "SMART",
                CUSTOM = "CUSTOM";

        final int STANDARD_SCREEN_BANNER_WIDTH = 320,
                STANDARD_BANNER_SIZE_HEIGHT = 50,
                LARGE_SCREEN_BANNER_WIDTH = 728,
                LARGE_BANNER_SIZE_HEIGHT = 90;

        String sizeLabel = bannerSize.getDescription();

        int widthDp = STANDARD_SCREEN_BANNER_WIDTH;
        int heightDp = STANDARD_BANNER_SIZE_HEIGHT;

        switch (sizeLabel) {
            case BANNER: {
                widthDp = STANDARD_SCREEN_BANNER_WIDTH;
                heightDp = STANDARD_BANNER_SIZE_HEIGHT;
                break;
            }
            case LARGE: {
                widthDp = STANDARD_SCREEN_BANNER_WIDTH;
                heightDp = LARGE_BANNER_SIZE_HEIGHT;
                break;
            }
            case SMART: {
                boolean isLargeScreen = AdapterUtils.isLargeScreen(activity);
                widthDp = isLargeScreen ? LARGE_SCREEN_BANNER_WIDTH : STANDARD_SCREEN_BANNER_WIDTH;
                heightDp = isLargeScreen ? LARGE_BANNER_SIZE_HEIGHT : STANDARD_BANNER_SIZE_HEIGHT;
                break;
            }
            case CUSTOM: {
                widthDp = STANDARD_SCREEN_BANNER_WIDTH;
                heightDp = bannerSize.getHeight();
                if (heightDp != STANDARD_BANNER_SIZE_HEIGHT && heightDp != LARGE_BANNER_SIZE_HEIGHT) { //Limitation for CUSTOM banner size (JIRA UC-460)
                    if (listener != null) {
                        listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize(SUPERSONIC_ADS));
                    }
                    return null;
                }
                break;
            }
            case RECTANGLE:
            default: {
                if (listener != null) {
                    listener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize(SUPERSONIC_ADS));
                }
                return null;
            }
        }
        int widthPixels = AdapterUtils.dpToPixels(activity, widthDp);
        int heightPixels = AdapterUtils.dpToPixels(activity, heightDp);
        ISAdSize bannerAdSize = new ISAdSize(widthPixels, heightPixels, sizeLabel);

        return mSSAPublisher.createBanner(activity, bannerAdSize);
    }

    // ********** Supersonic Rewarded Video Callbacks **********

    @Override
    public void onRVNoMoreOffers() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        mIsRVAvailable = false;

        for (RewardedVideoSmashListener smash : mAllRewardedVideoSmashes) {
            if (smash != null)
                smash.onRewardedVideoAvailabilityChanged(false);
        }
    }

    @Override
    public void onRVInitSuccess(AdUnitsReady aur) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        int numOfAdUnits = 0;

        try {
            numOfAdUnits = Integer.parseInt(aur.getNumOfAdUnits());
        } catch (NumberFormatException e) {
            IronLog.INTERNAL.error("parseInt()" +  e);
        }

        boolean availability = numOfAdUnits > 0;
        mIsRVAvailable = availability;

        for (RewardedVideoSmashListener smash : mAllRewardedVideoSmashes) {
            if (smash != null)
                smash.onRewardedVideoAvailabilityChanged(availability);
        }
    }

    @Override
    public void onRVInitFail(String error) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        for (RewardedVideoSmashListener smash : mAllRewardedVideoSmashes) {
            if (smash != null)
                smash.onRewardedVideoAvailabilityChanged(false);
        }
    }

    @Override
    public void onRVAdClicked() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveRewardedVideoSmash != null)
            mActiveRewardedVideoSmash.onRewardedVideoAdClicked();
    }

    @Override
    public void onRVEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null)
            IronLog.ADAPTER_CALLBACK.verbose ( getProviderName() + " " + eventName + " extData: " + extData.toString());

        if (!TextUtils.isEmpty(eventName) && AD_VISIBLE_EVENT_NAME.equals(eventName) && mActiveRewardedVideoSmash != null) {
            mActiveRewardedVideoSmash.onRewardedVideoAdVisible();
        }
    }

    @Override
    public void onRVShowFail(String error) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveRewardedVideoSmash != null)
            mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(new IronSourceError(IronSourceError.ERROR_CODE_NO_ADS_TO_SHOW, error));
    }

    @Override
    public void onRVAdCredited(int amount) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveRewardedVideoSmash != null) {
            mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
        }
    }

    @Override
    public void onRVAdClosed() {
        IronLog.ADAPTER_CALLBACK.verbose(getProviderName());

        if (mActiveRewardedVideoSmash != null)
            mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
    }

    @Override
    public void onRVAdOpened() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveRewardedVideoSmash != null)
            mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
    }

    // ********** Supersonic Interstitial Callbacks **********

    @Override
    public void onInterstitialInitSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());
        for (InterstitialSmashListener smash : mAllInterstitialSmashes) {
            if (smash != null)
                smash.onInterstitialInitSuccess();
        }
    }

    @Override
    public void onInterstitialInitFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose (getProviderName());
        for (InterstitialSmashListener smash : mAllInterstitialSmashes) {
            if (smash != null)
                smash.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError(description, IronSourceConstants.INTERSTITIAL_AD_UNIT));
        }
    }

    @Override
    public void onInterstitialLoadSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        for (InterstitialSmashListener smash : mAllInterstitialSmashes) {
            if (smash != null)
                smash.onInterstitialAdReady();
        }
    }

    @Override
    public void onInterstitialLoadFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        for (InterstitialSmashListener smash : mAllInterstitialSmashes) {
            if (smash != null)
                smash.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
        }
    }

    @Override
    public void onInterstitialOpen() {
        IronLog.ADAPTER_CALLBACK.verbose(getProviderName());

        if (mActiveInterstitialSmash != null)
            mActiveInterstitialSmash.onInterstitialAdOpened();
    }

    @Override
    public void onInterstitialAdRewarded(String demandSourceId, int amount) {

    }

    @Override
    public void onInterstitialClose() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveInterstitialSmash != null)
            mActiveInterstitialSmash.onInterstitialAdClosed();
    }

    @Override
    public void onInterstitialShowSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveInterstitialSmash != null)
            mActiveInterstitialSmash.onInterstitialAdShowSucceeded();
    }

    @Override
    public void onInterstitialShowFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveInterstitialSmash != null) {
            mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError(IronSourceConstants.INTERSTITIAL_AD_UNIT, description));
        }
    }

    @Override
    public void onInterstitialClick() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveInterstitialSmash != null)
            mActiveInterstitialSmash.onInterstitialAdClicked();
    }

    @Override
    public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronLog.ADAPTER_CALLBACK.verbose( getProviderName() + " " + eventName + " extData: " + extData.toString());
            if (!TextUtils.isEmpty(eventName) && AD_VISIBLE_EVENT_NAME.equals(eventName) && mActiveInterstitialSmash != null) {
                mActiveInterstitialSmash.onInterstitialAdVisible();
            }
        }
    }


    // ********** Supersonic Offerwall Callbacks **********

    @Override
    public void onOfferwallInitSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mOfferwallListener != null) {
            mOfferwallListener.onOfferwallAvailable(true);
        }
    }

    @Override
    public void onOfferwallInitFail(String description) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(description);
            mOfferwallListener.onOfferwallAvailable(false, sse);
        }
    }

    @Override
    public void onOfferwallEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronLog.ADAPTER_CALLBACK.verbose(
                    getProviderName());
        }
    }

    @Override
    public void onOWShowSuccess(String placementId) {
        if (TextUtils.isEmpty(placementId)) {
            IronLog.ADAPTER_CALLBACK.verbose( getProviderName());
        } else {
            IronLog.ADAPTER_CALLBACK.verbose( getProviderName() + ":onOWShowSuccess(placementId:" + placementId + ")");
        }

        if (mOfferwallListener != null) {
            mOfferwallListener.onOfferwallOpened();
        }
    }

    @Override
    public void onOWShowFail(String desc) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(desc);
            mOfferwallListener.onOfferwallShowFailed(sse);
        }
    }

    @Override
    public void onOWGeneric(String arg0, String arg1) {
        // Deprecated
    }

    @Override
    public boolean onOWAdCredited(int credits, int totalCredits, boolean totalCreditsFlag) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        return mOfferwallListener != null && mOfferwallListener.onOfferwallAdCredited(credits, totalCredits, totalCreditsFlag);
    }

    @Override
    public void onOWAdClosed() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mOfferwallListener != null)
            mOfferwallListener.onOfferwallClosed();
    }

    @Override
    public void onGetOWCreditsFailed(String desc) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mOfferwallListener != null) {
            IronSourceError sse = ErrorBuilder.buildGenericError(desc);
            mOfferwallListener.onGetOfferwallCreditsFailed(sse);
        }
    }

    // ********** Supersonic Banner Callbacks **********

    @Override
    public void onBannerInitSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        for (BannerSmashListener smash : mAllBannerSmashes) {
            if (smash != null)
                smash.onBannerInitSuccess();
        }
    }

    @Override
    public void onBannerInitFailed(String description) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        for (BannerSmashListener smash : mAllBannerSmashes) {
            if (smash != null)
                smash.onBannerInitFailed(ErrorBuilder.buildInitFailedError(description, IronSourceConstants.BANNER_AD_UNIT));
        }
    }

    @Override
    public void onBannerClick() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        if (mActiveBannerSmash != null)
            mActiveBannerSmash.onBannerAdClicked();
    }

    @Override
    public void onBannerLoadSuccess() {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        for (BannerSmashListener smash : mAllBannerSmashes) {
            if (smash != null && mIsnAdView != null && mIsnAdView.getAdViewSize() != null) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(mIsnAdView.getAdViewSize().getWidth(), mIsnAdView.getAdViewSize().getHeight());
                layoutParams.gravity = Gravity.CENTER;
                smash.onBannerAdLoaded(mIsnAdView, layoutParams);
            }
        }
    }

    @Override
    public void onBannerLoadFail(String description) {
        IronLog.ADAPTER_CALLBACK.verbose( getProviderName());

        for (BannerSmashListener smash : mAllBannerSmashes) {
            if (smash != null)
                smash.onBannerAdLoadFailed(ErrorBuilder.buildInitFailedError(description, IronSourceConstants.BANNER_AD_UNIT));
        }
    }

    @Override
    protected void addBannerListener(BannerSmashListener listener) {
        mAllBannerSmashes.add(listener);
    }

    @Override
    protected void removeBannerListener(BannerSmashListener listener) {
        mAllBannerSmashes.remove(listener);
    }


    protected void setMediationState(AbstractSmash.MEDIATION_STATE state, String adUnit) {
        if (mSSAPublisher != null) {
            IronLog.ADAPTER_API.verbose( getProviderName() + ": setMediationState(" + adUnit + " , " + getProviderName() + " , " + state.getValue() + ")");
            mSSAPublisher.setMediationState(adUnit, getProviderName(), state.getValue());
        }
    }

    protected void setConsent(boolean consent) {
        IronLog.ADAPTER_API.verbose( getProviderName() + ": setConsent (" + (consent ? "true" : "false") + ")");

        mDidSetConsent = true;
        mConsent = consent;
        applyConsent(consent);
    }

    private void applyConsent(boolean consent) {
        if (mSSAPublisher == null) {
            // if there is not instance OR consent was not changed do nothing
            return;
        }

        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put(Constants.RequestParameters.GDPR_CONSENT_STATUS, String.valueOf(consent));
            consentParams.put(Constants.RequestParameters.DEMAND_SOURCE_NAME, getProviderName());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        mSSAPublisher.updateConsentInfo(consentParams);
    }



    /* The early init was added for early download of the controller. It's using the new SDK5's API, but there's no harm in it.*/
    @Override
    public void earlyInit (final String appKey, final String userId, final JSONObject config) {
        IronSourceUtils.sendAutomationLog(getProviderName() + ": " + "earlyInit");

        if (mDidInitSdk.compareAndSet(false,true)) {

            if (isAdaptersDebugEnabled()) {
                SDKUtils.setDebugMode(IronSourceLogger.IronSourceLogLevel.ERROR);
            } else {
                SDKUtils.setDebugMode(config.optInt(DYNAMIC_CONTROLLER_DEBUG_MODE, IronSourceLogger.IronSourceLogLevel.VERBOSE));
            }

            SDKUtils.setControllerUrl(config.optString(DYNAMIC_CONTROLLER_URL));
            IronLog.ADAPTER_API.verbose (getProviderName() + " IronSourceNetwork setting controller url to  "+ config.optString(DYNAMIC_CONTROLLER_URL));
            SDKUtils.setControllerConfig(config.optString(DYNAMIC_CONTROLLER_CONFIG, ""));
            IronLog.ADAPTER_API.verbose ( getProviderName() + " IronSourceNetwork setting controller config to  "+ config.optString(DYNAMIC_CONTROLLER_CONFIG));
            HashMap<String, String> initParams = getInitParams();
            IronSourceNetwork.initSDK(ContextProvider.getInstance().getCurrentActiveActivity(), appKey, userId, initParams);
            IronLog.ADAPTER_API.verbose ( "initSDK with appKey=" + appKey+ " userId=" + userId+ " parameters "+ initParams);
        }
    }

    private HashMap<String, String> getInitParams() {
        HashMap<String, String> params = new HashMap<>();

        if (!TextUtils.isEmpty(mUserAgeGroup)) {
            params.put(APPLICATION_USER_AGE_GROUP, mUserAgeGroup);
        }

        if (!TextUtils.isEmpty(mUserGender)) {
            params.put(APPLICATION_USER_GENDER, mUserGender);
        }

        String pluginType = getPluginType();
        if (!TextUtils.isEmpty(pluginType)) {
            params.put(SDK_PLUGIN_TYPE, pluginType);
        }

        if (!TextUtils.isEmpty(mMediationSegment)) {
            params.put(CUSTOM_SEGMENT, mMediationSegment);
        }

        return params;
    }

    private boolean isValidMetaData(String key, String value) {
        // In case the formatted CCPA Value is empty it means we didn't get a valid boolean string value and therefore we don't want to pass it to the network
        if (key.equals(MetaDataConstants.META_DATA_CCPA_KEY)) {
            return MetaDataUtils.isValidCCPAMetaData(key, value);
        }

        return true;
    }

    @Override
    protected void setMetaData(String key, String value) {
        if (!mDidInitSdk.get()) {
            IronLog.ADAPTER_API.verbose("key=" + key +", value=" + value);

            if (!isValidMetaData(key, value)) {
                IronLog.ADAPTER_API.verbose( "not valid");
                return;
            }

            JSONObject metaDataJson = new JSONObject();
            try {
                metaDataJson.put(key, value);
                IronSourceNetwork.updateMetadata(metaDataJson);
            } catch (JSONException e) {
                IronLog.ADAPTER_API.error("error - " + e);
                e.printStackTrace();
            }

        }
    }


}
