/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.ironsource.sdk.data.SSABCParameters;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.data.SSASession;
import com.ironsource.sdk.utils.IronSourceAsyncHttpRequestTask;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceSharedPrefHelper {
    private static final String SUPERSONIC_SHARED_PREF = "supersonic_shared_preferen";
    private static final String VERSION = "version";
    private static final String SSA_SDK_DOWNLOAD_URL = "ssa_sdk_download_url";
    private static final String SSA_SDK_LOAD_URL = "ssa_sdk_load_url";
    private static final String UNIQUE_ID_RV = "unique_id_rv";
    private static final String UNIQUE_ID_OW = "unique_id_ow";
    private static final String UNIQUE_ID_IS = "unique_id_is";
    private static final String UNIQUE_ID = "unique_id";
    private static final String APPLICATION_KEY_RV = "application_key_rv";
    private static final String APPLICATION_KEY_OW = "application_key_ow";
    private static final String APPLICATION_KEY_IS = "application_key_is";
    private static final String APPLICATION_KEY = "application_key";
    private static final String SSA_RV_PARAMETER_CONNECTION_RETRIES = "ssa_rv_parameter_connection_retries";
    private static final String BACK_BUTTON_STATE = "back_button_state";
    private static final String SEARCH_KEYS = "search_keys";
    private static final String REGISTER_SESSIONS = "register_sessions";
    private static final String SESSIONS = "sessions";
    private static final String IS_REPORTED = "is_reported";
    private SharedPreferences mSharedPreferences;
    private static IronSourceSharedPrefHelper mInstance;

    private IronSourceSharedPrefHelper(Context context) {
        this.mSharedPreferences = context.getSharedPreferences(SUPERSONIC_SHARED_PREF, 0);
    }

    public static synchronized IronSourceSharedPrefHelper getSupersonicPrefHelper(Context context) {
        if (mInstance == null) {
            mInstance = new IronSourceSharedPrefHelper(context);
        }
        return mInstance;
    }

    public static synchronized IronSourceSharedPrefHelper getSupersonicPrefHelper() {
        return mInstance;
    }

    public String getConnectionRetries() {
        return this.mSharedPreferences.getString(SSA_RV_PARAMETER_CONNECTION_RETRIES, "3");
    }

    public void setSSABCParameters(SSABCParameters object) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(SSA_RV_PARAMETER_CONNECTION_RETRIES, object.getConnectionRetries());
        editor.commit();
    }

    public void setBackButtonState(String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(BACK_BUTTON_STATE, value);
        editor.commit();
    }

    public SSAEnums.BackButtonState getBackButtonState() {
        String stateStr = this.mSharedPreferences.getString(BACK_BUTTON_STATE, "2");
        int state = Integer.parseInt(stateStr);
        if (state == 0) {
            return SSAEnums.BackButtonState.None;
        }
        if (state == 1) {
            return SSAEnums.BackButtonState.Device;
        }
        if (state == 2) {
            return SSAEnums.BackButtonState.Controller;
        }
        return SSAEnums.BackButtonState.Controller;
    }

    public void setSearchKeys(String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(SEARCH_KEYS, value);
        editor.commit();
    }

    public List<String> getSearchKeys() {
        SSAObj ssaObj;
        String value = this.mSharedPreferences.getString(SEARCH_KEYS, null);
        ArrayList<String> keys = new ArrayList<String>();
        if (value != null && (ssaObj = new SSAObj(value)).containsKey("searchKeys")) {
            JSONArray jsonArr = (JSONArray)ssaObj.get("searchKeys");
            try {
                keys.addAll(ssaObj.toList(jsonArr));
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        return keys;
    }

    public JSONArray getSessions() {
        JSONArray jsArr = null;
        String value = this.mSharedPreferences.getString(SESSIONS, null);
        if (value == null) {
            return new JSONArray();
        }
        try {
            jsArr = new JSONArray(value);
        }
        catch (JSONException e2) {
            jsArr = new JSONArray();
        }
        return jsArr;
    }

    public void deleteSessions() {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(SESSIONS, null);
        editor.commit();
    }

    public void addSession(SSASession session) {
        if (this.getShouldRegisterSessions()) {
            JSONObject jsObj = new JSONObject();
            try {
                jsObj.put("sessionStartTime", session.getSessionStartTime());
                jsObj.put("sessionEndTime", session.getSessionEndTime());
                jsObj.put("sessionType", (Object)session.getSessionType());
                jsObj.put("connectivity", (Object)session.getConnectivity());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            JSONArray jsArr = this.getSessions();
            if (jsArr == null) {
                jsArr = new JSONArray();
            }
            jsArr.put((Object)jsObj);
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.putString(SESSIONS, jsArr.toString());
            editor.commit();
        }
    }

    private boolean getShouldRegisterSessions() {
        return this.mSharedPreferences.getBoolean(REGISTER_SESSIONS, true);
    }

    public void setShouldRegisterSessions(boolean value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putBoolean(REGISTER_SESSIONS, value);
        editor.commit();
    }

    public boolean setUserData(String key, String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public String getUserData(String key) {
        String value = this.mSharedPreferences.getString(key, null);
        if (value != null) {
            return value;
        }
        return "{}";
    }

    public String getApplicationKey(SSAEnums.ProductType type) {
        String applicationKey = null;
        switch (type) {
            case RewardedVideo: {
                applicationKey = this.mSharedPreferences.getString(APPLICATION_KEY_RV, null);
                break;
            }
            case OfferWall: {
                applicationKey = this.mSharedPreferences.getString(APPLICATION_KEY_OW, null);
                break;
            }
            case Interstitial: {
                applicationKey = this.mSharedPreferences.getString(APPLICATION_KEY_IS, null);
                break;
            }
        }
        if (applicationKey == null) {
            applicationKey = this.mSharedPreferences.getString(APPLICATION_KEY, "EMPTY_APPLICATION_KEY");
        }
        return applicationKey;
    }

    public void setApplicationKey(String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(APPLICATION_KEY, value);
        editor.commit();
    }

    public boolean setUniqueId(String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(UNIQUE_ID, value);
        return editor.commit();
    }

    public String getCurrentSDKVersion() {
        return this.mSharedPreferences.getString(VERSION, "UN_VERSIONED");
    }

    public void setCurrentSDKVersion(String sdkVersion) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(VERSION, sdkVersion);
        editor.commit();
    }

    public String getSDKDownloadUrl() {
        return this.mSharedPreferences.getString(SSA_SDK_DOWNLOAD_URL, null);
    }

    public String getCampaignLastUpdate(String campaign) {
        return this.mSharedPreferences.getString(campaign, null);
    }

    public void setCampaignLastUpdate(String campaign, String lastUpdate) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(campaign, lastUpdate);
        editor.commit();
    }

    public String getUniqueId(String type) {
        String userUniqueId = null;
        if (type.equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.toString())) {
            userUniqueId = this.mSharedPreferences.getString(UNIQUE_ID_RV, null);
        } else if (type.equalsIgnoreCase(SSAEnums.ProductType.OfferWall.toString())) {
            userUniqueId = this.mSharedPreferences.getString(UNIQUE_ID_OW, null);
        } else if (type.equalsIgnoreCase(SSAEnums.ProductType.Interstitial.toString())) {
            userUniqueId = this.mSharedPreferences.getString(UNIQUE_ID_IS, null);
        }
        if (userUniqueId == null) {
            userUniqueId = this.mSharedPreferences.getString(UNIQUE_ID, "EMPTY_UNIQUE_ID");
        }
        return userUniqueId;
    }

    public String getUniqueId(SSAEnums.ProductType type) {
        return this.getUniqueId(type.toString());
    }

    public boolean setLatestCompeltionsTime(String timestamp, String applicationKey, String userId) {
        String value = this.mSharedPreferences.getString("ssaUserData", null);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                JSONObject applicationKeyJson;
                JSONObject ssaUserDataJson = new JSONObject(value);
                if (!ssaUserDataJson.isNull(applicationKey) && !(applicationKeyJson = ssaUserDataJson.getJSONObject(applicationKey)).isNull(userId)) {
                    JSONObject userIdJson = applicationKeyJson.getJSONObject(userId);
                    userIdJson.put("timestamp", (Object)timestamp);
                    SharedPreferences.Editor editor = this.mSharedPreferences.edit();
                    editor.putString("ssaUserData", ssaUserDataJson.toString());
                    return editor.commit();
                }
            }
            catch (JSONException e2) {
                new IronSourceAsyncHttpRequestTask().execute(new String[]{"https://www.supersonicads.com/mobile/sdk5/log?method=" + e2.getStackTrace()[0].getMethodName()});
            }
        }
        return false;
    }

    public void setReportAppStarted(boolean value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putBoolean(IS_REPORTED, value);
        editor.apply();
    }

    public boolean getReportAppStarted() {
        return this.mSharedPreferences.getBoolean(IS_REPORTED, false);
    }
}

