/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.DemandOnlyRvSmash;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.RVDemandOnlyListenerWrapper;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.model.RewardedVideoConfigurations;
import com.ironsource.mediationsdk.sdk.DemandOnlyRvManagerListener;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

class DemandOnlyRvManager
implements DemandOnlyRvManagerListener {
    private ConcurrentHashMap<String, DemandOnlyRvSmash> mSmashes;
    private String mAppKey;
    private Context mContext;
    private AuctionSettings mAuctionSettings;

    DemandOnlyRvManager(Activity activity, List<ProviderSettings> providersList, RewardedVideoConfigurations configs, String appKey, String userId) {
        this.mAppKey = appKey;
        this.mSmashes = new ConcurrentHashMap();
        this.mContext = activity.getApplicationContext();
        this.mAuctionSettings = configs.getRewardedVideoAuctionSettings();
        for (ProviderSettings provider : providersList) {
            if (provider.getProviderTypeForReflection().equalsIgnoreCase("SupersonicAds") || provider.getProviderTypeForReflection().equalsIgnoreCase("IronSource")) {
                AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(provider, provider.getRewardedVideoSettings(), activity, true);
                if (adapter == null) continue;
                DemandOnlyRvSmash smash = new DemandOnlyRvSmash(activity, appKey, userId, provider, this, configs.getRewardedVideoAdaptersSmartLoadTimeout(), adapter);
                this.mSmashes.put(provider.getSubProviderId(), smash);
                continue;
            }
            this.logInternal("cannot load " + provider.getProviderTypeForReflection());
        }
    }

    public void loadRewardedVideoWithAdm(String instanceId, String adm, boolean isBidderFlow) {
        try {
            if (!this.mSmashes.containsKey(instanceId)) {
                this.sendMediationEvent(1500, instanceId);
                IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Rewarded Video");
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, error);
                return;
            }
            DemandOnlyRvSmash smash = this.mSmashes.get(instanceId);
            if (isBidderFlow) {
                if (!smash.isBidder()) {
                    IronSourceError error = ErrorBuilder.buildLoadFailedError("loadRewardedVideoWithAdm in IAB flow must be called by bidder instances");
                    this.logInternal(error.getErrorMessage());
                    RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, error);
                    this.sendProviderEvent(1200, smash);
                } else {
                    JSONObject jsonObj = AuctionDataUtils.getInstance().decodeAdmResponse(adm);
                    AuctionDataUtils.AuctionData auctionDataObj = AuctionDataUtils.getInstance().getAuctionDataFromResponse(jsonObj);
                    AuctionResponseItem responseItem = AuctionDataUtils.getInstance().getAuctionResponseItem(smash.getInstanceName(), auctionDataObj.getWaterfall());
                    if (responseItem != null) {
                        smash.setDynamicDemandSourceIdByServerData(responseItem.getServerData());
                        smash.loadRewardedVideo(responseItem.getServerData(), auctionDataObj.getAuctionId(), responseItem.getBurls());
                        this.sendProviderEvent(1001, smash);
                    } else {
                        IronSourceError error = ErrorBuilder.buildLoadFailedError("loadRewardedVideoWithAdm invalid enriched adm");
                        this.logInternal(error.getErrorMessage());
                        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, error);
                        this.sendProviderEvent(1200, smash);
                    }
                }
            } else if (!smash.isBidder()) {
                this.sendProviderEvent(1001, smash);
                smash.loadRewardedVideo("", "", null);
            } else {
                IronSourceError error = ErrorBuilder.buildLoadFailedError("loadRewardedVideoWithAdm in non IAB flow must be called by non bidder instances");
                this.logInternal(error.getErrorMessage());
                RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, error);
                this.sendProviderEvent(1200, smash);
            }
        }
        catch (Exception e2) {
            this.logInternal("loadRewardedVideoWithAdm exception " + e2.getMessage());
            IronSourceError error = ErrorBuilder.buildLoadFailedError("loadRewardedVideoWithAdm exception");
            RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(instanceId, error);
        }
    }

    public String getBiddingData() {
        this.sendMediationEvent(83002, null);
        if (this.mSmashes != null) {
            DemandOnlyRvSmash smash = this.mSmashes.entrySet().iterator().next().getValue();
            String token = AdapterRepository.getInstance().getBiddingData(IronSource.AD_UNIT.REWARDED_VIDEO, smash.getAdapterConfig().getProviderSettings());
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
            String sessionId = IronSourceObject.getInstance().getSessionId();
            if (token != null) {
                HashMap<String, String> ironSourceBidderMap = new HashMap<String, String>();
                ironSourceBidderMap.put("token", token);
                HashMap<String, Object> bidder = new HashMap<String, Object>();
                bidder.put("IronSource", ironSourceBidderMap);
                try {
                    JSONObject ret = new JSONObject();
                    ret = AuctionDataUtils.getInstance().enrichToken(this.mContext, bidder, null, null, sessionDepth, sessionId, this.mAuctionSettings);
                    return AuctionDataUtils.getInstance().encryptToken(ret);
                }
                catch (JSONException e2) {
                    this.logInternal("getBiddingData() error during enrich token");
                    this.sendMediationEvent(83004, null);
                    return null;
                }
            }
        }
        this.logInternal("called getBiddingData() with no smashes");
        this.sendMediationEvent(83003, null);
        return null;
    }

    public void showRewardedVideo(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(1500, instanceId);
            IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Rewarded Video");
            RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdShowFailed(instanceId, error);
            return;
        }
        DemandOnlyRvSmash smash = this.mSmashes.get(instanceId);
        this.sendProviderEvent(1201, smash);
        smash.showRewardedVideo();
    }

    public boolean isRewardedVideoAvailable(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(1500, instanceId);
            return false;
        }
        DemandOnlyRvSmash smash = this.mSmashes.get(instanceId);
        if (smash.isRewardedVideoAvailable()) {
            this.sendProviderEvent(1210, smash);
            return true;
        }
        this.sendProviderEvent(1211, smash);
        return false;
    }

    @Override
    public void onRewardedVideoLoadSuccess(DemandOnlyRvSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onRewardedVideoLoadSuccess");
        this.sendProviderEvent(1002, smash, new Object[][]{{"duration", elapsedTime}});
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoLoadSuccess(smash.getSubProviderId());
    }

    @Override
    public void onRewardedVideoAdLoadFailed(IronSourceError error, DemandOnlyRvSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onRewardedVideoAdLoadFailed error=" + error);
        this.sendProviderEvent(1200, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", elapsedTime}});
        this.sendProviderEvent(1212, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", elapsedTime}});
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdLoadFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onRewardedVideoAdOpened(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdOpened");
        this.sendProviderEvent(1005, smash);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdOpened(smash.getSubProviderId());
        if (smash.isBidder()) {
            for (String url : smash.mBUrl) {
                if (url == null) continue;
                AuctionDataUtils.getInstance().sendResponse(url);
            }
        }
    }

    @Override
    public void onRewardedVideoAdClosed(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdClosed");
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(1);
        this.sendProviderEvent(1203, smash, new Object[][]{{"sessionDepth", sessionDepth}});
        SessionDepthManager.getInstance().increaseSessionDepth(1);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdClosed(smash.getSubProviderId());
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdShowFailed error=" + error);
        this.sendProviderEvent(1202, smash, new Object[][]{{"errorCode", error.getErrorCode()}});
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdShowFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onRewardedVideoAdClicked(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdClicked");
        this.sendProviderEvent(1006, smash);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdClicked(smash.getSubProviderId());
    }

    @Override
    public void onRewardedVideoAdVisible(DemandOnlyRvSmash smash) {
        this.logSmashCallback(smash, "onRewardedVideoAdVisible");
        this.sendProviderEvent(1206, smash);
    }

    @Override
    public void onRewardedVideoAdRewarded(DemandOnlyRvSmash smash) {
        Placement defaultPlacement;
        this.logSmashCallback(smash, "onRewardedVideoAdRewarded");
        Map<String, Object> data = smash.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
            data.put("dynamicUserId", IronSourceObject.getInstance().getDynamicUserId());
        }
        if (IronSourceObject.getInstance().getRvServerParams() != null) {
            for (String key : IronSourceObject.getInstance().getRvServerParams().keySet()) {
                data.put("custom_" + key, IronSourceObject.getInstance().getRvServerParams().get(key));
            }
        }
        if ((defaultPlacement = IronSourceObject.getInstance().getCurrentServerResponse().getConfigurations().getRewardedVideoConfigurations().getDefaultRewardedVideoPlacement()) != null) {
            data.put("placement", defaultPlacement.getPlacementName());
            data.put("rewardName", defaultPlacement.getRewardName());
            data.put("rewardAmount", defaultPlacement.getRewardAmount());
        } else {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "defaultPlacement is null", 3);
        }
        EventData event = new EventData(1010, new JSONObject(data));
        String strToTransId = "" + Long.toString(event.getTimeStamp()) + this.mAppKey + smash.getInstanceName();
        String transId = IronSourceUtils.getTransId(strToTransId);
        event.addToAdditionalData("transId", transId);
        RewardedVideoEventsManager.getInstance().log(event);
        RVDemandOnlyListenerWrapper.getInstance().onRewardedVideoAdRewarded(smash.getSubProviderId());
    }

    private void sendProviderEvent(int eventId, DemandOnlyRvSmash smash) {
        this.sendProviderEvent(eventId, smash, null);
    }

    private void sendProviderEvent(int eventId, DemandOnlyRvSmash smash, Object[][] keyVals) {
        Map<String, Object> data = smash.getProviderEventData();
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private void sendMediationEvent(int eventId, String instanceId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("isDemandOnly", 1);
        data.put("spId", instanceId != null ? instanceId : "");
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "DemandOnlyRvManager " + text, 0);
    }

    private void logSmashCallback(DemandOnlyRvSmash smash, String line) {
        String text = "DemandOnlyRvManager " + smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

