/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class DemandOnlySmash {
    protected AbstractAdapter mAdapter;
    protected AdapterConfig mAdapterConfig;
    protected JSONObject mAdUnitSettings;
    private SMASH_STATE mState;
    private Timer mLoadTimer;
    int mLoadTimeoutSecs;
    protected String mAuctionId;
    protected List<String> mBUrl;
    protected String mDynamicDemandSourceId;
    private final Object mStateLock = new Object();
    private final Object mTimerLock = new Object();

    public DemandOnlySmash(AdapterConfig adapterConfig, AbstractAdapter adapter) {
        this.mAdapterConfig = adapterConfig;
        this.mAdapter = adapter;
        this.mAdUnitSettings = adapterConfig.getAdUnitSetings();
        this.mState = SMASH_STATE.NOT_LOADED;
        this.mLoadTimer = null;
        this.mAuctionId = "";
        this.mBUrl = new ArrayList<String>();
    }

    public String getInstanceName() {
        return this.mAdapterConfig.getProviderName();
    }

    public String getSubProviderId() {
        return this.mAdapterConfig.getSubProviderId();
    }

    public String getAuctionId() {
        return this.mAuctionId;
    }

    public List<String> getbURL() {
        return this.mBUrl;
    }

    public Map<String, Object> getProviderEventData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            data.put("providerAdapterVersion", this.mAdapter != null ? this.mAdapter.getVersion() : "");
            data.put("providerSDKVersion", this.mAdapter != null ? this.mAdapter.getCoreSDKVersion() : "");
            data.put("spId", this.mAdapterConfig.getSubProviderId());
            data.put("provider", this.mAdapterConfig.getAdSourceNameForEvents());
            data.put("isDemandOnly", 1);
            if (this.isBidder()) {
                data.put("programmatic", 1);
                data.put("instanceType", 2);
                if (!TextUtils.isEmpty((CharSequence)this.mAuctionId)) {
                    data.put("auctionId", this.mAuctionId);
                }
            } else {
                data.put("programmatic", 0);
                data.put("instanceType", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mDynamicDemandSourceId)) {
                data.put("dynamicDemandSource", this.mDynamicDemandSourceId);
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "getProviderEventData " + this.getInstanceName() + ")", e2);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean compareAndSetState(SMASH_STATE state, SMASH_STATE newState) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == state) {
                this.setState(newState);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SMASH_STATE compareAndSetState(SMASH_STATE[] states, SMASH_STATE newState) {
        Object object = this.mStateLock;
        synchronized (object) {
            SMASH_STATE currentState = this.mState;
            if (Arrays.asList(states).contains((Object)this.mState)) {
                this.setState(newState);
            }
            return currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(SMASH_STATE state) {
        String text = "DemandOnlySmash " + this.mAdapterConfig.getProviderName() + ": current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = state;
        }
    }

    String getStateString() {
        return this.mState == null ? "null" : this.mState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimer(TimerTask task) {
        Object object = this.mTimerLock;
        synchronized (object) {
            this.stopTimer();
            this.mLoadTimer = new Timer();
            this.mLoadTimer.schedule(task, this.mLoadTimeoutSecs * 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mLoadTimer != null) {
                this.mLoadTimer.cancel();
                this.mLoadTimer = null;
            }
        }
    }

    public boolean isBidder() {
        return this.mAdapterConfig.isBidder();
    }

    public AdapterConfig getAdapterConfig() {
        return this.mAdapterConfig;
    }

    public void setDynamicDemandSourceIdByServerData(String serverData) {
        this.mDynamicDemandSourceId = AuctionDataUtils.getInstance().getDynamicDemandSourceIdFromServerData(serverData);
    }

    protected static enum SMASH_STATE {
        NOT_LOADED,
        LOAD_IN_PROGRESS,
        LOADED,
        SHOW_IN_PROGRESS;

    }
}

