/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AuctionHistory;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.IronSourceAES;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuctionDataUtils {
    private static final String TAG = "AuctionDataUtils";
    private static final String AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY = "params";
    private static final String AUCTION_RESPONSE_SERVER_DATA_MARKET_PLACE_DEMAND_TYPE_KEY = "dynamicDemandSource";
    private static final String AUCTION_RESPONSE_SERVER_DATA_ADM_KEY = "adMarkup";
    private static AuctionDataUtils sInstance = new AuctionDataUtils();

    public static AuctionDataUtils getInstance() {
        return sInstance;
    }

    public AuctionData getAuctionDataFromResponse(JSONObject jsonResponseObj) throws JSONException {
        AuctionData auctionDataObj = new AuctionData();
        auctionDataObj.mAuctionId = jsonResponseObj.getString("auctionId");
        auctionDataObj.mWaterfall = new ArrayList();
        JSONArray waterfall = jsonResponseObj.getJSONArray("waterfall");
        for (int i = 0; i < waterfall.length(); ++i) {
            AuctionResponseItem item = new AuctionResponseItem(waterfall.getJSONObject(i));
            if (!item.isValid()) {
                auctionDataObj.mErrorCode = 1002;
                auctionDataObj.mErrorMessage = "waterfall " + i;
                throw new JSONException("invalid response");
            }
            auctionDataObj.mWaterfall.add(item);
        }
        return auctionDataObj;
    }

    public AuctionResponseItem getAuctionResponseItem(String instanceName, List<AuctionResponseItem> waterfall) {
        for (int i = 0; i < waterfall.size(); ++i) {
            if (!waterfall.get(i).getInstanceName().equals(instanceName)) continue;
            return waterfall.get(i);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject enrichToken(Context context, Map<String, Object> bidders, List<String> nonBidders, AuctionHistory auctionHistory, int sessionDepth, String sessionId, AuctionSettings auctionSettings) throws JSONException {
        void var12_19;
        JSONObject instances = new JSONObject();
        for (String instance : bidders.keySet()) {
            JSONObject bidderObject = new JSONObject();
            bidderObject.put("instanceType", 2);
            bidderObject.put("biddingAdditionalData", (Object)new JSONObject((Map)bidders.get(instance)));
            String string = auctionHistory != null ? auctionHistory.getStoredPerformanceForInstance(instance) : "";
            bidderObject.put("performance", (Object)string);
            instances.put(instance, (Object)bidderObject);
        }
        if (nonBidders != null) {
            for (String instance : nonBidders) {
                JSONObject nonbBidderObject = new JSONObject();
                nonbBidderObject.put("instanceType", 1);
                String string = auctionHistory != null ? auctionHistory.getStoredPerformanceForInstance(instance) : "";
                nonbBidderObject.put("performance", (Object)string);
                instances.put(instance, (Object)nonbBidderObject);
            }
        }
        ConcurrentHashMap<String, String> metaDataMap = AdapterRepository.getInstance().getMetaData();
        JSONObject metaDataJson = new JSONObject();
        for (Map.Entry entry : metaDataMap.entrySet()) {
            metaDataJson.put((String)entry.getKey(), entry.getValue());
        }
        JSONObject clientParams = new JSONObject();
        clientParams.put("applicationUserId", (Object)IronSourceObject.getInstance().getIronSourceUserId());
        String string = IronSourceObject.getInstance().getGender();
        if (TextUtils.isEmpty((CharSequence)string)) {
            String string2 = "unknown";
        }
        clientParams.put("applicationUserGender", (Object)var12_19);
        Integer age = IronSourceObject.getInstance().getAge();
        if (age == null) {
            age = -1;
        }
        clientParams.put("applicationUserAge", (Object)age);
        Boolean consent = IronSourceObject.getInstance().getConsent();
        if (consent != null) {
            clientParams.put("consent", consent != false ? 1 : 0);
        }
        clientParams.put("mobileCarrier", (Object)DeviceStatus.getMobileCarrier(context));
        clientParams.put("connectionType", (Object)IronSourceUtils.getConnectionType(context));
        clientParams.put("deviceOS", (Object)"android");
        clientParams.put("deviceWidth", context.getResources().getConfiguration().screenWidthDp);
        clientParams.put("deviceHeight", context.getResources().getConfiguration().screenHeightDp);
        clientParams.put("deviceOSVersion", (Object)(Build.VERSION.SDK_INT + "(" + Build.VERSION.RELEASE + ")"));
        clientParams.put("deviceModel", (Object)Build.MODEL);
        clientParams.put("deviceMake", (Object)Build.MANUFACTURER);
        clientParams.put("bundleId", (Object)context.getPackageName());
        clientParams.put("appVersion", (Object)ApplicationContext.getPublisherApplicationVersion(context, context.getPackageName()));
        clientParams.put("clientTimestamp", new Date().getTime());
        String advertisingId = "";
        String advertisingIdType = "";
        boolean isLimitAdTrackingEnabled = false;
        try {
            String[] advertisingIdInfo = DeviceStatus.getAdvertisingIdInfo(context);
            if (advertisingIdInfo != null && advertisingIdInfo.length == 2) {
                if (!TextUtils.isEmpty((CharSequence)advertisingIdInfo[0])) {
                    advertisingId = advertisingIdInfo[0];
                }
                isLimitAdTrackingEnabled = Boolean.valueOf(advertisingIdInfo[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
            advertisingIdType = "GAID";
        } else {
            advertisingId = DeviceStatus.getOrGenerateOnceUniqueIdentifier(context);
            if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
                advertisingIdType = "UUID";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
            clientParams.put("advId", (Object)advertisingId);
            clientParams.put("advIdType", (Object)advertisingIdType);
            clientParams.put("isLimitAdTrackingEnabled", (Object)(isLimitAdTrackingEnabled ? "true" : "false"));
        }
        JSONObject ret = new JSONObject();
        ret.put("applicationKey", (Object)IronSourceObject.getInstance().getIronSourceAppKey());
        ret.put("SDKVersion", (Object)IronSourceUtils.getSDKVersion());
        ret.put("clientParams", (Object)clientParams);
        ret.put("sessionDepth", sessionDepth);
        ret.put("sessionId", (Object)sessionId);
        ret.put("instances", (Object)instances);
        ret.put("auctionData", (Object)auctionSettings.getAuctionData());
        ret.put("metaData", (Object)metaDataJson);
        return ret;
    }

    String encryptToken(JSONObject token) {
        String body = token.toString();
        body = IronSourceAES.encode("C38FB23A402222A0C17D34A92F971D1F", body);
        return body;
    }

    JSONObject decodeAdmResponse(String adm) {
        try {
            String decryptedAdm = IronSourceAES.decode("C38FB23A402222A0C17D34A92F971D1F", adm);
            JSONObject jsonObj = new JSONObject(decryptedAdm);
            return jsonObj;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void sendResponse(String url) {
        new ImpressionHttpTask().execute(new String[]{url});
    }

    public Map<String, String> getAuctionResponseServerDataParams(String serverData) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            JSONObject serverDataJson = new JSONObject(serverData);
            if (serverDataJson.has(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY)) {
                JSONObject paramsJson = serverDataJson.getJSONObject(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY);
                Iterator keys = paramsJson.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = paramsJson.get(key);
                    if (!(value instanceof String)) continue;
                    params.put(key, (String)value);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return params;
    }

    public String getAdmFromServerData(String serverData) {
        String adm = serverData;
        try {
            JSONObject serverDataJson = new JSONObject(serverData);
            if (serverDataJson.has(AUCTION_RESPONSE_SERVER_DATA_ADM_KEY)) {
                adm = serverDataJson.getString(AUCTION_RESPONSE_SERVER_DATA_ADM_KEY);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return adm;
    }

    public String getDynamicDemandSourceIdFromServerData(String serverData) {
        String dynamicDemandSourceId = "";
        try {
            JSONObject paramsJson;
            JSONObject serverDataJson = new JSONObject(serverData);
            if (serverDataJson.has(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY) && (paramsJson = serverDataJson.getJSONObject(AUCTION_RESPONSE_SERVER_DATA_PARAMS_KEY)).has(AUCTION_RESPONSE_SERVER_DATA_MARKET_PLACE_DEMAND_TYPE_KEY)) {
                dynamicDemandSourceId = paramsJson.getString(AUCTION_RESPONSE_SERVER_DATA_MARKET_PLACE_DEMAND_TYPE_KEY);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return dynamicDemandSourceId;
    }

    static class ImpressionHttpTask
    extends AsyncTask<String, Void, Boolean> {
        private static final int SERVER_REQUEST_TIMEOUT = 15000;

        ImpressionHttpTask() {
        }

        protected Boolean doInBackground(String ... objects) {
            try {
                URL url = new URL(objects[0]);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.setReadTimeout(15000);
                urlConnection.setConnectTimeout(15000);
                urlConnection.connect();
                int httpResponseCode = urlConnection.getResponseCode();
                urlConnection.disconnect();
                return httpResponseCode == 200;
            }
            catch (Exception e2) {
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
        }
    }

    public static class AuctionData {
        private String mAuctionId;
        private List<AuctionResponseItem> mWaterfall;
        private int mErrorCode;
        private String mErrorMessage;

        public String getAuctionId() {
            return this.mAuctionId;
        }

        public List<AuctionResponseItem> getWaterfall() {
            return this.mWaterfall;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }
}

