/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AuctionDataUtils;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.metadata.MetaDataUtils;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.IronSourceAdInstanceBuilder;
import com.ironsource.sdk.IronSourceNetwork;
import com.ironsource.sdk.listeners.OnInterstitialListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class IronSourceAdapter
extends AbstractAdapter {
    private static final String VERSION = "6.16.1";
    private static final int IS_LOAD_EXCEPTION = 1000;
    private static final int IS_SHOW_EXCEPTION = 1001;
    private static final int RV_LOAD_EXCEPTION = 1002;
    private static final int RV_SHOW_EXCEPTION = 1003;
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private final String APPLICATION_USER_GENDER = "applicationUserGender";
    private final String APPLICATION_USER_AGE_GROUP = "applicationUserAgeGroup";
    private final String SDK_PLUGIN_TYPE = "SDKPluginType";
    private final String CUSTOM_SEGMENT = "custom_Segment";
    private final String ADM_KEY = "adm";
    private final String DEMAND_SOURCE_NAME = "demandSourceName";
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToISAd;
    private ConcurrentHashMap<String, IronSourceAdInstance> mDemandSourceToRvAd;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mDemandSourceToRvSmash;
    private ConcurrentHashMap<String, InterstitialSmashListener> mDemandSourceToISSmash;
    private static AtomicBoolean mDidInitSdk = new AtomicBoolean(false);
    private String mUserAgeGroup;
    private String mUserGender;
    private String mMediationSegment;
    private Context mContext;

    public static IronSourceAdapter startAdapter(String providerName) {
        return new IronSourceAdapter(providerName);
    }

    private IronSourceAdapter(String providerName) {
        super(providerName);
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, providerName + ": new instance");
        this.mDemandSourceToISAd = new ConcurrentHashMap();
        this.mDemandSourceToRvAd = new ConcurrentHashMap();
        this.mDemandSourceToRvSmash = new ConcurrentHashMap();
        this.mDemandSourceToISSmash = new ConcurrentHashMap();
        this.mUserAgeGroup = null;
        this.mUserGender = null;
        this.mMediationSegment = null;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onPause(Activity activity) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "IronSourceNetwork.onPause");
        IronSourceNetwork.onPause(activity);
    }

    @Override
    public void onResume(Activity activity) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "IronSourceNetwork.onResume");
        IronSourceNetwork.onResume(activity);
    }

    @Override
    protected void setConsent(boolean consent) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "setConsent (" + (consent ? "true" : "false") + ")");
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("gdprConsentStatus", (Object)String.valueOf(consent));
        }
        catch (JSONException e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "setConsent exception " + e2.getMessage());
            return;
        }
        IronSourceNetwork.updateConsentInfo(consentParams);
    }

    @Override
    public void setAge(int age) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, "setAge: " + age);
        this.mUserAgeGroup = age >= 13 && age <= 17 ? "1" : (age >= 18 && age <= 20 ? "2" : (age >= 21 && age <= 24 ? "3" : (age >= 25 && age <= 34 ? "4" : (age >= 35 && age <= 44 ? "5" : (age >= 45 && age <= 54 ? "6" : (age >= 55 && age <= 64 ? "7" : (age > 65 && age <= 120 ? "8" : "0")))))));
    }

    @Override
    public void setGender(String gender) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, "setGender: " + gender);
        this.mUserGender = gender;
    }

    @Override
    public void setMediationSegment(String segment) {
        this.mMediationSegment = segment;
    }

    private HashMap<String, String> getInitParams() {
        String pluginType;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)this.mUserAgeGroup)) {
            params.put("applicationUserAgeGroup", this.mUserAgeGroup);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUserGender)) {
            params.put("applicationUserGender", this.mUserGender);
        }
        if (!TextUtils.isEmpty((CharSequence)(pluginType = this.getPluginType()))) {
            params.put("SDKPluginType", pluginType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediationSegment)) {
            params.put("custom_Segment", this.mMediationSegment);
        }
        return params;
    }

    @Override
    public void earlyInit(Activity activity, String appKey, String userId, JSONObject config) {
        IronSourceUtils.sendAutomationLog(this.getDemandSourceName(config) + ": earlyInit");
        this.initSDK(activity, appKey, userId, config);
    }

    @Override
    public Map<String, Object> getIsBiddingData(JSONObject config) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "getIsBiddingData");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(this.mContext);
        if (token != null) {
            ret.put("token", token);
        } else {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "IS bidding token is null");
            ret.put("token", "");
        }
        return ret;
    }

    @Override
    public void initInterstitialForBidding(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, config, "initInterstitialForBidding demandSourceName=" + demandSourceName);
        this.initInterstitialInternal(activity, appKey, userId, config, listener, demandSourceName);
    }

    @Override
    public void initInterstitial(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, config, "initInterstitial demandSourceName=" + demandSourceName);
        this.initInterstitialInternal(activity, appKey, userId, config, listener, demandSourceName);
    }

    private void initInterstitialInternal(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener, String demandSourceName) {
        this.initSDK(activity, appKey, userId, config);
        this.mDemandSourceToISSmash.put(demandSourceName, listener);
        listener.onInterstitialInitSuccess();
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener, String serverData) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, config, "loadInterstitial");
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, false, true, false);
        }
        catch (Exception e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "loadInterstitial for bidding exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, config, "loadInterstitial");
        try {
            this.loadAdInternal(this.getDemandSourceName(config), null, false, false, false);
        }
        catch (Exception e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "loadInterstitial exception " + e2.getMessage());
            listener.onInterstitialAdLoadFailed(new IronSourceError(1000, e2.getMessage()));
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, config, "showInterstitial");
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
            this.showAdInternal(adInstance, 2);
        }
        catch (Exception e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "showInterstitial exception " + e2.getMessage());
            listener.onInterstitialAdShowFailed(new IronSourceError(1001, e2.getMessage()));
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToISAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    @Override
    public Map<String, Object> getRvBiddingData(JSONObject config) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "getRvBiddingData");
        HashMap<String, Object> biddingData = new HashMap<String, Object>();
        String token = IronSourceNetwork.getToken(this.mContext);
        if (token != null) {
            biddingData.put("token", token);
        } else {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV bidding token is null");
            biddingData.put("token", "");
        }
        return biddingData;
    }

    @Override
    public void initRvForBidding(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, config, "initRvForBidding demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(activity, appKey, userId, config, listener, demandSourceName);
        listener.onRewardedVideoInitSuccess();
    }

    @Override
    public void initRvForDemandOnly(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, config, "initRvForDemandOnly demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(activity, appKey, userId, config, listener, demandSourceName);
    }

    @Override
    public void initRewardedVideo(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
        String demandSourceName = this.getDemandSourceName(config);
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, config, "initRewardedVideo with demandSourceName=" + demandSourceName);
        this.initRewardedVideoInternal(activity, appKey, userId, config, listener, demandSourceName);
        this.fetchRewardedVideo(config);
    }

    private void initRewardedVideoInternal(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener, String demandSourceName) {
        this.initSDK(activity, appKey, userId, config);
        this.mDemandSourceToRvSmash.put(demandSourceName, listener);
    }

    private IronSourceAdInstance getAdInstance(String demandSourceName, boolean isDemandOnlyForRv, boolean isBidder, boolean isRewarded) {
        IronSourceAdInstance adInstance;
        IronSourceAdInstance ironSourceAdInstance = adInstance = isRewarded ? this.mDemandSourceToRvAd.get(demandSourceName) : this.mDemandSourceToISAd.get(demandSourceName);
        if (adInstance == null) {
            IronSourceAdInstanceBuilder builder;
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "getAdInstance creating ad instance for " + demandSourceName + " isDemandOnlyForRv=" + isDemandOnlyForRv + " isBidder=" + isBidder + " isRewarded=" + isRewarded);
            if (isRewarded) {
                builder = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceRewardedVideoListener(this.mDemandSourceToRvSmash.get(demandSourceName), demandSourceName, isDemandOnlyForRv)).setExtraParams(this.getInitParams());
                builder.setRewarded();
            } else {
                builder = new IronSourceAdInstanceBuilder(demandSourceName, new IronSourceInterstitialListener(this.mDemandSourceToISSmash.get(demandSourceName), demandSourceName)).setExtraParams(this.getInitParams());
            }
            if (isBidder) {
                builder.setInAppBidding();
            }
            adInstance = builder.build();
            if (isRewarded) {
                this.mDemandSourceToRvAd.put(demandSourceName, adInstance);
            } else {
                this.mDemandSourceToISAd.put(demandSourceName, adInstance);
            }
        }
        return adInstance;
    }

    @Override
    public void fetchRewardedVideo(JSONObject config) {
        block2: {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, config, "fetchRewardedVideo");
            String demandSourceName = this.getDemandSourceName(config);
            try {
                this.loadAdInternal(demandSourceName, null, false, false, true);
            }
            catch (Exception e2) {
                this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "fetchRewardedVideo exception " + e2.getMessage());
                RewardedVideoSmashListener listener = this.mDemandSourceToRvSmash.get(demandSourceName);
                if (listener == null) break block2;
                this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "fetchRewardedVideo exception " + e2.getMessage());
                listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
                listener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    @Override
    public void loadVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, config, "loadVideoForDemandOnly");
        try {
            this.loadAdInternal(this.getDemandSourceName(config), null, true, false, true);
        }
        catch (Exception e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "loadVideoForDemandOnly exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, config, "loadVideoForDemandOnly in bidding mode");
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, true, true, true);
        }
        catch (Exception e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "loadVideoForDemandOnly exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
        }
    }

    @Override
    public void loadVideo(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, config, "loadVideo (RV in bidding mode)");
        try {
            this.loadAdInternal(this.getDemandSourceName(config), serverData, false, true, true);
        }
        catch (Exception e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "loadVideo exception " + e2.getMessage());
            listener.onRewardedVideoLoadFailed(new IronSourceError(1002, e2.getMessage()));
            listener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    private void loadAdInternal(String demandSourceName, String serverData, boolean isDemandOnlyForRv, boolean isBidder, boolean isRewarded) throws Exception {
        HashMap<String, String> loadConfig = new HashMap<String, String>();
        if (serverData != null) {
            loadConfig.put("adm", AuctionDataUtils.getInstance().getAdmFromServerData(serverData));
            Map<String, String> auctionResponseServerDataParams = AuctionDataUtils.getInstance().getAuctionResponseServerDataParams(serverData);
            loadConfig.putAll(auctionResponseServerDataParams);
        }
        IronSourceAdInstance adInstance = this.getAdInstance(demandSourceName, isDemandOnlyForRv, isBidder, isRewarded);
        this.printInstanceExtraParams(loadConfig);
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "loadAd demandSourceName=" + adInstance.getName());
        IronSourceNetwork.loadAd(adInstance, loadConfig);
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
        try {
            IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
            this.showAdInternal(adInstance, 1);
        }
        catch (Exception e2) {
            this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "showRewardedVideo exception " + e2.getMessage());
            listener.onRewardedVideoAdShowFailed(new IronSourceError(1003, e2.getMessage()));
        }
    }

    private void showAdInternal(IronSourceAdInstance adInstance, int adUnit) throws Exception {
        int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(adUnit);
        HashMap<String, String> showParams = new HashMap<String, String>();
        showParams.put("sessionDepth", String.valueOf(sessionDepth));
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "showAd demandSourceName=" + adInstance.getName() + " showParams=" + showParams);
        IronSourceNetwork.showAd(adInstance, showParams);
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        IronSourceAdInstance adInstance = this.mDemandSourceToRvAd.get(this.getDemandSourceName(config));
        return adInstance != null && IronSourceNetwork.isAdAvailableForInstance(adInstance);
    }

    private void initSDK(Activity activity, String appKey, String userId, JSONObject config) {
        if (activity == null) {
            this.logError(IronSourceLogger.IronSourceTag.INTERNAL, "initSDK: null activity");
            return;
        }
        this.mContext = activity.getApplicationContext();
        if (mDidInitSdk.compareAndSet(false, true)) {
            int logLevel = config.optInt("debugMode", 0);
            if (this.isAdaptersDebugEnabled()) {
                logLevel = 3;
            }
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "initSDK setting debug mode to " + logLevel);
            SDKUtils.setDebugMode(logLevel);
            SDKUtils.setControllerUrl(config.optString("controllerUrl"));
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "IronSourceNetwork setting controller url to  " + config.optString("controllerUrl"));
            SDKUtils.setControllerConfig(config.optString("controllerConfig"));
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "IronSourceNetwork setting controller config to  " + config.optString("controllerConfig"));
            HashMap<String, String> initParams = this.getInitParams();
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "initSDK with appKey=" + appKey + " userId=" + userId + " parameters " + initParams);
            IronSourceNetwork.initSDK(activity, appKey, userId, initParams);
        }
    }

    private String getDemandSourceName(JSONObject config) {
        if (!TextUtils.isEmpty((CharSequence)config.optString("demandSourceName"))) {
            return config.optString("demandSourceName");
        }
        return this.getProviderName();
    }

    private void logError(IronSourceLogger.IronSourceTag tag, String text) {
        IronSourceLoggerManager.getLogger().log(tag, "IronSourceAdapter: " + text, 3);
    }

    private void log(IronSourceLogger.IronSourceTag tag, String text) {
        IronSourceLoggerManager.getLogger().log(tag, "IronSourceAdapter: " + text, 0);
    }

    private void log(IronSourceLogger.IronSourceTag tag, JSONObject config, String text) {
        IronSourceLoggerManager.getLogger().log(tag, "IronSourceAdapter " + this.getDemandSourceName(config) + ": " + text, 0);
    }

    private boolean isValidMetaData(String key, String value) {
        if (key.equals("do_not_sell")) {
            return MetaDataUtils.isValidCCPAMetaData(key, value);
        }
        return true;
    }

    @Override
    protected void setMetaData(String key, String value) {
        if (!mDidInitSdk.get()) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "setMetaData: key=" + key + ", value=" + value);
            if (!this.isValidMetaData(key, value)) {
                this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "MetaData not valid");
                return;
            }
            JSONObject metaDataJson = new JSONObject();
            try {
                metaDataJson.put(key, (Object)value);
                IronSourceNetwork.updateMetadata(metaDataJson);
            }
            catch (JSONException e2) {
                this.logError(IronSourceLogger.IronSourceTag.ADAPTER_API, "setMetaData error - " + (Object)((Object)e2));
                e2.printStackTrace();
            }
        }
    }

    private void printInstanceExtraParams(Map<String, String> params) {
        if (params != null && params.size() > 0) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "instance extra params:");
            for (String key : params.keySet()) {
                this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, key + "=" + params.get(key));
            }
        }
    }

    private class IronSourceRewardedVideoListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        RewardedVideoSmashListener mListener;
        boolean mIsRvDemandOnly;

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = false;
        }

        IronSourceRewardedVideoListener(RewardedVideoSmashListener listener, String demandSourceName, boolean isDemandOnly) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
            this.mIsRvDemandOnly = isDemandOnly;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialInitSuccess");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialInitFailed");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialLoadSuccess");
            if (this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoLoadSuccess();
            } else {
                this.mListener.onRewardedVideoAvailabilityChanged(true);
            }
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialLoadFailed " + description);
            if (this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoLoadFailed(ErrorBuilder.buildLoadFailedError(description));
            } else {
                this.mListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        @Override
        public void onInterstitialOpen() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialOpen");
            this.mListener.onRewardedVideoAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialAdRewarded demandSourceId=" + demandSourceId + " amount=" + amount);
            this.mListener.onRewardedVideoAdRewarded();
        }

        @Override
        public void onInterstitialClose() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialClose");
            this.mListener.onRewardedVideoAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialShowSuccess");
            if (!this.mIsRvDemandOnly) {
                this.mListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "rewardedVideoListener onInterstitialShowSuccess " + description);
            this.mListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildShowFailedError("Rewarded Video", description));
        }

        @Override
        public void onInterstitialClick() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialClick");
            this.mListener.onRewardedVideoAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " rewardedVideoListener onInterstitialEventNotificationReceived eventName=" + eventName);
            this.mListener.onRewardedVideoAdVisible();
        }
    }

    private class IronSourceInterstitialListener
    implements OnInterstitialListener {
        private String mDemandSourceName;
        private InterstitialSmashListener mListener;

        IronSourceInterstitialListener(InterstitialSmashListener listener, String demandSourceName) {
            this.mDemandSourceName = demandSourceName;
            this.mListener = listener;
        }

        @Override
        public void onInterstitialInitSuccess() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialInitSuccess");
        }

        @Override
        public void onInterstitialInitFailed(String description) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialInitFailed");
        }

        @Override
        public void onInterstitialLoadSuccess() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialLoadSuccess");
            this.mListener.onInterstitialAdReady();
        }

        @Override
        public void onInterstitialLoadFailed(String description) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialLoadFailed " + description);
            this.mListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError(description));
        }

        @Override
        public void onInterstitialOpen() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialOpen");
            this.mListener.onInterstitialAdOpened();
        }

        @Override
        public void onInterstitialAdRewarded(String demandSourceId, int amount) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialAdRewarded demandSourceId=" + demandSourceId + " amount=" + amount);
        }

        @Override
        public void onInterstitialClose() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialClose");
            this.mListener.onInterstitialAdClosed();
        }

        @Override
        public void onInterstitialShowSuccess() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialShowSuccess");
            this.mListener.onInterstitialAdShowSucceeded();
        }

        @Override
        public void onInterstitialShowFailed(String description) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialShowFailed " + description);
            this.mListener.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", description));
        }

        @Override
        public void onInterstitialClick() {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialClick");
            this.mListener.onInterstitialAdClicked();
        }

        @Override
        public void onInterstitialEventNotificationReceived(String eventName, JSONObject extData) {
            IronSourceAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, this.mDemandSourceName + " interstitialListener onInterstitialEventNotificationReceived eventName=" + eventName);
            this.mListener.onInterstitialAdVisible();
        }
    }
}

