/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.content.Context;
import android.webkit.WebView;
import com.ironsource.sdk.analytics.omid.OMIDManager;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.data.SSAObj;
import com.ironsource.sdk.utils.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class OMIDJSAdapter {
    private static final String TAG = OMIDJSAdapter.class.getSimpleName();
    private Context mContext;
    private static final String ACTIVATE_FUNCTION_NAME = "activate";
    private static final String START_SESSION_FUNCTION_NAME = "startSession";
    private static final String FINISH_SESSION_FUNCTION_NAME = "finishSession";
    private static final String IMPRESSION_OCCURRED_FUNCTION_NAME = "impressionOccurred";
    private static final String GET_OMID_DATA_FUNCTION_NAME = "getOmidData";
    private static final String OMID_FUNCTION_PROPERTY_NAME = "omidFunction";
    private static final String OMID_PARAMS_PROPERTY_NAME = "omidParams";
    private static final String SUCCESS_JS_CALLBACK_NAME = "success";
    private static final String FAIL_JS_CALLBACK_NAME = "fail";
    private static final String UNSUPPORTED_OMID_API_MESSAGE = "%s | unsupported OMID API";

    public OMIDJSAdapter(Context context) {
        this.mContext = context;
    }

    void call(String params, WebController.NativeAPI.JSCallbackTask callback, WebView webView) throws Exception {
        FunctionCall fCall = this.fetchFunctionCall(params);
        SSAObj result = new SSAObj();
        try {
            switch (fCall.name) {
                case "activate": {
                    OMIDManager.activate(this.mContext);
                    result = OMIDManager.getOMIDData();
                    break;
                }
                case "startSession": {
                    OMIDManager.startSession(fCall.params, webView);
                    break;
                }
                case "finishSession": {
                    OMIDManager.finishSession();
                    break;
                }
                case "impressionOccurred": {
                    OMIDManager.impressionOccurred();
                    break;
                }
                case "getOmidData": {
                    result = OMIDManager.getOMIDData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(UNSUPPORTED_OMID_API_MESSAGE, fCall.name));
                }
            }
            callback.sendMessage(true, fCall.successCallback, result);
        }
        catch (Exception exception) {
            result.put("errMsg", exception.getMessage());
            Logger.i(TAG, "OMIDJSAdapter " + fCall.name + " Exception: " + exception.getMessage());
            callback.sendMessage(false, fCall.failCallback, result);
        }
    }

    private FunctionCall fetchFunctionCall(String params) throws JSONException {
        JSONObject functionData = new JSONObject(params);
        FunctionCall res = new FunctionCall();
        res.name = functionData.optString(OMID_FUNCTION_PROPERTY_NAME);
        res.params = functionData.optJSONObject(OMID_PARAMS_PROPERTY_NAME);
        res.successCallback = functionData.optString(SUCCESS_JS_CALLBACK_NAME);
        res.failCallback = functionData.optString(FAIL_JS_CALLBACK_NAME);
        return res;
    }

    private static class FunctionCall {
        String name;
        JSONObject params;
        String successCallback;
        String failCallback;

        private FunctionCall() {
        }
    }
}

