/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.environment.NetworkStateReceiver;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdUnitManager;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.RewardedVideoSmash;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.ListenersWrapper;
import com.ironsource.mediationsdk.sdk.RewardedVideoManagerListener;
import com.ironsource.mediationsdk.server.Server;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.DailyCappingListener;
import com.ironsource.mediationsdk.utils.DailyCappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

class RewardedVideoManager
extends AbstractAdUnitManager
implements RewardedVideoManagerListener,
NetworkStateReceiver.NetworkStateReceiverListener,
DailyCappingListener {
    private final String TAG = this.getClass().getSimpleName();
    private ListenersWrapper mListenersWrapper;
    private boolean mPauseSmartLoadDueToNetworkUnavailability = false;
    private boolean mIsUltraEventsEnabled = false;
    private NetworkStateReceiver mNetworkStateReceiver;
    private Placement mCurrentPlacement;
    private Timer mTimer = null;
    private int mManualLoadInterval;
    private List<AbstractSmash.MEDIATION_STATE> mStatesToIgnore;
    private boolean mShouldSendMediationLoadSuccessEvent = false;
    private long mLoadStartTime = new Date().getTime();
    private boolean mIsCurrentlyShowing = false;

    RewardedVideoManager() {
        this.mStatesToIgnore = Arrays.asList(AbstractSmash.MEDIATION_STATE.INIT_FAILED, AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, AbstractSmash.MEDIATION_STATE.EXHAUSTED, AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
        this.mDailyCappingManager = new DailyCappingManager("rewarded_video", this);
    }

    public void setRewardedVideoListener(ListenersWrapper listener) {
        this.mListenersWrapper = listener;
    }

    public synchronized void initRewardedVideo(Activity activity, String appKey, String userId) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, this.TAG + ":initRewardedVideo(appKey: " + appKey + ", userId: " + userId + ")", 1);
        long initStartTime = new Date().getTime();
        this.logMediationEvent(81312);
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mActivity = activity;
        this.mDailyCappingManager.setContext((Context)this.mActivity);
        int dailyCappedCount = 0;
        for (AbstractSmash smash : this.mSmashArray) {
            if (this.mDailyCappingManager.shouldSendCapReleasedEvent(smash)) {
                this.logProviderEvent(150, smash, new Object[][]{{"status", "false"}});
            }
            if (!this.mDailyCappingManager.isCapped(smash)) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
            ++dailyCappedCount;
        }
        if (dailyCappedCount == this.mSmashArray.size()) {
            this.mListenersWrapper.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        this.logMediationEvent(1000);
        this.mListenersWrapper.setRvPlacement(null);
        this.mShouldSendMediationLoadSuccessEvent = true;
        this.mLoadStartTime = new Date().getTime();
        long elapsedTime = new Date().getTime() - initStartTime;
        this.logMediationEvent(81313, new Object[][]{{"duration", elapsedTime}});
        this.prepareSDK5();
        for (int i = 0; i < this.mSmartLoadAmount && i < this.mSmashArray.size() && this.loadNextAdapter() != null; ++i) {
        }
    }

    public synchronized void showRewardedVideo(String placementName) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, this.TAG + ":showRewardedVideo(placementName: " + placementName + ")", 1);
        this.mListenersWrapper.setRvPlacement(placementName);
        this.logMediationEvent(1100, new Object[][]{{"placement", placementName}});
        if (this.mIsCurrentlyShowing) {
            String message = "showRewardedVideo error: can't show ad while an ad is already showing";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            IronSourceError error = new IronSourceError(1022, message);
            this.logMediationEvent(1113, new Object[][]{{"placement", placementName}, {"errorCode", 1022}, {"reason", message}});
            this.mListenersWrapper.onInterstitialAdShowFailed(error);
            return;
        }
        if (this.mShouldTrackNetworkState && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            String message = "showRewardedVideo error: can't show ad when there's no internet connection";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            this.logMediationEvent(1113, new Object[][]{{"placement", placementName}, {"errorCode", 520}, {"reason", message}});
            this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoInternetConnectionShowFailError("Rewarded Video"));
            return;
        }
        int capped = 0;
        int notAvailable = 0;
        for (int i = 0; i < this.mSmashArray.size(); ++i) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i);
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "showRewardedVideo, iterating on: " + smash.getInstanceName() + ", Status: " + (Object)((Object)smash.getMediationState()), 0);
            if (smash.getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE) {
                if (((RewardedVideoSmash)smash).isRewardedVideoAvailable()) {
                    this.showAdapter(smash, i);
                    if (this.mCanShowPremium && !smash.equals(this.getPremiumSmash())) {
                        this.disablePremiumForCurrentSession();
                    }
                    if (smash.isCappedPerSession()) {
                        smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION);
                        this.logProviderEvent(1401, smash, null);
                        this.completeAdapterCap();
                    } else if (this.mDailyCappingManager.isCapped(smash)) {
                        smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
                        this.logProviderEvent(150, smash, new Object[][]{{"status", "true"}});
                        this.completeAdapterCap();
                    } else if (smash.isExhausted()) {
                        this.loadNextAdapter();
                        this.completeIterationRound();
                    }
                    return;
                }
                this.onRewardedVideoAvailabilityChanged(false, (RewardedVideoSmash)smash);
                Exception e2 = new Exception("FailedToShowVideoException");
                this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.INTERNAL, smash.getInstanceName() + " Failed to show video", e2);
                continue;
            }
            if (smash.getMediationState() == AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION || smash.getMediationState() == AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY) {
                ++capped;
                continue;
            }
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            ++notAvailable;
        }
        if (this.isBackFillAvailable()) {
            this.showAdapter(this.getBackfillSmash(), this.mSmashArray.size());
        } else if (capped + notAvailable == this.mSmashArray.size()) {
            this.mListenersWrapper.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Rewarded Video"));
        }
    }

    public synchronized boolean isRewardedVideoAvailable() {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, this.TAG + ":isRewardedVideoAvailable()", 1);
        if (this.mShouldTrackNetworkState && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            return false;
        }
        for (AbstractSmash smash : this.mSmashArray) {
            if (!smash.isMediationAvailable() || !((RewardedVideoSmash)smash).isRewardedVideoAvailable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error, RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdShowFailed(" + error + ")", 1);
        this.mIsCurrentlyShowing = false;
        this.logProviderEvent(1202, smash, new Object[][]{{"placement", this.getCurrentPlacementName()}, {"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        this.sendMediationLoadEvents();
        this.mListenersWrapper.onRewardedVideoAdShowFailed(error);
    }

    @Override
    public void onRewardedVideoAdOpened(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdOpened()", 1);
        this.logProviderEvent(1005, smash, new Object[][]{{"placement", this.getCurrentPlacementName()}});
        this.mListenersWrapper.onRewardedVideoAdOpened();
    }

    @Override
    public void onRewardedVideoAdClosed(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdClosed()", 1);
        this.mIsCurrentlyShowing = false;
        boolean hasOtherAvailableAds = false;
        try {
            for (AbstractSmash aSmash : this.mSmashArray) {
                if (!((RewardedVideoSmash)aSmash).isRewardedVideoAvailable()) continue;
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, aSmash.getInstanceName() + " has available RV", 0);
                hasOtherAvailableAds = true;
                break;
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Failed to check RV availability", 0);
        }
        this.logProviderEvent(1203, smash, new Object[][]{{"placement", this.getCurrentPlacementName()}, {"ext1", "otherRVAvailable = " + (hasOtherAvailableAds ? "true" : "false")}});
        if (!smash.isCappedPerSession() && !this.mDailyCappingManager.isCapped(smash)) {
            this.logProviderEvent(1001, smash, null);
        }
        this.sendMediationLoadEvents();
        this.mListenersWrapper.onRewardedVideoAdClosed();
        for (AbstractSmash aSmash : this.mSmashArray) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Fetch on ad closed, iterating on: " + aSmash.getInstanceName() + ", Status: " + (Object)((Object)aSmash.getMediationState()), 0);
            if (aSmash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            try {
                if (aSmash.getInstanceName().equals(smash.getInstanceName())) continue;
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, aSmash.getInstanceName() + ":reload smash", 1);
                ((RewardedVideoSmash)aSmash).fetchRewardedVideo();
                this.logProviderEvent(1001, aSmash, null);
            }
            catch (Throwable t) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, aSmash.getInstanceName() + " Failed to call fetchVideo(), " + t.getLocalizedMessage(), 1);
            }
        }
    }

    @Override
    public synchronized void onRewardedVideoAvailabilityChanged(boolean available, RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ": onRewardedVideoAvailabilityChanged(available:" + available + ")", 1);
        if (this.mPauseSmartLoadDueToNetworkUnavailability) {
            return;
        }
        if (available && this.mShouldSendMediationLoadSuccessEvent) {
            this.mShouldSendMediationLoadSuccessEvent = false;
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.logMediationEvent(1003, new Object[][]{{"duration", elapsedTime}});
        }
        try {
            if (smash.equals(this.getBackfillSmash())) {
                if (this.shouldNotifyAvailabilityChanged(available)) {
                    this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
                }
                return;
            }
            if (smash.equals(this.getPremiumSmash())) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + " is a premium adapter, canShowPremium: " + this.canShowPremium(), 1);
                if (!this.canShowPremium()) {
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION);
                    if (this.shouldNotifyAvailabilityChanged(false)) {
                        this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
                    }
                    return;
                }
            }
            if (smash.isMediationAvailable() && !this.mDailyCappingManager.isCapped(smash)) {
                if (available) {
                    if (this.shouldNotifyAvailabilityChanged(true)) {
                        this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
                    }
                } else {
                    if (this.shouldNotifyAvailabilityChanged(false)) {
                        this.notifyAvailabilityChange();
                    }
                    this.loadNextAdapter();
                    this.completeIterationRound();
                }
            }
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onRewardedVideoAvailabilityChanged(available:" + available + ", provider:" + smash.getName() + ")", e2);
        }
    }

    @Override
    public void onRewardedVideoAdStarted(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdStarted()", 1);
        this.logProviderEvent(1204, smash, new Object[][]{{"placement", this.getCurrentPlacementName()}});
        this.mListenersWrapper.onRewardedVideoAdStarted();
    }

    @Override
    public void onRewardedVideoAdEnded(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdEnded()", 1);
        this.logProviderEvent(1205, smash, new Object[][]{{"placement", this.getCurrentPlacementName()}});
        this.mListenersWrapper.onRewardedVideoAdEnded();
    }

    @Override
    public void onRewardedVideoAdRewarded(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdRewarded()", 1);
        if (this.mCurrentPlacement == null) {
            this.mCurrentPlacement = IronSourceObject.getInstance().getCurrentServerResponse().getConfigurations().getRewardedVideoConfigurations().getDefaultRewardedVideoPlacement();
        }
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            if (this.mCurrentPlacement != null) {
                data.put("placement", (Object)this.getCurrentPlacementName());
                data.put("rewardName", (Object)this.mCurrentPlacement.getRewardName());
                data.put("rewardAmount", this.mCurrentPlacement.getRewardAmount());
            } else {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "mCurrentPlacement is null", 3);
            }
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        EventData event = new EventData(1010, data);
        if (!TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            Map<String, String> rvServerParams;
            String strToTransId = "" + Long.toString(event.getTimeStamp()) + this.mAppKey + smash.getName();
            String transId = IronSourceUtils.getTransId(strToTransId);
            event.addToAdditionalData("transId", transId);
            if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
                event.addToAdditionalData("dynamicUserId", IronSourceObject.getInstance().getDynamicUserId());
            }
            if ((rvServerParams = IronSourceObject.getInstance().getRvServerParams()) != null) {
                for (String key : rvServerParams.keySet()) {
                    event.addToAdditionalData("custom_" + key, rvServerParams.get(key));
                }
            }
        }
        RewardedVideoEventsManager.getInstance().log(event);
        if (this.mCurrentPlacement != null) {
            this.mListenersWrapper.onRewardedVideoAdRewarded(this.mCurrentPlacement);
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "mCurrentPlacement is null", 3);
        }
    }

    @Override
    public void onRewardedVideoAdClicked(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdClicked()", 1);
        if (this.mCurrentPlacement == null) {
            this.mCurrentPlacement = IronSourceObject.getInstance().getCurrentServerResponse().getConfigurations().getRewardedVideoConfigurations().getDefaultRewardedVideoPlacement();
        }
        if (this.mCurrentPlacement == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "mCurrentPlacement is null", 3);
            return;
        }
        this.logProviderEvent(1006, smash, new Object[][]{{"placement", this.getCurrentPlacementName()}});
        this.mListenersWrapper.onRewardedVideoAdClicked(this.mCurrentPlacement);
    }

    @Override
    public void onRewardedVideoAdVisible(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onRewardedVideoAdVisible()", 1);
        if (this.mCurrentPlacement != null) {
            this.logProviderEvent(1206, smash, new Object[][]{{"placement", this.getCurrentPlacementName()}});
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "mCurrentPlacement is null", 3);
        }
    }

    @Override
    public void onNetworkAvailabilityChanged(boolean connected) {
        if (this.mShouldTrackNetworkState) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Network Availability Changed To: " + connected, 0);
            if (this.shouldNotifyNetworkAvailabilityChanged(connected)) {
                this.mPauseSmartLoadDueToNetworkUnavailability = !connected;
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(connected);
            }
        }
    }

    @Override
    void shouldTrackNetworkState(Context context, boolean track) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, this.TAG + " Should Track Network State: " + track, 0);
        this.mShouldTrackNetworkState = track;
        if (this.mShouldTrackNetworkState) {
            if (this.mNetworkStateReceiver == null) {
                this.mNetworkStateReceiver = new NetworkStateReceiver(context, this);
            }
            context.getApplicationContext().registerReceiver((BroadcastReceiver)this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        } else if (this.mNetworkStateReceiver != null) {
            context.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mNetworkStateReceiver);
        }
    }

    private boolean shouldNotifyNetworkAvailabilityChanged(boolean networkState) {
        boolean shouldNotify = false;
        if (this.mLastMediationAvailabilityState == null) {
            return false;
        }
        if (networkState && !this.mLastMediationAvailabilityState.booleanValue() && this.hasAvailableSmash()) {
            this.mLastMediationAvailabilityState = true;
            shouldNotify = true;
        } else if (!networkState && this.mLastMediationAvailabilityState.booleanValue()) {
            this.mLastMediationAvailabilityState = false;
            shouldNotify = true;
        }
        return shouldNotify;
    }

    void setIsUltraEventsEnabled(boolean enabled) {
        this.mIsUltraEventsEnabled = enabled;
    }

    private void reportFalseImpressionsOnHigherPriority(int priority, int placementId) {
        for (int i = 0; i < priority && i < this.mSmashArray.size(); ++i) {
            if (this.mStatesToIgnore.contains((Object)((AbstractSmash)this.mSmashArray.get(i)).getMediationState())) continue;
            this.reportImpression(((RewardedVideoSmash)this.mSmashArray.get(i)).getRequestUrl(), false, placementId);
        }
    }

    private synchronized void reportImpression(String adapterUrl, boolean hit, int placementId) {
        String url = "";
        try {
            url = url + adapterUrl;
            url = url + "&sdkVersion=" + IronSourceUtils.getSDKVersion();
            Server.callAsyncRequestURL(url, hit, placementId);
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.NETWORK, "reportImpression:(providerURL:" + url + ", hit:" + hit + ")", e2);
        }
    }

    void setCurrentPlacement(Placement currentPlacement) {
        this.mCurrentPlacement = currentPlacement;
        this.mListenersWrapper.setRvPlacement(currentPlacement.getPlacementName());
    }

    @Override
    protected synchronized void disablePremiumForCurrentSession() {
        super.disablePremiumForCurrentSession();
        for (AbstractSmash smash : this.mSmashArray) {
            if (!smash.equals(this.getPremiumSmash())) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION);
            this.loadNextAdapter();
            break;
        }
    }

    private synchronized AbstractAdapter startAdapter(RewardedVideoSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":startAdapter(" + smash.getInstanceName() + ")", 1);
        AbstractAdapter providerAdapter = AdapterRepository.getInstance().getAdapter(smash.mAdapterConfigs, smash.mAdapterConfigs.getRewardedVideoSettings(), this.mActivity);
        if (providerAdapter == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, smash.getInstanceName() + " is configured in IronSource's platform, but the adapter is not integrated", 2);
            return null;
        }
        smash.setAdapterForSmash(providerAdapter);
        smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        this.setCustomParams(smash);
        this.logProviderEvent(1001, smash, null);
        try {
            smash.initRewardedVideo(this.mActivity, this.mAppKey, this.mUserId);
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + "failed to init adapter: " + smash.getName() + "v", e2);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            return null;
        }
        return providerAdapter;
    }

    private AbstractAdapter loadNextAdapter() {
        AbstractAdapter initiatedAdapter = null;
        int activeAdapters = 0;
        for (int i = 0; i < this.mSmashArray.size() && initiatedAdapter == null; ++i) {
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || ((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.INITIATED) {
                if (++activeAdapters < this.mSmartLoadAmount) continue;
                break;
            }
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED || (initiatedAdapter = this.startAdapter((RewardedVideoSmash)this.mSmashArray.get(i))) != null) continue;
            ((AbstractSmash)this.mSmashArray.get(i)).setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
        }
        return initiatedAdapter;
    }

    private synchronized void showAdapter(AbstractSmash smash, int index) {
        Object[][] objectArray;
        CappingManager.incrementShowCounter((Context)this.mActivity, this.mCurrentPlacement);
        if (CappingManager.isRvPlacementCapped((Context)this.mActivity, this.getCurrentPlacementName())) {
            this.logMediationEvent(1400, new Object[][]{{"placement", this.getCurrentPlacementName()}});
        }
        this.mDailyCappingManager.increaseShowCounter(smash);
        if (this.mCurrentPlacement != null) {
            if (this.mIsUltraEventsEnabled) {
                this.reportImpression(((RewardedVideoSmash)smash).getRequestUrl(), true, this.mCurrentPlacement.getPlacementId());
                this.reportFalseImpressionsOnHigherPriority(index, this.mCurrentPlacement.getPlacementId());
            }
            this.sendShowChanceEvents(smash, index, this.getCurrentPlacementName());
        } else {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "mCurrentPlacement is null", 3);
        }
        if (this.mCurrentPlacement != null) {
            Object[][] objectArrayArray = new Object[1][];
            objectArray = objectArrayArray;
            objectArrayArray[0] = new Object[]{"placement", this.getCurrentPlacementName()};
        } else {
            objectArray = null;
        }
        this.logProviderEvent(1201, smash, objectArray);
        this.mIsCurrentlyShowing = true;
        ((RewardedVideoSmash)smash).showRewardedVideo();
    }

    void setManualLoadInterval(int manualLoadInterval) {
        this.mManualLoadInterval = manualLoadInterval;
    }

    private void scheduleFetchTimer() {
        if (this.mManualLoadInterval <= 0) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "load interval is not set, ignoring", 1);
            return;
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                this.cancel();
                RewardedVideoManager.this.loadRewardedVideo();
                RewardedVideoManager.this.scheduleFetchTimer();
            }
        }, this.mManualLoadInterval * 1000);
    }

    private synchronized void loadRewardedVideo() {
        if (!IronSourceUtils.isNetworkConnected((Context)this.mActivity) || this.mLastMediationAvailabilityState == null) {
            return;
        }
        if (!this.mLastMediationAvailabilityState.booleanValue()) {
            this.logMediationEvent(102);
            this.logMediationEvent(1000);
            this.mShouldSendMediationLoadSuccessEvent = true;
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
                try {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Fetch from timer: " + smash.getInstanceName() + ":reload smash", 1);
                    this.logProviderEvent(1001, smash, null);
                    ((RewardedVideoSmash)smash).fetchRewardedVideo();
                }
                catch (Throwable t) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, smash.getInstanceName() + " Failed to call fetchVideo(), " + t.getLocalizedMessage(), 1);
                }
            }
        }
    }

    private synchronized boolean shouldNotifyAvailabilityChanged(boolean adapterAvailability) {
        boolean shouldNotify = false;
        if (this.mLastMediationAvailabilityState == null) {
            this.scheduleFetchTimer();
            if (adapterAvailability) {
                this.mLastMediationAvailabilityState = true;
                shouldNotify = true;
            } else if (!this.isBackFillAvailable() && this.isAllAdaptersInactive()) {
                this.mLastMediationAvailabilityState = false;
                shouldNotify = true;
            }
        } else if (adapterAvailability && !this.mLastMediationAvailabilityState.booleanValue()) {
            this.mLastMediationAvailabilityState = true;
            shouldNotify = true;
        } else if (!adapterAvailability && this.mLastMediationAvailabilityState.booleanValue() && !this.hasAvailableSmash() && !this.isBackFillAvailable()) {
            this.mLastMediationAvailabilityState = false;
            shouldNotify = true;
        }
        return shouldNotify;
    }

    private synchronized boolean isAllAdaptersInactive() {
        int countInactive = 0;
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INIT_FAILED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.EXHAUSTED) continue;
            ++countInactive;
        }
        return this.mSmashArray.size() == countInactive;
    }

    private synchronized boolean isAvailableAdaptersToLoad() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INIT_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean hasAvailableSmash() {
        boolean hasAvailableSmash = false;
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            hasAvailableSmash = true;
            break;
        }
        return hasAvailableSmash;
    }

    private synchronized boolean isBackFillAvailable() {
        if (this.getBackfillSmash() != null) {
            return ((RewardedVideoSmash)this.getBackfillSmash()).isRewardedVideoAvailable();
        }
        return false;
    }

    private void sendShowChanceEvents(AbstractSmash selectedSmash, int priority, String placementName) {
        this.logProviderEvent(1209, selectedSmash, new Object[][]{{"placement", placementName}, {"status", "true"}});
        for (int i = 0; i < this.mSmashArray.size() && i < priority; ++i) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i);
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            this.logProviderEvent(1209, smash, new Object[][]{{"placement", placementName}, {"status", "false"}});
        }
    }

    private synchronized void notifyAvailabilityChange() {
        if (this.getBackfillSmash() != null && !this.mBackFillInitStarted) {
            this.mBackFillInitStarted = true;
            AbstractAdapter backfillAdapter = this.startAdapter((RewardedVideoSmash)this.getBackfillSmash());
            if (backfillAdapter == null) {
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
            }
        } else if (this.isBackFillAvailable()) {
            if (this.shouldNotifyAvailabilityChanged(true)) {
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
            }
        } else {
            this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
        }
    }

    private synchronized void completeAdapterCap() {
        if (this.loadNextAdapter() != null) {
            return;
        }
        int cappedOrNotAvailable = this.smashesCount(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE, AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
        if (cappedOrNotAvailable < this.mSmashArray.size()) {
            this.completeIterationRound();
            return;
        }
        if (this.shouldNotifyAvailabilityChanged(false)) {
            this.notifyAvailabilityChange();
        }
    }

    private synchronized void completeIterationRound() {
        if (this.isIterationRoundComplete()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Reset Iteration", 0);
            boolean isAvailable = false;
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() == AbstractSmash.MEDIATION_STATE.EXHAUSTED) {
                    smash.completeIteration();
                }
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
                isAvailable = true;
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "End of Reset Iteration", 0);
            if (this.shouldNotifyAvailabilityChanged(isAvailable)) {
                this.mListenersWrapper.onRewardedVideoAvailabilityChanged(this.mLastMediationAvailabilityState);
            }
        }
    }

    private synchronized boolean isIterationRoundComplete() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            return false;
        }
        return true;
    }

    private void logMediationEvent(int eventId) {
        this.logMediationEvent(eventId, null);
    }

    private void logMediationEvent(int eventId, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "RewardedVideoManager logMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private void logProviderEvent(int eventId, AbstractSmash smash, Object[][] keyVals) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "RewardedVideoManager logProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private int smashesCount(AbstractSmash.MEDIATION_STATE ... states) {
        int ret = 0;
        for (AbstractSmash smash : this.mSmashArray) {
            for (AbstractSmash.MEDIATION_STATE state : states) {
                if (smash.getMediationState() != state) continue;
                ++ret;
            }
        }
        return ret;
    }

    private void sendMediationLoadEvents() {
        if (this.isRewardedVideoAvailable()) {
            this.logMediationEvent(1000);
            this.logMediationEvent(1003, new Object[][]{{"duration", 0}});
            this.mShouldSendMediationLoadSuccessEvent = false;
            return;
        }
        if (this.isAvailableAdaptersToLoad()) {
            this.logMediationEvent(1000);
            this.mShouldSendMediationLoadSuccessEvent = true;
            this.mLoadStartTime = new Date().getTime();
        }
    }

    @Override
    public void onDailyCapReleased() {
        boolean atLeastOneSmashBecameAvailable = false;
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY) continue;
            this.logProviderEvent(150, smash, new Object[][]{{"status", "false"}});
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
            if (!((RewardedVideoSmash)smash).isRewardedVideoAvailable() || !smash.isMediationAvailable()) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.AVAILABLE);
            atLeastOneSmashBecameAvailable = true;
        }
        if (atLeastOneSmashBecameAvailable && this.shouldNotifyAvailabilityChanged(true)) {
            this.mListenersWrapper.onRewardedVideoAvailabilityChanged(true);
        }
    }

    private void prepareSDK5() {
        for (int i = 0; i < this.mSmashArray.size(); ++i) {
            String reflectionName = ((AbstractSmash)this.mSmashArray.get((int)i)).mAdapterConfigs.getProviderTypeForReflection();
            if (!reflectionName.equalsIgnoreCase("IronSource") && !reflectionName.equalsIgnoreCase("SupersonicAds")) continue;
            AdapterRepository.getInstance().getAdapter(((AbstractSmash)this.mSmashArray.get((int)i)).mAdapterConfigs, ((AbstractSmash)this.mSmashArray.get((int)i)).mAdapterConfigs.getRewardedVideoSettings(), this.mActivity);
            break;
        }
    }

    private String getCurrentPlacementName() {
        if (this.mCurrentPlacement == null) {
            return "";
        }
        return this.mCurrentPlacement.getPlacementName();
    }
}

