/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class ProgRvSmash
extends ProgSmash
implements RewardedVideoSmashListener {
    private SMASH_STATE mState;
    private ProgRvManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private Activity mActivity;
    private String mAppKey;
    private String mUserId;
    private String mAuctionServerDataToLoad;
    private boolean mShouldLoadAfterClose;
    private boolean mShouldLoadAfterLoad;
    private boolean mIsShowCandidate;
    private Placement mCurrentPlacement;
    private int mSessionDepth;
    private long mLoadStartTime;
    private String mCurrentAuctionId;
    private String mAuctionIdToLoad;
    private int mAuctionTrial;
    private String mAuctionFallback;
    private int mAuctionTrialToLoad;
    private int mSessionDepthToLoad;
    private String mAuctionFallbackToLoad;
    private final Object mTimerLock = new Object();
    private final Object mStateLock = new Object();
    private static final int errorCode_biddingDataException = 5001;
    private static final int errorCode_isReadyException = 5002;
    private static final int errorCode_loadInProgress = 5003;
    private static final int errorCode_showInProgress = 5004;
    private static final int errorCode_loadException = 5005;
    private static final int errorCode_showFailed = 5006;
    private static final int errorCode_initSuccess = 5007;
    private static final int errorCode_initFailed = 5008;
    private static final int errorCode_adClosed = 5009;

    public ProgRvSmash(Activity activity, String appKey, String userId, ProviderSettings settings, ProgRvManagerListener listener, int loadTimeoutSecs, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getRewardedVideoSettings()), adapter);
        this.mState = SMASH_STATE.NO_INIT;
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeoutSecs;
        this.mAdapter.addRewardedVideoListener(this);
        this.mShouldLoadAfterClose = false;
        this.mShouldLoadAfterLoad = false;
        this.mIsShowCandidate = false;
        this.mCurrentPlacement = null;
        this.mCurrentAuctionId = "";
        this.mSessionDepth = 1;
        this.resetAuctionParams();
    }

    private void resetAuctionParams() {
        this.mAuctionIdToLoad = "";
        this.mAuctionTrialToLoad = -1;
        this.mAuctionFallbackToLoad = "";
        this.mAuctionServerDataToLoad = "";
        this.mSessionDepthToLoad = this.mSessionDepth;
    }

    public boolean isLoadingInProgress() {
        return this.mState == SMASH_STATE.INIT_IN_PROGRESS || this.mState == SMASH_STATE.LOAD_IN_PROGRESS;
    }

    public Map<String, Object> getBiddingData() {
        try {
            return this.isBidder() ? this.mAdapter.getRvBiddingData(this.mAdUnitSettings) : null;
        }
        catch (Throwable t) {
            this.logInternalError("getBiddingData exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5001}, {"reason", t.getLocalizedMessage()}});
            return null;
        }
    }

    public void initForBidding() {
        this.logInternal("initForBidding()");
        this.setState(SMASH_STATE.INIT_IN_PROGRESS);
        this.setCustomParams();
        try {
            this.mAdapter.initRvForBidding(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError("initForBidding exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.onRewardedVideoInitFailed(new IronSourceError(1040, t.getLocalizedMessage()));
        }
    }

    public void unloadVideo() {
        if (this.isBidder()) {
            this.mIsShowCandidate = false;
        }
    }

    public boolean isRewardedVideoAvailable() {
        return this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
    }

    public boolean isReadyToShow() {
        try {
            if (this.isBidder()) {
                return this.mIsShowCandidate && this.mState == SMASH_STATE.LOADED && this.isRewardedVideoAvailable();
            }
            return this.isRewardedVideoAvailable();
        }
        catch (Throwable t) {
            this.logInternalError("isReadyToShow exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5002}, {"reason", t.getLocalizedMessage()}});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVideo(String serverData, String auctionId, int auctionTrial, String auctionFallback, int sessionDepth) {
        SMASH_STATE currentState;
        this.logInternal("loadVideo() auctionId: " + auctionId + " state: " + (Object)((Object)this.mState));
        this.setIsLoadCandidate(false);
        this.mIsShowCandidate = true;
        Object object = this.mStateLock;
        synchronized (object) {
            currentState = this.mState;
            if (this.mState != SMASH_STATE.LOAD_IN_PROGRESS && this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
            }
        }
        if (currentState == SMASH_STATE.LOAD_IN_PROGRESS) {
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5003}, {"reason", "load during load"}});
            this.mShouldLoadAfterLoad = true;
            this.updateFutureAuctionData(serverData, auctionId, auctionTrial, auctionFallback, sessionDepth);
            this.mListener.onLoadError(this, auctionId);
            return;
        }
        if (currentState == SMASH_STATE.SHOW_IN_PROGRESS) {
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5004}, {"reason", "load during show"}});
            this.mShouldLoadAfterClose = true;
            this.updateFutureAuctionData(serverData, auctionId, auctionTrial, auctionFallback, sessionDepth);
            return;
        }
        this.mCurrentAuctionId = auctionId;
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFallback = auctionFallback;
        this.mSessionDepth = sessionDepth;
        this.startLoadTimer();
        this.mLoadStartTime = new Date().getTime();
        this.sendProviderEvent(1001);
        try {
            if (this.isBidder()) {
                this.mAdapter.loadVideo(this.mAdUnitSettings, this, serverData);
                return;
            }
            if (currentState == SMASH_STATE.NO_INIT) {
                this.setCustomParams();
                this.mAdapter.initRewardedVideo(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
                return;
            }
            this.mAdapter.fetchRewardedVideo(this.mAdUnitSettings);
        }
        catch (Throwable t) {
            this.logInternalError("loadVideo exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5005}, {"reason", t.getLocalizedMessage()}});
        }
    }

    public void reportShowChance(boolean status, int sessionDepth) {
        this.mSessionDepth = sessionDepth;
        this.sendProviderEventWithPlacement(1209, new Object[][]{{"status", status ? "true" : "false"}});
    }

    public void showVideo(Placement placement, int sessionDepth) {
        this.stopLoadTimer();
        this.logInternal("showVideo()");
        this.mCurrentPlacement = placement;
        this.mSessionDepth = sessionDepth;
        this.setState(SMASH_STATE.SHOW_IN_PROGRESS);
        this.sendProviderEventWithPlacement(1201);
        try {
            this.mAdapter.showRewardedVideo(this.mAdUnitSettings, this);
        }
        catch (Throwable t) {
            this.logInternalError("showVideo exception: " + t.getLocalizedMessage());
            t.printStackTrace();
            this.onRewardedVideoAdShowFailed(new IronSourceError(1038, t.getLocalizedMessage()));
        }
    }

    public void setCappedPerSession() {
        this.mAdapter.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, "rewardedvideo");
        this.sendProviderEvent(1401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(SMASH_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = state;
        }
    }

    private void setCustomParams() {
        try {
            String pluginType;
            String segment = IronSourceObject.getInstance().getMediationSegment();
            if (!TextUtils.isEmpty((CharSequence)segment)) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
        }
        catch (Exception e2) {
            this.logInternal("setCustomParams() " + e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
        this.stopLoadTimer();
        this.logAdapterCallback("onRewardedVideoAvailabilityChanged available=" + available + " state=" + this.mState.name());
        boolean isWrongSmashState = false;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == SMASH_STATE.LOAD_IN_PROGRESS) {
                this.setState(available ? SMASH_STATE.LOADED : SMASH_STATE.NOT_LOADED);
            } else {
                isWrongSmashState = true;
            }
        }
        if (isWrongSmashState) {
            if (available) {
                this.sendProviderEvent(1207, new Object[][]{{"ext1", this.mState.name()}});
            } else {
                this.sendProviderEvent(1208, new Object[][]{{"errorCode", 1034}, {"duration", this.getElapsedTime()}, {"ext1", this.mState.name()}});
            }
            return;
        }
        this.sendProviderEvent(available ? 1002 : 1200, new Object[][]{{"duration", this.getElapsedTime()}});
        if (this.mShouldLoadAfterLoad) {
            this.mShouldLoadAfterLoad = false;
            this.logInternal("onRewardedVideoAvailabilityChanged to " + available + "and mShouldLoadAfterLoad is true - calling loadVideo");
            this.loadVideo(this.mAuctionServerDataToLoad, this.mAuctionIdToLoad, this.mAuctionTrialToLoad, this.mAuctionFallbackToLoad, this.mSessionDepthToLoad);
            this.resetAuctionParams();
            return;
        }
        if (available) {
            this.mListener.onLoadSuccess(this, this.mCurrentAuctionId);
        } else {
            this.mListener.onLoadError(this, this.mCurrentAuctionId);
        }
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
        this.sendProviderEvent(1212, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", this.getElapsedTime()}});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
        this.sendProviderEventWithPlacement(1202, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5006}, {"reason", "showFailed: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.NOT_LOADED);
        }
        this.mListener.onRewardedVideoAdShowFailed(error, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitSuccess() {
        this.logAdapterCallback("onRewardedVideoInitSuccess");
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5007}, {"reason", "initSuccess: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.NOT_LOADED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoInitFailed error=" + error.getErrorMessage());
        this.stopLoadTimer();
        this.sendProviderEvent(1200, new Object[][]{{"errorCode", 1033}, {"duration", this.getElapsedTime()}});
        this.sendProviderEvent(1212, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", this.getElapsedTime()}});
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5008}, {"reason", "initFailed: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.NO_INIT);
        }
        this.mListener.onLoadError(this, this.mCurrentAuctionId);
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.logAdapterCallback("onRewardedVideoAdOpened");
        this.mListener.onRewardedVideoAdOpened(this);
        this.sendProviderEventWithPlacement(1005);
    }

    @Override
    public void onRewardedVideoAdStarted() {
        this.logAdapterCallback("onRewardedVideoAdStarted");
        this.mListener.onRewardedVideoAdStarted(this);
        this.sendProviderEventWithPlacement(1204);
    }

    @Override
    public void onRewardedVideoAdVisible() {
        this.logAdapterCallback("onRewardedVideoAdVisible");
        this.sendProviderEventWithPlacement(1206);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed() {
        this.logAdapterCallback("onRewardedVideoAdClosed");
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                this.sendProviderEventWithPlacement(1203);
                this.sendProviderEvent(81316, new Object[][]{{"errorCode", 5009}, {"reason", "adClosed: " + (Object)((Object)this.mState)}});
                return;
            }
            this.setState(SMASH_STATE.NOT_LOADED);
        }
        this.mListener.onRewardedVideoAdClosed(this);
        if (this.mShouldLoadAfterClose) {
            this.logInternal("onRewardedVideoAdClosed and mShouldLoadAfterClose is true - calling loadVideo");
            this.mShouldLoadAfterClose = false;
            this.loadVideo(this.mAuctionServerDataToLoad, this.mAuctionIdToLoad, this.mAuctionTrialToLoad, this.mAuctionFallbackToLoad, this.mSessionDepthToLoad);
            this.resetAuctionParams();
        }
    }

    @Override
    public void onRewardedVideoAdEnded() {
        this.logAdapterCallback("onRewardedVideoAdEnded");
        this.mListener.onRewardedVideoAdEnded(this);
        this.sendProviderEventWithPlacement(1205);
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        this.logAdapterCallback("onRewardedVideoAdRewarded");
        this.mListener.onRewardedVideoAdRewarded(this, this.mCurrentPlacement);
        Map<String, Object> data = this.getProviderEventData();
        if (this.mCurrentPlacement != null) {
            data.put("placement", this.mCurrentPlacement.getPlacementName());
            data.put("rewardName", this.mCurrentPlacement.getRewardName());
            data.put("rewardAmount", this.mCurrentPlacement.getRewardAmount());
        }
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
            data.put("dynamicUserId", IronSourceObject.getInstance().getDynamicUserId());
        }
        if (IronSourceObject.getInstance().getRvServerParams() != null) {
            for (String key : IronSourceObject.getInstance().getRvServerParams().keySet()) {
                data.put("custom_" + key, IronSourceObject.getInstance().getRvServerParams().get(key));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (this.shouldAddAuctionParams(1010)) {
            RewardedVideoEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFallback);
        }
        data.put("sessionDepth", this.mSessionDepth);
        EventData event = new EventData(1010, new JSONObject(data));
        String strToTransId = "" + Long.toString(event.getTimeStamp()) + this.mAppKey + this.getInstanceName();
        String transId = IronSourceUtils.getTransId(strToTransId);
        event.addToAdditionalData("transId", transId);
        RewardedVideoEventsManager.getInstance().log(event);
    }

    @Override
    public void onRewardedVideoAdClicked() {
        this.logAdapterCallback("onRewardedVideoAdClicked");
        this.mListener.onRewardedVideoAdClicked(this, this.mCurrentPlacement);
        this.sendProviderEventWithPlacement(1006);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLoadTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
    }

    private long getElapsedTime() {
        return new Date().getTime() - this.mLoadStartTime;
    }

    private void updateFutureAuctionData(String serverData, String auctionId, int auctionTrial, String auctionFallback, int sessionDepth) {
        this.mAuctionIdToLoad = auctionId;
        this.mAuctionServerDataToLoad = serverData;
        this.mAuctionTrialToLoad = auctionTrial;
        this.mAuctionFallbackToLoad = auctionFallback;
        this.mSessionDepthToLoad = sessionDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            this.stopLoadTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean shouldInvokeCallback = false;
                    int errorCode = 510;
                    String errorMessage = "Rewarded Video - load instance time out";
                    Object object = ProgRvSmash.this.mStateLock;
                    synchronized (object) {
                        if (ProgRvSmash.this.mState == SMASH_STATE.LOAD_IN_PROGRESS || ProgRvSmash.this.mState == SMASH_STATE.INIT_IN_PROGRESS) {
                            if (ProgRvSmash.this.mState == SMASH_STATE.LOAD_IN_PROGRESS) {
                                errorCode = 1025;
                            } else {
                                errorCode = 1032;
                                errorMessage = "Rewarded Video - init instance time out";
                            }
                            ProgRvSmash.this.setState(SMASH_STATE.NOT_LOADED);
                            shouldInvokeCallback = true;
                        }
                    }
                    ProgRvSmash.this.logInternal(errorMessage);
                    if (shouldInvokeCallback) {
                        ProgRvSmash.this.sendProviderEvent(1200, new Object[][]{{"errorCode", errorCode}, {"duration", ProgRvSmash.this.getElapsedTime()}});
                        ProgRvSmash.this.sendProviderEvent(1212, new Object[][]{{"errorCode", errorCode}, {"reason", errorMessage}, {"duration", ProgRvSmash.this.getElapsedTime()}});
                        ProgRvSmash.this.mListener.onLoadError(ProgRvSmash.this, ProgRvSmash.this.mCurrentAuctionId);
                    } else {
                        ProgRvSmash.this.sendProviderEvent(1208, new Object[][]{{"errorCode", 1025}, {"duration", ProgRvSmash.this.getElapsedTime()}, {"ext1", ProgRvSmash.this.mState.name()}});
                    }
                }
            }, this.mLoadTimeoutSecs * 1000);
        }
    }

    private void logAdapterCallback(String line) {
        String text = "ProgRvSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "ProgRvSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void logInternalError(String line) {
        String text = "ProgRvSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 3);
    }

    private void sendProviderEventWithPlacement(int eventId) {
        this.sendProviderEventWithPlacement(eventId, null);
    }

    public void sendProviderEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, true);
    }

    private void sendProviderEvent(int eventId) {
        this.sendProviderEvent(eventId, null, false);
    }

    public void sendProviderEvent(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, false);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        Map<String, Object> data = this.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && this.mCurrentPlacement != null && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement.getPlacementName())) {
            data.put("placement", this.mCurrentPlacement.getPlacementName());
        }
        if (this.shouldAddAuctionParams(eventId)) {
            RewardedVideoEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFallback);
        }
        data.put("sessionDepth", this.mSessionDepth);
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getInstanceName() + " smash: RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 1001 || eventId == 1002 || eventId == 1200 || eventId == 1005 || eventId == 1203 || eventId == 1201 || eventId == 1202 || eventId == 1006 || eventId == 1010;
    }

    protected static enum SMASH_STATE {
        NO_INIT,
        INIT_IN_PROGRESS,
        NOT_LOADED,
        LOAD_IN_PROGRESS,
        LOADED,
        SHOW_IN_PROGRESS;

    }
}

