/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdUnitManager;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.CallbackThrottler;
import com.ironsource.mediationsdk.ISListenerWrapper;
import com.ironsource.mediationsdk.InterstitialSmash;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.MediationInitializer;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.model.InterstitialPlacement;
import com.ironsource.mediationsdk.sdk.InterstitialManagerListener;
import com.ironsource.mediationsdk.sdk.ListenersWrapper;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialApi;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialManagerListener;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.DailyCappingListener;
import com.ironsource.mediationsdk.utils.DailyCappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONObject;

class InterstitialManager
extends AbstractAdUnitManager
implements InterstitialManagerListener,
MediationInitializer.OnMediationInitializationListener,
RewardedInterstitialManagerListener,
RewardedInterstitialApi,
DailyCappingListener {
    private final String TAG = this.getClass().getName();
    private ListenersWrapper mInterstitialListenersWrapper;
    private RewardedInterstitialListener mRewardedInterstitialListenerWrapper;
    private boolean mDidCallLoadInterstitial = false;
    private boolean mIsLoadInterstitialInProgress = false;
    private boolean mDidFinishToInitInterstitial;
    private InterstitialPlacement mCurrentPlacement;
    private CallbackThrottler mCallbackThrottler;
    private boolean mShouldSendAdReadyEvent = false;
    private Map<String, InterstitialSmash> mInstanceIdToSmashMap;
    private CopyOnWriteArraySet<String> mInstancesToLoad = new CopyOnWriteArraySet();
    private long mLoadStartTime;
    private boolean mIsCurrentlyShowing;

    InterstitialManager() {
        this.mInstanceIdToSmashMap = new ConcurrentHashMap<String, InterstitialSmash>();
        this.mCallbackThrottler = CallbackThrottler.getInstance();
        this.mDailyCappingManager = new DailyCappingManager("interstitial", this);
        this.mIsCurrentlyShowing = false;
    }

    public void setInterstitialListener(ListenersWrapper listener) {
        this.mInterstitialListenersWrapper = listener;
        this.mCallbackThrottler.setInterstitialListener(listener);
    }

    @Override
    public void setRewardedInterstitialListener(RewardedInterstitialListener listener) {
        this.mRewardedInterstitialListenerWrapper = listener;
    }

    public synchronized void initInterstitial(Activity activity, String appKey, String userId) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":initInterstitial(appKey: " + appKey + ", userId: " + userId + ")", 1);
        long initStartTime = new Date().getTime();
        this.logMediationEvent(82312);
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mActivity = activity;
        this.mDailyCappingManager.setContext((Context)activity);
        int dailyCappedCount = 0;
        for (AbstractSmash smash : this.mSmashArray) {
            if (this.mDailyCappingManager.shouldSendCapReleasedEvent(smash)) {
                this.logProviderEvent(250, smash, new Object[][]{{"status", "false"}});
            }
            if (!this.mDailyCappingManager.isCapped(smash)) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
            ++dailyCappedCount;
        }
        if (dailyCappedCount == this.mSmashArray.size()) {
            this.mDidFinishToInitInterstitial = true;
        }
        this.prepareSDK5(activity);
        for (int i = 0; i < this.mSmartLoadAmount && this.startNextAdapter() != null; ++i) {
        }
        long elapsedTime = new Date().getTime() - initStartTime;
        this.logMediationEvent(82313, new Object[][]{{"duration", elapsedTime}});
    }

    public synchronized void loadInterstitial() {
        block13: {
            try {
                if (this.mIsCurrentlyShowing) {
                    String message = "loadInterstitial cannot be invoked while showing an ad";
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
                    IronSourceError error = new IronSourceError(1037, message);
                    ISListenerWrapper.getInstance().onInterstitialAdLoadFailed(error);
                    return;
                }
                this.mCurrentPlacement = null;
                this.mInterstitialListenersWrapper.setInterstitialPlacement(null);
                if (this.mIsLoadInterstitialInProgress || this.mCallbackThrottler.hasPendingInvocation()) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "Load Interstitial is already in progress", 3);
                    return;
                }
                MediationInitializer.EInitStatus initStatus = MediationInitializer.getInstance().getCurrentInitStatus();
                if (initStatus == MediationInitializer.EInitStatus.NOT_INIT) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() must be called before loadInterstitial()", 3);
                    return;
                }
                if (initStatus == MediationInitializer.EInitStatus.INIT_IN_PROGRESS) {
                    if (MediationInitializer.getInstance().isInProgressMoreThan15Secs()) {
                        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                        this.mCallbackThrottler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                    } else {
                        this.mLoadStartTime = new Date().getTime();
                        this.logMediationEvent(2001, null);
                        this.mDidCallLoadInterstitial = true;
                        this.mShouldSendAdReadyEvent = true;
                    }
                    return;
                }
                if (initStatus == MediationInitializer.EInitStatus.INIT_FAILED) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "init() had failed", 3);
                    this.mCallbackThrottler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
                    return;
                }
                if (this.mSmashArray.size() == 0) {
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, "the server response does not contain interstitial data", 3);
                    this.mCallbackThrottler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("the server response does not contain interstitial data", "Interstitial"));
                    return;
                }
                this.mLoadStartTime = new Date().getTime();
                this.logMediationEvent(2001, null);
                this.mShouldSendAdReadyEvent = true;
                this.changeStateToInitiated();
                if (this.smashesCount(AbstractSmash.MEDIATION_STATE.INITIATED) == 0) {
                    if (!this.mDidFinishToInitInterstitial) {
                        this.mDidCallLoadInterstitial = true;
                        return;
                    }
                    IronSourceError error = ErrorBuilder.buildGenericError("no ads to load");
                    this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.getErrorMessage(), 1);
                    this.mCallbackThrottler.onInterstitialAdLoadFailed(error);
                    this.logMediationEvent(2110, new Object[][]{{"errorCode", error.getErrorCode()}});
                    this.mShouldSendAdReadyEvent = false;
                    return;
                }
                this.mDidCallLoadInterstitial = true;
                this.mIsLoadInterstitialInProgress = true;
                int loading = 0;
                for (AbstractSmash smash : this.mSmashArray) {
                    if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
                    this.loadAdapterAndSendEvent((InterstitialSmash)smash);
                    if (++loading < this.mSmartLoadAmount) continue;
                    return;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitial exception " + e2.getMessage());
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, error.getErrorMessage(), 3);
                this.mCallbackThrottler.onInterstitialAdLoadFailed(error);
                if (!this.mShouldSendAdReadyEvent) break block13;
                this.mShouldSendAdReadyEvent = false;
                this.logMediationEvent(2110, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", e2.getMessage()}});
            }
        }
    }

    public void showInterstitial(String placementName) {
        if (this.mIsCurrentlyShowing) {
            String message = "showInterstitial error: can't show ad while an ad is already showing";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(new IronSourceError(1036, message));
            return;
        }
        if (!this.mDidCallLoadInterstitial) {
            String message = "showInterstitial failed - You need to load interstitial before showing it";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", message));
            return;
        }
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            String message = "showInterstitial error: can't show ad when there's no internet connection";
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, message, 3);
            this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildNoInternetConnectionShowFailError("Interstitial"));
            return;
        }
        for (int i = 0; i < this.mSmashArray.size(); ++i) {
            AbstractSmash smash = (AbstractSmash)this.mSmashArray.get(i);
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            CappingManager.incrementShowCounter((Context)this.mActivity, this.mCurrentPlacement);
            if (CappingManager.isPlacementCapped((Context)this.mActivity, this.mCurrentPlacement) != CappingManager.ECappingStatus.NOT_CAPPED) {
                this.logMediationEventWithPlacement(2400, null);
            }
            this.logProviderEventWithPlacement(2201, smash, null);
            this.mIsCurrentlyShowing = true;
            ((InterstitialSmash)smash).showInterstitial();
            if (smash.isCappedPerSession()) {
                this.logProviderEvent(2401, smash);
            }
            this.mDailyCappingManager.increaseShowCounter(smash);
            if (this.mDailyCappingManager.isCapped(smash)) {
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY);
                this.logProviderEvent(250, smash, new Object[][]{{"status", "true"}});
            }
            this.mDidCallLoadInterstitial = false;
            if (!smash.isMediationAvailable()) {
                this.startNextAdapter();
            }
            return;
        }
        this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError("Interstitial", "showInterstitial failed - No adapters ready to show"));
    }

    public synchronized boolean isInterstitialReady() {
        if (this.mShouldTrackNetworkState && this.mActivity != null && !IronSourceUtils.isNetworkConnected((Context)this.mActivity)) {
            return false;
        }
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE || !((InterstitialSmash)smash).isInterstitialReady()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void onInterstitialInitSuccess(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + " :onInterstitialInitSuccess()", 1);
        this.logProviderEvent(2205, smash);
        this.mDidFinishToInitInterstitial = true;
        if (this.mDidCallLoadInterstitial && this.smashesCount(AbstractSmash.MEDIATION_STATE.AVAILABLE, AbstractSmash.MEDIATION_STATE.LOAD_PENDING) < this.mSmartLoadAmount) {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
            this.loadAdapterAndSendEvent(smash);
        }
    }

    @Override
    public synchronized void onInterstitialInitFailed(IronSourceError error, InterstitialSmash smash) {
        try {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialInitFailed(" + error + ")", 1);
            this.logProviderEvent(2206, smash, new Object[][]{{"reason", error.getErrorMessage()}});
            if (this.smashesCount(AbstractSmash.MEDIATION_STATE.INIT_FAILED) >= this.mSmashArray.size()) {
                this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "Smart Loading - initialization failed - no adapters are initiated and no more left to init, error: " + error.getErrorMessage(), 2);
                if (this.mDidCallLoadInterstitial) {
                    this.mCallbackThrottler.onInterstitialAdLoadFailed(ErrorBuilder.buildGenericError("no ads to show"));
                    this.logMediationEvent(2110, new Object[][]{{"errorCode", 510}});
                    this.mShouldSendAdReadyEvent = false;
                }
                this.mDidFinishToInitInterstitial = true;
            } else {
                if (this.startNextAdapter() == null && this.mDidCallLoadInterstitial && this.smashesCount(AbstractSmash.MEDIATION_STATE.INIT_FAILED, AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE, AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY, AbstractSmash.MEDIATION_STATE.EXHAUSTED) >= this.mSmashArray.size()) {
                    this.mCallbackThrottler.onInterstitialAdLoadFailed(new IronSourceError(509, "No ads to show"));
                    this.logMediationEvent(2110, new Object[][]{{"errorCode", 509}});
                    this.mShouldSendAdReadyEvent = false;
                }
                this.completeIterationRound();
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onInterstitialInitFailed(error:" + error + ", provider:" + smash.getName() + ")", e2);
        }
    }

    @Override
    public synchronized void onInterstitialAdReady(InterstitialSmash smash, long elapsedTime) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdReady()", 1);
        this.logProviderEvent(2003, smash, new Object[][]{{"duration", elapsedTime}});
        long totalLoadElapsedTime = new Date().getTime() - this.mLoadStartTime;
        smash.setMediationState(AbstractSmash.MEDIATION_STATE.AVAILABLE);
        this.mIsLoadInterstitialInProgress = false;
        if (this.mShouldSendAdReadyEvent) {
            this.mShouldSendAdReadyEvent = false;
            this.mInterstitialListenersWrapper.onInterstitialAdReady();
            this.logMediationEvent(2004, new Object[][]{{"duration", totalLoadElapsedTime}});
        }
    }

    @Override
    public synchronized void onInterstitialAdLoadFailed(IronSourceError error, InterstitialSmash smash, long elapsedTime) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdLoadFailed(" + error + ")", 1);
        IronSourceUtils.sendAutomationLog(smash.getInstanceName() + ":onInterstitialAdLoadFailed(" + error + ")");
        this.logProviderEvent(2200, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", elapsedTime}});
        smash.setMediationState(AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE);
        int availableOrLoadPending = this.smashesCount(AbstractSmash.MEDIATION_STATE.AVAILABLE, AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
        if (availableOrLoadPending >= this.mSmartLoadAmount) {
            return;
        }
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED) continue;
            asmash.setMediationState(AbstractSmash.MEDIATION_STATE.LOAD_PENDING);
            this.loadAdapterAndSendEvent((InterstitialSmash)asmash);
            return;
        }
        if (this.startNextAdapter() != null) {
            return;
        }
        if (this.mDidCallLoadInterstitial && availableOrLoadPending + this.smashesCount(AbstractSmash.MEDIATION_STATE.INIT_PENDING) == 0) {
            this.completeIterationRound();
            this.mIsLoadInterstitialInProgress = false;
            this.mCallbackThrottler.onInterstitialAdLoadFailed(new IronSourceError(509, "No ads to show"));
            this.logMediationEvent(2110, new Object[][]{{"errorCode", 509}});
        }
    }

    @Override
    public void onInterstitialAdOpened(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdOpened()", 1);
        this.logProviderEventWithPlacement(2005, smash, null);
        this.mInterstitialListenersWrapper.onInterstitialAdOpened();
    }

    @Override
    public void onInterstitialAdClosed(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdClosed()", 1);
        this.mIsCurrentlyShowing = false;
        this.logProviderEventWithPlacement(2204, smash, null);
        this.mInterstitialListenersWrapper.onInterstitialAdClosed();
    }

    @Override
    public void onInterstitialAdShowSucceeded(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdShowSucceeded()", 1);
        this.logProviderEventWithPlacement(2202, smash, null);
        boolean hasAvailable = false;
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            hasAvailable = true;
            this.completeAdapterShow(asmash);
        }
        if (!(hasAvailable || smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.EXHAUSTED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY)) {
            this.completeIterationRound();
        }
        this.changeStateToInitiated();
        this.mInterstitialListenersWrapper.onInterstitialAdShowSucceeded();
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error, InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdShowFailed(" + error + ")", 1);
        this.logProviderEventWithPlacement(2203, smash, new Object[][]{{"errorCode", error.getErrorCode()}});
        this.mIsCurrentlyShowing = false;
        this.completeAdapterShow(smash);
        for (AbstractSmash asmash : this.mSmashArray) {
            if (asmash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            this.mDidCallLoadInterstitial = true;
            String placementName = this.mCurrentPlacement != null ? this.mCurrentPlacement.getPlacementName() : "";
            this.showInterstitial(placementName);
            return;
        }
        this.mInterstitialListenersWrapper.onInterstitialAdShowFailed(error);
    }

    @Override
    public void onInterstitialAdClicked(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdClicked()", 1);
        this.logProviderEventWithPlacement(2006, smash, null);
        this.mInterstitialListenersWrapper.onInterstitialAdClicked();
    }

    @Override
    public void onInterstitialAdVisible(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, smash.getInstanceName() + ":onInterstitialAdVisible()", 1);
    }

    @Override
    public void onInterstitialAdRewarded(InterstitialSmash smash) {
        this.logProviderEvent(290, smash, null);
        if (this.mRewardedInterstitialListenerWrapper != null) {
            this.mRewardedInterstitialListenerWrapper.onInterstitialAdRewarded();
        }
    }

    @Override
    void shouldTrackNetworkState(Context context, boolean track) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, this.TAG + " Should Track Network State: " + track, 0);
        this.mShouldTrackNetworkState = track;
    }

    @Override
    public void onInitSuccess(List<IronSource.AD_UNIT> adUnits, boolean revived) {
    }

    @Override
    public void onInitFailed(String reason) {
        if (this.mDidCallLoadInterstitial) {
            this.mCallbackThrottler.onInterstitialAdLoadFailed(ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial"));
            this.mDidCallLoadInterstitial = false;
            this.mIsLoadInterstitialInProgress = false;
        }
    }

    @Override
    public void onStillInProgressAfter15Secs() {
        if (this.mDidCallLoadInterstitial) {
            IronSourceError error = ErrorBuilder.buildInitFailedError("init() had failed", "Interstitial");
            this.mCallbackThrottler.onInterstitialAdLoadFailed(error);
            this.mDidCallLoadInterstitial = false;
            this.mIsLoadInterstitialInProgress = false;
            if (this.mShouldSendAdReadyEvent) {
                this.logMediationEvent(2110, new Object[][]{{"errorCode", error.getErrorCode()}});
                this.mShouldSendAdReadyEvent = false;
            }
        }
    }

    private boolean isIterationRoundComplete() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INIT_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.INITIATED && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE) continue;
            return false;
        }
        return true;
    }

    private void completeIterationRound() {
        if (this.isIterationRoundComplete()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "Reset Iteration", 0);
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.EXHAUSTED) continue;
                smash.completeIteration();
            }
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "End of Reset Iteration", 0);
        }
    }

    private void completeAdapterShow(AbstractSmash smash) {
        if (!smash.isMediationAvailable()) {
            this.startNextAdapter();
            this.completeIterationRound();
        } else {
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        }
    }

    private AbstractAdapter startNextAdapter() {
        AbstractAdapter initiatedAdapter = null;
        int activeAdapters = 0;
        for (int i = 0; i < this.mSmashArray.size() && initiatedAdapter == null; ++i) {
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.AVAILABLE || ((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.INITIATED || ((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.INIT_PENDING || ((AbstractSmash)this.mSmashArray.get(i)).getMediationState() == AbstractSmash.MEDIATION_STATE.LOAD_PENDING) {
                if (++activeAdapters < this.mSmartLoadAmount) continue;
                break;
            }
            if (((AbstractSmash)this.mSmashArray.get(i)).getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_INITIATED || (initiatedAdapter = this.startAdapter((InterstitialSmash)this.mSmashArray.get(i))) != null) continue;
            ((AbstractSmash)this.mSmashArray.get(i)).setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
        }
        return initiatedAdapter;
    }

    private synchronized AbstractAdapter startAdapter(InterstitialSmash smash) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, this.TAG + ":startAdapter(" + smash.getName() + ")", 1);
        AbstractAdapter providerAdapter = AdapterRepository.getInstance().getAdapter(smash.mAdapterConfigs, smash.mAdapterConfigs.getInterstitialSettings(), this.mActivity);
        if (providerAdapter == null) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.API, smash.getInstanceName() + " is configured in IronSource's platform, but the adapter is not integrated", 2);
            return null;
        }
        smash.setAdapterForSmash(providerAdapter);
        smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_PENDING);
        if (this.mRewardedInterstitialListenerWrapper != null) {
            smash.setRewardedInterstitialManagerListener(this);
        }
        this.setCustomParams(smash);
        try {
            smash.initInterstitial(this.mActivity, this.mAppKey, this.mUserId);
        }
        catch (Throwable e2) {
            this.mLoggerManager.logException(IronSourceLogger.IronSourceTag.API, this.TAG + "failed to init adapter: " + smash.getName() + "v", e2);
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INIT_FAILED);
            return null;
        }
        return providerAdapter;
    }

    void setCurrentPlacement(InterstitialPlacement currentPlacement) {
        this.mCurrentPlacement = currentPlacement;
        this.mInterstitialListenersWrapper.setInterstitialPlacement(currentPlacement);
    }

    private synchronized void loadAdapterAndSendEvent(InterstitialSmash smash) {
        this.logProviderEvent(2002, smash, null);
        smash.loadInterstitial();
    }

    private synchronized void changeStateToInitiatedForInstanceId(String instanceId) {
        for (AbstractSmash smash : this.mSmashArray) {
            if (!smash.getSubProviderId().equals(instanceId) || smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            break;
        }
    }

    private synchronized void changeStateToInitiated() {
        for (AbstractSmash smash : this.mSmashArray) {
            if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.AVAILABLE && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.LOAD_PENDING && smash.getMediationState() != AbstractSmash.MEDIATION_STATE.NOT_AVAILABLE) continue;
            smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
        }
    }

    private void logMediationEvent(int eventId) {
        this.logMediationEvent(eventId, null);
    }

    private void logMediationEvent(int eventId, Object[][] keyVals) {
        this.logMediationEvent(eventId, keyVals, false);
    }

    private void logMediationEventWithPlacement(int eventId, Object[][] keyVals) {
        this.logMediationEvent(eventId, keyVals, true);
    }

    private void logMediationEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        JSONObject data = IronSourceUtils.getMediationAdditionalData(false);
        try {
            if (isAddPlacement && this.mCurrentPlacement != null && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement.getPlacementName())) {
                data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
            }
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "InterstitialManager logMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private void logProviderEvent(int eventId, AbstractSmash smash) {
        this.logProviderEvent(eventId, smash, null);
    }

    private void logProviderEvent(int eventId, AbstractSmash smash, Object[][] keyVals) {
        this.logProviderEvent(eventId, smash, keyVals, false);
    }

    private void logProviderEventWithPlacement(int eventId, AbstractSmash smash, Object[][] keyVals) {
        this.logProviderEvent(eventId, smash, keyVals, true);
    }

    private void logProviderEvent(int eventId, AbstractSmash smash, Object[][] keyVals, boolean isAddPlacement) {
        JSONObject data = IronSourceUtils.getProviderAdditionalData(smash);
        try {
            if (isAddPlacement && this.mCurrentPlacement != null && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement.getPlacementName())) {
                data.put("placement", (Object)this.mCurrentPlacement.getPlacementName());
            }
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, "InterstitialManager logProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, data);
        InterstitialEventsManager.getInstance().log(event);
    }

    private int smashesCount(AbstractSmash.MEDIATION_STATE ... states) {
        int ret = 0;
        for (AbstractSmash smash : this.mSmashArray) {
            for (AbstractSmash.MEDIATION_STATE state : states) {
                if (smash.getMediationState() != state) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public void onDailyCapReleased() {
        if (this.mSmashArray != null) {
            for (AbstractSmash smash : this.mSmashArray) {
                if (smash.getMediationState() != AbstractSmash.MEDIATION_STATE.CAPPED_PER_DAY) continue;
                this.logProviderEvent(250, smash, new Object[][]{{"status", "false"}});
                if (smash.isCappedPerSession()) {
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION);
                    continue;
                }
                if (smash.isExhausted()) {
                    smash.setMediationState(AbstractSmash.MEDIATION_STATE.EXHAUSTED);
                    continue;
                }
                smash.setMediationState(AbstractSmash.MEDIATION_STATE.INITIATED);
            }
        }
    }

    public void setDelayLoadFailureNotificationInSeconds(int delay) {
        this.mCallbackThrottler.setDelayLoadFailureNotificationInSeconds(delay);
    }

    private void prepareSDK5(Activity activity) {
        for (int i = 0; i < this.mSmashArray.size(); ++i) {
            String reflectionName = ((AbstractSmash)this.mSmashArray.get((int)i)).mAdapterConfigs.getProviderTypeForReflection();
            if (!reflectionName.equalsIgnoreCase("IronSource") && !reflectionName.equalsIgnoreCase("SupersonicAds")) continue;
            AdapterRepository.getInstance().getAdapter(((AbstractSmash)this.mSmashArray.get((int)i)).mAdapterConfigs, ((AbstractSmash)this.mSmashArray.get((int)i)).mAdapterConfigs.getInterstitialSettings(), activity);
            break;
        }
    }
}

