/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.AdaptersCompatibilityHandler;
import com.ironsource.mediationsdk.AuctionEventListener;
import com.ironsource.mediationsdk.AuctionHandler;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.CallbackThrottler;
import com.ironsource.mediationsdk.ISListenerWrapper;
import com.ironsource.mediationsdk.ProgIsManagerListener;
import com.ironsource.mediationsdk.ProgIsSmash;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.InterstitialConfigurations;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.CappingManager;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionCappingManager;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class ProgIsManager
implements ProgIsManagerListener,
AuctionEventListener {
    private SessionCappingManager mSessionCappingManager;
    private MEDIATION_STATE mState;
    private final ConcurrentHashMap<String, ProgIsSmash> mSmashes;
    private CopyOnWriteArrayList<ProgIsSmash> mWaterfall;
    private ConcurrentHashMap<String, AuctionResponseItem> mWaterfallServerData;
    private String mCurrentPlacement;
    private String mCurrentAuctionId;
    private int mMaxSmashesToLoad;
    private boolean mIsAuctionEnabled;
    private AuctionHandler mAuctionHandler;
    private Context mAppContext;
    private long mInitMangerTime;
    private long mTimeToWaitBeforeFirstAction;
    private long mLoadStartTime;
    private int mAuctionTrial;
    private String mAuctionFallback = "";

    public ProgIsManager(Activity activity, List<ProviderSettings> providersList, InterstitialConfigurations configs, String appKey, String userId, int delayLoadFailure) {
        long initStartTime = new Date().getTime();
        this.sendMediationEvent(82312);
        this.setState(MEDIATION_STATE.STATE_NOT_INITIALIZED);
        this.mSmashes = new ConcurrentHashMap();
        this.mWaterfall = new CopyOnWriteArrayList();
        this.mWaterfallServerData = new ConcurrentHashMap();
        this.mCurrentPlacement = "";
        this.mCurrentAuctionId = "";
        this.mAppContext = activity.getApplicationContext();
        this.mMaxSmashesToLoad = configs.getInterstitialAdaptersSmartLoadAmount();
        CallbackThrottler.getInstance().setDelayLoadFailureNotificationInSeconds(delayLoadFailure);
        AuctionSettings auctionSettings = configs.getInterstitialAuctionSettings();
        this.mTimeToWaitBeforeFirstAction = auctionSettings.getTimeToWaitBeforeFirstAuctionMs();
        boolean bl = this.mIsAuctionEnabled = auctionSettings.getNumOfMaxTrials() > 0;
        if (this.mIsAuctionEnabled) {
            this.mAuctionHandler = new AuctionHandler("interstitial", auctionSettings, this);
        }
        for (ProviderSettings provider : providersList) {
            AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(provider, provider.getInterstitialSettings(), activity);
            if (adapter == null || !AdaptersCompatibilityHandler.getInstance().isAdapterVersionISCompatible(adapter)) continue;
            ProgIsSmash smash = new ProgIsSmash(activity, appKey, userId, provider, this, configs.getInterstitialAdaptersSmartLoadTimeout(), adapter);
            this.mSmashes.put(smash.getInstanceName(), smash);
        }
        this.mSessionCappingManager = new SessionCappingManager(new ArrayList<ProgSmash>(this.mSmashes.values()));
        for (ProgIsSmash smash : this.mSmashes.values()) {
            if (!smash.isBidder()) continue;
            smash.initForBidding();
        }
        this.mInitMangerTime = new Date().getTime();
        this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
        long elapsedTime = new Date().getTime() - initStartTime;
        this.sendMediationEvent(82313, new Object[][]{{"duration", elapsedTime}});
    }

    private void makeAuction() {
        this.setState(MEDIATION_STATE.STATE_AUCTION);
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgIsManager.this.mCurrentAuctionId = "";
                StringBuilder waterfallStr = new StringBuilder();
                long timeSinceManagerInit = new Date().getTime() - ProgIsManager.this.mInitMangerTime;
                long timeToWaitBeforeAuction = ProgIsManager.this.mTimeToWaitBeforeFirstAction - timeSinceManagerInit;
                if (timeToWaitBeforeAuction > 0L) {
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ProgIsManager.this.makeAuction();
                        }
                    }, timeToWaitBeforeAuction);
                    return;
                }
                ProgIsManager.this.sendMediationEvent(2000, null);
                HashMap<String, Object> bidderCandidates = new HashMap<String, Object>();
                ArrayList<String> noBidderCandidates = new ArrayList<String>();
                for (ProgIsSmash smash : ProgIsManager.this.mSmashes.values()) {
                    if (ProgIsManager.this.mSessionCappingManager.isCapped(smash)) continue;
                    if (smash.isBidder()) {
                        Map<String, Object> biddingData = smash.getBiddingData();
                        if (biddingData == null) continue;
                        bidderCandidates.put(smash.getInstanceName(), biddingData);
                        waterfallStr.append("2" + smash.getInstanceName() + ",");
                        continue;
                    }
                    if (smash.isBidder()) continue;
                    noBidderCandidates.add(smash.getInstanceName());
                    waterfallStr.append("1" + smash.getInstanceName() + ",");
                }
                if (bidderCandidates.size() == 0 && noBidderCandidates.size() == 0) {
                    ProgIsManager.this.sendMediationEvent(2300, new Object[][]{{"errorCode", 1005}, {"duration", 0}});
                    CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(1005, "No candidates available for auctioning"));
                    ProgIsManager.this.sendMediationEvent(2110, new Object[][]{{"errorCode", 1005}});
                    ProgIsManager.this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
                    return;
                }
                if (waterfallStr.length() > 256) {
                    waterfallStr.setLength(256);
                } else if (waterfallStr.length() > 0) {
                    waterfallStr.deleteCharAt(waterfallStr.length() - 1);
                }
                ProgIsManager.this.sendMediationEvent(2310, new Object[][]{{"ext1", waterfallStr.toString()}});
                int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
                if (ProgIsManager.this.mAuctionHandler != null) {
                    ProgIsManager.this.mAuctionHandler.executeAuction(ProgIsManager.this.mAppContext, bidderCandidates, noBidderCandidates, sessionDepth);
                }
            }
        });
    }

    @Override
    public void onAuctionSuccess(List<AuctionResponseItem> newWaterfall, String auctionId, int auctionTrial, long elapsedTime) {
        this.mCurrentAuctionId = auctionId;
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFallback = "";
        this.sendMediationEvent(2301, new Object[][]{{"duration", elapsedTime}});
        this.updateWaterfall(newWaterfall);
        this.loadSmashes();
    }

    @Override
    public void onAuctionFailed(int errorCode, String errorMessage, int auctionTrial, String auctionFallback, long elapsedTime) {
        this.logInternal("Auction failed | moving to fallback waterfall");
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFallback = auctionFallback;
        if (TextUtils.isEmpty((CharSequence)errorMessage)) {
            this.sendMediationEvent(2300, new Object[][]{{"errorCode", errorCode}, {"duration", elapsedTime}});
        } else {
            this.sendMediationEvent(2300, new Object[][]{{"errorCode", errorCode}, {"reason", errorMessage}, {"duration", elapsedTime}});
        }
        this.updateWaterfallToNonBidding();
        this.loadSmashes();
    }

    private void updateWaterfallToNonBidding() {
        List<AuctionResponseItem> nonBiddersWaterfall = this.extractNonBidderProvidersFromWaterfall();
        this.updateWaterfall(nonBiddersWaterfall);
    }

    private List<AuctionResponseItem> extractNonBidderProvidersFromWaterfall() {
        CopyOnWriteArrayList<AuctionResponseItem> nonBidders = new CopyOnWriteArrayList<AuctionResponseItem>();
        for (ProgIsSmash smash : this.mSmashes.values()) {
            if (smash.isBidder() || this.mSessionCappingManager.isCapped(smash)) continue;
            nonBidders.add(new AuctionResponseItem(smash.getInstanceName()));
        }
        return nonBidders;
    }

    private String getAsString(AuctionResponseItem item) {
        String isProgrammatic = TextUtils.isEmpty((CharSequence)item.getServerData()) ? "1" : "2";
        return isProgrammatic + item.getInstanceName();
    }

    private void updateWaterfall(List<AuctionResponseItem> waterfall) {
        this.mWaterfall.clear();
        this.mWaterfallServerData.clear();
        StringBuilder waterfallStr = new StringBuilder();
        for (AuctionResponseItem item : waterfall) {
            waterfallStr.append(this.getAsString(item) + ",");
            ProgIsSmash smash = this.mSmashes.get(item.getInstanceName());
            if (smash != null) {
                smash.setIsLoadCandidate(true);
                this.mWaterfall.add(smash);
                this.mWaterfallServerData.put(smash.getInstanceName(), item);
                continue;
            }
            this.logInternal("updateWaterfall() - could not find matching smash for auction response item " + item.getInstanceName());
        }
        this.logInternal("updateWaterfall() - response waterfall is " + waterfallStr.toString());
        if (waterfallStr.length() > 256) {
            waterfallStr.setLength(256);
        } else if (waterfallStr.length() > 0) {
            waterfallStr.deleteCharAt(waterfallStr.length() - 1);
        } else {
            this.logInternal("Updated waterfall is empty");
        }
        this.sendMediationEvent(2311, new Object[][]{{"ext1", waterfallStr.toString()}});
    }

    private void loadSmashes() {
        if (this.mWaterfall.isEmpty()) {
            this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
            this.sendMediationEvent(2110, new Object[][]{{"errorCode", 1035}, {"reason", "Empty waterfall"}});
            CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(1035, "Empty waterfall"));
            return;
        }
        this.setState(MEDIATION_STATE.STATE_LOADING_SMASHES);
        for (int i = 0; i < Math.min(this.mMaxSmashesToLoad, this.mWaterfall.size()); ++i) {
            ProgIsSmash smash = this.mWaterfall.get(i);
            String serverData = this.mWaterfallServerData.get(smash.getInstanceName()).getServerData();
            smash.setDynamicDemandSourceIdByServerData(serverData);
            this.sendProviderEvent(2002, smash);
            smash.loadInterstitial(serverData);
        }
    }

    public synchronized void loadInterstitial() {
        if (this.mState == MEDIATION_STATE.STATE_SHOWING) {
            String message = "loadInterstitial: load cannot be invoked while showing an ad";
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, message, 3);
            IronSourceError error = new IronSourceError(1037, message);
            ISListenerWrapper.getInstance().onInterstitialAdLoadFailed(error);
            return;
        }
        if (this.mState != MEDIATION_STATE.STATE_READY_TO_LOAD && this.mState != MEDIATION_STATE.STATE_READY_TO_SHOW || CallbackThrottler.getInstance().hasPendingInvocation()) {
            this.logInternal("loadInterstitial: load is already in progress");
            return;
        }
        this.mCurrentAuctionId = "";
        this.mCurrentPlacement = "";
        this.sendMediationEvent(2001);
        this.mLoadStartTime = new Date().getTime();
        if (this.mIsAuctionEnabled) {
            this.makeAuction();
        } else {
            this.updateWaterfallToNonBidding();
            this.loadSmashes();
        }
    }

    public synchronized void showInterstitial(String placementName) {
        if (this.mState == MEDIATION_STATE.STATE_SHOWING) {
            String message = "showInterstitial error: can't show ad while an ad is already showing";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(1036, message);
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            this.sendMediationEvent(2111, new Object[][]{{"errorCode", 1036}, {"reason", message}});
            return;
        }
        if (this.mState != MEDIATION_STATE.STATE_READY_TO_SHOW) {
            this.logInternal("showInterstitial() error state=" + this.mState.toString());
            String message = "showInterstitial error: show called while no ads are available";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(509, message);
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            this.sendMediationEvent(2111, new Object[][]{{"errorCode", 509}, {"reason", message}});
            return;
        }
        if (placementName == null) {
            String message = "showInterstitial error: empty default placement";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(1020, message);
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            this.sendMediationEvent(2111, new Object[][]{{"errorCode", 1020}, {"reason", message}});
            return;
        }
        this.mCurrentPlacement = placementName;
        this.sendMediationEventWithPlacement(2100);
        if (CappingManager.isInterstitialPlacementCapped(this.mAppContext, this.mCurrentPlacement)) {
            String message = "placement " + this.mCurrentPlacement + " is capped";
            this.logAPIError(message);
            IronSourceError error = new IronSourceError(524, message);
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            this.sendMediationEventWithPlacement(2111, new Object[][]{{"errorCode", 524}, {"reason", message}});
            return;
        }
        for (ProgIsSmash smash : this.mWaterfall) {
            if (smash.isReadyToShow()) {
                this.showInterstitial(smash, this.mCurrentPlacement);
                return;
            }
            this.logInternal("showInterstitial " + smash.getInstanceName() + " isReadyToShow() == false");
        }
        ISListenerWrapper.getInstance().onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError("Interstitial"));
        this.sendMediationEventWithPlacement(2111, new Object[][]{{"errorCode", 509}, {"reason", "Show Fail - No ads to show"}});
    }

    private void showInterstitial(ProgIsSmash smash, String placementName) {
        this.setState(MEDIATION_STATE.STATE_SHOWING);
        smash.showInterstitial();
        this.sendProviderEventWithPlacement(2201, smash);
        this.mSessionCappingManager.increaseShowCounter(smash);
        if (this.mSessionCappingManager.isCapped(smash)) {
            smash.setCappedPerSession();
            this.sendProviderEvent(2401, smash);
            IronSourceUtils.sendAutomationLog(smash.getInstanceName() + " was session capped");
        }
        CappingManager.incrementIsShowCounter(this.mAppContext, placementName);
        if (CappingManager.isInterstitialPlacementCapped(this.mAppContext, placementName)) {
            this.sendMediationEventWithPlacement(2400);
        }
    }

    public synchronized boolean isInterstitialReady() {
        if (!IronSourceUtils.isNetworkConnected(this.mAppContext) || this.mState != MEDIATION_STATE.STATE_READY_TO_SHOW) {
            return false;
        }
        for (ProgIsSmash smash : this.mWaterfall) {
            if (!smash.isReadyToShow()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdReady(ProgIsSmash smash, long elapsedTime) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdReady");
            this.sendProviderEvent(2003, smash, new Object[][]{{"duration", elapsedTime}});
            if (this.mState == MEDIATION_STATE.STATE_LOADING_SMASHES) {
                this.setState(MEDIATION_STATE.STATE_READY_TO_SHOW);
                ISListenerWrapper.getInstance().onInterstitialAdReady();
                long totalLoadElapsedTime = new Date().getTime() - this.mLoadStartTime;
                this.sendMediationEvent(2004, new Object[][]{{"duration", totalLoadElapsedTime}});
                AuctionResponseItem winnerInstance = this.mWaterfallServerData.get(smash.getInstanceName());
                if (winnerInstance != null) {
                    this.mAuctionHandler.reportLoadSuccess(winnerInstance);
                    this.mAuctionHandler.reportAuctionLose(this.mWaterfall, this.mWaterfallServerData, winnerInstance);
                } else {
                    String smashName = smash != null ? smash.getInstanceName() : "Smash is null";
                    this.logInternal("onInterstitialAdReady winner instance " + smashName + " missing from waterfall");
                    this.sendMediationEvent(82317, new Object[][]{{"errorCode", 1010}, {"reason", "Loaded missing"}, {"ext1", smashName}});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error, ProgIsSmash smash, long elapsedTime) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdLoadFailed error=" + error.getErrorMessage() + " state=" + this.mState.name());
            this.sendProviderEvent(2200, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", elapsedTime}});
            boolean hasLoadInProgress = false;
            for (ProgIsSmash waterfallSmash : this.mWaterfall) {
                if (waterfallSmash.getIsLoadCandidate()) {
                    String serverData = this.mWaterfallServerData.get(waterfallSmash.getInstanceName()).getServerData();
                    this.sendProviderEvent(2002, waterfallSmash);
                    waterfallSmash.loadInterstitial(serverData);
                    return;
                }
                if (!waterfallSmash.isLoadingInProgress()) continue;
                hasLoadInProgress = true;
            }
            if (this.mState == MEDIATION_STATE.STATE_LOADING_SMASHES && !hasLoadInProgress) {
                CallbackThrottler.getInstance().onInterstitialAdLoadFailed(new IronSourceError(509, "No ads to show"));
                this.sendMediationEvent(2110, new Object[][]{{"errorCode", 509}});
                this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdOpened(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdOpened");
            ISListenerWrapper.getInstance().onInterstitialAdOpened();
            this.sendProviderEventWithPlacement(2005, smash);
            if (this.mIsAuctionEnabled) {
                AuctionResponseItem showingInstance = this.mWaterfallServerData.get(smash.getInstanceName());
                if (showingInstance != null) {
                    this.mAuctionHandler.reportImpression(showingInstance);
                } else {
                    String smashName = smash != null ? smash.getInstanceName() : "Smash is null";
                    this.logInternal("onInterstitialAdOpened showing instance " + smashName + " missing from waterfall");
                    this.sendMediationEvent(82317, new Object[][]{{"errorCode", 1011}, {"reason", "Showing missing " + (Object)((Object)this.mState)}, {"ext1", smashName}});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdClosed(ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdClosed");
            this.sendProviderEventWithPlacement(2204, smash);
            ISListenerWrapper.getInstance().onInterstitialAdClosed();
            this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
        }
    }

    @Override
    public void onInterstitialAdShowSucceeded(ProgIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdShowSucceeded");
        ISListenerWrapper.getInstance().onInterstitialAdShowSucceeded();
        this.sendProviderEventWithPlacement(2202, smash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInterstitialAdShowFailed(IronSourceError error, ProgIsSmash smash) {
        ProgIsManager progIsManager = this;
        synchronized (progIsManager) {
            this.logSmashCallback(smash, "onInterstitialAdShowFailed error=" + error.getErrorMessage());
            ISListenerWrapper.getInstance().onInterstitialAdShowFailed(error);
            this.sendProviderEventWithPlacement(2203, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
            this.setState(MEDIATION_STATE.STATE_READY_TO_LOAD);
        }
    }

    @Override
    public void onInterstitialAdClicked(ProgIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdClicked");
        ISListenerWrapper.getInstance().onInterstitialAdClicked();
        this.sendProviderEventWithPlacement(2006, smash);
    }

    @Override
    public void onInterstitialAdVisible(ProgIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdVisible");
    }

    @Override
    public void onInterstitialInitFailed(IronSourceError error, ProgIsSmash smash) {
        this.sendProviderEvent(2206, smash, new Object[][]{{"reason", error.getErrorMessage()}});
    }

    @Override
    public void onInterstitialInitSuccess(ProgIsSmash smash) {
        this.sendProviderEvent(2205, smash);
    }

    private void setState(MEDIATION_STATE state) {
        this.mState = state;
        this.logInternal("state=" + (Object)((Object)state));
    }

    private void logSmashCallback(ProgIsSmash smash, String line) {
        String text = "ProgIsManager " + smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void logAPIError(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, text, 3);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "ProgIsManager " + text, 0);
    }

    private void sendMediationEvent(int eventId) {
        this.sendMediationEvent(eventId, null, false);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, false);
    }

    private void sendMediationEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendMediationEvent(eventId, keyVals, true);
    }

    private void sendMediationEventWithPlacement(int eventId) {
        this.sendMediationEvent(eventId, null, true);
    }

    private void sendMediationEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("programmatic", 1);
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        if (this.shouldAddAuctionParams(eventId)) {
            InterstitialEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFallback);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            this.logInternal("sendMediationEvent " + e2.getMessage());
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 2002 || eventId == 2003 || eventId == 2200 || eventId == 2005 || eventId == 2204 || eventId == 2201 || eventId == 2203 || eventId == 2006 || eventId == 2004 || eventId == 2110 || eventId == 2301 || eventId == 2300;
    }

    private void sendProviderEvent(int eventId, ProgIsSmash smash) {
        this.sendProviderEvent(eventId, smash, null, false);
    }

    private void sendProviderEvent(int eventId, ProgIsSmash smash, Object[][] keyVals) {
        this.sendProviderEvent(eventId, smash, keyVals, false);
    }

    private void sendProviderEventWithPlacement(int eventId, ProgIsSmash smash, Object[][] keyVals) {
        this.sendProviderEvent(eventId, smash, keyVals, true);
    }

    private void sendProviderEventWithPlacement(int eventId, ProgIsSmash smash) {
        this.sendProviderEvent(eventId, smash, null, true);
    }

    private void sendProviderEvent(int eventId, ProgIsSmash smash, Object[][] keyVals, boolean isAddPlacement) {
        Map<String, Object> data = smash.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement)) {
            data.put("placement", this.mCurrentPlacement);
        }
        if (this.shouldAddAuctionParams(eventId)) {
            InterstitialEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFallback);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    static enum MEDIATION_STATE {
        STATE_NOT_INITIALIZED,
        STATE_READY_TO_LOAD,
        STATE_AUCTION,
        STATE_LOADING_SMASHES,
        STATE_READY_TO_SHOW,
        STATE_SHOWING;

    }
}

