/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ProviderSettings;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class AdapterRepository {
    private static final String IRONSOURCE_ADAPTER_PREFIX = "IronSource";
    private static AdapterRepository mInstance = new AdapterRepository();
    private static final Object lock = new Object();
    private ConcurrentHashMap<String, AbstractAdapter> adapters;
    private String mAppKey;
    private String mUserId;
    private Boolean mConsent;
    private Boolean mAdapterDebug;
    private Integer mAge;
    private String mGender;
    private ConcurrentHashMap<String, String> mMetaData;
    private AtomicBoolean mDidIronSourceEarlyInit = new AtomicBoolean(false);

    public static AdapterRepository getInstance() {
        return mInstance;
    }

    private AdapterRepository() {
        this.adapters = new ConcurrentHashMap();
        this.mMetaData = new ConcurrentHashMap();
    }

    public void setInitParams(String ironSourceAppKey, String ironSourceUserId) {
        this.mAppKey = ironSourceAppKey;
        this.mUserId = ironSourceUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsent(boolean consent) {
        Object object = lock;
        synchronized (object) {
            this.mConsent = consent;
            for (AbstractAdapter adapter : this.adapters.values()) {
                this.setConsent(adapter);
            }
        }
    }

    private void setConsent(AbstractAdapter adapter) {
        try {
            if (this.mConsent != null) {
                adapter.setConsent(this.mConsent);
            }
        }
        catch (Throwable t) {
            this.logInternal("error while setting consent of " + adapter.getProviderName() + ": " + t.getLocalizedMessage());
            t.printStackTrace();
        }
    }

    public AbstractAdapter getAdapter(ProviderSettings settings, JSONObject config, Activity activity) {
        return this.getAdapter(settings, config, activity, false);
    }

    public AbstractAdapter getAdapter(ProviderSettings settings, JSONObject config, Activity activity, boolean isDemandOnly) {
        String name = this.getAdapterKey(settings);
        String reflectionName = isDemandOnly ? IRONSOURCE_ADAPTER_PREFIX : settings.getProviderTypeForReflection();
        return this.getAdapterInternal(name, reflectionName, config, activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAdapter getAdapterInternal(String name, String reflectionName, JSONObject config, Activity activity) {
        this.logInternal(name + " (" + reflectionName + ") - Getting adapter");
        Object object = lock;
        synchronized (object) {
            if (this.adapters.containsKey(name)) {
                this.logInternal(name + " was already allocated");
                return this.adapters.get(name);
            }
            AbstractAdapter adapter = this.getAdapterByReflection(name, reflectionName);
            if (adapter == null) {
                this.logErrorInternal(name + " adapter was not loaded");
                return null;
            }
            this.logInternal(name + " was allocated (adapter version: " + adapter.getVersion() + ", sdk version: " + adapter.getCoreSDKVersion() + ")");
            adapter.setLogListener(IronSourceLoggerManager.getLogger());
            this.setMetaData(adapter);
            this.setConsent(adapter);
            this.setAge(adapter);
            this.setGender(adapter);
            this.setAdaptersDebug(adapter);
            this.earlyInitAdapter(config, adapter, reflectionName, activity);
            this.adapters.put(name, adapter);
            return adapter;
        }
    }

    private void earlyInitAdapter(JSONObject config, AbstractAdapter adapter, String reflectionName, Activity activity) {
        if ((reflectionName.equalsIgnoreCase("SupersonicAds") || reflectionName.equalsIgnoreCase(IRONSOURCE_ADAPTER_PREFIX)) && this.mDidIronSourceEarlyInit.compareAndSet(false, true)) {
            this.logInternal("SDK5 earlyInit  <" + reflectionName + ">");
            adapter.earlyInit(activity, this.mAppKey, this.mUserId, config);
        }
    }

    private AbstractAdapter getAdapterByReflection(String name, String reflectionName) {
        try {
            Class<?> adapterClass = Class.forName("com.ironsource.adapters." + reflectionName.toLowerCase() + "." + reflectionName + "Adapter");
            Method startAdapterMethod = adapterClass.getMethod("startAdapter", String.class);
            return (AbstractAdapter)startAdapterMethod.invoke(adapterClass, name);
        }
        catch (Exception e2) {
            this.logErrorInternal("Error while loading adapter: " + e2.getLocalizedMessage());
            return null;
        }
    }

    private void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AdapterRepository: " + text, 3);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AdapterRepository: " + text, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAge(int age) {
        Object object = lock;
        synchronized (object) {
            this.mAge = age;
            for (AbstractAdapter adapter : this.adapters.values()) {
                this.setAge(adapter);
            }
        }
    }

    private void setAge(AbstractAdapter adapter) {
        if (this.mAge != null) {
            try {
                adapter.setAge(this.mAge);
            }
            catch (Throwable t) {
                this.logInternal("error while setting age of " + adapter.getProviderName() + ": " + t.getLocalizedMessage());
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGender(String gender) {
        Object object = lock;
        synchronized (object) {
            this.mGender = gender;
            for (AbstractAdapter adapter : this.adapters.values()) {
                this.setGender(adapter);
            }
        }
    }

    private void setGender(AbstractAdapter adapter) {
        if (this.mGender != null) {
            try {
                adapter.setGender(this.mGender);
            }
            catch (Throwable t) {
                this.logInternal("error while setting gender of " + adapter.getProviderName() + ": " + t.getLocalizedMessage());
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdaptersDebug(boolean enabled) {
        Object object = lock;
        synchronized (object) {
            this.mAdapterDebug = enabled;
            for (AbstractAdapter adapter : this.adapters.values()) {
                this.setAdaptersDebug(adapter);
            }
        }
    }

    private void setAdaptersDebug(AbstractAdapter adapter) {
        if (this.mAdapterDebug != null) {
            try {
                adapter.setAdapterDebug(this.mAdapterDebug);
            }
            catch (Throwable t) {
                this.logInternal("error while setting adapterDebug of " + adapter.getProviderName() + ": " + t.getLocalizedMessage());
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaData(String key, String value) {
        Object object = lock;
        synchronized (object) {
            this.mMetaData.put(key, value);
            for (AbstractAdapter adapter : this.adapters.values()) {
                try {
                    adapter.setMetaData(key, value);
                }
                catch (Throwable t) {
                    this.logInternal("error while setting metadata of " + adapter.getProviderName() + ": " + t.getLocalizedMessage());
                    t.printStackTrace();
                }
            }
        }
    }

    private void setMetaData(AbstractAdapter adapter) {
        for (String key : this.mMetaData.keySet()) {
            try {
                adapter.setMetaData(key, this.mMetaData.get(key));
            }
            catch (Throwable t) {
                this.logInternal("error while setting metadata of " + adapter.getProviderName() + ": " + t.getLocalizedMessage());
                t.printStackTrace();
            }
        }
    }

    public String getBiddingData(IronSource.AD_UNIT adUnit, ProviderSettings settings) {
        AbstractAdapter adapter;
        String biddingData = null;
        Map<String, Object> biddingDataMap = null;
        String adapterKey = this.getAdapterKey(settings);
        if (adapterKey != null && (adapter = this.adapters.get(adapterKey)) != null) {
            Object val;
            switch (adUnit) {
                case REWARDED_VIDEO: {
                    biddingDataMap = adapter.getRvBiddingData(null);
                    break;
                }
                case INTERSTITIAL: {
                    biddingDataMap = adapter.getIsBiddingData(null);
                }
            }
            if (biddingDataMap != null && (val = biddingDataMap.get("token")) instanceof String) {
                biddingData = (String)val;
            }
        }
        return biddingData;
    }

    public ConcurrentHashMap<String, String> getMetaData() {
        return this.mMetaData;
    }

    private String getAdapterKey(ProviderSettings settings) {
        return settings.isMultipleInstances() ? settings.getProviderTypeForReflection() : settings.getProviderName();
    }

    public void onPause(Activity activity) {
        for (AbstractAdapter adapter : this.getUniqueAdapters()) {
            adapter.onPause(activity);
        }
    }

    public void onResume(Activity activity) {
        for (AbstractAdapter adapter : this.getUniqueAdapters()) {
            adapter.onResume(activity);
        }
    }

    private Set<AbstractAdapter> getUniqueAdapters() {
        TreeSet<AbstractAdapter> adaptersSet = new TreeSet<AbstractAdapter>(new Comparator<AbstractAdapter>(){

            @Override
            public int compare(AbstractAdapter o1, AbstractAdapter o2) {
                return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            }
        });
        adaptersSet.addAll(this.adapters.values());
        return adaptersSet;
    }
}

