/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.utils;

import com.ironsource.mediationsdk.ProgSmash;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionCappingManager {
    private Map<String, Integer> mShowCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> mMaxAdsPerSessionMap = new HashMap<String, Integer>();

    public SessionCappingManager(List<ProgSmash> smashes) {
        for (ProgSmash smash : smashes) {
            this.mShowCountMap.put(smash.getInstanceName(), 0);
            this.mMaxAdsPerSessionMap.put(smash.getInstanceName(), smash.getMaxAdsPerSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseShowCounter(ProgSmash smash) {
        SessionCappingManager sessionCappingManager = this;
        synchronized (sessionCappingManager) {
            String instanceName = smash.getInstanceName();
            if (this.mShowCountMap.containsKey(instanceName)) {
                this.mShowCountMap.put(instanceName, this.mShowCountMap.get(instanceName) + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCapped(ProgSmash smash) {
        SessionCappingManager sessionCappingManager = this;
        synchronized (sessionCappingManager) {
            String instanceName = smash.getInstanceName();
            if (this.mShowCountMap.containsKey(instanceName)) {
                return this.mShowCountMap.get(instanceName) >= smash.getMaxAdsPerSession();
            }
            return false;
        }
    }

    public boolean areAllSmashesCapped() {
        for (String smashInstanceName : this.mMaxAdsPerSessionMap.keySet()) {
            int maxAdsPerSessionOfSmash;
            int currentShowCount = this.mShowCountMap.get(smashInstanceName);
            if (currentShowCount >= (maxAdsPerSessionOfSmash = this.mMaxAdsPerSessionMap.get(smashInstanceName).intValue())) continue;
            return false;
        }
        return true;
    }
}

