/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.model;

import android.text.TextUtils;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.ArrayList;
import java.util.HashSet;

public class ProviderSettingsHolder {
    private ArrayList<ProviderSettings> mProviderSettingsArrayList = new ArrayList();
    private static ProviderSettingsHolder mInstance;

    public static synchronized ProviderSettingsHolder getProviderSettingsHolder() {
        if (mInstance == null) {
            mInstance = new ProviderSettingsHolder();
        }
        return mInstance;
    }

    private ProviderSettingsHolder() {
    }

    public void addProviderSettings(ProviderSettings providerSettings) {
        if (providerSettings != null) {
            this.mProviderSettingsArrayList.add(providerSettings);
        }
    }

    public ProviderSettings getProviderSettings(String providerName) {
        for (ProviderSettings providerSettings : this.mProviderSettingsArrayList) {
            if (!providerSettings.getProviderName().equals(providerName)) continue;
            return providerSettings;
        }
        ProviderSettings ps = new ProviderSettings(providerName);
        this.addProviderSettings(ps);
        return ps;
    }

    public HashSet<String> getProviderSettingsByReflectionName(String providerNameForReflection, String fieldName) {
        HashSet<String> result = new HashSet<String>();
        try {
            for (ProviderSettings providerSettings : this.mProviderSettingsArrayList) {
                if (!providerSettings.getProviderTypeForReflection().equals(providerNameForReflection)) continue;
                if (providerSettings.getRewardedVideoSettings() != null && providerSettings.getRewardedVideoSettings().length() > 0 && !TextUtils.isEmpty((CharSequence)providerSettings.getRewardedVideoSettings().optString(fieldName))) {
                    result.add(providerSettings.getRewardedVideoSettings().optString(fieldName));
                }
                if (providerSettings.getInterstitialSettings() != null && providerSettings.getInterstitialSettings().length() > 0 && !TextUtils.isEmpty((CharSequence)providerSettings.getInterstitialSettings().optString(fieldName))) {
                    result.add(providerSettings.getInterstitialSettings().optString(fieldName));
                }
                if (providerSettings.getBannerSettings() == null || providerSettings.getBannerSettings().length() <= 0 || TextUtils.isEmpty((CharSequence)providerSettings.getBannerSettings().optString(fieldName))) continue;
                result.add(providerSettings.getBannerSettings().optString(fieldName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean containsProviderSettings(String providerName) {
        for (ProviderSettings providerSettings : this.mProviderSettingsArrayList) {
            if (!providerSettings.getProviderName().equals(providerName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ProviderSettings> getProviderSettingsArrayList() {
        return this.mProviderSettingsArrayList;
    }

    public void fillSubProvidersDetails() {
        for (ProviderSettings providerSettings : this.mProviderSettingsArrayList) {
            boolean isSubProvider = providerSettings.isMultipleInstances() && !TextUtils.isEmpty((CharSequence)providerSettings.getProviderTypeForReflection());
            if (!isSubProvider) continue;
            ProviderSettings commonProviderSettings = this.getProviderSettings(providerSettings.getProviderTypeForReflection());
            providerSettings.setInterstitialSettings(IronSourceUtils.mergeJsons(providerSettings.getInterstitialSettings(), commonProviderSettings.getInterstitialSettings()));
            providerSettings.setRewardedVideoSettings(IronSourceUtils.mergeJsons(providerSettings.getRewardedVideoSettings(), commonProviderSettings.getRewardedVideoSettings()));
            providerSettings.setBannerSettings(IronSourceUtils.mergeJsons(providerSettings.getBannerSettings(), commonProviderSettings.getBannerSettings()));
        }
    }
}

