/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.os.Handler;
import android.os.Looper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;

public class ISDemandOnlyListenerWrapper {
    private static final ISDemandOnlyListenerWrapper sInstance = new ISDemandOnlyListenerWrapper();
    private ISDemandOnlyInterstitialListener mListener = null;

    public static ISDemandOnlyListenerWrapper getInstance() {
        return sInstance;
    }

    private ISDemandOnlyListenerWrapper() {
    }

    public void setListener(ISDemandOnlyInterstitialListener listener) {
        this.mListener = listener;
    }

    public ISDemandOnlyInterstitialListener getListener() {
        return this.mListener;
    }

    public void onInterstitialAdReady(final String instanceId) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    ISDemandOnlyListenerWrapper.this.mListener.onInterstitialAdReady(instanceId);
                    ISDemandOnlyListenerWrapper.this.log("onInterstitialAdReady() instanceId=" + instanceId);
                }
            });
        }
    }

    public void onInterstitialAdLoadFailed(final String instanceId, final IronSourceError error) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    ISDemandOnlyListenerWrapper.this.mListener.onInterstitialAdLoadFailed(instanceId, error);
                    ISDemandOnlyListenerWrapper.this.log("onInterstitialAdLoadFailed() instanceId=" + instanceId + " error=" + error.getErrorMessage());
                }
            });
        }
    }

    public void onInterstitialAdOpened(final String instanceId) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    ISDemandOnlyListenerWrapper.this.mListener.onInterstitialAdOpened(instanceId);
                    ISDemandOnlyListenerWrapper.this.log("onInterstitialAdOpened() instanceId=" + instanceId);
                }
            });
        }
    }

    public void onInterstitialAdClosed(final String instanceId) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    ISDemandOnlyListenerWrapper.this.mListener.onInterstitialAdClosed(instanceId);
                    ISDemandOnlyListenerWrapper.this.log("onInterstitialAdClosed() instanceId=" + instanceId);
                }
            });
        }
    }

    public void onInterstitialAdShowFailed(final String instanceId, final IronSourceError error) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    ISDemandOnlyListenerWrapper.this.mListener.onInterstitialAdShowFailed(instanceId, error);
                    ISDemandOnlyListenerWrapper.this.log("onInterstitialAdShowFailed() instanceId=" + instanceId + " error=" + error.getErrorMessage());
                }
            });
        }
    }

    public void onInterstitialAdClicked(final String instanceId) {
        if (this.mListener != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    ISDemandOnlyListenerWrapper.this.mListener.onInterstitialAdClicked(instanceId);
                    ISDemandOnlyListenerWrapper.this.log("onInterstitialAdClicked() instanceId=" + instanceId);
                }
            });
        }
    }

    private void log(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, text, 1);
    }
}

