/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.DemandOnlySmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.DemandOnlyRvManagerListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;

public class DemandOnlyRvSmash
extends DemandOnlySmash
implements RewardedVideoSmashListener {
    private DemandOnlyRvManagerListener mListener;
    private long mLoadStartTime;

    DemandOnlyRvSmash(Activity activity, String appKey, String userId, ProviderSettings settings, DemandOnlyRvManagerListener listener, int loadTimeout, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getInterstitialSettings()), adapter);
        this.mAdapterConfig = new AdapterConfig(settings, settings.getRewardedVideoSettings());
        this.mAdUnitSettings = this.mAdapterConfig.getAdUnitSetings();
        this.mAdapter = adapter;
        this.mListener = listener;
        this.mLoadTimeoutSecs = loadTimeout;
        this.mAdapter.initRvForDemandOnly(activity, appKey, userId, this.mAdUnitSettings, this);
    }

    public void loadRewardedVideo(String serverData, String auctionId, List<String> bURL) {
        this.logInternal("loadRewardedVideo state=" + this.getStateString());
        DemandOnlySmash.SMASH_STATE currentState = this.compareAndSetState(new DemandOnlySmash.SMASH_STATE[]{DemandOnlySmash.SMASH_STATE.NOT_LOADED, DemandOnlySmash.SMASH_STATE.LOADED}, DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS);
        if (currentState == DemandOnlySmash.SMASH_STATE.NOT_LOADED || currentState == DemandOnlySmash.SMASH_STATE.LOADED) {
            this.mLoadStartTime = new Date().getTime();
            this.startLoadTimer();
            if (this.isBidder()) {
                this.mAuctionId = auctionId;
                this.mBUrl = bURL;
                this.mAdapter.loadVideoForDemandOnly(this.mAdUnitSettings, this, serverData);
            } else {
                this.mAdapter.loadVideoForDemandOnly(this.mAdUnitSettings, this);
            }
        } else if (currentState == DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS) {
            IronSourceError error = new IronSourceError(1053, "load already in progress");
            this.mListener.onRewardedVideoAdLoadFailed(error, this, 0L);
        } else {
            IronSourceError error = new IronSourceError(1056, "cannot load because show is in progress");
            this.mListener.onRewardedVideoAdLoadFailed(error, this, 0L);
        }
    }

    public void showRewardedVideo() {
        this.logInternal("showRewardedVideo state=" + this.getStateString());
        if (this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOADED, DemandOnlySmash.SMASH_STATE.SHOW_IN_PROGRESS)) {
            this.mAdapter.showRewardedVideo(this.mAdUnitSettings, this);
        } else {
            IronSourceError error = new IronSourceError(1054, "load must be called before show");
            this.mListener.onRewardedVideoAdShowFailed(error, this);
        }
    }

    public boolean isRewardedVideoAvailable() {
        return this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
    }

    private void startLoadTimer() {
        this.logInternal("start timer");
        this.startTimer(new TimerTask(){

            @Override
            public void run() {
                DemandOnlyRvSmash.this.logInternal("load timed out state=" + DemandOnlyRvSmash.this.getStateString());
                if (DemandOnlyRvSmash.this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS, DemandOnlySmash.SMASH_STATE.NOT_LOADED)) {
                    long elapsedTime = new Date().getTime() - DemandOnlyRvSmash.this.mLoadStartTime;
                    DemandOnlyRvSmash.this.mListener.onRewardedVideoAdLoadFailed(new IronSourceError(1055, "load timed out"), DemandOnlyRvSmash.this, elapsedTime);
                }
            }
        });
    }

    @Override
    public void onRewardedVideoInitSuccess() {
    }

    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
        this.logAdapterCallback("onRewardedVideoLoadSuccess state=" + this.getStateString());
        this.stopTimer();
        if (this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS, DemandOnlySmash.SMASH_STATE.LOADED)) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onRewardedVideoLoadSuccess(this, elapsedTime);
        }
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoLoadFailed error=" + error.getErrorMessage() + " state=" + this.getStateString());
        this.stopTimer();
        if (this.compareAndSetState(DemandOnlySmash.SMASH_STATE.LOAD_IN_PROGRESS, DemandOnlySmash.SMASH_STATE.NOT_LOADED)) {
            long elapsedTime = new Date().getTime() - this.mLoadStartTime;
            this.mListener.onRewardedVideoAdLoadFailed(error, this, elapsedTime);
        }
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.logAdapterCallback("onRewardedVideoAdOpened");
        this.mListener.onRewardedVideoAdOpened(this);
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.setState(DemandOnlySmash.SMASH_STATE.NOT_LOADED);
        this.logAdapterCallback("onRewardedVideoAdClosed");
        this.mListener.onRewardedVideoAdClosed(this);
    }

    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
    }

    @Override
    public void onRewardedVideoAdStarted() {
    }

    @Override
    public void onRewardedVideoAdEnded() {
    }

    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        this.setState(DemandOnlySmash.SMASH_STATE.NOT_LOADED);
        this.logAdapterCallback("onRewardedVideoAdClosed error=" + error);
        this.mListener.onRewardedVideoAdShowFailed(error, this);
    }

    @Override
    public void onRewardedVideoAdClicked() {
        this.logAdapterCallback("onRewardedVideoAdClicked");
        this.mListener.onRewardedVideoAdClicked(this);
    }

    @Override
    public void onRewardedVideoAdVisible() {
        this.logAdapterCallback("onRewardedVideoAdVisible");
        this.mListener.onRewardedVideoAdVisible(this);
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        this.logAdapterCallback("onRewardedVideoAdRewarded");
        this.mListener.onRewardedVideoAdRewarded(this);
    }

    private void logAdapterCallback(String line) {
        String text = "DemandOnlyRewardedVideoSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "DemandOnlyRewardedVideoSmash " + this.mAdapterConfig.getProviderName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

