/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;

public class AdapterUtils {
    public static boolean isLargeScreen(Activity activity) {
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "AdapterUtils isLargeScreen - activity is null", 3);
            return false;
        }
        DisplayMetrics displayMetrics = activity.getResources().getDisplayMetrics();
        float dpHeight = (float)displayMetrics.heightPixels / displayMetrics.density;
        float dpWidth = (float)displayMetrics.widthPixels / displayMetrics.density;
        return dpHeight > 720.0f && dpWidth >= 728.0f;
    }

    public static int dpToPixels(Activity activity, int dpSize) {
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, "AdapterUtils dpToPixels - activity is null, returning dpSize", 3);
            return dpSize;
        }
        return (int)TypedValue.applyDimension((int)1, (float)dpSize, (DisplayMetrics)activity.getResources().getDisplayMetrics());
    }
}

