/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.logger.LogListener;
import com.ironsource.mediationsdk.logger.LoggingApi;
import com.ironsource.mediationsdk.sdk.BannerAdapterApi;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.BaseApi;
import com.ironsource.mediationsdk.sdk.InterstitialAdapterApi;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialApi;
import com.ironsource.mediationsdk.sdk.RewardedInterstitialListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoAdapterApi;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public abstract class AbstractAdapter
implements BaseApi,
InterstitialAdapterApi,
RewardedVideoAdapterApi,
BannerAdapterApi,
LoggingApi,
RewardedInterstitialApi {
    private IronSourceLoggerManager mLoggerManager = IronSourceLoggerManager.getLogger();
    protected RewardedVideoSmashListener mActiveRewardedVideoSmash;
    protected CopyOnWriteArrayList<RewardedVideoSmashListener> mAllRewardedVideoSmashes = new CopyOnWriteArrayList();
    protected ConcurrentHashMap<String, RewardedVideoSmashListener> mRewardedVideoPlacementToListenerMap;
    protected InterstitialSmashListener mActiveInterstitialSmash;
    protected CopyOnWriteArrayList<InterstitialSmashListener> mAllInterstitialSmashes = new CopyOnWriteArrayList();
    protected ConcurrentHashMap<String, InterstitialSmashListener> mInterstitialPlacementToListenerMap;
    protected BannerSmashListener mActiveBannerSmash;
    protected CopyOnWriteArrayList<BannerSmashListener> mAllBannerSmashes = new CopyOnWriteArrayList();
    protected ConcurrentHashMap<String, BannerSmashListener> mBannerPlacementToListenerMap;
    private String mPluginType;
    private String mPluginFrameworkVersion;
    private String mProviderName;
    protected RewardedInterstitialListener mRewardedInterstitial;
    private Boolean mAdapterDebug;

    public void earlyInit(Activity activity, String appKey, String userId, JSONObject config) {
    }

    public void initInterstitialForBidding(Activity activity, String appKey, String userId, JSONObject config, InterstitialSmashListener listener) {
    }

    public void initRvForBidding(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
    }

    public void initRvForDemandOnly(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
    }

    public void loadVideo(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
    }

    public void loadVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener) {
    }

    public void loadVideoForDemandOnly(JSONObject config, RewardedVideoSmashListener listener, String serverData) {
    }

    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener, String serverData) {
    }

    public Map<String, Object> getIsBiddingData(JSONObject config) {
        return null;
    }

    public Map<String, Object> getRvBiddingData(JSONObject config) {
        return null;
    }

    public AbstractAdapter(String providerName) {
        this.mRewardedVideoPlacementToListenerMap = new ConcurrentHashMap();
        this.mInterstitialPlacementToListenerMap = new ConcurrentHashMap();
        this.mBannerPlacementToListenerMap = new ConcurrentHashMap();
        this.mProviderName = providerName;
    }

    public String getProviderName() {
        return this.mProviderName;
    }

    protected String getDynamicUserId() {
        return IronSourceObject.getInstance().getDynamicUserId();
    }

    void setPluginData(String pluginType, String pluginFrameworkVersion) {
        this.mPluginType = pluginType;
        this.mPluginFrameworkVersion = pluginFrameworkVersion;
    }

    public String getPluginType() {
        return this.mPluginType;
    }

    public String getPluginFrameworkVersion() {
        return this.mPluginFrameworkVersion;
    }

    protected void log(IronSourceLogger.IronSourceTag tag, String message, int logLevel) {
        this.mLoggerManager.onLog(tag, message, logLevel);
    }

    public abstract String getVersion();

    public abstract String getCoreSDKVersion();

    @Override
    public void setLogListener(LogListener logListener) {
    }

    @Override
    public void setRewardedInterstitialListener(RewardedInterstitialListener listener) {
        this.mRewardedInterstitial = listener;
    }

    protected boolean isAdaptersDebugEnabled() {
        return this.mAdapterDebug != null && this.mAdapterDebug != false;
    }

    @Override
    public void initBanners(Activity activity, String appKey, String userId, JSONObject config, BannerSmashListener listener) {
    }

    @Override
    public void loadBanner(IronSourceBannerLayout banner, JSONObject config, BannerSmashListener listener) {
    }

    @Override
    public void destroyBanner(JSONObject config) {
    }

    @Override
    public void reloadBanner(JSONObject config) {
    }

    @Override
    public boolean shouldBindBannerViewOnReload() {
        return false;
    }

    protected void addBannerListener(BannerSmashListener listener) {
    }

    protected void removeBannerListener(BannerSmashListener listener) {
    }

    @Override
    public void addRewardedVideoListener(RewardedVideoSmashListener listener) {
        this.mAllRewardedVideoSmashes.add(listener);
    }

    @Override
    public void removeRewardedVideoListener(RewardedVideoSmashListener listener) {
        this.mAllRewardedVideoSmashes.remove(listener);
    }

    @Override
    public void addInterstitialListener(InterstitialSmashListener listener) {
        this.mAllInterstitialSmashes.add(listener);
    }

    @Override
    public void removeInterstitialListener(InterstitialSmashListener listener) {
        this.mAllInterstitialSmashes.remove(listener);
    }

    public void onResume(Activity activity) {
    }

    public void onPause(Activity activity) {
    }

    public void setAge(int age) {
    }

    public void setGender(String gender) {
    }

    @Override
    public void setMediationSegment(String segment) {
    }

    protected void setMediationState(AbstractSmash.MEDIATION_STATE state, String adUnit) {
    }

    protected void setConsent(boolean consent) {
    }

    protected void setAdapterDebug(Boolean adapterDebug) {
        this.mAdapterDebug = adapterDebug;
    }

    protected void setMetaData(String key, String value) {
    }
}

