/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import com.ironsource.environment.ApplicationContext;
import com.ironsource.environment.DeviceStatus;
import com.ironsource.mediationsdk.AuctionEventListener;
import com.ironsource.mediationsdk.AuctionResponseItem;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.utils.AuctionSettings;
import com.ironsource.mediationsdk.utils.IronSourceAES;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuctionHandler {
    private static final int SERVER_REQUEST_TIMEOUT = 15000;
    private final String AUCTION_PRICE_MACRO = "${AUCTION_PRICE}";
    private final String AUCTION_LOSS_MACRO = "${AUCTION_LOSS}";
    private final String AUCTION_INTERNAL_ERROR_LOSS_CODE = "1";
    private final String AUCTION_NOT_HIGHEST_RTB_BIDDER_LOSS_CODE = "102";
    private final String AUCTION_LOST_TO_NON_BIDDER_LOSS_CODE = "103";
    private String mAdUnit;
    private String mSessionId;
    private AuctionSettings mSettings;
    private AuctionEventListener mAuctionListener;

    public AuctionHandler(String adUnit, AuctionSettings auctionSettings, AuctionEventListener listener) {
        this.mAdUnit = adUnit;
        this.mSettings = auctionSettings;
        this.mAuctionListener = listener;
        this.mSessionId = IronSourceObject.getInstance().getSessionId();
    }

    public void executeAuction(Context context, Map<String, Object> bidders, List<String> nonBidders, int sessionDepth) {
        try {
            boolean isEncryptedResponse = IronSourceUtils.getSerr() == 1;
            JSONObject requestData = this.generateRequest(context, bidders, nonBidders, sessionDepth, isEncryptedResponse);
            AuctionHttpRequestTask task = new AuctionHttpRequestTask(this.mAuctionListener);
            task.execute(new Object[]{this.mSettings.getUrl(), requestData, isEncryptedResponse, this.mSettings.getNumOfMaxTrials(), this.mSettings.getTrialsInterval()});
        }
        catch (Exception e2) {
            this.mAuctionListener.onAuctionFailed(1000, e2.getMessage(), 0, "other", 0L);
        }
    }

    public void reportImpression(AuctionResponseItem responseItem) {
        for (String url : responseItem.getBurls()) {
            new ImpressionHttpTask().execute(new String[]{url});
        }
    }

    public void reportLoadSuccess(AuctionResponseItem responseItem) {
        for (String url : responseItem.getNurls()) {
            new ImpressionHttpTask().execute(new String[]{url});
        }
    }

    public void reportAuctionLose(CopyOnWriteArrayList<ProgSmash> waterfall, ConcurrentHashMap<String, AuctionResponseItem> waterfallServerData, AuctionResponseItem winnerInstance) {
        String price = winnerInstance.getPrice();
        boolean reachedWinningInstanceOnWaterfall = false;
        boolean isWinnerBidder = false;
        for (ProgSmash smash : waterfall) {
            String smashInstanceName = smash.getInstanceName();
            if (smashInstanceName.equals(winnerInstance.getInstanceName())) {
                reachedWinningInstanceOnWaterfall = true;
                isWinnerBidder = smash.isBidder();
                continue;
            }
            AuctionResponseItem instance = waterfallServerData.get(smashInstanceName);
            String loseReasonCode = reachedWinningInstanceOnWaterfall ? (isWinnerBidder ? "102" : "103") : "1";
            for (String url : instance.getLurls()) {
                String modifiedURL = url.replace("${AUCTION_PRICE}", price);
                modifiedURL = modifiedURL.replace("${AUCTION_LOSS}", loseReasonCode);
                new ImpressionHttpTask().execute(new String[]{modifiedURL});
            }
        }
    }

    private JSONObject generateRequest(Context context, Map<String, Object> bidders, List<String> nonBidders, int sessionDepth, boolean isEncryptedResponse) throws JSONException {
        JSONObject instances = new JSONObject();
        for (String instance : bidders.keySet()) {
            JSONObject bidderObject = new JSONObject();
            bidderObject.put("instanceType", 2);
            bidderObject.put("biddingAdditionalData", (Object)new JSONObject((Map)bidders.get(instance)));
            instances.put(instance, (Object)bidderObject);
        }
        for (String instance : nonBidders) {
            JSONObject nonbBidderObject = new JSONObject();
            nonbBidderObject.put("instanceType", 1);
            instances.put(instance, (Object)nonbBidderObject);
        }
        JSONObject clientParams = new JSONObject();
        clientParams.put("applicationUserId", (Object)IronSourceObject.getInstance().getIronSourceUserId());
        String gender = IronSourceObject.getInstance().getGender();
        if (TextUtils.isEmpty((CharSequence)gender)) {
            gender = "unknown";
        }
        clientParams.put("applicationUserGender", (Object)gender);
        Integer age = IronSourceObject.getInstance().getAge();
        if (age == null) {
            age = -1;
        }
        clientParams.put("applicationUserAge", (Object)age);
        Boolean consent = IronSourceObject.getInstance().getConsent();
        if (consent != null) {
            clientParams.put("consent", consent != false ? 1 : 0);
        }
        clientParams.put("mobileCarrier", (Object)DeviceStatus.getMobileCarrier(context));
        clientParams.put("connectionType", (Object)IronSourceUtils.getConnectionType(context));
        clientParams.put("deviceOS", (Object)"android");
        clientParams.put("deviceWidth", context.getResources().getConfiguration().screenWidthDp);
        clientParams.put("deviceHeight", context.getResources().getConfiguration().screenHeightDp);
        clientParams.put("deviceOSVersion", (Object)(Build.VERSION.SDK_INT + "(" + Build.VERSION.RELEASE + ")"));
        clientParams.put("deviceModel", (Object)Build.MODEL);
        clientParams.put("deviceMake", (Object)Build.MANUFACTURER);
        clientParams.put("bundleId", (Object)context.getPackageName());
        clientParams.put("appVersion", (Object)ApplicationContext.getPublisherApplicationVersion(context, context.getPackageName()));
        clientParams.put("clientTimestamp", new Date().getTime());
        String advertisingId = "";
        String advertisingIdType = "";
        boolean isLimitAdTrackingEnabled = false;
        try {
            String[] advertisingIdInfo = DeviceStatus.getAdvertisingIdInfo(context);
            if (advertisingIdInfo != null && advertisingIdInfo.length == 2) {
                if (!TextUtils.isEmpty((CharSequence)advertisingIdInfo[0])) {
                    advertisingId = advertisingIdInfo[0];
                }
                isLimitAdTrackingEnabled = Boolean.valueOf(advertisingIdInfo[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
            advertisingIdType = "GAID";
        } else {
            advertisingId = DeviceStatus.getOrGenerateOnceUniqueIdentifier(context);
            if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
                advertisingIdType = "UUID";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)advertisingId)) {
            clientParams.put("advId", (Object)advertisingId);
            clientParams.put("advIdType", (Object)advertisingIdType);
            clientParams.put("isLimitAdTrackingEnabled", (Object)(isLimitAdTrackingEnabled ? "true" : "false"));
        }
        JSONObject ret = new JSONObject();
        ret.put("adUnit", (Object)this.mAdUnit);
        ret.put("auctionData", (Object)this.mSettings.getAuctionData());
        ret.put("applicationKey", (Object)IronSourceObject.getInstance().getIronSourceAppKey());
        ret.put("SDKVersion", (Object)IronSourceUtils.getSDKVersion());
        ret.put("clientParams", (Object)clientParams);
        ret.put("sessionDepth", sessionDepth);
        ret.put("sessionId", (Object)this.mSessionId);
        ret.put("doNotEncryptResponse", (Object)(isEncryptedResponse ? "false" : "true"));
        ret.put("instances", (Object)instances);
        return ret;
    }

    static class ImpressionHttpTask
    extends AsyncTask<String, Void, Boolean> {
        ImpressionHttpTask() {
        }

        protected Boolean doInBackground(String ... objects) {
            try {
                URL url = new URL(objects[0]);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.setReadTimeout(15000);
                urlConnection.setConnectTimeout(15000);
                urlConnection.connect();
                int httpResponseCode = urlConnection.getResponseCode();
                urlConnection.disconnect();
                return httpResponseCode == 200;
            }
            catch (Exception e2) {
                return false;
            }
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
        }
    }

    static class AuctionHttpRequestTask
    extends AsyncTask<Object, Void, Boolean> {
        private WeakReference<AuctionEventListener> mAuctionListener;
        private JSONObject mRequestData;
        private int mErrorCode;
        private String mErrorMessage;
        private String mAuctionId;
        private List<AuctionResponseItem> mWaterfall;
        private long mRequestStartTime;
        private int mCurrentAuctionTrial;
        private String mAuctionFallback = "other";

        AuctionHttpRequestTask(AuctionEventListener listener) {
            this.mAuctionListener = new WeakReference<AuctionEventListener>(listener);
        }

        protected Boolean doInBackground(Object ... objects) {
            long auctionTrialTimeout;
            int auctionMaxTrials;
            boolean isEncryptedResponse;
            URL auctionURL;
            this.mRequestStartTime = new Date().getTime();
            HttpURLConnection urlConnection = null;
            try {
                auctionURL = new URL((String)objects[0]);
                this.mRequestData = (JSONObject)objects[1];
                isEncryptedResponse = (Boolean)objects[2];
                auctionMaxTrials = (Integer)objects[3];
                auctionTrialTimeout = (Long)objects[4];
            }
            catch (Exception e2) {
                this.mErrorCode = 1007;
                this.mErrorMessage = e2.getMessage();
                this.mCurrentAuctionTrial = 0;
                this.mAuctionFallback = "other";
                return false;
            }
            this.mCurrentAuctionTrial = 0;
            while (this.mCurrentAuctionTrial < auctionMaxTrials) {
                block12: {
                    try {
                        long startTimeOfCurrentTrial = new Date().getTime();
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Auction Handler: auction trial " + (this.mCurrentAuctionTrial + 1) + " out of " + auctionMaxTrials + " max trials", 0);
                        urlConnection = this.prepareAuctionRequest(auctionURL, auctionTrialTimeout);
                        this.sendAuctionRequest(urlConnection, this.mRequestData);
                        int httpResponseCode = urlConnection.getResponseCode();
                        if (httpResponseCode != 200) {
                            this.mErrorCode = 1001;
                            this.mErrorMessage = String.valueOf(httpResponseCode);
                            urlConnection.disconnect();
                            if (this.mCurrentAuctionTrial < auctionMaxTrials - 1) {
                                this.waitUntilNextTrial(auctionTrialTimeout, startTimeOfCurrentTrial);
                            }
                            break block12;
                        }
                        String responseStr = this.readResponse(urlConnection);
                        try {
                            this.handleResponse(responseStr, isEncryptedResponse);
                        }
                        catch (JSONException e3) {
                            this.mErrorCode = 1002;
                            this.mErrorMessage = "failed parsing auction response";
                            this.mAuctionFallback = "parsing";
                            urlConnection.disconnect();
                            return false;
                        }
                        urlConnection.disconnect();
                        return true;
                    }
                    catch (SocketTimeoutException e4) {
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        this.mErrorCode = 1006;
                        this.mErrorMessage = "Connection timed out";
                    }
                    catch (Exception e5) {
                        if (urlConnection != null) {
                            urlConnection.disconnect();
                        }
                        this.mErrorCode = 1000;
                        this.mErrorMessage = e5.getMessage();
                        this.mAuctionFallback = "other";
                        return false;
                    }
                }
                ++this.mCurrentAuctionTrial;
            }
            this.mCurrentAuctionTrial = auctionMaxTrials - 1;
            this.mAuctionFallback = "trials_fail";
            return false;
        }

        private void waitUntilNextTrial(long auctionTrialTimeout, long startTimeOfCurrentTrial) {
            long timeToWaitUntilNextTrial = auctionTrialTimeout - (new Date().getTime() - startTimeOfCurrentTrial);
            if (timeToWaitUntilNextTrial > 0L) {
                SystemClock.sleep((long)timeToWaitUntilNextTrial);
            }
        }

        private void sendAuctionRequest(HttpURLConnection urlConnection, JSONObject requestData) throws IOException {
            OutputStream outputStream = urlConnection.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            BufferedWriter writer = new BufferedWriter(outputStreamWriter);
            String body = requestData.toString();
            body = IronSourceAES.encode("C38FB23A402222A0C17D34A92F971D1F", body);
            body = String.format("{\"request\" : \"%1$s\"}", body);
            writer.write(body);
            writer.flush();
            writer.close();
            outputStreamWriter.close();
            outputStream.close();
        }

        private HttpURLConnection prepareAuctionRequest(URL auctionURL, long trialTimeout) throws IOException {
            int timeout = (int)trialTimeout;
            HttpURLConnection urlConnection = (HttpURLConnection)auctionURL.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            urlConnection.setReadTimeout(timeout);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            return urlConnection;
        }

        private void handleResponse(String responseStr, boolean isEncryptedResponse) throws JSONException {
            if (TextUtils.isEmpty((CharSequence)responseStr)) {
                throw new JSONException("empty response");
            }
            JSONObject jsonObj = new JSONObject(responseStr);
            if (isEncryptedResponse) {
                String encryptedStr = jsonObj.getString("response");
                jsonObj = new JSONObject(IronSourceAES.decode("C38FB23A402222A0C17D34A92F971D1F", encryptedStr));
            }
            this.mAuctionId = jsonObj.getString("auctionId");
            this.mWaterfall = new ArrayList<AuctionResponseItem>();
            JSONArray waterfall = jsonObj.getJSONArray("waterfall");
            for (int i = 0; i < waterfall.length(); ++i) {
                AuctionResponseItem item = new AuctionResponseItem(waterfall.getJSONObject(i));
                if (!item.isValid()) {
                    this.mErrorCode = 1002;
                    this.mErrorMessage = "waterfall " + i;
                    throw new JSONException("invalid response");
                }
                this.mWaterfall.add(item);
            }
        }

        private String readResponse(HttpURLConnection urlConnection) throws IOException {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
            BufferedReader reader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            reader.close();
            inputStreamReader.close();
            return stringBuilder.toString();
        }

        protected void onPostExecute(Boolean isSuccess) {
            AuctionEventListener listener = (AuctionEventListener)this.mAuctionListener.get();
            if (listener == null) {
                return;
            }
            long elapsedTime = new Date().getTime() - this.mRequestStartTime;
            if (isSuccess.booleanValue()) {
                listener.onAuctionSuccess(this.mWaterfall, this.mAuctionId, this.mCurrentAuctionTrial + 1, elapsedTime);
            } else {
                listener.onAuctionFailed(this.mErrorCode, this.mErrorMessage, this.mCurrentAuctionTrial + 1, this.mAuctionFallback, elapsedTime);
            }
        }
    }
}

