/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import com.ironsource.sdk.utils.MD5Hashing;
import java.security.MessageDigest;
import java.util.UUID;

final class SecureMessagingService {
    private static final String SECURE_HASHING_ALGORITHM = "MD5";
    private String mTokenForMessaging;

    SecureMessagingService(String tokenForMessaging) {
        this.mTokenForMessaging = tokenForMessaging;
    }

    static String generateToken() {
        return UUID.randomUUID().toString();
    }

    private String hashMessage(String value) {
        String messageHash = "";
        try {
            messageHash = MD5Hashing.getHashString(value);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            messageHash = this.hashWithDigest(value);
        }
        return messageHash;
    }

    private String hashWithDigest(String value) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(SECURE_HASHING_ALGORITHM);
            messageDigest.update(value.getBytes());
            byte[] digest = messageDigest.digest();
            return this.formatDigestToString(digest);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    private String formatDigestToString(byte[] digest) throws Exception {
        StringBuilder hexString = new StringBuilder();
        for (byte messageDigestByte : digest) {
            String letter = Integer.toHexString(0xFF & messageDigestByte);
            if (letter.length() < 2) {
                letter = "0" + letter;
            }
            hexString.append(letter);
        }
        return hexString.toString();
    }

    boolean isValidMessage(String functionName, String parameters, String hash) {
        try {
            String hashedMessage = this.hashMessage(functionName + parameters + this.mTokenForMessaging);
            return hash.equalsIgnoreCase(hashedMessage);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    String getTokenForMessaging() {
        return this.mTokenForMessaging;
    }
}

