/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.ironsource.sdk.ISNAdView.ISNAdView;
import com.ironsource.sdk.controller.ControllerEventListener;
import com.ironsource.sdk.controller.IronSourceController;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.listeners.OnOfferWallListener;
import com.ironsource.sdk.listeners.internals.DSBannerListener;
import com.ironsource.sdk.listeners.internals.DSInterstitialListener;
import com.ironsource.sdk.listeners.internals.DSRewardedVideoListener;
import java.util.Map;
import org.json.JSONObject;

public class NativeController
implements IronSourceController {
    private String mFailedControllerReason = "";
    private OnOfferWallListener mOfferwallListener;
    private static final Handler mUiHandler = new Handler(Looper.getMainLooper());

    NativeController(final ControllerEventListener controllerListener) {
        mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                controllerListener.handleControllerStageReady();
            }
        });
    }

    void setFailedControllerReason(String failureReason) {
        this.mFailedControllerReason = failureReason;
    }

    @Override
    public void initOfferWall(String applicationKey, String userId, Map<String, String> extraParameters, OnOfferWallListener listener) {
        if (listener != null) {
            this.mOfferwallListener = listener;
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    NativeController.this.mOfferwallListener.onOfferwallInitFail(NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void showOfferWall(Map<String, String> extraParameters) {
        if (this.mOfferwallListener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    NativeController.this.mOfferwallListener.onOWShowFail(NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void getOfferWallCredits(String applicationKey, String userId, final OnOfferWallListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onGetOWCreditsFailed(NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void initRewardedVideo(String applicationKey, String userId, final DemandSource demandSource, final DSRewardedVideoListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onAdProductInitFailed(SSAEnums.ProductType.RewardedVideo, demandSource.getDemandSourceName(), NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void showRewardedVideo(final JSONObject showParams, final DSRewardedVideoListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onRVShowFail(showParams.optString("demandSourceName"), NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void initInterstitial(String applicationKey, String userId, final DemandSource demandSource, final DSInterstitialListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onAdProductInitFailed(SSAEnums.ProductType.Interstitial, demandSource.getDemandSourceName(), NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void loadInterstitial(final String demandSourceName, final DSInterstitialListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onInterstitialLoadFailed(demandSourceName, NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void loadInterstitial(final DemandSource demandSource, Map<String, String> loadParams, final DSInterstitialListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onInterstitialLoadFailed(demandSource.getDemandSourceName(), NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void showInterstitial(final JSONObject showParams, final DSInterstitialListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onInterstitialShowFailed(showParams.optString("demandSourceName"), NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void showInterstitial(final DemandSource demandSource, Map<String, String> showParams, final DSInterstitialListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onInterstitialShowFailed(demandSource.getDemandSourceName(), NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public boolean isInterstitialAdAvailable(String demandSourceName) {
        return false;
    }

    @Override
    public void initBanner(String applicationKey, String userId, DemandSource demandSource, DSBannerListener listener) {
        if (listener != null) {
            listener.onAdProductInitFailed(SSAEnums.ProductType.Banner, demandSource.getDemandSourceName(), this.mFailedControllerReason);
        }
    }

    @Override
    public void loadBanner(final JSONObject loadParams, final DSBannerListener listener) {
        if (listener != null) {
            mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onBannerLoadFail(loadParams.optString("demandSourceName"), NativeController.this.mFailedControllerReason);
                }
            });
        }
    }

    @Override
    public void updateConsentInfo(JSONObject consentParams) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void enterBackground() {
    }

    @Override
    public void enterForeground() {
    }

    @Override
    public void registerConnectionReceiver(Context context) {
    }

    @Override
    public void unregisterConnectionReceiver(Context context) {
    }

    @Override
    public void setCommunicationWithAdView(ISNAdView isnAdView) {
    }

    @Override
    public void restoreSavedState() {
    }
}

