/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk.model;

import com.ironsource.mediationsdk.model.ApplicationEvents;
import com.ironsource.mediationsdk.model.BannerPlacement;
import java.util.ArrayList;

public class BannerConfigurations {
    private ApplicationEvents mBNEvents;
    private int mBNAdaptersSmartLoadAmount;
    private long mBNAdaptersTimeoutInMilliseconds;
    private ArrayList<BannerPlacement> mBNPlacements;
    private static final int DEFAULT_BN_PLACEMENT_ID = 0;
    private BannerPlacement mDefaultBNPlacement;
    private int mBNRefreshInterval;
    private int mBNDelayLoadFailureNotificationInSeconds;

    public BannerConfigurations() {
        this.mBNEvents = new ApplicationEvents();
        this.mBNPlacements = new ArrayList();
    }

    public BannerConfigurations(int adaptersSmartLoadAmount, long adaptersSmartLoadTimeoutInMillis, ApplicationEvents events, int refreshInterval, int delayLoadFailure) {
        this.mBNPlacements = new ArrayList();
        this.mBNAdaptersSmartLoadAmount = adaptersSmartLoadAmount;
        this.mBNAdaptersTimeoutInMilliseconds = adaptersSmartLoadTimeoutInMillis;
        this.mBNEvents = events;
        this.mBNRefreshInterval = refreshInterval;
        this.mBNDelayLoadFailureNotificationInSeconds = delayLoadFailure;
    }

    public int getBannerAdaptersSmartLoadAmount() {
        return this.mBNAdaptersSmartLoadAmount;
    }

    public long getBannerAdaptersSmartLoadTimeout() {
        return this.mBNAdaptersTimeoutInMilliseconds;
    }

    public ApplicationEvents getBannerEventsConfigurations() {
        return this.mBNEvents;
    }

    public void addBannerPlacement(BannerPlacement placement) {
        if (placement != null) {
            this.mBNPlacements.add(placement);
            if (this.mDefaultBNPlacement == null) {
                this.mDefaultBNPlacement = placement;
            } else if (placement.getPlacementId() == 0) {
                this.mDefaultBNPlacement = placement;
            }
        }
    }

    public BannerPlacement getBannerPlacement(String placementName) {
        for (BannerPlacement placement : this.mBNPlacements) {
            if (!placement.getPlacementName().equals(placementName)) continue;
            return placement;
        }
        return null;
    }

    public BannerPlacement getDefaultBannerPlacement() {
        for (BannerPlacement placement : this.mBNPlacements) {
            if (!placement.isDefault()) continue;
            return placement;
        }
        return this.mDefaultBNPlacement;
    }

    public int getBannerRefreshInterval() {
        return this.mBNRefreshInterval;
    }

    public int getBannerDelayLoadFailure() {
        return this.mBNDelayLoadFailureNotificationInSeconds;
    }
}

