/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterRepository;
import com.ironsource.mediationsdk.DemandOnlyIsSmash;
import com.ironsource.mediationsdk.ISDemandOnlyListenerWrapper;
import com.ironsource.mediationsdk.events.InterstitialEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.InterstitialConfigurations;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.DemandOnlyIsManagerListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

class DemandOnlyIsManager
implements DemandOnlyIsManagerListener {
    private ConcurrentHashMap<String, DemandOnlyIsSmash> mSmashes = new ConcurrentHashMap();

    DemandOnlyIsManager(Activity activity, List<ProviderSettings> providersList, InterstitialConfigurations configs, String appKey, String userId) {
        for (ProviderSettings provider : providersList) {
            if (provider.getProviderTypeForReflection().equalsIgnoreCase("SupersonicAds") || provider.getProviderTypeForReflection().equalsIgnoreCase("IronSource")) {
                AbstractAdapter adapter = AdapterRepository.getInstance().getAdapter(provider, provider.getRewardedVideoSettings(), activity, true);
                if (adapter == null) continue;
                DemandOnlyIsSmash smash = new DemandOnlyIsSmash(activity, appKey, userId, provider, this, configs.getInterstitialAdaptersSmartLoadTimeout(), adapter);
                this.mSmashes.put(provider.getSubProviderId(), smash);
                continue;
            }
            this.logInternal("cannot load " + provider.getProviderTypeForReflection());
        }
    }

    public void onResume(Activity activity) {
        if (activity != null) {
            for (DemandOnlyIsSmash smash : this.mSmashes.values()) {
                smash.onResume(activity);
            }
        }
    }

    public void onPause(Activity activity) {
        if (activity != null) {
            for (DemandOnlyIsSmash smash : this.mSmashes.values()) {
                smash.onPause(activity);
            }
        }
    }

    public void loadInterstitial(String instanceId) {
        try {
            if (!this.mSmashes.containsKey(instanceId)) {
                this.sendMediationEvent(2500, instanceId);
                IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Interstitial");
                ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, error);
                return;
            }
            DemandOnlyIsSmash smash = this.mSmashes.get(instanceId);
            this.sendProviderEvent(2002, smash);
            smash.loadInterstitial();
        }
        catch (Exception e2) {
            this.logInternal("loadInterstitial exception " + e2.getMessage());
            IronSourceError error = ErrorBuilder.buildLoadFailedError("loadInterstitial exception");
            ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(instanceId, error);
        }
    }

    public void showInterstitial(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(2500, instanceId);
            IronSourceError error = ErrorBuilder.buildNonExistentInstanceError("Interstitial");
            ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdShowFailed(instanceId, error);
            return;
        }
        DemandOnlyIsSmash smash = this.mSmashes.get(instanceId);
        this.sendProviderEvent(2201, smash);
        smash.showInterstitial();
    }

    public boolean isInterstitialReady(String instanceId) {
        if (!this.mSmashes.containsKey(instanceId)) {
            this.sendMediationEvent(2500, instanceId);
            return false;
        }
        DemandOnlyIsSmash smash = this.mSmashes.get(instanceId);
        if (smash.isInterstitialReady()) {
            this.sendProviderEvent(2211, smash);
            return true;
        }
        this.sendProviderEvent(2212, smash);
        return false;
    }

    @Override
    public void onInterstitialAdReady(DemandOnlyIsSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onInterstitialAdReady");
        this.sendProviderEvent(2003, smash, new Object[][]{{"duration", elapsedTime}});
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdReady(smash.getSubProviderId());
    }

    @Override
    public void onInterstitialAdLoadFailed(IronSourceError error, DemandOnlyIsSmash smash, long elapsedTime) {
        this.logSmashCallback(smash, "onInterstitialAdLoadFailed error=" + error.toString());
        this.sendProviderEvent(2200, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", elapsedTime}});
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdLoadFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onInterstitialAdOpened(DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdOpened");
        this.sendProviderEvent(2005, smash);
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdOpened(smash.getSubProviderId());
    }

    @Override
    public void onInterstitialAdClosed(DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdClosed");
        this.sendProviderEvent(2204, smash);
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdClosed(smash.getSubProviderId());
    }

    @Override
    public void onInterstitialAdShowFailed(IronSourceError error, DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdShowFailed error=" + error.toString());
        this.sendProviderEvent(2203, smash, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdShowFailed(smash.getSubProviderId(), error);
    }

    @Override
    public void onInterstitialAdClicked(DemandOnlyIsSmash smash) {
        this.logSmashCallback(smash, "onInterstitialAdClicked");
        this.sendProviderEvent(2006, smash);
        ISDemandOnlyListenerWrapper.getInstance().onInterstitialAdClicked(smash.getSubProviderId());
    }

    @Override
    public void onInterstitialAdVisible(DemandOnlyIsSmash smash) {
        this.sendProviderEvent(2210, smash);
        this.logSmashCallback(smash, "onInterstitialAdVisible");
    }

    private void sendProviderEvent(int eventId, DemandOnlyIsSmash smash) {
        this.sendProviderEvent(eventId, smash, null);
    }

    private void sendProviderEvent(int eventId, DemandOnlyIsSmash smash, Object[][] keyVals) {
        Map<String, Object> data = smash.getProviderEventData();
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS sendProviderEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    private void sendMediationEvent(int eventId, String instanceId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("provider", "Mediation");
        data.put("isDemandOnly", 1);
        data.put("spId", instanceId != null ? instanceId : "");
        EventData event = new EventData(eventId, new JSONObject(data));
        InterstitialEventsManager.getInstance().log(event);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "DemandOnlyIsManager " + text, 0);
    }

    private void logSmashCallback(DemandOnlyIsSmash smash, String line) {
        String text = "DemandOnlyIsManager " + smash.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }
}

