/*
 * Decompiled with CFR 0.152.
 */
package com.iab.omid.library.ironsrc.adsession;

import android.webkit.WebView;
import com.iab.omid.library.ironsrc.adsession.AdSessionContextType;
import com.iab.omid.library.ironsrc.adsession.Partner;
import com.iab.omid.library.ironsrc.adsession.VerificationScriptResource;
import com.iab.omid.library.ironsrc.d.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class AdSessionContext {
    private final Partner partner;
    private final WebView webView;
    private final List<VerificationScriptResource> verificationScriptResources = new ArrayList<VerificationScriptResource>();
    private final Map<String, VerificationScriptResource> injectedResourcesMap = new HashMap<String, VerificationScriptResource>();
    private final String omidJsScriptContent;
    private final String customReferenceData;
    private final AdSessionContextType adSessionContextType;

    private AdSessionContext(Partner partner, WebView webView, String string, List<VerificationScriptResource> list, String string2) {
        this.partner = partner;
        this.webView = webView;
        this.omidJsScriptContent = string;
        if (list != null) {
            this.verificationScriptResources.addAll(list);
            for (VerificationScriptResource verificationScriptResource : list) {
                String string3 = UUID.randomUUID().toString();
                this.injectedResourcesMap.put(string3, verificationScriptResource);
            }
            this.adSessionContextType = AdSessionContextType.NATIVE;
        } else {
            this.adSessionContextType = AdSessionContextType.HTML;
        }
        this.customReferenceData = string2;
    }

    public static AdSessionContext createHtmlAdSessionContext(Partner partner, WebView webView, String string) {
        e.a(partner, "Partner is null");
        e.a(webView, "WebView is null");
        if (string != null) {
            e.a(string, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, webView, null, null, string);
    }

    public static AdSessionContext createNativeAdSessionContext(Partner partner, String string, List<VerificationScriptResource> list, String string2) {
        e.a(partner, "Partner is null");
        e.a((Object)string, "OM SDK JS script content is null");
        e.a(list, "VerificationScriptResources is null");
        if (string2 != null) {
            e.a(string2, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, null, string, list, string2);
    }

    public Partner getPartner() {
        return this.partner;
    }

    public List<VerificationScriptResource> getVerificationScriptResources() {
        return Collections.unmodifiableList(this.verificationScriptResources);
    }

    public Map<String, VerificationScriptResource> getInjectedResourcesMap() {
        return Collections.unmodifiableMap(this.injectedResourcesMap);
    }

    public WebView getWebView() {
        return this.webView;
    }

    public String getCustomReferenceData() {
        return this.customReferenceData;
    }

    public String getOmidJsScriptContent() {
        return this.omidJsScriptContent;
    }

    public AdSessionContextType getAdSessionContextType() {
        return this.adSessionContextType;
    }
}

