/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.webkit.JavascriptInterface;
import com.ironsource.sdk.controller.ControllerAdapter;
import com.ironsource.sdk.controller.SecureMessagingService;
import com.ironsource.sdk.utils.Logger;
import com.ironsource.sdk.utils.SDKUtils;
import org.json.JSONException;
import org.json.JSONObject;

final class ControllerMessageHandler {
    private final ControllerAdapter mControllerAdapter;
    private final SecureMessagingService mSecurityService;
    private static final String TAG = ControllerMessageHandler.class.getCanonicalName();
    private static final String ERROR_MESSAGE_KEY_FUNCTION_NAME = "functionName";
    private static final String ERROR_MESSAGE_KEY_PARAMS = "params";
    private static final String ERROR_MESSAGE_KEY_HASH = "hash";

    ControllerMessageHandler(ControllerAdapter controllerAdapter, SecureMessagingService securityService) {
        this.mControllerAdapter = controllerAdapter;
        this.mSecurityService = securityService;
    }

    private void handleException(Exception e2) {
        e2.printStackTrace();
        Logger.i(TAG, "messageHandler failed with exception " + e2.getMessage());
    }

    private void handleValidMessage(String functionName, String params) throws Exception {
        this.mControllerAdapter.call(functionName, params);
    }

    private void handleInvalidMessage(String functionName, String params, String hash) {
        this.mControllerAdapter.sendUnauthorizedError(this.buildErrorMessage(functionName, params, hash));
    }

    private String buildErrorMessage(String functionName, String params, String hash) {
        JSONObject errorMessage = new JSONObject();
        try {
            errorMessage.put(ERROR_MESSAGE_KEY_FUNCTION_NAME, (Object)SDKUtils.encodeString(functionName));
            errorMessage.put(ERROR_MESSAGE_KEY_PARAMS, (Object)SDKUtils.encodeString(params));
            errorMessage.put(ERROR_MESSAGE_KEY_HASH, (Object)SDKUtils.encodeString(hash));
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        return errorMessage.toString();
    }

    @JavascriptInterface
    public void messageHandler(String functionName, String params, String hash) {
        try {
            Logger.i(TAG, "messageHandler(" + functionName + " " + hash + ")");
            if (this.mSecurityService.isValidMessage(functionName, params, hash)) {
                this.handleValidMessage(functionName, params);
            } else {
                this.handleInvalidMessage(functionName, params, hash);
            }
        }
        catch (Exception e2) {
            this.handleException(e2);
        }
    }
}

