/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.os.Build;
import android.webkit.JavascriptInterface;
import com.ironsource.sdk.controller.WebController;
import com.ironsource.sdk.utils.Logger;
import java.lang.reflect.Method;
import java.security.AccessControlException;

class ControllerAdapter {
    private static final String TAG = ControllerAdapter.class.getSimpleName();
    private final WebController.NativeAPI mNativeAPI;

    ControllerAdapter(WebController.NativeAPI nativeAPI) {
        this.mNativeAPI = nativeAPI;
    }

    synchronized void call(String functionName, String params) throws Exception {
        if (this.mNativeAPI == null) {
            Logger.e(TAG, "!!! nativeAPI == null !!!");
            return;
        }
        Class[] argTypes = new Class[]{String.class};
        Method method = WebController.NativeAPI.class.getDeclaredMethod(functionName, argTypes);
        if (Build.VERSION.SDK_INT >= 17 && !method.isAnnotationPresent(JavascriptInterface.class)) {
            throw new AccessControlException("Trying to access a private function: " + functionName);
        }
        method.invoke((Object)this.mNativeAPI, params);
    }

    void sendUnauthorizedError(String errorMessage) {
        if (this.mNativeAPI != null) {
            this.mNativeAPI.sendUnauthorizedError(errorMessage);
        }
    }
}

