/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.ironsource.mediationsdk.BannerSmash;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerListener;

public class IronSourceBannerLayout
extends FrameLayout {
    private View mBannerView;
    private ISBannerSize mSize;
    private String mPlacementName;
    private Activity mActivity;
    private boolean isDestroyed = false;
    private boolean mIsBannerDisplayed = false;
    private BannerListener mBannerListener;

    public IronSourceBannerLayout(Activity activity, ISBannerSize size) {
        super((Context)activity);
        this.mActivity = activity;
        if (size == null) {
            size = ISBannerSize.BANNER;
        }
        this.mSize = size;
    }

    protected void destroyBanner() {
        this.isDestroyed = true;
        this.mBannerListener = null;
        this.mActivity = null;
        this.mSize = null;
        this.mPlacementName = null;
        this.mBannerView = null;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public View getBannerView() {
        return this.mBannerView;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public ISBannerSize getSize() {
        return this.mSize;
    }

    public String getPlacementName() {
        return this.mPlacementName;
    }

    public void setPlacementName(String placementName) {
        this.mPlacementName = placementName;
    }

    public void setBannerListener(BannerListener listener) {
        String logMessage = "setBannerListener()";
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        this.mBannerListener = listener;
    }

    public void removeBannerListener() {
        String logMessage = "removeBannerListener()";
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.API, logMessage, 1);
        this.mBannerListener = null;
    }

    public BannerListener getBannerListener() {
        return this.mBannerListener;
    }

    void sendBannerAdLoaded(BannerSmash smash) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onBannerAdLoaded() | internal | adapter: " + smash.getName(), 0);
        if (this.mBannerListener != null && !this.mIsBannerDisplayed) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdLoaded()", 1);
            this.mBannerListener.onBannerAdLoaded();
        }
        this.mIsBannerDisplayed = true;
    }

    void sendBannerAdLoadFailed(final IronSourceError error) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdLoadFailed()  error=" + error, 1);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (IronSourceBannerLayout.this.mIsBannerDisplayed) {
                    IronSourceBannerLayout.this.mBannerListener.onBannerAdLoadFailed(error);
                    return;
                }
                try {
                    if (IronSourceBannerLayout.this.mBannerView != null) {
                        IronSourceBannerLayout.this.removeView(IronSourceBannerLayout.this.mBannerView);
                        IronSourceBannerLayout.this.mBannerView = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (IronSourceBannerLayout.this.mBannerListener != null) {
                    IronSourceBannerLayout.this.mBannerListener.onBannerAdLoadFailed(error);
                }
            }
        });
    }

    void sendBannerAdClicked() {
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdClicked()", 1);
            this.mBannerListener.onBannerAdClicked();
        }
    }

    void sendBannerAdScreenPresented() {
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdScreenPresented()", 1);
            this.mBannerListener.onBannerAdScreenPresented();
        }
    }

    void sendBannerAdScreenDismissed() {
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdScreenDismissed()", 1);
            this.mBannerListener.onBannerAdScreenDismissed();
        }
    }

    void sendBannerAdLeftApplication() {
        if (this.mBannerListener != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.CALLBACK, "onBannerAdLeftApplication()", 1);
            this.mBannerListener.onBannerAdLeftApplication();
        }
    }

    void addViewWithFrameLayoutParams(final View adView, final FrameLayout.LayoutParams layoutParams) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                IronSourceBannerLayout.this.removeAllViews();
                ViewParent viewParent = adView.getParent();
                if (viewParent instanceof ViewGroup) {
                    ViewGroup viewGroup = (ViewGroup)viewParent;
                    viewGroup.removeView(adView);
                }
                IronSourceBannerLayout.this.mBannerView = adView;
                IronSourceBannerLayout.this.addView(adView, 0, (ViewGroup.LayoutParams)layoutParams);
            }
        });
    }
}

