/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BaseApi;
import com.ironsource.mediationsdk.utils.DailyCappingManager;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class AbstractAdUnitManager
implements BaseApi {
    final String KEY_REASON = "reason";
    final String KEY_STATUS = "status";
    final String KEY_PLACEMENT = "placement";
    final String KEY_REWARD_NAME = "rewardName";
    final String KEY_REWARD_AMOUNT = "rewardAmount";
    final String KEY_PROVIDER_PRIORITY = "providerPriority";
    DailyCappingManager mDailyCappingManager = null;
    int mSmartLoadAmount;
    final CopyOnWriteArrayList<AbstractSmash> mSmashArray = new CopyOnWriteArrayList();
    private AbstractSmash mBackfillSmash;
    private AbstractSmash mPremiumSmash;
    Activity mActivity;
    String mUserId;
    String mAppKey;
    IronSourceLoggerManager mLoggerManager = IronSourceLoggerManager.getLogger();
    boolean mShouldTrackNetworkState = false;
    Boolean mLastMediationAvailabilityState;
    boolean mBackFillInitStarted;
    boolean mCanShowPremium = true;
    AtomicBoolean mDidImplementOnResume = new AtomicBoolean();
    AtomicBoolean mDidImplementOnPause = new AtomicBoolean();

    AbstractAdUnitManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume(Activity activity) {
        this.mDidImplementOnResume.set(true);
        if (activity != null) {
            this.mActivity = activity;
        }
        CopyOnWriteArrayList<AbstractSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            if (this.mSmashArray != null) {
                for (AbstractSmash smash : this.mSmashArray) {
                    smash.onResume(activity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPause(Activity activity) {
        this.mDidImplementOnPause.set(true);
        CopyOnWriteArrayList<AbstractSmash> copyOnWriteArrayList = this.mSmashArray;
        synchronized (copyOnWriteArrayList) {
            if (this.mSmashArray != null) {
                for (AbstractSmash smash : this.mSmashArray) {
                    smash.onPause(activity);
                }
            }
        }
    }

    @Override
    public void setMediationSegment(String segment) {
    }

    void setSmartLoadAmount(int numberOfAdaptersToLoad) {
        this.mSmartLoadAmount = numberOfAdaptersToLoad;
    }

    void addSmashToArray(AbstractSmash smash) {
        this.mSmashArray.add(smash);
        if (this.mDailyCappingManager != null) {
            this.mDailyCappingManager.addSmash(smash);
        }
    }

    abstract void shouldTrackNetworkState(Context var1, boolean var2);

    void setBackfillSmash(AbstractSmash backfill) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, backfill.getInstanceName() + " is set as backfill", 0);
        this.mBackfillSmash = backfill;
    }

    void setPremiumSmash(AbstractSmash premium) {
        this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, premium.getInstanceName() + " is set as premium", 0);
        this.mPremiumSmash = premium;
    }

    AbstractSmash getBackfillSmash() {
        return this.mBackfillSmash;
    }

    AbstractSmash getPremiumSmash() {
        return this.mPremiumSmash;
    }

    void setCustomParams(AbstractSmash smash) {
        try {
            String pluginType;
            String segment = IronSourceObject.getInstance().getMediationSegment();
            if (!TextUtils.isEmpty((CharSequence)segment)) {
                smash.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                smash.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
        }
        catch (Exception e2) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.INTERNAL, ":setCustomParams():" + e2.toString(), 3);
        }
    }

    synchronized boolean canShowPremium() {
        return this.mCanShowPremium;
    }

    synchronized void disablePremiumForCurrentSession() {
        this.mCanShowPremium = false;
    }

    void verifyOnPauseOnResume() {
        if (!this.mDidImplementOnPause.get()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "IronSource.onPause() wasn't overridden in your activity lifecycle!", 3);
        }
        if (!this.mDidImplementOnResume.get()) {
            this.mLoggerManager.log(IronSourceLogger.IronSourceTag.NATIVE, "IronSource.onResume() wasn't overridden in your activity lifecycle!", 3);
        }
    }
}

