/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.ris;

import android.app.Activity;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import com.ironsource.mediationsdk.utils.SessionDepthManager;
import com.ironsource.sdk.SSAFactory;
import com.ironsource.sdk.SSAPublisher;
import com.ironsource.sdk.data.AdUnitsReady;
import com.ironsource.sdk.listeners.OnRewardedVideoListener;
import com.ironsource.sdk.utils.SDKUtils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class RISAdapter
extends AbstractAdapter
implements OnRewardedVideoListener {
    private SSAPublisher mSSAPublisher;
    private boolean hasAdAvailable = false;
    private boolean mDidReportInitStatus = false;
    private final String DYNAMIC_CONTROLLER_URL = "controllerUrl";
    private final String DYNAMIC_CONTROLLER_DEBUG_MODE = "debugMode";
    private final String DYNAMIC_CONTROLLER_CONFIG = "controllerConfig";
    private final String AD_VISIBLE_EVENT_NAME = "impressions";
    private boolean mConsent;
    private boolean mDidSetConsent;

    public static RISAdapter startAdapter(String providerName) {
        return new RISAdapter(providerName);
    }

    private RISAdapter(String providerName) {
        super(providerName);
    }

    @Override
    public String getVersion() {
        return IronSourceUtils.getSDKVersion();
    }

    @Override
    public String getCoreSDKVersion() {
        return SDKUtils.getSDKVersion();
    }

    @Override
    public void onResume(Activity activity) {
        if (this.mSSAPublisher != null) {
            this.mSSAPublisher.onResume(activity);
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (this.mSSAPublisher != null) {
            this.mSSAPublisher.onPause(activity);
        }
    }

    @Override
    public void initRewardedVideo(Activity activity, String appKey, String userId, JSONObject config, RewardedVideoSmashListener listener) {
    }

    @Override
    public void fetchRewardedVideo(JSONObject config) {
    }

    @Override
    public boolean isRewardedVideoAvailable(JSONObject config) {
        return false;
    }

    @Override
    public void showRewardedVideo(JSONObject config, RewardedVideoSmashListener listener) {
    }

    @Override
    public void initInterstitial(final Activity activity, final String appKey, final String userId, JSONObject config, InterstitialSmashListener listener) {
        SDKUtils.setControllerUrl(config.optString("controllerUrl"));
        if (this.isAdaptersDebugEnabled()) {
            SDKUtils.setDebugMode(3);
        } else {
            SDKUtils.setDebugMode(config.optInt("debugMode", 0));
        }
        SDKUtils.setControllerConfig(config.optString("controllerConfig", ""));
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    RISAdapter.this.mSSAPublisher = SSAFactory.getPublisherInstance(activity);
                    if (RISAdapter.this.mDidSetConsent) {
                        RISAdapter.this.applyConsent(RISAdapter.this.mConsent);
                    }
                    SSAFactory.getPublisherInstance(activity).initRewardedVideo(appKey, userId, RISAdapter.this.getProviderName(), new HashMap<String, String>(), RISAdapter.this);
                }
                catch (Exception e2) {
                    RISAdapter.this.onRVInitFail(e2.getMessage());
                }
            }
        });
    }

    @Override
    public void loadInterstitial(JSONObject config, InterstitialSmashListener listener) {
        if (this.hasAdAvailable) {
            for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
                if (smash == null) continue;
                smash.onInterstitialAdReady();
            }
        } else {
            for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
                if (smash == null) continue;
                smash.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError("No Ads to Load"));
            }
        }
    }

    @Override
    public void showInterstitial(JSONObject config, InterstitialSmashListener listener) {
        this.mActiveInterstitialSmash = listener;
        if (this.mSSAPublisher != null) {
            int sessionDepth = SessionDepthManager.getInstance().getSessionDepth(2);
            JSONObject showParams = new JSONObject();
            try {
                showParams.put("demandSourceName", (Object)this.getProviderName());
                showParams.put("sessionDepth", sessionDepth);
            }
            catch (JSONException e2) {
                e2.printStackTrace();
            }
            this.mSSAPublisher.showRewardedVideo(showParams);
        } else if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowFailed(new IronSourceError(509, "Please call init before calling showRewardedVideo"));
        }
    }

    @Override
    public boolean isInterstitialReady(JSONObject config) {
        return this.hasAdAvailable;
    }

    @Override
    public void onRVInitSuccess(AdUnitsReady adUnitsReady) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVInitSuccess()", 1);
        int numOfAdUnits = 0;
        try {
            numOfAdUnits = Integer.parseInt(adUnitsReady.getNumOfAdUnits());
        }
        catch (NumberFormatException e2) {
            IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.NATIVE, "onRVInitSuccess:parseInt()", e2);
        }
        boolean bl = this.hasAdAvailable = numOfAdUnits > 0;
        if (!this.mDidReportInitStatus) {
            this.mDidReportInitStatus = true;
            for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
                if (smash == null) continue;
                smash.onInterstitialInitSuccess();
            }
        }
    }

    @Override
    public void onRVInitFail(String description) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVInitFail()", 1);
        this.hasAdAvailable = false;
        if (!this.mDidReportInitStatus) {
            this.mDidReportInitStatus = true;
            for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
                if (smash == null) continue;
                smash.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError(description, "Interstitial"));
            }
        }
    }

    @Override
    public void onRVNoMoreOffers() {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVNoMoreOffers()", 1);
        if (!this.mDidReportInitStatus) {
            this.mDidReportInitStatus = true;
            for (InterstitialSmashListener smash : this.mAllInterstitialSmashes) {
                if (smash == null) continue;
                smash.onInterstitialInitSuccess();
            }
        }
    }

    @Override
    public void onRVAdCredited(int credits) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVAdCredited()", 1);
        if (this.mRewardedInterstitial != null) {
            this.mRewardedInterstitial.onInterstitialAdRewarded();
        }
    }

    @Override
    public void onRVAdClosed() {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVAdClosed()", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdClosed();
        }
    }

    @Override
    public void onRVAdOpened() {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVAdOpened()", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowSucceeded();
            this.mActiveInterstitialSmash.onInterstitialAdOpened();
        }
    }

    @Override
    public void onRVShowFail(String description) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVShowFail()", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowFailed(new IronSourceError(509, "Show Failed"));
        }
    }

    @Override
    public void onRVAdClicked() {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRVAdClicked()", 1);
        if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdClicked();
        }
    }

    @Override
    public void onRVEventNotificationReceived(String eventName, JSONObject extData) {
        if (extData != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :onRISEventNotificationReceived: " + eventName + " extData: " + extData.toString(), 1);
            if (!TextUtils.isEmpty((CharSequence)eventName) && "impressions".equals(eventName) && this.mActiveInterstitialSmash != null) {
                this.mActiveInterstitialSmash.onInterstitialAdVisible();
            }
        }
    }

    @Override
    protected void setMediationState(AbstractSmash.MEDIATION_STATE state, String adUnit) {
        if (this.mSSAPublisher != null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " :setMediationState(RIS:(rewardedvideo)):" + adUnit + " , " + this.getProviderName() + " , " + state.getValue() + ")", 1);
            this.mSSAPublisher.setMediationState("rewardedvideo", this.getProviderName(), state.getValue());
        }
    }

    @Override
    protected void setConsent(boolean consent) {
        this.mConsent = consent;
        this.mDidSetConsent = true;
        this.applyConsent(consent);
    }

    private void applyConsent(boolean consent) {
        if (this.mSSAPublisher == null) {
            return;
        }
        JSONObject consentParams = new JSONObject();
        try {
            consentParams.put("gdprConsentStatus", (Object)String.valueOf(consent));
            consentParams.put("demandSourceName", (Object)this.getProviderName());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        this.mSSAPublisher.updateConsentInfo(consentParams);
    }
}

