/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.utils;

import java.io.UnsupportedEncodingException;

public final class MD5Hashing {
    private MD5State workingState = new MD5State();
    private MD5State finalState = new MD5State();
    private int[] decodeBuffer = new int[16];
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    MD5Hashing() {
        this.reset();
    }

    public byte[] getHash() {
        if (!this.finalState.valid) {
            this.finalState.copy(this.workingState);
            long bitCount = this.finalState.bitCount;
            int leftOver = (int)(bitCount >>> 3 & 0x3FL);
            int padlen = leftOver < 56 ? 56 - leftOver : 120 - leftOver;
            this.update(this.finalState, padding, 0, padlen);
            this.update(this.finalState, MD5Hashing.encode(bitCount), 0, 8);
            this.finalState.valid = true;
        }
        return MD5Hashing.encode(this.finalState.state, 16);
    }

    public String getHashString() {
        return MD5Hashing.toHex(this.getHash());
    }

    public static String getHashString(String s2) {
        MD5Hashing md5 = new MD5Hashing();
        md5.update(s2);
        return md5.getHashString();
    }

    public void reset() {
        this.workingState.reset();
        this.finalState.valid = false;
    }

    public String toString() {
        return this.getHashString();
    }

    private void update(MD5State state, byte[] buffer, int offset, int length) {
        this.finalState.valid = false;
        if (length + offset > buffer.length) {
            length = buffer.length - offset;
        }
        int index = (int)(state.bitCount >>> 3) & 0x3F;
        MD5State mD5State = state;
        mD5State.bitCount = mD5State.bitCount + (long)(length << 3);
        int partlen = 64 - index;
        int i2 = 0;
        if (length >= partlen) {
            System.arraycopy(buffer, offset, state.buffer, index, partlen);
            MD5Hashing.transform(state, this.decode(state.buffer, 64, 0));
            i2 = partlen;
            while (i2 + 63 < length) {
                MD5Hashing.transform(state, this.decode(buffer, 64, i2));
                i2 += 64;
            }
            index = 0;
        }
        if (i2 < length) {
            int start = i2;
            while (i2 < length) {
                ((MD5State)state).buffer[index + i2 - start] = buffer[i2 + offset];
                ++i2;
            }
        }
    }

    public void update(byte[] buffer, int offset, int length) {
        this.update(this.workingState, buffer, offset, length);
    }

    public void update(byte[] buffer, int length) {
        this.update(buffer, 0, length);
    }

    public void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    public void update(byte b2) {
        byte[] buffer = new byte[]{b2};
        this.update(buffer, 1);
    }

    public void update(String s2) {
        this.update(s2.getBytes());
    }

    public void update(String s2, String enc) throws UnsupportedEncodingException {
        this.update(s2.getBytes(enc));
    }

    private static String toHex(byte[] hash) {
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (byte element : hash) {
            int intVal = element & 0xFF;
            if (intVal < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(intVal));
        }
        return buf.toString();
    }

    private static int FF(int a2, int b2, int c2, int d2, int x2, int s2, int ac) {
        a2 += b2 & c2 | ~b2 & d2;
        a2 += x2;
        a2 += ac;
        a2 = a2 << s2 | a2 >>> 32 - s2;
        return a2 + b2;
    }

    private static int GG(int a2, int b2, int c2, int d2, int x2, int s2, int ac) {
        a2 += b2 & d2 | c2 & ~d2;
        a2 += x2;
        a2 += ac;
        a2 = a2 << s2 | a2 >>> 32 - s2;
        return a2 + b2;
    }

    private static int HH(int a2, int b2, int c2, int d2, int x2, int s2, int ac) {
        a2 += b2 ^ c2 ^ d2;
        a2 += x2;
        a2 += ac;
        a2 = a2 << s2 | a2 >>> 32 - s2;
        return a2 + b2;
    }

    private static int II(int a2, int b2, int c2, int d2, int x2, int s2, int ac) {
        a2 += c2 ^ (b2 | ~d2);
        a2 += x2;
        a2 += ac;
        a2 = a2 << s2 | a2 >>> 32 - s2;
        return a2 + b2;
    }

    private static byte[] encode(long l2) {
        byte[] out = new byte[]{(byte)(l2 & 0xFFL), (byte)(l2 >>> 8 & 0xFFL), (byte)(l2 >>> 16 & 0xFFL), (byte)(l2 >>> 24 & 0xFFL), (byte)(l2 >>> 32 & 0xFFL), (byte)(l2 >>> 40 & 0xFFL), (byte)(l2 >>> 48 & 0xFFL), (byte)(l2 >>> 56 & 0xFFL)};
        return out;
    }

    private static byte[] encode(int[] input, int len) {
        byte[] out = new byte[len];
        int i2 = 0;
        for (int j2 = 0; j2 < len; j2 += 4) {
            out[j2] = (byte)(input[i2] & 0xFF);
            out[j2 + 1] = (byte)(input[i2] >>> 8 & 0xFF);
            out[j2 + 2] = (byte)(input[i2] >>> 16 & 0xFF);
            out[j2 + 3] = (byte)(input[i2] >>> 24 & 0xFF);
            ++i2;
        }
        return out;
    }

    private int[] decode(byte[] buffer, int len, int offset) {
        int i2 = 0;
        for (int j2 = 0; j2 < len; j2 += 4) {
            this.decodeBuffer[i2] = buffer[j2 + offset] & 0xFF | (buffer[j2 + 1 + offset] & 0xFF) << 8 | (buffer[j2 + 2 + offset] & 0xFF) << 16 | (buffer[j2 + 3 + offset] & 0xFF) << 24;
            ++i2;
        }
        return this.decodeBuffer;
    }

    private static void transform(MD5State state, int[] x2) {
        int a2 = state.state[0];
        int b2 = state.state[1];
        int c2 = state.state[2];
        int d2 = state.state[3];
        a2 = MD5Hashing.FF(a2, b2, c2, d2, x2[0], 7, -680876936);
        d2 = MD5Hashing.FF(d2, a2, b2, c2, x2[1], 12, -389564586);
        c2 = MD5Hashing.FF(c2, d2, a2, b2, x2[2], 17, 606105819);
        b2 = MD5Hashing.FF(b2, c2, d2, a2, x2[3], 22, -1044525330);
        a2 = MD5Hashing.FF(a2, b2, c2, d2, x2[4], 7, -176418897);
        d2 = MD5Hashing.FF(d2, a2, b2, c2, x2[5], 12, 1200080426);
        c2 = MD5Hashing.FF(c2, d2, a2, b2, x2[6], 17, -1473231341);
        b2 = MD5Hashing.FF(b2, c2, d2, a2, x2[7], 22, -45705983);
        a2 = MD5Hashing.FF(a2, b2, c2, d2, x2[8], 7, 1770035416);
        d2 = MD5Hashing.FF(d2, a2, b2, c2, x2[9], 12, -1958414417);
        c2 = MD5Hashing.FF(c2, d2, a2, b2, x2[10], 17, -42063);
        b2 = MD5Hashing.FF(b2, c2, d2, a2, x2[11], 22, -1990404162);
        a2 = MD5Hashing.FF(a2, b2, c2, d2, x2[12], 7, 1804603682);
        d2 = MD5Hashing.FF(d2, a2, b2, c2, x2[13], 12, -40341101);
        c2 = MD5Hashing.FF(c2, d2, a2, b2, x2[14], 17, -1502002290);
        b2 = MD5Hashing.FF(b2, c2, d2, a2, x2[15], 22, 1236535329);
        a2 = MD5Hashing.GG(a2, b2, c2, d2, x2[1], 5, -165796510);
        d2 = MD5Hashing.GG(d2, a2, b2, c2, x2[6], 9, -1069501632);
        c2 = MD5Hashing.GG(c2, d2, a2, b2, x2[11], 14, 643717713);
        b2 = MD5Hashing.GG(b2, c2, d2, a2, x2[0], 20, -373897302);
        a2 = MD5Hashing.GG(a2, b2, c2, d2, x2[5], 5, -701558691);
        d2 = MD5Hashing.GG(d2, a2, b2, c2, x2[10], 9, 38016083);
        c2 = MD5Hashing.GG(c2, d2, a2, b2, x2[15], 14, -660478335);
        b2 = MD5Hashing.GG(b2, c2, d2, a2, x2[4], 20, -405537848);
        a2 = MD5Hashing.GG(a2, b2, c2, d2, x2[9], 5, 568446438);
        d2 = MD5Hashing.GG(d2, a2, b2, c2, x2[14], 9, -1019803690);
        c2 = MD5Hashing.GG(c2, d2, a2, b2, x2[3], 14, -187363961);
        b2 = MD5Hashing.GG(b2, c2, d2, a2, x2[8], 20, 1163531501);
        a2 = MD5Hashing.GG(a2, b2, c2, d2, x2[13], 5, -1444681467);
        d2 = MD5Hashing.GG(d2, a2, b2, c2, x2[2], 9, -51403784);
        c2 = MD5Hashing.GG(c2, d2, a2, b2, x2[7], 14, 1735328473);
        b2 = MD5Hashing.GG(b2, c2, d2, a2, x2[12], 20, -1926607734);
        a2 = MD5Hashing.HH(a2, b2, c2, d2, x2[5], 4, -378558);
        d2 = MD5Hashing.HH(d2, a2, b2, c2, x2[8], 11, -2022574463);
        c2 = MD5Hashing.HH(c2, d2, a2, b2, x2[11], 16, 1839030562);
        b2 = MD5Hashing.HH(b2, c2, d2, a2, x2[14], 23, -35309556);
        a2 = MD5Hashing.HH(a2, b2, c2, d2, x2[1], 4, -1530992060);
        d2 = MD5Hashing.HH(d2, a2, b2, c2, x2[4], 11, 1272893353);
        c2 = MD5Hashing.HH(c2, d2, a2, b2, x2[7], 16, -155497632);
        b2 = MD5Hashing.HH(b2, c2, d2, a2, x2[10], 23, -1094730640);
        a2 = MD5Hashing.HH(a2, b2, c2, d2, x2[13], 4, 681279174);
        d2 = MD5Hashing.HH(d2, a2, b2, c2, x2[0], 11, -358537222);
        c2 = MD5Hashing.HH(c2, d2, a2, b2, x2[3], 16, -722521979);
        b2 = MD5Hashing.HH(b2, c2, d2, a2, x2[6], 23, 76029189);
        a2 = MD5Hashing.HH(a2, b2, c2, d2, x2[9], 4, -640364487);
        d2 = MD5Hashing.HH(d2, a2, b2, c2, x2[12], 11, -421815835);
        c2 = MD5Hashing.HH(c2, d2, a2, b2, x2[15], 16, 530742520);
        b2 = MD5Hashing.HH(b2, c2, d2, a2, x2[2], 23, -995338651);
        a2 = MD5Hashing.II(a2, b2, c2, d2, x2[0], 6, -198630844);
        d2 = MD5Hashing.II(d2, a2, b2, c2, x2[7], 10, 1126891415);
        c2 = MD5Hashing.II(c2, d2, a2, b2, x2[14], 15, -1416354905);
        b2 = MD5Hashing.II(b2, c2, d2, a2, x2[5], 21, -57434055);
        a2 = MD5Hashing.II(a2, b2, c2, d2, x2[12], 6, 1700485571);
        d2 = MD5Hashing.II(d2, a2, b2, c2, x2[3], 10, -1894986606);
        c2 = MD5Hashing.II(c2, d2, a2, b2, x2[10], 15, -1051523);
        b2 = MD5Hashing.II(b2, c2, d2, a2, x2[1], 21, -2054922799);
        a2 = MD5Hashing.II(a2, b2, c2, d2, x2[8], 6, 1873313359);
        d2 = MD5Hashing.II(d2, a2, b2, c2, x2[15], 10, -30611744);
        c2 = MD5Hashing.II(c2, d2, a2, b2, x2[6], 15, -1560198380);
        b2 = MD5Hashing.II(b2, c2, d2, a2, x2[13], 21, 1309151649);
        a2 = MD5Hashing.II(a2, b2, c2, d2, x2[4], 6, -145523070);
        d2 = MD5Hashing.II(d2, a2, b2, c2, x2[11], 10, -1120210379);
        c2 = MD5Hashing.II(c2, d2, a2, b2, x2[2], 15, 718787259);
        b2 = MD5Hashing.II(b2, c2, d2, a2, x2[9], 21, -343485551);
        int[] nArray = state.state;
        nArray[0] = nArray[0] + a2;
        int[] nArray2 = state.state;
        nArray2[1] = nArray2[1] + b2;
        int[] nArray3 = state.state;
        nArray3[2] = nArray3[2] + c2;
        int[] nArray4 = state.state;
        nArray4[3] = nArray4[3] + d2;
    }

    private class MD5State {
        private boolean valid = true;
        private int[] state = new int[4];
        private long bitCount;
        private byte[] buffer = new byte[64];

        private void reset() {
            this.state[0] = 1732584193;
            this.state[1] = -271733879;
            this.state[2] = -1732584194;
            this.state[3] = 271733878;
            this.bitCount = 0L;
        }

        private MD5State() {
            this.reset();
        }

        private void copy(MD5State from) {
            System.arraycopy(from.buffer, 0, this.buffer, 0, this.buffer.length);
            System.arraycopy(from.state, 0, this.state, 0, this.state.length);
            this.valid = from.valid;
            this.bitCount = from.bitCount;
        }
    }
}

