/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.sdk.controller;

import android.text.TextUtils;
import com.ironsource.sdk.IronSourceAdInstance;
import com.ironsource.sdk.data.DemandSource;
import com.ironsource.sdk.data.SSAEnums;
import com.ironsource.sdk.listeners.OnAdProductListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DemandSourceManager {
    private Map<String, DemandSource> mRewardedVideoDemandSourceMap = new LinkedHashMap<String, DemandSource>();
    private Map<String, DemandSource> mInterstitialDemandSourceMap = new LinkedHashMap<String, DemandSource>();
    private Map<String, DemandSource> mBannerDemandSourceMap = new LinkedHashMap<String, DemandSource>();

    private Map<String, DemandSource> getMapByProductType(SSAEnums.ProductType productType) {
        if (productType.name().equalsIgnoreCase(SSAEnums.ProductType.RewardedVideo.name())) {
            return this.mRewardedVideoDemandSourceMap;
        }
        if (productType.name().equalsIgnoreCase(SSAEnums.ProductType.Interstitial.name())) {
            return this.mInterstitialDemandSourceMap;
        }
        if (productType.name().equalsIgnoreCase(SSAEnums.ProductType.Banner.name())) {
            return this.mBannerDemandSourceMap;
        }
        return null;
    }

    public Collection<DemandSource> getDemandSources(SSAEnums.ProductType productType) {
        Map<String, DemandSource> productDemandMap = this.getMapByProductType(productType);
        if (productDemandMap != null) {
            return productDemandMap.values();
        }
        return new ArrayList<DemandSource>();
    }

    public DemandSource getDemandSourceById(SSAEnums.ProductType productType, String instanceId) {
        Map<String, DemandSource> productDemandMap;
        if (!TextUtils.isEmpty((CharSequence)instanceId) && (productDemandMap = this.getMapByProductType(productType)) != null) {
            return productDemandMap.get(instanceId);
        }
        return null;
    }

    private void addDemandSourceToDemandSources(SSAEnums.ProductType productType, String demandSourceId, DemandSource demandSource) {
        Map<String, DemandSource> productDemandMap;
        if (!TextUtils.isEmpty((CharSequence)demandSourceId) && demandSource != null && (productDemandMap = this.getMapByProductType(productType)) != null) {
            productDemandMap.put(demandSourceId, demandSource);
        }
    }

    public DemandSource createDemandSource(SSAEnums.ProductType productType, IronSourceAdInstance adInstance) {
        String id = adInstance.getId();
        DemandSource demandSource = new DemandSource(id, adInstance.getName(), adInstance.convertToMap(), adInstance.getAdListener());
        this.addDemandSourceToDemandSources(productType, id, demandSource);
        return demandSource;
    }

    public DemandSource createDemandSource(SSAEnums.ProductType type, String demandSourceName, Map<String, String> demandExtParam, OnAdProductListener listener) {
        String id = demandSourceName;
        DemandSource demandSource = new DemandSource(id, demandSourceName, demandExtParam, listener);
        this.addDemandSourceToDemandSources(type, id, demandSource);
        return demandSource;
    }
}

