/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuctionResponseItem {
    private String mInstanceName;
    private String mServerData;
    private String mPrice;
    private List<String> mBurls;
    private List<String> mLurls;
    private List<String> mNurls;
    private boolean mIsValid;

    public AuctionResponseItem(String instanceName) {
        this.mInstanceName = instanceName;
        this.mServerData = "";
        this.mPrice = "";
        this.mBurls = new ArrayList<String>();
        this.mLurls = new ArrayList<String>();
        this.mNurls = new ArrayList<String>();
        this.mIsValid = true;
    }

    public AuctionResponseItem(JSONObject json) {
        this.mIsValid = false;
        try {
            int i2;
            this.mInstanceName = json.getString("instance");
            this.mServerData = json.has("adMarkup") ? json.getString("adMarkup") : "";
            this.mPrice = json.has("price") ? json.getString("price") : "0";
            JSONObject notifications = json.optJSONObject("notifications");
            this.mBurls = new ArrayList<String>();
            if (notifications.has("burl")) {
                JSONArray burls = notifications.getJSONArray("burl");
                for (i2 = 0; i2 < burls.length(); ++i2) {
                    this.mBurls.add(burls.getString(i2));
                }
            }
            this.mLurls = new ArrayList<String>();
            if (notifications.has("lurl")) {
                JSONArray lurls = notifications.getJSONArray("lurl");
                for (i2 = 0; i2 < lurls.length(); ++i2) {
                    this.mLurls.add(lurls.getString(i2));
                }
            }
            this.mNurls = new ArrayList<String>();
            if (notifications.has("nurl")) {
                JSONArray nurls = notifications.getJSONArray("nurl");
                for (i2 = 0; i2 < nurls.length(); ++i2) {
                    this.mNurls.add(nurls.getString(i2));
                }
            }
        }
        catch (Exception e2) {
            return;
        }
        this.mIsValid = true;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public String getServerData() {
        return this.mServerData;
    }

    public String getPrice() {
        return this.mPrice;
    }

    public List<String> getBurls() {
        return this.mBurls;
    }

    public List<String> getLurls() {
        return this.mLurls;
    }

    public List<String> getNurls() {
        return this.mNurls;
    }

    public boolean isValid() {
        return this.mIsValid;
    }
}

