/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.ProviderSettings;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class AdapterRepository {
    private static AdapterRepository mInstance = new AdapterRepository();
    private static final Object lock = new Object();
    private ConcurrentHashMap<String, AbstractAdapter> adapters;
    private String mAppKey;
    private String mUserId;
    private Boolean mConsent;
    private AtomicBoolean mDidIronSourceEarlyInit = new AtomicBoolean(false);

    public static AdapterRepository getInstance() {
        return mInstance;
    }

    private AdapterRepository() {
        this.adapters = new ConcurrentHashMap();
    }

    public void setInitParams(String ironSourceAppKey, String ironSourceUserId) {
        this.mAppKey = ironSourceAppKey;
        this.mUserId = ironSourceUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsent(boolean consent) {
        Object object = lock;
        synchronized (object) {
            this.mConsent = consent;
            for (AbstractAdapter adapter : this.adapters.values()) {
                this.setConsent(adapter);
            }
        }
    }

    private void setConsent(AbstractAdapter adapter) {
        try {
            if (this.mConsent != null) {
                adapter.setConsent(this.mConsent);
            }
        }
        catch (Throwable t2) {
            this.logInternal("error while setting consent of " + adapter.getProviderName() + ": " + t2.getLocalizedMessage());
            t2.printStackTrace();
        }
    }

    public AbstractAdapter getAdapter(ProviderSettings settings, JSONObject config, Activity activity) {
        String name = settings.isMultipleInstances() ? settings.getProviderTypeForReflection() : settings.getProviderName();
        String reflectionName = settings.getProviderTypeForReflection();
        return this.getAdapterInternal(name, reflectionName, config, activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAdapter getAdapterInternal(String name, String reflectionName, JSONObject config, Activity activity) {
        this.logInternal(name + " (" + reflectionName + ") - Getting adapter");
        Object object = lock;
        synchronized (object) {
            if (this.adapters.containsKey(name)) {
                this.logInternal(name + " was already allocated");
                return this.adapters.get(name);
            }
            AbstractAdapter adapter = this.getAdapterByReflection(name, reflectionName);
            if (adapter == null) {
                this.logErrorInternal(name + " adapter was not loaded");
                return null;
            }
            this.logInternal(name + " was allocated (adapter version: " + adapter.getVersion() + ", sdk version: " + adapter.getCoreSDKVersion() + ")");
            adapter.setLogListener(IronSourceLoggerManager.getLogger());
            this.earlyInitAdapter(config, adapter, reflectionName, activity);
            this.setConsent(adapter);
            this.adapters.put(name, adapter);
            return adapter;
        }
    }

    private void earlyInitAdapter(JSONObject config, AbstractAdapter adapter, String reflectionName, Activity activity) {
        if ((reflectionName.equalsIgnoreCase("SupersonicAds") || reflectionName.equalsIgnoreCase("IronSource")) && this.mDidIronSourceEarlyInit.compareAndSet(false, true)) {
            this.logInternal("SDK5 earlyInit  <" + reflectionName + ">");
            adapter.earlyInit(activity, this.mAppKey, this.mUserId, config);
        }
    }

    private AbstractAdapter getAdapterByReflection(String name, String reflectionName) {
        try {
            Class<?> adapterClass = Class.forName("com.ironsource.adapters." + reflectionName.toLowerCase() + "." + reflectionName + "Adapter");
            Method startAdapterMethod = adapterClass.getMethod("startAdapter", String.class);
            return (AbstractAdapter)startAdapterMethod.invoke(adapterClass, name);
        }
        catch (Exception e2) {
            this.logErrorInternal("Error while loading adapter: " + e2.getLocalizedMessage());
            return null;
        }
    }

    private void logErrorInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AdapterRepository: " + text, 3);
    }

    private void logInternal(String text) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AdapterRepository: " + text, 0);
    }
}

