/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.mediationsdk;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.ironsource.eventsmodule.EventData;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AbstractSmash;
import com.ironsource.mediationsdk.IronSourceObject;
import com.ironsource.mediationsdk.ProgRvManagerListener;
import com.ironsource.mediationsdk.ProgSmash;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.events.RewardedVideoEventsManager;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.model.AdapterConfig;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.model.ProviderSettings;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class ProgRvSmash
extends ProgSmash
implements RewardedVideoSmashListener {
    private SMASH_STATE mState;
    private ProgRvManagerListener mListener;
    private Timer mTimer;
    private int mLoadTimeoutSecs;
    private Activity mActivity;
    private String mAppKey;
    private String mUserId;
    private String mAuctionServerDataToLoad;
    private boolean mShouldLoadAfterClose;
    private boolean mShouldLoadAfterLoad;
    private boolean mIsShowCandidate;
    private Placement mCurrentPlacement;
    private long mLoadStartTime;
    private String mCurrentAuctionId;
    private String mAuctionIdToLoad;
    private int mAuctionTrial;
    private String mAuctionFallback;
    private int mAuctionTrialToLoad;
    private String mAuctionFallbackToLoad;
    private final Object mTimerLock = new Object();
    private final Object mStateLock = new Object();

    public ProgRvSmash(Activity activity, String appKey, String userId, ProviderSettings settings, ProgRvManagerListener listener, int loadTimeoutSecs, AbstractAdapter adapter) {
        super(new AdapterConfig(settings, settings.getRewardedVideoSettings()), adapter);
        this.mState = SMASH_STATE.NO_INIT;
        this.mActivity = activity;
        this.mAppKey = appKey;
        this.mUserId = userId;
        this.mListener = listener;
        this.mTimer = null;
        this.mLoadTimeoutSecs = loadTimeoutSecs;
        this.mAdapter.addRewardedVideoListener(this);
        this.mShouldLoadAfterClose = false;
        this.mShouldLoadAfterLoad = false;
        this.mIsShowCandidate = false;
        this.mCurrentPlacement = null;
        this.mCurrentAuctionId = "";
        this.resetAuctionParams();
    }

    private void resetAuctionParams() {
        this.mAuctionIdToLoad = "";
        this.mAuctionTrialToLoad = -1;
        this.mAuctionFallbackToLoad = "";
        this.mAuctionServerDataToLoad = "";
    }

    public boolean isReadyToBid() {
        return this.mState != SMASH_STATE.NO_INIT && this.mState != SMASH_STATE.INIT_IN_PROGRESS;
    }

    public boolean isLoadingInProgress() {
        return this.mState == SMASH_STATE.INIT_IN_PROGRESS || this.mState == SMASH_STATE.LOAD_IN_PROGRESS;
    }

    public Map<String, Object> getBiddingData() {
        return this.isBidder() ? this.mAdapter.getRvBiddingData(this.mAdUnitSettings) : null;
    }

    public void initForBidding() {
        this.logInternal("initForBidding()");
        this.setState(SMASH_STATE.INIT_IN_PROGRESS);
        this.setCustomParams();
        this.mAdapter.initRvForBidding(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
    }

    public void unloadVideo() {
        if (this.isBidder()) {
            this.mIsShowCandidate = false;
        }
    }

    public boolean isReadyToShow() {
        if (this.isBidder()) {
            return this.mIsShowCandidate && this.mState == SMASH_STATE.LOADED && this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
        }
        return this.mAdapter.isRewardedVideoAvailable(this.mAdUnitSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVideo(String serverData, String auctionId, int auctionTrial, String auctionFallback) {
        SMASH_STATE currentState;
        this.logInternal("loadVideo() auctionId: " + auctionId + " state: " + (Object)((Object)this.mState));
        this.setIsLoadCandidate(false);
        this.mIsShowCandidate = true;
        Object object = this.mStateLock;
        synchronized (object) {
            currentState = this.mState;
            if (this.mState != SMASH_STATE.LOAD_IN_PROGRESS && this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                this.setState(SMASH_STATE.LOAD_IN_PROGRESS);
            }
        }
        if (currentState == SMASH_STATE.LOAD_IN_PROGRESS) {
            this.mShouldLoadAfterLoad = true;
            this.updateFutureAuctionData(serverData, auctionId, auctionTrial, auctionFallback);
            this.mListener.onLoadError(this, auctionId);
            return;
        }
        if (currentState == SMASH_STATE.SHOW_IN_PROGRESS) {
            this.mShouldLoadAfterClose = true;
            this.updateFutureAuctionData(serverData, auctionId, auctionTrial, auctionFallback);
            return;
        }
        this.mCurrentAuctionId = auctionId;
        this.mAuctionTrial = auctionTrial;
        this.mAuctionFallback = auctionFallback;
        this.startLoadTimer();
        this.mLoadStartTime = new Date().getTime();
        this.sendProviderEvent(1001);
        if (this.isBidder()) {
            this.mAdapter.loadVideo(this.mAdUnitSettings, this, serverData);
            return;
        }
        if (currentState == SMASH_STATE.NO_INIT) {
            this.setCustomParams();
            this.mAdapter.initRewardedVideo(this.mActivity, this.mAppKey, this.mUserId, this.mAdUnitSettings, this);
            return;
        }
        this.mAdapter.fetchRewardedVideo(this.mAdUnitSettings);
    }

    public void reportShowChance(boolean status) {
        this.sendProviderEventWithPlacement(1209, new Object[][]{{"status", status ? "true" : "false"}});
    }

    public void showVideo(Placement placement) {
        this.stopLoadTimer();
        this.logInternal("showVideo()");
        this.mCurrentPlacement = placement;
        this.setState(SMASH_STATE.SHOW_IN_PROGRESS);
        this.mAdapter.showRewardedVideo(this.mAdUnitSettings, this);
        this.sendProviderEventWithPlacement(1201);
    }

    public void setCappedPerSession() {
        this.mAdapter.setMediationState(AbstractSmash.MEDIATION_STATE.CAPPED_PER_SESSION, "rewardedvideo");
        this.sendProviderEvent(1401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(SMASH_STATE state) {
        this.logInternal("current state=" + (Object)((Object)this.mState) + ", new state=" + (Object)((Object)state));
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = state;
        }
    }

    private void setCustomParams() {
        try {
            Boolean consent;
            String pluginType;
            String segment;
            String gender;
            Integer age = IronSourceObject.getInstance().getAge();
            if (age != null) {
                this.mAdapter.setAge(age);
            }
            if (!TextUtils.isEmpty((CharSequence)(gender = IronSourceObject.getInstance().getGender()))) {
                this.mAdapter.setGender(gender);
            }
            if (!TextUtils.isEmpty((CharSequence)(segment = IronSourceObject.getInstance().getMediationSegment()))) {
                this.mAdapter.setMediationSegment(segment);
            }
            if (!TextUtils.isEmpty((CharSequence)(pluginType = ConfigFile.getConfigFile().getPluginType()))) {
                this.mAdapter.setPluginData(pluginType, ConfigFile.getConfigFile().getPluginFrameworkVersion());
            }
            if ((consent = IronSourceObject.getInstance().getConsent()) != null) {
                this.logInternal("setConsent(" + consent + ")");
                this.mAdapter.setConsent(consent);
            }
        }
        catch (Exception e2) {
            this.logInternal("setCustomParams() " + e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAvailabilityChanged(boolean available) {
        this.stopLoadTimer();
        this.logAdapterCallback("onRewardedVideoAvailabilityChanged available=" + available + " state=" + this.mState.name());
        boolean isWrongSmashState = false;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState == SMASH_STATE.LOAD_IN_PROGRESS) {
                this.setState(available ? SMASH_STATE.LOADED : SMASH_STATE.NOT_LOADED);
            } else {
                isWrongSmashState = true;
            }
        }
        if (isWrongSmashState) {
            if (available) {
                this.sendProviderEvent(1207);
            } else {
                this.sendProviderEvent(1208, new Object[][]{{"errorCode", 1034}, {"duration", this.getElapsedTime()}});
            }
            return;
        }
        this.sendProviderEvent(available ? 1002 : 1200, new Object[][]{{"duration", this.getElapsedTime()}});
        if (this.mShouldLoadAfterLoad) {
            this.mShouldLoadAfterLoad = false;
            this.logInternal("onRewardedVideoAvailabilityChanged to " + available + "and mShouldLoadAfterLoad is true - calling loadVideo");
            this.loadVideo(this.mAuctionServerDataToLoad, this.mAuctionIdToLoad, this.mAuctionTrialToLoad, this.mAuctionFallbackToLoad);
            this.resetAuctionParams();
            return;
        }
        if (available) {
            this.mListener.onLoadSuccess(this, this.mCurrentAuctionId);
        } else {
            this.mListener.onLoadError(this, this.mCurrentAuctionId);
        }
    }

    @Override
    public void onRewardedVideoLoadSuccess() {
    }

    @Override
    public void onRewardedVideoLoadFailed(IronSourceError error) {
        this.sendProviderEvent(1212, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", this.getElapsedTime()}});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdShowFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoAdShowFailed error=" + error.getErrorMessage());
        this.sendProviderEventWithPlacement(1202, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}});
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                return;
            }
            this.setState(SMASH_STATE.NOT_LOADED);
        }
        this.mListener.onRewardedVideoAdShowFailed(error, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitSuccess() {
        this.logAdapterCallback("onRewardedVideoInitSuccess");
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
                return;
            }
            this.setState(SMASH_STATE.NOT_LOADED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoInitFailed(IronSourceError error) {
        this.logAdapterCallback("onRewardedVideoInitFailed error=" + error.getErrorMessage());
        this.stopLoadTimer();
        this.sendProviderEvent(1200, new Object[][]{{"errorCode", 1033}, {"duration", this.getElapsedTime()}});
        this.sendProviderEvent(1212, new Object[][]{{"errorCode", error.getErrorCode()}, {"reason", error.getErrorMessage()}, {"duration", this.getElapsedTime()}});
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.INIT_IN_PROGRESS) {
                return;
            }
            this.setState(SMASH_STATE.NO_INIT);
        }
        this.mListener.onLoadError(this, this.mCurrentAuctionId);
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.logAdapterCallback("onRewardedVideoAdOpened");
        this.mListener.onRewardedVideoAdOpened(this);
        this.sendProviderEventWithPlacement(1005);
    }

    @Override
    public void onRewardedVideoAdStarted() {
        this.logAdapterCallback("onRewardedVideoAdStarted");
        this.mListener.onRewardedVideoAdStarted(this);
        this.sendProviderEventWithPlacement(1204);
    }

    @Override
    public void onRewardedVideoAdVisible() {
        this.logAdapterCallback("onRewardedVideoAdVisible");
        this.sendProviderEventWithPlacement(1206);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRewardedVideoAdClosed() {
        this.logAdapterCallback("onRewardedVideoAdClosed");
        this.sendProviderEventWithPlacement(1203);
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != SMASH_STATE.SHOW_IN_PROGRESS) {
                return;
            }
            this.setState(SMASH_STATE.NOT_LOADED);
        }
        this.mListener.onRewardedVideoAdClosed(this);
        if (this.mShouldLoadAfterClose) {
            this.logInternal("onRewardedVideoAdClosed and mShouldLoadAfterClose is true - calling loadVideo");
            this.mShouldLoadAfterClose = false;
            this.loadVideo(this.mAuctionServerDataToLoad, this.mAuctionIdToLoad, this.mAuctionTrialToLoad, this.mAuctionFallbackToLoad);
            this.resetAuctionParams();
        }
    }

    @Override
    public void onRewardedVideoAdEnded() {
        this.logAdapterCallback("onRewardedVideoAdEnded");
        this.mListener.onRewardedVideoAdEnded(this);
        this.sendProviderEventWithPlacement(1205);
    }

    @Override
    public void onRewardedVideoAdRewarded() {
        this.logAdapterCallback("onRewardedVideoAdRewarded");
        this.mListener.onRewardedVideoAdRewarded(this, this.mCurrentPlacement);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"placement", this.mCurrentPlacement.getPlacementName()});
        data.add(new Object[]{"rewardName", this.mCurrentPlacement.getRewardName()});
        data.add(new Object[]{"rewardAmount", this.mCurrentPlacement.getRewardAmount()});
        String transId = Long.toString(new Date().getTime()) + this.mAppKey + this.getInstanceName();
        data.add(new Object[]{"transId", IronSourceUtils.getTransId(transId)});
        if (!TextUtils.isEmpty((CharSequence)IronSourceObject.getInstance().getDynamicUserId())) {
            data.add(new Object[]{"dynamicUserId", IronSourceObject.getInstance().getDynamicUserId()});
        }
        if (IronSourceObject.getInstance().getRvServerParams() != null) {
            for (String key : IronSourceObject.getInstance().getRvServerParams().keySet()) {
                data.add(new Object[]{"custom_" + key, IronSourceObject.getInstance().getRvServerParams().get(key)});
            }
        }
        this.sendProviderEvent(1010, (Object[][])data.toArray((T[])new Object[2][data.size()]));
    }

    @Override
    public void onRewardedVideoAdClicked() {
        this.logAdapterCallback("onRewardedVideoAdClicked");
        this.mListener.onRewardedVideoAdClicked(this, this.mCurrentPlacement);
        this.sendProviderEventWithPlacement(1006);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLoadTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
    }

    private long getElapsedTime() {
        return new Date().getTime() - this.mLoadStartTime;
    }

    private void updateFutureAuctionData(String serverData, String auctionId, int auctionTrial, String auctionFallback) {
        this.mAuctionIdToLoad = auctionId;
        this.mAuctionServerDataToLoad = serverData;
        this.mAuctionTrialToLoad = auctionTrial;
        this.mAuctionFallbackToLoad = auctionFallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadTimer() {
        Object object = this.mTimerLock;
        synchronized (object) {
            this.stopLoadTimer();
            this.mTimer = new Timer();
            this.mTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgRvSmash.this.logInternal("Rewarded Video - load instance time out");
                    boolean shouldInvokeCallback = false;
                    int errorCode = 510;
                    Object object = ProgRvSmash.this.mStateLock;
                    synchronized (object) {
                        if (ProgRvSmash.this.mState == SMASH_STATE.LOAD_IN_PROGRESS || ProgRvSmash.this.mState == SMASH_STATE.INIT_IN_PROGRESS) {
                            ProgRvSmash.this.setState(SMASH_STATE.NOT_LOADED);
                            errorCode = ProgRvSmash.this.mState == SMASH_STATE.LOAD_IN_PROGRESS ? 1025 : 1032;
                            shouldInvokeCallback = true;
                        }
                    }
                    if (shouldInvokeCallback) {
                        ProgRvSmash.this.sendProviderEvent(1200, new Object[][]{{"errorCode", errorCode}, {"duration", ProgRvSmash.this.getElapsedTime()}});
                        ProgRvSmash.this.sendProviderEvent(1212, new Object[][]{{"errorCode", errorCode}, {"duration", ProgRvSmash.this.getElapsedTime()}});
                        ProgRvSmash.this.mListener.onLoadError(ProgRvSmash.this, ProgRvSmash.this.mCurrentAuctionId);
                    } else {
                        ProgRvSmash.this.sendProviderEvent(1208, new Object[][]{{"errorCode", 1025}, {"duration", ProgRvSmash.this.getElapsedTime()}});
                    }
                }
            }, this.mLoadTimeoutSecs * 1000);
        }
    }

    private void logAdapterCallback(String line) {
        String text = "ProgRvSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, text, 0);
    }

    private void logInternal(String line) {
        String text = "ProgRvSmash " + this.getInstanceName() + " : " + line;
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, text, 0);
    }

    private void sendProviderEventWithPlacement(int eventId) {
        this.sendProviderEventWithPlacement(eventId, null);
    }

    private void sendProviderEventWithPlacement(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, true);
    }

    private void sendProviderEvent(int eventId) {
        this.sendProviderEvent(eventId, null, false);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals) {
        this.sendProviderEvent(eventId, keyVals, false);
    }

    private void sendProviderEvent(int eventId, Object[][] keyVals, boolean isAddPlacement) {
        Map<String, Object> data = this.getProviderEventData();
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAuctionId)) {
            data.put("auctionId", this.mCurrentAuctionId);
        }
        if (isAddPlacement && this.mCurrentPlacement != null && !TextUtils.isEmpty((CharSequence)this.mCurrentPlacement.getPlacementName())) {
            data.put("placement", this.mCurrentPlacement.getPlacementName());
        }
        if (this.shouldAddAuctionParams(eventId)) {
            RewardedVideoEventsManager.getInstance().setEventAuctionParams(data, this.mAuctionTrial, this.mAuctionFallback);
        }
        try {
            if (keyVals != null) {
                for (Object[] pair : keyVals) {
                    data.put(pair[0].toString(), pair[1]);
                }
            }
        }
        catch (Exception e2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getInstanceName() + " smash: RV sendMediationEvent " + Log.getStackTraceString((Throwable)e2), 3);
        }
        EventData event = new EventData(eventId, new JSONObject(data));
        RewardedVideoEventsManager.getInstance().log(event);
    }

    private boolean shouldAddAuctionParams(int eventId) {
        return eventId == 1001 || eventId == 1002 || eventId == 1200 || eventId == 1005 || eventId == 1203 || eventId == 1201 || eventId == 1202 || eventId == 1006 || eventId == 1010;
    }

    protected static enum SMASH_STATE {
        NO_INIT,
        INIT_IN_PROGRESS,
        NOT_LOADED,
        LOAD_IN_PROGRESS,
        LOADED,
        SHOW_IN_PROGRESS;

    }
}

