/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.signature;

import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Signature_Api;
import com.ironsoftware.ironpdf.signature.Signature;
import com.ironsoftware.ironpdf.signature.SignaturePermissions;
import com.ironsoftware.ironpdf.signature.VerifiedSignature;
import java.util.ArrayList;
import java.util.List;

public class SignatureManager {
    private final InternalPdfDocument internalPdfDocument;

    public SignatureManager(InternalPdfDocument internalPdfDocument) {
        this.internalPdfDocument = internalPdfDocument;
    }

    public List<VerifiedSignature> getVerifiedSignature() {
        return Signature_Api.getVerifiedSignatures(this.internalPdfDocument);
    }

    public void SignPdfWithSignature(Signature signature) {
        this.SignPdfWithSignature(signature, SignaturePermissions.NoChangesAllowed);
    }

    public void SignPdfWithSignature(Signature signature, SignaturePermissions permissions) {
        int index;
        signature.internalIndex = index = Signature_Api.signPdfWithSignatureFile(this.internalPdfDocument, signature, permissions);
        this.internalPdfDocument.signatures.add(signature);
    }

    public boolean VerifyPdfSignatures() {
        return Signature_Api.verifyPdfSignatures(this.internalPdfDocument);
    }

    public void RemoveSignature() {
        this.internalPdfDocument.signatures = new ArrayList<Signature>();
        Signature_Api.removeSignature(this.internalPdfDocument);
    }
}

