/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.render;

import com.ironsoftware.ironpdf.exception.IronPdfInputException;
import com.ironsoftware.ironpdf.internal.staticapi.HtmlValidator;
import com.ironsoftware.ironpdf.render.WaitForType;

public class WaitFor {
    public static final int DefaultMaxWaitTime = 10000;
    public static final int DefaultRenderDelayDuration = 20;
    private WaitForType Type;
    private int Timeout;
    private int NetworkIdleDuration;
    private int NumAllowedInFlight;
    private int RenderDelayDuration;
    private String HtmlElementQueryStr;

    public final WaitForType getType() {
        return this.Type;
    }

    private void setType(WaitForType value) {
        this.Type = value;
    }

    public final int getTimeout() {
        return this.Timeout;
    }

    private void setTimeout(int value) {
        this.Timeout = value;
    }

    public final int getNetworkIdleDuration() {
        return this.NetworkIdleDuration;
    }

    private void setNetworkIdleDuration(int value) {
        this.NetworkIdleDuration = value;
    }

    public final int getNumAllowedInFlight() {
        return this.NumAllowedInFlight;
    }

    private void setNumAllowedInFlight(int value) {
        this.NumAllowedInFlight = value;
    }

    public final int getRenderDelayDuration() {
        return this.RenderDelayDuration;
    }

    private void setRenderDelayDuration(int value) {
        this.RenderDelayDuration = value;
    }

    public final String getHtmlElementQueryStr() {
        return this.HtmlElementQueryStr;
    }

    private void setHtmlElementQueryStr(String value) {
        this.HtmlElementQueryStr = value;
    }

    public WaitFor(int maxWaitTime) {
        this(maxWaitTime, 20);
    }

    public WaitFor() {
        this(10000, 20);
    }

    public WaitFor(int maxWaitTime, int renderDelay) {
        this.setType(WaitForType.RenderDelay);
        this.setTimeout(maxWaitTime);
        this.setNetworkIdleDuration(500);
        this.setNumAllowedInFlight(0);
        this.setRenderDelayDuration(renderDelay);
        this.setHtmlElementQueryStr(null);
    }

    public WaitFor(WaitForType type, int maxWaitTime, int networkIdleDuration, int numAllowedInflight, int renderDelayDuration, String htmlElementQueryStr) {
        this.setType(type);
        this.setTimeout(maxWaitTime);
        this.setNetworkIdleDuration(networkIdleDuration);
        this.setNumAllowedInFlight(numAllowedInflight);
        this.setRenderDelayDuration(renderDelayDuration);
        this.setHtmlElementQueryStr(htmlElementQueryStr);
    }

    public final void PageLoad() {
        this.setType(WaitForType.None);
        this.setTimeout(10000);
        this.setNetworkIdleDuration(500);
        this.setNumAllowedInFlight(0);
        this.setRenderDelayDuration(0);
        this.setHtmlElementQueryStr(null);
    }

    public final void RenderDelay(int delay) {
        this.setType(WaitForType.RenderDelay);
        this.setTimeout(10000);
        this.setNetworkIdleDuration(500);
        this.setNumAllowedInFlight(0);
        this.setRenderDelayDuration(delay);
        this.setHtmlElementQueryStr(null);
    }

    public final void JavaScript() {
        this.JavaScript(10000);
    }

    public final void JavaScript(int maxWaitTime) {
        this.setType(WaitForType.ManualTrigger);
        this.setTimeout(maxWaitTime);
        this.setNetworkIdleDuration(500);
        this.setNumAllowedInFlight(0);
        this.setRenderDelayDuration(0);
        this.setHtmlElementQueryStr(null);
    }

    public final void NetworkIdle0() {
        this.NetworkIdle0(10000);
    }

    public final void NetworkIdle0(int maxWaitTime) {
        this.setType(WaitForType.NetworkIdle0);
        this.setTimeout(maxWaitTime);
        this.setNetworkIdleDuration(500);
        this.setNumAllowedInFlight(0);
        this.setRenderDelayDuration(0);
        this.setHtmlElementQueryStr(null);
    }

    public final void NetworkIdle2() {
        this.NetworkIdle2(10000);
    }

    public final void NetworkIdle2(int maxWaitTime) {
        this.setType(WaitForType.NetworkIdle2);
        this.setTimeout(maxWaitTime);
        this.setNetworkIdleDuration(500);
        this.setNumAllowedInFlight(2);
        this.setRenderDelayDuration(0);
        this.setHtmlElementQueryStr(null);
    }

    public final void NetworkIdle(int networkIdleDuration, int maxNumAllowedInflight) {
        this.NetworkIdle(networkIdleDuration, maxNumAllowedInflight, 10000);
    }

    public final void NetworkIdle(int networkIdleDuration, int maxNumAllowedInflight, int maxWaitTime) {
        this.Type = WaitForType.NetworkIdleN;
        this.Timeout = maxWaitTime;
        this.NetworkIdleDuration = networkIdleDuration;
        this.NumAllowedInFlight = maxNumAllowedInflight;
        this.RenderDelayDuration = 0;
        this.HtmlElementQueryStr = null;
    }

    public final void HtmlQuerySelector(String htmlQueryStr) {
        this.HtmlQuerySelector(htmlQueryStr, 10000);
    }

    public final void HtmlQuerySelector(String htmlQueryStr, int maxWaitTime) {
        this.Type = WaitForType.HtmlElement;
        this.Timeout = maxWaitTime;
        this.NetworkIdleDuration = 500;
        this.NumAllowedInFlight = 0;
        this.RenderDelayDuration = 0;
        this.HtmlElementQueryStr = htmlQueryStr;
    }

    public final void HtmlElementById(String id) {
        this.HtmlElementById(id, 10000);
    }

    public final void HtmlElementById(String id, int maxWaitTime) {
        if (!HtmlValidator.ValidateHtmlNameAndIdToken(id)) {
            throw new IronPdfInputException("Invalid input of name or Id.. It must begin with a letter ([A-Za-z]) and may be followed by any number of letters, digits ([0-9]), hyphens (\"-\"), underscores (\"_\"), colons (\":\"), and periods (\".\").");
        }
        this.HtmlQuerySelector(String.format("#%1$s", id), maxWaitTime);
    }

    public final void HtmlElementByName(String name) {
        this.HtmlElementByName(name, 10000);
    }

    public final void HtmlElementByName(String name, int maxWaitTime) {
        if (!HtmlValidator.ValidateHtmlNameAndIdToken(name)) {
            throw new IronPdfInputException("Invalid input of name or Id.. It must begin with a letter ([A-Za-z]) and may be followed by any number of letters, digits ([0-9]), hyphens (\"-\"), underscores (\"_\"), colons (\":\"), and periods (\".\").");
        }
        this.HtmlQuerySelector(String.format("[name='%1$s']", name), maxWaitTime);
    }

    public final void HtmlElementByTagName(String tagName) {
        this.HtmlElementByTagName(tagName, 10000);
    }

    public final void HtmlElementByTagName(String tagName, int maxWaitTime) {
        if (!HtmlValidator.ValidateHtmlNameAndIdToken(tagName)) {
            throw new IronPdfInputException("Invalid input of name or Id.. It must begin with a letter ([A-Za-z]) and may be followed by any number of letters, digits ([0-9]), hyphens (\"-\"), underscores (\"_\"), colons (\":\"), and periods (\".\").");
        }
        this.HtmlQuerySelector(String.format("%1$s", tagName), maxWaitTime);
    }

    public final void HtmlElementByClassName(String classAttribName) {
        this.HtmlElementByClassName(classAttribName, 10000);
    }

    public final void HtmlElementByClassName(String classAttribName, int maxWaitTime) {
        if (!HtmlValidator.ValidateHtmlClassAttribName(classAttribName)) {
            throw new IronPdfInputException("Invalid input of class attribute name. It must begin with a letter ([A-Za-z]) and may be followed by any number of letters, digits ([0-9]), hyphens (\"-\"), and underscores (\"_\").");
        }
        this.HtmlQuerySelector(String.format(".%1$s", classAttribName), maxWaitTime);
    }

    public final void AllFontsLoaded() {
        this.AllFontsLoaded(10000);
    }

    public final void AllFontsLoaded(int maxWaitTime) {
        this.Type = WaitForType.AllFontsLoaded;
        this.Timeout = maxWaitTime;
        this.NetworkIdleDuration = 500;
        this.NumAllowedInFlight = 0;
        this.RenderDelayDuration = 0;
        this.HtmlElementQueryStr = null;
    }
}

