/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.internal.proto.ChromeApplyStampRequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.ChromeBarcodeStamperInfoP;
import com.ironsoftware.ironpdf.internal.proto.ChromeHtmlStamperInfoP;
import com.ironsoftware.ironpdf.internal.proto.ChromeImageStamperInfoP;
import com.ironsoftware.ironpdf.internal.proto.ChromeTextStamperInfoP;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Render_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Stamp_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import com.ironsoftware.ironpdf.stamp.BarcodeStamper;
import com.ironsoftware.ironpdf.stamp.HtmlStamper;
import com.ironsoftware.ironpdf.stamp.ImageStamper;
import com.ironsoftware.ironpdf.stamp.Stamper;
import com.ironsoftware.ironpdf.stamp.TextStamper;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

public final class Stamp_Api {
    public static void applyStamp(InternalPdfDocument internalPdfDocument, Stamper stamper, List<PageInfo> pageInfosToStamp) {
        ChromeApplyStampRequestStreamP.Builder msg;
        RpcClient client = Access.ensureConnection();
        String stampValue = "";
        byte[] stampImageBytes = new byte[]{};
        ChromeApplyStampRequestStreamP.InfoP.Builder info = ChromeApplyStampRequestStreamP.InfoP.newBuilder();
        info.setDocument(internalPdfDocument.remoteDocument);
        info.setOpacity(stamper.getOpacity());
        info.setRotation(stamper.getRotation());
        info.setHorizontalAlignment(Stamp_Converter.toProto(stamper.getHorizontalAlignment()));
        info.setVerticalAlignment(Stamp_Converter.toProto(stamper.getVerticalAlignment()));
        info.setHorizontalOffset(Stamp_Converter.toProto(stamper.getHorizontalOffset()));
        info.setVerticalOffset(Stamp_Converter.toProto(stamper.getVerticalOffset()));
        info.setScale(stamper.getScale());
        info.setIsStampBehindContent(stamper.isStampBehindContent());
        if (stamper.getMaxWidth() != null) {
            info.setMaxWidth(Stamp_Converter.toProto(stamper.getMaxWidth()));
        }
        if (stamper.getMaxHeight() != null) {
            info.setMaxHeight(Stamp_Converter.toProto(stamper.getMaxHeight()));
        }
        if (stamper.getMinWidth() != null) {
            info.setMinWidth(Stamp_Converter.toProto(stamper.getMinWidth()));
        }
        if (stamper.getMinHeight() != null) {
            info.setMinHeight(Stamp_Converter.toProto(stamper.getMinHeight()));
        }
        if (stamper.getHyperlink() != null) {
            info.setHyperlink(stamper.getHyperlink());
        }
        if (pageInfosToStamp != null) {
            info.addAllTargetPages(pageInfosToStamp.stream().map(Page_Converter::toProto).collect(Collectors.toList()));
        }
        info.setTimeout(stamper.getWaitFor().getTimeout());
        info.setRenderDelay(stamper.getWaitFor().getRenderDelayDuration());
        if (stamper instanceof HtmlStamper) {
            HtmlStamper htmlStamper = (HtmlStamper)stamper;
            ChromeHtmlStamperInfoP.Builder chromeHtmlStamperInfoP = ChromeHtmlStamperInfoP.newBuilder();
            chromeHtmlStamperInfoP.setCssMediaType(Render_Converter.toProto(htmlStamper.getCssMediaType()));
            if (htmlStamper.getHtmlBaseUrl() != null) {
                chromeHtmlStamperInfoP.setBaseUrl(htmlStamper.getHtmlBaseUrl());
            }
            info.setHtmlStamper(chromeHtmlStamperInfoP);
            stampValue = htmlStamper.getHtml();
        } else if (stamper instanceof TextStamper) {
            ChromeTextStamperInfoP.Builder textStamperInfoP = ChromeTextStamperInfoP.newBuilder();
            textStamperInfoP.setFontFamily(((TextStamper)stamper).getFontFamily());
            textStamperInfoP.setFontSize(((TextStamper)stamper).getFontSize());
            textStamperInfoP.setIsBold(((TextStamper)stamper).isBold());
            textStamperInfoP.setIsItalic(((TextStamper)stamper).isItalic());
            textStamperInfoP.setIsUnderline(((TextStamper)stamper).isUnderline());
            textStamperInfoP.setIsStrikethrough(((TextStamper)stamper).isStrikethrough());
            textStamperInfoP.setUseGoogleFont(((TextStamper)stamper).isUseGoogleFont());
            textStamperInfoP.setTextColor(((TextStamper)stamper).getFontColorCode());
            textStamperInfoP.setBackgroundColor(((TextStamper)stamper).getBackgroundColorCode());
            info.setTextStamper(textStamperInfoP);
            stampValue = ((TextStamper)stamper).getText();
        } else if (stamper instanceof BarcodeStamper) {
            ChromeBarcodeStamperInfoP.Builder barcodeStamperInfo = ChromeBarcodeStamperInfoP.newBuilder();
            barcodeStamperInfo.setBarcodeType(Stamp_Converter.toProto(((BarcodeStamper)stamper).getBarcodeType()));
            barcodeStamperInfo.setWidthPx(((BarcodeStamper)stamper).getWidth());
            barcodeStamperInfo.setHeightPx(((BarcodeStamper)stamper).getHeight());
            info.setBarcodeStamper(barcodeStamperInfo);
            stampValue = ((BarcodeStamper)stamper).getValue();
        } else if (stamper instanceof ImageStamper) {
            ChromeImageStamperInfoP.Builder imageStamperInfoP = ChromeImageStamperInfoP.newBuilder();
            info.setImageStamper(imageStamperInfoP);
            stampImageBytes = ((ImageStamper)stamper).getImageData();
        }
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<EmptyResultP> resultChunks = new ArrayList<EmptyResultP>();
        StreamObserver<ChromeApplyStampRequestStreamP> requestStream = client.stub.chromeStampApplyStamp(new Utils_ReceivingCustomStreamObserver<EmptyResultP>(finishLatch, resultChunks));
        ChromeApplyStampRequestStreamP.Builder infoMsg = ChromeApplyStampRequestStreamP.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        Iterator<Object[]> it = Utils_Util.chunk(stampValue.toCharArray());
        while (it.hasNext()) {
            char[] chars = it.next();
            msg = ChromeApplyStampRequestStreamP.newBuilder();
            msg.setStampValue(String.valueOf(chars));
            requestStream.onNext((Object)msg.build());
        }
        it = Utils_Util.chunk(stampImageBytes);
        while (it.hasNext()) {
            byte[] bytes = (byte[])it.next();
            msg = ChromeApplyStampRequestStreamP.newBuilder();
            msg.setStampImageBytes(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)msg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        Utils_Util.handleEmptyResultChunks(resultChunks);
    }
}

