/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.bookmark;

import com.ironsoftware.ironpdf.bookmark.BookmarkDestinations;
import com.ironsoftware.ironpdf.bookmark.BookmarkManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Bookmark {
    private final String nextBookmarkText;
    private final String parentBookmarkText;
    private final int pageIndex;
    private final String previousBookmarkText;
    private final BookmarkDestinations destinationType;
    private String text;
    private BookmarkManager bookmarkManager;

    public Bookmark(@Nonnull String text, int pageIndex, @Nullable String parentBookmarkText, BookmarkDestinations destinationType, @Nullable String nextBookmarkText, @Nullable String previousBookmarkText) {
        this.setText(text);
        this.pageIndex = pageIndex;
        this.parentBookmarkText = parentBookmarkText;
        this.nextBookmarkText = nextBookmarkText;
        this.previousBookmarkText = previousBookmarkText;
        this.destinationType = destinationType;
    }

    public final BookmarkDestinations getDestinationType() {
        return this.destinationType;
    }

    public final String getNextBookmarkText() {
        return this.nextBookmarkText;
    }

    public final int getPageIndex() {
        return this.pageIndex;
    }

    public final BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    void setBookmarkManager(BookmarkManager value) {
        this.bookmarkManager = value;
    }

    public final void addNextBookmark(String text, int pageIndex) {
        if (this.bookmarkManager == null) {
            throw new RuntimeException("not found a BookmarkManager, Please get this Bookmark object from PdfDocument.getBookmarkManager()");
        }
        this.bookmarkManager.insertBookmark(text, pageIndex, this.getParentBookmarkText(), this.getText());
    }

    public final String getParentBookmarkText() {
        return this.parentBookmarkText;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String value) {
        this.text = value;
    }

    public final void AddPreviousBookmark(String text, int pageIndex) {
        if (this.bookmarkManager == null) {
            throw new RuntimeException("not found a BookmarkManager, Please get this Bookmark object from PdfDocument.getBookmarkManager()");
        }
        this.bookmarkManager.insertBookmark(text, pageIndex, this.getParentBookmarkText(), this.getPreviousBookmarkText());
    }

    public final String getPreviousBookmarkText() {
        return this.previousBookmarkText;
    }

    public final Bookmark AddChildBookmark(String text, int pageIndex) {
        return this.bookmarkManager.addChildBookmark(text, pageIndex, this.getText());
    }
}

