/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.internal.proto.ChromePdfRenderOptions;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResult;
import com.ironsoftware.ironpdf.internal.proto.RenderPdfDocumentFromRtfStringRequestStream;
import com.ironsoftware.ironpdf.internal.proto.RenderPdfDocumentFromStringSnippetRequestStream;
import com.ironsoftware.ironpdf.internal.proto.RenderPdfDocumentFromUriRequest;
import com.ironsoftware.ironpdf.internal.proto.RenderPdfDocumentFromZipRequestStream;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Render_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Setting_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.render.ChromeHttpLoginCredentials;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Render_Api {
    static final Logger logger = LoggerFactory.getLogger(Render_Api.class);

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath) throws IOException {
        return Render_Api.renderHtmlFileAsPdf(htmlFilePath, null, null, null);
    }

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath, String baseUrl, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        if (Utils_StringHelper.isNullOrWhiteSpace(htmlFilePath)) {
            throw new IllegalArgumentException("Value 'htmlFilePath' cannot be null or empty.");
        }
        File htmlFile = new File(htmlFilePath);
        String absoluteFilePath = htmlFile.getAbsolutePath();
        if (!new File(absoluteFilePath).isFile()) {
            throw new IOException(String.format("%1$s is not a valid Html file path. That file does not exist.", absoluteFilePath));
        }
        List<String> htmlList = Files.readAllLines(Paths.get(htmlFilePath, new String[0]));
        if (htmlList.size() == 0) {
            throw new IOException(String.format("html data is null or empty.  Can not create a PDF document from invalid data. %1$s", htmlFilePath));
        }
        return Render_Api.renderHtmlAsPdf(String.join((CharSequence)"", htmlList), renderOptions, loginCredentials, baseUrl);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials, String baseUrl) {
        com.ironsoftware.ironpdf.internal.proto.ChromeHttpLoginCredentials login;
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResult> resultChunks = new ArrayList<PdfDocumentResult>();
        StreamObserver<RenderPdfDocumentFromStringSnippetRequestStream> requestStream = client.stub.renderFromStringSnippet(new Utils_ReceivingCustomStreamObserver<PdfDocumentResult>(finishLatch, resultChunks));
        RenderPdfDocumentFromStringSnippetRequestStream.Info.Builder info = RenderPdfDocumentFromStringSnippetRequestStream.Info.newBuilder();
        ChromePdfRenderOptions renderOp = Render_Converter.toProto(renderOptions);
        if (renderOp != null) {
            info.setRenderOptions(renderOp);
        }
        if ((login = Render_Converter.toProto(loginCredentials)) != null) {
            info.setHttpOptions(login);
        }
        if (baseUrl != null) {
            if (Setting_Api.isIronPdfEngineDocker) {
                logger.warn("baseUrl does not support when using IronPdfEngine in Docker, For alternative please use PdfDocument.renderZipAsPdf()");
            } else {
                info.setBaseUrl(baseUrl);
            }
        }
        RenderPdfDocumentFromStringSnippetRequestStream.Builder infoMsg = RenderPdfDocumentFromStringSnippetRequestStream.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        Iterator<char[]> it = Utils_Util.chunk(html.toCharArray());
        while (it.hasNext()) {
            char[] htmlChunk = it.next();
            RenderPdfDocumentFromStringSnippetRequestStream.Builder dataMsg = RenderPdfDocumentFromStringSnippetRequestStream.newBuilder();
            dataMsg.setHtmlChunk(String.valueOf(htmlChunk));
            requestStream.onNext((Object)dataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        return Render_Api.renderHtmlFileAsPdf(htmlFilePath, null, null, loginCredentials);
    }

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions) throws IOException {
        return Render_Api.renderHtmlFileAsPdf(htmlFilePath, null, renderOptions, null);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url) {
        return Render_Api.renderUrlAsPdf(url, null, null);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) {
        RpcClient client = Access.ensureConnection();
        RenderPdfDocumentFromUriRequest.Builder request = RenderPdfDocumentFromUriRequest.newBuilder();
        request.setUri(url);
        if (renderOptions != null) {
            request.setRenderOptions(Render_Converter.toProto(renderOptions));
        }
        if (loginCredentials != null) {
            request.setHttpOptions(Render_Converter.toProto(loginCredentials));
        }
        PdfDocumentResult res = client.blockingStub.renderFromUri(request.build());
        return Utils_Util.handlePdfDocumentResult(res);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url, ChromeHttpLoginCredentials loginCredentials) {
        return Render_Api.renderUrlAsPdf(url, null, loginCredentials);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions) {
        return Render_Api.renderUrlAsPdf(url, renderOptions, null);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html) {
        return Render_Api.renderHtmlAsPdf(html, null, null, null);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, String baseUrl, ChromeHttpLoginCredentials loginCredentials) {
        return Render_Api.renderHtmlAsPdf(html, null, loginCredentials, baseUrl);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, String baseUrl, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions) {
        return Render_Api.renderHtmlAsPdf(html, renderOptions, null, baseUrl);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) {
        return Render_Api.renderHtmlAsPdf(html, renderOptions, loginCredentials, null);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, String baseUrl) {
        return Render_Api.renderHtmlAsPdf(html, null, null, baseUrl);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, ChromeHttpLoginCredentials loginCredentials) {
        return Render_Api.renderHtmlAsPdf(html, null, loginCredentials, null);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions) {
        return Render_Api.renderHtmlAsPdf(html, renderOptions, null, null);
    }

    public static InternalPdfDocument renderRtfAsPdf(String rtfString) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResult> resultChunks = new ArrayList<PdfDocumentResult>();
        StreamObserver<RenderPdfDocumentFromRtfStringRequestStream> requestStream = client.stub.renderFromRtfString(new Utils_ReceivingCustomStreamObserver<PdfDocumentResult>(finishLatch, resultChunks));
        Iterator<char[]> it = Utils_Util.chunk(rtfString.toCharArray());
        while (it.hasNext()) {
            char[] htmlChunk = it.next();
            RenderPdfDocumentFromRtfStringRequestStream.Builder dataMsg = RenderPdfDocumentFromRtfStringRequestStream.newBuilder();
            dataMsg.setRtfStringChunk(String.valueOf(htmlChunk));
            requestStream.onNext((Object)dataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static InternalPdfDocument renderZipAsPdf(Path zipFilePath, String mainFile, com.ironsoftware.ironpdf.render.ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        com.ironsoftware.ironpdf.internal.proto.ChromeHttpLoginCredentials login;
        RpcClient client = Access.ensureConnection();
        RenderPdfDocumentFromZipRequestStream.Info.Builder info = RenderPdfDocumentFromZipRequestStream.Info.newBuilder();
        ChromePdfRenderOptions renderOp = Render_Converter.toProto(renderOptions);
        if (renderOp != null) {
            info.setRenderOptions(renderOp);
        }
        if ((login = Render_Converter.toProto(loginCredentials)) != null) {
            info.setHttpOptions(login);
        }
        if (mainFile != null) {
            info.setMainFile(mainFile);
        }
        RenderPdfDocumentFromZipRequestStream.Builder infoMsg = RenderPdfDocumentFromZipRequestStream.newBuilder();
        infoMsg.setInfo(info);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResult> resultChunks = new ArrayList<PdfDocumentResult>();
        StreamObserver<RenderPdfDocumentFromZipRequestStream> requestStream = client.stub.renderFromZip(new Utils_ReceivingCustomStreamObserver<PdfDocumentResult>(finishLatch, resultChunks));
        requestStream.onNext((Object)infoMsg.build());
        byte[] zipByte = Files.readAllBytes(zipFilePath);
        Iterator<byte[]> it = Utils_Util.chunk(zipByte);
        while (it.hasNext()) {
            byte[] zipChunk = it.next();
            RenderPdfDocumentFromZipRequestStream.Builder dataMsg = RenderPdfDocumentFromZipRequestStream.newBuilder();
            dataMsg.setRawZipChunk(ByteString.copyFrom((byte[])zipChunk));
            requestStream.onNext((Object)dataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }
}

