/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.AddBackgroundForegroundRequest;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;

public final class BackgroundForeground_Api {
    public static void addBackground(InternalPdfDocument baseDocument, InternalPdfDocument backgroundDocument, Iterable<Integer> basePdfPageIndexes) {
        BackgroundForeground_Api.addBackground(baseDocument, backgroundDocument, basePdfPageIndexes, 0);
    }

    public static void addBackground(InternalPdfDocument baseDocument, InternalPdfDocument backgroundDocument, Iterable<Integer> basePdfPageIndexes, int backgroundPdfPageIndex) {
        RpcClient client = Access.ensureConnection();
        AddBackgroundForegroundRequest.Builder req = AddBackgroundForegroundRequest.newBuilder();
        req.setBackgroundPdf(backgroundDocument.remoteDocument);
        req.setBasePdf(baseDocument.remoteDocument);
        req.setLayerPdfPageIndex(backgroundPdfPageIndex);
        if (basePdfPageIndexes != null) {
            req.addAllBasePdfPages(basePdfPageIndexes);
        }
        EmptyResult res = client.blockingStub.pdfDocumentBackgroundForegroundAddBackgroundForeground(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void addBackground(InternalPdfDocument baseDocument, InternalPdfDocument backgroundDocument) {
        BackgroundForeground_Api.addBackground(baseDocument, backgroundDocument, null, 0);
    }

    public static void addForeground(InternalPdfDocument baseDocument, InternalPdfDocument foregroundDocument, Iterable<Integer> basePdfPageIndexes) {
        BackgroundForeground_Api.addForeground(baseDocument, foregroundDocument, basePdfPageIndexes, 0);
    }

    public static void addForeground(InternalPdfDocument baseDocument, InternalPdfDocument foregroundDocument, Iterable<Integer> basePdfPageIndexes, int foregroundPdfPageIndex) {
        RpcClient client = Access.ensureConnection();
        AddBackgroundForegroundRequest.Builder req = AddBackgroundForegroundRequest.newBuilder();
        req.setForegroundPdf(foregroundDocument.remoteDocument);
        req.setBasePdf(baseDocument.remoteDocument);
        req.setLayerPdfPageIndex(foregroundPdfPageIndex);
        if (basePdfPageIndexes != null) {
            req.addAllBasePdfPages(basePdfPageIndexes);
        }
        EmptyResult res = client.blockingStub.pdfDocumentBackgroundForegroundAddBackgroundForeground(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void addForeground(InternalPdfDocument baseDocument, InternalPdfDocument foregroundDocument) {
        BackgroundForeground_Api.addForeground(baseDocument, foregroundDocument, null, 0);
    }
}

